/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.webrtc.GlShader;
import org.webrtc.GlTextureFrameBuffer;
import org.webrtc.GlUtil;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;

class YuvConverter {
    private static final FloatBuffer DEVICE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer TEXTURE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private static final String VERTEX_SHADER = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES oesTex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
    private final GlTextureFrameBuffer textureFrameBuffer;
    private final GlShader shader;
    private final int texMatrixLoc;
    private final int xUnitLoc;
    private final int coeffsLoc;
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private boolean released = false;

    public YuvConverter() {
        this.threadChecker.checkIsOnValidThread();
        this.textureFrameBuffer = new GlTextureFrameBuffer(6408);
        this.shader = new GlShader(VERTEX_SHADER, FRAGMENT_SHADER);
        this.shader.useProgram();
        this.texMatrixLoc = this.shader.getUniformLocation("texMatrix");
        this.xUnitLoc = this.shader.getUniformLocation("xUnit");
        this.coeffsLoc = this.shader.getUniformLocation("coeffs");
        GLES20.glUniform1i((int)this.shader.getUniformLocation("oesTex"), (int)0);
        GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
        this.shader.setVertexAttribArray("in_pos", 2, DEVICE_RECTANGLE);
        this.shader.setVertexAttribArray("in_tc", 2, TEXTURE_RECTANGLE);
    }

    public void convert(ByteBuffer buf, int width, int height, int stride, int srcTextureId, float[] transformMatrix) {
        this.threadChecker.checkIsOnValidThread();
        if (this.released) {
            throw new IllegalStateException("YuvConverter.convert called on released object");
        }
        if (stride % 8 != 0) {
            throw new IllegalArgumentException("Invalid stride, must be a multiple of 8");
        }
        if (stride < width) {
            throw new IllegalArgumentException("Invalid stride, must >= width");
        }
        int y_width = (width + 3) / 4;
        int uv_width = (width + 7) / 8;
        int uv_height = (height + 1) / 2;
        int total_height = height + uv_height;
        int size = stride * total_height;
        if (buf.capacity() < size) {
            throw new IllegalArgumentException("YuvConverter.convert called with too small buffer");
        }
        transformMatrix = RendererCommon.multiplyMatrices(transformMatrix, RendererCommon.verticalFlipMatrix());
        int frameBufferWidth = stride / 4;
        int frameBufferHeight = total_height;
        this.textureFrameBuffer.setSize(frameBufferWidth, frameBufferHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.textureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)srcTextureId);
        GLES20.glUniformMatrix4fv((int)this.texMatrixLoc, (int)1, (boolean)false, (float[])transformMatrix, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)y_width, (int)height);
        GLES20.glUniform2f((int)this.xUnitLoc, (float)(transformMatrix[0] / (float)width), (float)(transformMatrix[1] / (float)width));
        GLES20.glUniform4f((int)this.coeffsLoc, (float)0.299f, (float)0.587f, (float)0.114f, (float)0.0f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glViewport((int)0, (int)height, (int)uv_width, (int)uv_height);
        GLES20.glUniform2f((int)this.xUnitLoc, (float)(2.0f * transformMatrix[0] / (float)width), (float)(2.0f * transformMatrix[1] / (float)width));
        GLES20.glUniform4f((int)this.coeffsLoc, (float)-0.169f, (float)-0.331f, (float)0.499f, (float)0.5f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glViewport((int)(stride / 8), (int)height, (int)uv_width, (int)uv_height);
        GLES20.glUniform4f((int)this.coeffsLoc, (float)0.499f, (float)-0.418f, (float)-0.0813f, (float)0.5f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glReadPixels((int)0, (int)0, (int)frameBufferWidth, (int)frameBufferHeight, (int)6408, (int)5121, (Buffer)buf);
        GlUtil.checkNoGLES2Error("YuvConverter.convert");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        this.released = true;
        this.shader.release();
        this.textureFrameBuffer.release();
    }
}

