/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Matrix;
import java.nio.ByteBuffer;

public class VideoFrame {
    private final Buffer buffer;
    private final int rotation;
    private final long timestampNs;
    private final Matrix transformMatrix;

    public VideoFrame(Buffer buffer, int rotation, long timestampNs, Matrix transformMatrix) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (transformMatrix == null) {
            throw new IllegalArgumentException("transformMatrix not allowed to be null");
        }
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
        this.transformMatrix = transformMatrix;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public int getRotation() {
        return this.rotation;
    }

    public long getTimestampNs() {
        return this.timestampNs;
    }

    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    public int getWidth() {
        return this.buffer.getWidth();
    }

    public int getHeight() {
        return this.buffer.getHeight();
    }

    public void retain() {
        this.buffer.retain();
    }

    public void release() {
        this.buffer.release();
    }

    public static interface TextureBuffer
    extends Buffer {
        public Type getType();

        public int getTextureId();

        public static enum Type {
            OES,
            RGB;

        }
    }

    public static interface I420Buffer
    extends Buffer {
        public ByteBuffer getDataY();

        public ByteBuffer getDataU();

        public ByteBuffer getDataV();

        public int getStrideY();

        public int getStrideU();

        public int getStrideV();
    }

    public static interface Buffer {
        public int getWidth();

        public int getHeight();

        public I420Buffer toI420();

        public void retain();

        public void release();
    }
}

