/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.EncodedImage;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoFrame;

public interface VideoEncoder {
    public VideoCodecStatus initEncode(Settings var1, Callback var2);

    public VideoCodecStatus release();

    public VideoCodecStatus encode(VideoFrame var1, EncodeInfo var2);

    public VideoCodecStatus setChannelParameters(short var1, long var2);

    public VideoCodecStatus setRateAllocation(BitrateAllocation var1, int var2);

    public ScalingSettings getScalingSettings();

    public String getImplementationName();

    public static interface Callback {
        public void onEncodedFrame(EncodedImage var1, CodecSpecificInfo var2);
    }

    public static class ScalingSettings {
        public final boolean on;
        public final int low;
        public final int high;

        public ScalingSettings(boolean on, int low, int high) {
            this.on = on;
            this.low = low;
            this.high = high;
        }
    }

    public static class BitrateAllocation {
        public final int[][] bitratesBbs;

        public BitrateAllocation(int[][] bitratesBbs) {
            this.bitratesBbs = bitratesBbs;
        }

        public int getSum() {
            int sum = 0;
            int[][] nArray = this.bitratesBbs;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] spatialLayer;
                for (int bitrate : spatialLayer = nArray[i]) {
                    sum += bitrate;
                }
            }
            return sum;
        }
    }

    public static class CodecSpecificInfoH264
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP9
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP8
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfo {
    }

    public static class EncodeInfo {
        public final EncodedImage.FrameType[] frameTypes;

        public EncodeInfo(EncodedImage.FrameType[] frameTypes) {
            this.frameTypes = frameTypes;
        }
    }

    public static class Settings {
        public final int numberOfCores;
        public final int width;
        public final int height;
        public final int startBitrate;
        public final int maxFramerate;

        public Settings(int numberOfCores, int width, int height, int startBitrate, int maxFramerate) {
            this.numberOfCores = numberOfCores;
            this.width = width;
            this.height = height;
            this.startBitrate = startBitrate;
            this.maxFramerate = maxFramerate;
        }
    }
}

