/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.VideoFrame;

class I420BufferImpl
implements VideoFrame.I420Buffer {
    private final int width;
    private final int height;
    private final int strideUV;
    private final ByteBuffer y;
    private final ByteBuffer u;
    private final ByteBuffer v;

    I420BufferImpl(int width, int height) {
        this.width = width;
        this.height = height;
        this.strideUV = (width + 1) / 2;
        int halfHeight = (height + 1) / 2;
        this.y = ByteBuffer.allocateDirect(width * height);
        this.u = ByteBuffer.allocateDirect(this.strideUV * halfHeight);
        this.v = ByteBuffer.allocateDirect(this.strideUV * halfHeight);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.y;
    }

    @Override
    public ByteBuffer getDataU() {
        return this.u;
    }

    @Override
    public ByteBuffer getDataV() {
        return this.v;
    }

    @Override
    public int getStrideY() {
        return this.width;
    }

    @Override
    public int getStrideU() {
        return this.strideUV;
    }

    @Override
    public int getStrideV() {
        return this.strideUV;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return this;
    }

    @Override
    public void retain() {
    }

    @Override
    public void release() {
    }
}

