/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;

public class EncodedImage {
    public final ByteBuffer buffer;
    public final int encodedWidth;
    public final int encodedHeight;
    public final long captureTimeMs;
    public final FrameType frameType;
    public final int rotation;
    public final boolean completeFrame;
    public final Integer qp;

    private EncodedImage(ByteBuffer buffer, int encodedWidth, int encodedHeight, long captureTimeMs, FrameType frameType, int rotation, boolean completeFrame, Integer qp) {
        this.buffer = buffer;
        this.encodedWidth = encodedWidth;
        this.encodedHeight = encodedHeight;
        this.captureTimeMs = captureTimeMs;
        this.frameType = frameType;
        this.rotation = rotation;
        this.completeFrame = completeFrame;
        this.qp = qp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ByteBuffer buffer;
        private int encodedWidth;
        private int encodedHeight;
        private long captureTimeMs;
        private FrameType frameType;
        private int rotation;
        private boolean completeFrame;
        private Integer qp;

        private Builder() {
        }

        public Builder setBuffer(ByteBuffer buffer) {
            this.buffer = buffer;
            return this;
        }

        public Builder setEncodedWidth(int encodedWidth) {
            this.encodedWidth = encodedWidth;
            return this;
        }

        public Builder setEncodedHeight(int encodedHeight) {
            this.encodedHeight = encodedHeight;
            return this;
        }

        public Builder setCaptureTimeMs(long captureTimeMs) {
            this.captureTimeMs = captureTimeMs;
            return this;
        }

        public Builder setFrameType(FrameType frameType) {
            this.frameType = frameType;
            return this;
        }

        public Builder setRotation(int rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder setCompleteFrame(boolean completeFrame) {
            this.completeFrame = completeFrame;
            return this;
        }

        public Builder setQp(Integer qp) {
            this.qp = qp;
            return this;
        }

        public EncodedImage createEncodedImage() {
            return new EncodedImage(this.buffer, this.encodedWidth, this.encodedHeight, this.captureTimeMs, this.frameType, this.rotation, this.completeFrame, this.qp);
        }
    }

    public static enum FrameType {
        EmptyFrame,
        VideoFrameKey,
        VideoFrameDelta;

    }
}

