/*
 * Decompiled with CFR 0.152.
 */
package vcxsdk.Utilities;

import android.content.Context;
import android.content.SharedPreferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import vcxsdk.Utilities.VCXConstant;

public class VCXLogsUtil {
    SharedPreferences sharedPerferences;
    SharedPreferences.Editor editor;
    private String filename_1 = "log_File_1.txt";
    private String filename_2 = "log_File_2.txt";
    private String filepath = "VCXSDK";
    File outputFile_1;
    File outputFile_2;
    long file_1_Size = 0L;
    long file_2_Size = 0L;
    public static VCXLogsUtil vcxLogsUtil;
    boolean logsEnable;

    private VCXLogsUtil(Context context) {
        this.sharedPerferences = context.getSharedPreferences("sharedPerferences", 0);
        this.editor = this.sharedPerferences.edit();
        this.outputFile_1 = new File(context.getExternalFilesDir(this.filepath), this.filename_1);
        this.outputFile_2 = new File(context.getExternalFilesDir(this.filepath), this.filename_2);
    }

    public static VCXLogsUtil getInstance(Context context) {
        if (vcxLogsUtil == null) {
            vcxLogsUtil = new VCXLogsUtil(context);
        }
        return vcxLogsUtil;
    }

    public void enableLogs(boolean value) {
        this.logsEnable = value;
    }

    public boolean getLogsEnable() {
        return this.logsEnable;
    }

    public void writeLogs() {
        this.sizeOfLogFile(1);
        if (this.file_1_Size < 200L) {
            this.writeLogsFile(1);
        } else {
            this.sizeOfLogFile(2);
            if (this.file_2_Size < 200L) {
                this.writeLogsFile(2);
            } else {
                boolean fileBoolean = this.sharedPerferences.getBoolean("fileBoolean", false);
                if (!fileBoolean) {
                    this.cleanLogsFile(1);
                    this.writeLogsFile(1);
                    this.editor.putBoolean("fileBoolean", true);
                    this.editor.commit();
                } else {
                    this.cleanLogsFile(2);
                    this.writeLogsFile(2);
                    this.editor.putBoolean("fileBoolean", false);
                    this.editor.commit();
                }
            }
        }
    }

    public void sizeOfLogFile(int fileNumber) {
        if (fileNumber == 1) {
            long length = this.outputFile_1.length();
            this.file_1_Size = length / 1024L;
        } else {
            long length = this.outputFile_2.length();
            this.file_2_Size = length / 1024L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLogsFile(int fileNumber) {
        try {
            String line;
            FileOutputStream stream = fileNumber == 1 ? new FileOutputStream(this.outputFile_1, true) : new FileOutputStream(this.outputFile_2, true);
            Process process = Runtime.getRuntime().exec("logcat -d");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String log = "";
            if (VCXConstant.LogId == null) {
                return;
            }
            String filterText = VCXConstant.LogId + "|libjingle";
            Pattern pattern = Pattern.compile(filterText, 0);
            while ((line = bufferedReader.readLine()) != null) {
                if (pattern != null && !pattern.matcher(line).find()) continue;
                log = log + line;
                log = log + '\n';
            }
            try {
                OutputStreamWriter myOutWriter = new OutputStreamWriter(stream);
                myOutWriter.append(log);
                this.clearLogsOfLogcat();
                myOutWriter.close();
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanLogsFile(int fileNumber) {
        try {
            PrintWriter writer = fileNumber == 1 ? new PrintWriter(this.outputFile_1) : new PrintWriter(this.outputFile_2);
            writer.print("");
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearLogsOfLogcat() {
        try {
            Process process = new ProcessBuilder(new String[0]).command("logcat", "-c").redirectErrorStream(true).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String readLogsFromFile() {
        String logsText = "";
        try {
            String line1;
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.outputFile_1));
            while ((line = br.readLine()) != null) {
                logsText = logsText + "A : " + line;
                logsText = logsText + '\n';
            }
            br.close();
            BufferedReader br1 = new BufferedReader(new FileReader(this.outputFile_2));
            while ((line1 = br1.readLine()) != null) {
                logsText = logsText + "AN : " + line1;
                logsText = logsText + '\n';
            }
            br1.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return logsText;
    }
}

