/*
 * Decompiled with CFR 0.152.
 */
package vcxsdk.Streams;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.AudioTrack;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.Logging;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.SdpObserver;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoTrack;
import vcxsdk.Controller.VCXRoom;
import vcxsdk.Controller.VCXSignaling;
import vcxsdk.Streams.VCXStreamObserver;
import vcxsdk.Utilities.VCXConstant;
import vcxsdk.Utilities.VCXUtils;

public class VCXStream {
    private StreamState mState = StreamState.UNKNOWN;
    private String mId;
    private boolean mData;
    private boolean mVideo;
    private boolean mScreen;
    private boolean mAudio;
    private JSONObject mAttributes = new JSONObject();
    private String publisher_name;
    private VCXSignaling mVcxSignalling;
    private boolean mLocal;
    private MediaConstraints mSdpConstraints;
    private boolean mAudioActive = true;
    private boolean mAudioStatus;
    public VCXRoom vcxRoom;
    VCXStreamObserver mVcxStreamObserver;
    public PeerConnection pc = null;
    private volatile MediaStream mMediaStream;
    private VideoRenderer mRenderer;
    private String mLocalStreamID;
    boolean cameraStatus = true;

    public static VCXStream parseJson(JSONObject arg, VCXSignaling remoteVcxSignaling, VCXStreamObserver vcxStreamObserver) {
        String id = null;
        boolean data = false;
        boolean video = false;
        boolean audio = false;
        boolean screen = false;
        JSONObject attr = null;
        String nick = null;
        VCXSignaling mVcxSignaling = remoteVcxSignaling;
        VCXStreamObserver mvcxStreamObserver = vcxStreamObserver;
        try {
            id = arg.getString("id");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            data = arg.getBoolean("data");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            video = arg.getBoolean("video");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            audio = arg.getBoolean("audio");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            screen = arg.getBoolean("screen");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            attr = arg.getJSONObject("attributes");
            if (attr != null) {
                nick = attr.getString("nick");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return new VCXStream(id, data, video, audio, screen, attr, nick, mVcxSignaling, mvcxStreamObserver);
    }

    public VCXStream(String id, boolean data, boolean video, boolean audio, boolean screen, JSONObject attr, String nick, VCXSignaling vcxSignalling, VCXStreamObserver vcxStreamObserver) {
        this.mId = id;
        this.mData = data;
        this.mVideo = video;
        this.mAudio = audio;
        this.mScreen = screen;
        this.mVcxSignalling = vcxSignalling;
        if (attr != null) {
            this.mAttributes = attr;
        }
        this.publisher_name = nick;
        this.mVcxStreamObserver = vcxStreamObserver;
    }

    public JSONObject toJson() {
        JSONObject result = new JSONObject();
        try {
            result.put("data", this.mData);
            result.put("video", this.mVideo);
            result.put("audio", this.mAudio);
            result.put("screen", this.mScreen);
            if (this.mAttributes == null) {
                this.mAttributes = new JSONObject();
            }
            this.mAttributes.put("nick", (Object)this.publisher_name);
            result.put("attributes", (Object)this.mAttributes);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String newId) {
        if (!this.mLocal) {
            throw new UnsupportedOperationException("May not change id of a non-local stream!");
        }
        this.mId = newId;
    }

    public boolean isLocal() {
        return this.mLocal;
    }

    public JSONObject toJsonOffer(String state) {
        JSONObject result = new JSONObject();
        JSONObject jsonObjectMuteStream = new JSONObject();
        try {
            if (state != null) {
                result.put("state", (Object)state);
                result.put("data", this.mData);
                if (this.mAttributes == null) {
                    this.mAttributes = new JSONObject();
                }
                this.mAttributes.put("type", (Object)"public");
                this.mAttributes.put("name", (Object)this.publisher_name);
                this.mAttributes.put("actualName", (Object)this.publisher_name);
                result.put("audio", this.mAudio);
                result.put("video", this.mVideo);
                result.put("attributes", (Object)this.mAttributes);
            } else {
                result.put("data", this.mData);
                result.put("audio", this.mAudio);
                result.put("video", this.mVideo);
                jsonObjectMuteStream.put("audio", !this.mAudio);
                jsonObjectMuteStream.put("video", !this.mVideo);
                result.put("muteStream", (Object)jsonObjectMuteStream);
            }
        }
        catch (JSONException jex) {
            jex.printStackTrace();
        }
        return result;
    }

    public JSONObject getAttributes() {
        return this.mAttributes;
    }

    public MediaConstraints sdpConstraints() {
        return this.mSdpConstraints;
    }

    public void initLocal(PeerConnection pc, SdpObserver sdpObserver) {
        this.mLocal = true;
        this.mState = StreamState.LOCAL;
        this.pc = pc;
        this.mSdpConstraints = new MediaConstraints();
        this.mSdpConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        this.mSdpConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
        pc.createOffer(sdpObserver, this.mSdpConstraints);
        Logging.d((String)VCXConstant.LogId, (String)"Offer Create Successfully for Local");
    }

    public void initRemote(PeerConnection pc, SdpObserver sdpObserver) {
        this.mLocal = false;
        this.mState = StreamState.OPENING;
        this.pc = pc;
        this.mSdpConstraints = new MediaConstraints();
        this.mSdpConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        this.mSdpConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
        pc.createOffer(sdpObserver, this.mSdpConstraints);
        Logging.d((String)VCXConstant.LogId, (String)"Offer Create Successfully for Remote");
    }

    public void setMedia(MediaStream media) {
        this.mMediaStream = media;
    }

    public MediaStream getMedia() {
        return this.mMediaStream;
    }

    public synchronized void attachRenderer(VCXRoom.VideoCallbacks videoCallbacks) {
        if (this.mRenderer != null) {
            return;
        }
        if (this.mMediaStream != null && this.mMediaStream.videoTracks.size() == 1) {
            this.mState = StreamState.ACTIVE;
            this.mRenderer = new VideoRenderer((VideoRenderer.Callbacks)videoCallbacks);
            ((VideoTrack)this.mMediaStream.videoTracks.get(0)).addRenderer(this.mRenderer);
        }
    }

    public synchronized void attachLocalRenderer(VideoRenderer renderer) {
        if (this.mRenderer != null) {
            return;
        }
        this.mRenderer = renderer;
    }

    public synchronized void detachRenderer() {
        if (this.mRenderer != null && this.mMediaStream != null && this.mMediaStream.videoTracks.size() == 1) {
            ((VideoTrack)this.mMediaStream.videoTracks.get(0)).removeRenderer(this.mRenderer);
        }
        this.mRenderer = null;
    }

    public void onClosing() {
        this.mState = StreamState.CLOSING;
    }

    public void onDestroyed() {
        this.mState = StreamState.DESTROYED;
        this.mMediaStream = null;
    }

    public void onDisable() {
        this.mState = StreamState.BLOCKED;
        this.mMediaStream = null;
    }

    public StreamState getState() {
        return this.mState;
    }

    public void toggleAudio() {
        this.muteAudio(!this.mAudioActive);
    }

    public void muteSelfAudio(boolean mAudioStatus) {
        this.mAudioActive = mAudioStatus;
        try {
            if (!this.vcxRoom.participantHardMuteActiveState) {
                if (this.mMediaStream != null && this.mMediaStream.audioTracks.size() == 1) {
                    boolean status = ((AudioTrack)this.mMediaStream.audioTracks.get(0)).setEnabled(this.mAudioActive);
                    if (this.mVcxSignalling != null) {
                        this.mVcxSignalling.muteSelfAudio();
                    }
                    if (this.mVcxStreamObserver != null) {
                        JSONObject jsonObject = this.getCustomJsonObject(0, "Success");
                        this.mVcxStreamObserver.onAudioEvent(jsonObject);
                    }
                }
            } else {
                JSONObject jsonObject = this.getCustomJsonObject(0, "Hard Mute Room On");
                this.mVcxStreamObserver.onAudioEvent(jsonObject);
            }
        }
        catch (Exception e) {
            JSONObject jsonObject = this.getCustomJsonObject(1, e.getMessage());
            this.mVcxStreamObserver.onAudioEvent(jsonObject);
        }
    }

    public boolean muteAudio(boolean audioActive) {
        this.mAudioActive = audioActive;
        if (!this.vcxRoom.participantHardMuteActiveState && this.mMediaStream != null && this.mMediaStream.audioTracks.size() == 1) {
            boolean status = ((AudioTrack)this.mMediaStream.audioTracks.get(0)).setEnabled(this.mAudioActive);
            return status;
        }
        return false;
    }

    public void muteSelfVideo(boolean videoActive) {
        if (videoActive) {
            VCXRoom.isvideoMute = false;
            if (this.mMediaStream != null && this.mMediaStream.audioTracks.size() == 1) {
                boolean status = ((VideoTrack)this.mMediaStream.videoTracks.get(0)).setEnabled(true);
                JSONObject jsonObject = this.getCustomJsonObject(0, "Video on");
                this.mVcxStreamObserver.onVideoEvent(jsonObject);
            }
        } else {
            VCXRoom.isvideoMute = true;
            if (this.mMediaStream != null && this.mMediaStream.audioTracks.size() == 1) {
                boolean status = ((VideoTrack)this.mMediaStream.videoTracks.get(0)).setEnabled(false);
                JSONObject jsonObject = this.getCustomJsonObject(0, "Video off");
                this.mVcxStreamObserver.onVideoEvent(jsonObject);
            }
        }
    }

    public void setLocalStreamId(String localStreamID) {
        this.mLocalStreamID = localStreamID;
    }

    public void sendMessage(String txtMessage, String from) {
        this.sendDataSocket(this.mLocalStreamID, txtMessage, from);
    }

    public void recievedData(JSONObject jsonObject) {
        if (this.mVcxStreamObserver != null) {
            this.mVcxStreamObserver.onReceivedData(jsonObject);
        }
    }

    public void setBandWidthAlert(VCXStream vcxStream, JSONObject jsonObject) {
        this.mVcxStreamObserver.onBandWidthAlert(vcxStream, jsonObject);
    }

    private void sendDataSocket(String streamId, String message, String from) {
        JSONObject param = new JSONObject();
        try {
            if (streamId == null || streamId.trim().equalsIgnoreCase("")) {
                return;
            }
            param.put("id", Long.parseLong(streamId));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("message", (Object)message);
            jsonObject.put("from", (Object)from);
            jsonObject.put("type", (Object)"public");
            jsonObject.put("timestamp", (Object)VCXUtils.getCurrentTimeInMillSecond());
            param.put("msg", (Object)jsonObject);
            this.mVcxSignalling.sendMessage("sendDataStream", param);
            Logging.d((String)VCXConstant.LogId, (String)("data sent: " + param));
        }
        catch (JSONException e) {
            Logging.d((String)VCXConstant.LogId, (String)("data sent: " + e.getMessage()));
        }
    }

    public void switchCamera() {
        CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)VCXRoom.mVideoCapturer;
        cameraVideoCapturer.switchCamera(null);
    }

    public boolean isAudioActive() {
        return this.mAudioActive;
    }

    public boolean isClosing() {
        return this.mState == StreamState.CLOSING;
    }

    private JSONObject getCustomJsonObject(int code, String message) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("message", (Object)message);
            jsonObject.put("errorCode", code);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public static enum StreamState {
        UNKNOWN,
        OPENING,
        ACTIVE,
        CLOSING,
        DESTROYED,
        LOCAL,
        BLOCKED;

    }
}

