/*
 * Decompiled with CFR 0.152.
 */
package vcxsdk.Controller;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.util.Base64;
import io.socket.client.Ack;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.Logging;
import vcxsdk.Controller.VCXSignalingObserver;
import vcxsdk.Utilities.VCXConstant;
import vcxsdk.Utilities.VCXLogsUtil;

public class VCXSignaling {
    private Socket mSocket;
    private Object mSocketLock = new Object();
    private String token;
    private VCXSignalingObserver mVCXSignalingObserver;
    private Activity mActivity;
    private boolean isReconnected = false;
    String mode;
    String clientId;
    private Ack onAcknowledgeMuteAll = new Ack(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onAcknowledgeMuteAllInRoom(args);
        }
    };
    private Ack onAcknowledgeUnMuteAll = new Ack(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onAcknowledgeUnMuteAllInRoom(args);
        }
    };
    private Ack onAcknowledgeMuteUser = new Ack(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onAcknowledgeMuteUserInRoom(args);
        }
    };
    private Ack onAcknowledgeUnMuteUser = new Ack(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onAcknowledgeUnMuteUserInRoom(args);
        }
    };
    private Ack onAcknowledgeClientLogs = new Ack(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onAcknowledgeLogsInRoom(args);
        }
    };
    private Ack onAcknowledgerequestFlloor = new Ack(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onAcknowledgerequestFlloorInRoom(args);
        }
    };
    private Ack onAcknowledgeprocessFloorRequest = new Ack(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onAcknowledprocessFloorInRoom(args);
        }
    };
    private Emitter.Listener onConnect = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)"Socket Connected");
            if (!VCXSignaling.this.isReconnected) {
                VCXSignaling.this.sendMessageSocket("token", VCXSignaling.this.token, VCXSignaling.this.onAcknowledge);
            }
        }
    };
    private Emitter.Listener onDisconnect = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)"Socket DisConnected");
            VCXSignaling.this.mVCXSignalingObserver.onReconnectInRoom();
        }
    };
    private Emitter.Listener onConnectError = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)"Socket Error");
        }
    };
    private Emitter.Listener onTimeOutError = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("TimeOutError: " + args));
        }
    };
    private Emitter.Listener onRemoveTrack = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("RemoveTrack: " + args));
        }
    };
    private Emitter.Listener onUnpublish_me = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("Unpublish_me: " + args));
        }
    };
    private Emitter.Listener ononBandwidthAlert = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onBandWidthAlertInRoom(args);
            Logging.d((String)VCXConstant.LogId, (String)("BandWidthAlert: " + args));
        }
    };
    private Emitter.Listener onConnection_failed = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("Connection_failed: " + args));
        }
    };
    private Emitter.Listener onError = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("onError: " + args));
        }
    };
    private Emitter.Listener onReconnecting = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("Reconnecting: " + args));
        }
    };
    private Emitter.Listener onReconnect = new Emitter.Listener(){

        public void call(Object ... args) {
            if (!VCXSignaling.this.isReconnected) {
                VCXSignaling.this.isReconnected = true;
                VCXSignaling.this.mVCXSignalingObserver.onReconnectInRoom();
            }
            Logging.d((String)VCXConstant.LogId, (String)("Reconnect: " + args));
        }
    };
    private Emitter.Listener onReconnected = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("Reconnected: " + args));
            String str = "";
        }
    };
    private Emitter.Listener onReconnect_attempt = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("Reconnect_attempt: " + args));
        }
    };
    private Emitter.Listener onReconnect_error = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("Reconnect_error: " + args));
        }
    };
    private Emitter.Listener onReConnectFailed = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("ReConnectFailed: " + args));
        }
    };
    private Emitter.Listener onUserConnected = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onUserConnectedInRoom(args);
        }
    };
    private Emitter.Listener onUserDisconnected = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onUserDisConnectedInRoom(args);
        }
    };
    private Emitter.Listener onUserSubscribed = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("UserSubscribed: " + args));
        }
    };
    private Emitter.Listener onUserUnsubscribed = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("UserUnsubscribed: " + args));
        }
    };
    private Emitter.Listener onSubsCribeP2PListener = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("SubsCribeP2PListener: " + args));
        }
    };
    private Emitter.Listener onPublishP2PListener = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("PublishP2PListener: " + args));
        }
    };
    private Emitter.Listener onSignalingMessagePeer = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("SignalingMessagePeer: " + args));
        }
    };
    private Emitter.Listener onPublishMe = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("PublishMe: " + args));
        }
    };
    private Emitter.Listener onSignalingMessage = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("SignalingMessage: " + args));
        }
    };
    private Emitter.Listener onSignalingMediaConnecting = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("SignalingMediaConnecting: " + args));
            VCXSignaling.this.mVCXSignalingObserver.onReceiveSignalingMessage(args);
        }
    };
    private Emitter.Listener onAddStreamListener = new Emitter.Listener(){

        public void call(Object ... args) {
            Logging.d((String)VCXConstant.LogId, (String)("AddStreamListener: " + args));
            VCXSignaling.this.mVCXSignalingObserver.onAddStreamInRoom(args);
        }
    };
    private Emitter.Listener onDataStreamListener = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onDataAdded(args);
        }
    };
    private Emitter.Listener onRemoveStreamListener = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onRemoveStreamInRoom(args);
        }
    };
    private Emitter.Listener onfloorRequestedProcessed = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onfloorRequestedProcessedInRoom(args);
        }
    };
    private Emitter.Listener onfloorGrantedSuccess = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onfloorGrantedSuccessInRoom(args);
        }
    };
    private Emitter.Listener onfloorDenySuccess = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onfloorDenySuccessInRoom(args);
        }
    };
    private Emitter.Listener onfloorReleasedSuccess = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onfloorReleasedSuccessInRoom(args);
        }
    };
    private Emitter.Listener onhardMute = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onhardMuteSuccessInRoom(args);
        }
    };
    private Emitter.Listener onhardMuteRoom = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onhardMuteRoomSuccessInRoom(args);
        }
    };
    private Emitter.Listener roomRecordOn = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.roomRecordOnSuccessInRoom(args);
        }
    };
    private Emitter.Listener roomRecordOff = new Emitter.Listener(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.roomRecordOffSuccessInRoom(args);
        }
    };
    private Ack onAcknowledge = new Ack(){

        public void call(Object ... args) {
            VCXSignaling.this.mVCXSignalingObserver.onAcknowledgeInRoom(args);
        }
    };

    VCXSignaling(Activity mActivity, VCXSignalingObserver vcxSignalingObserver) {
        this.mActivity = mActivity;
        this.mVCXSignalingObserver = vcxSignalingObserver;
    }

    public void connectSignaling(String encodedTocken) {
        String token;
        this.isReconnected = false;
        this.token = token = this.decodeToken(encodedTocken);
        if (token == null) {
            return;
        }
        try {
            JSONObject jsonToken = new JSONObject(token);
            String host = jsonToken.getString("host");
            if (!host.startsWith("http://") || !host.startsWith("https://")) {
                host = "https://" + host;
            }
            String roomMeta = jsonToken.getString("roomMeta");
            JSONObject roomMetaJsonObject = new JSONObject(roomMeta);
            String settings = roomMetaJsonObject.getString("settings");
            JSONObject settingsJsonObject = new JSONObject(settings);
            this.mode = settingsJsonObject.getString("mode");
            this.mVCXSignalingObserver.setMode(this.mode);
            IO.Options options = new IO.Options();
            options.secure = jsonToken.getBoolean("secure");
            options.reconnection = true;
            options.forceNew = true;
            options.sslContext = this.trustEveryone();
            options.timeout = 10000L;
            options.transports = new String[]{"websocket"};
            this.mSocket = IO.socket((String)host, (IO.Options)options);
            this.mSocket.on("connect", this.onConnect);
            this.mSocket.on("disconnect", this.onDisconnect);
            this.mSocket.on("connect_error", this.onConnectError);
            this.mSocket.on("connect_timeout", this.onTimeOutError);
            this.mSocket.on("media_engine_connecting", this.onSignalingMediaConnecting);
            this.mSocket.on("signaling_message_peer", this.onSignalingMessagePeer);
            this.mSocket.on("publish_me", this.onPublishMe);
            this.mSocket.on("onUpdateAttributeStream", this.onSignalingMessage);
            this.mSocket.on("onAddStream", this.onAddStreamListener);
            this.mSocket.on("onSubscribeP2P", this.onSubsCribeP2PListener);
            this.mSocket.on("onPublishP2P", this.onPublishP2PListener);
            this.mSocket.on("onDataStream", this.onDataStreamListener);
            this.mSocket.on("onRemoveStream", this.onRemoveStreamListener);
            this.mSocket.on("subscribe", this.onSubsCribeP2PListener);
            this.mSocket.on("publish", this.onPublishP2PListener);
            this.mSocket.on("onRemoveTrack", this.onRemoveTrack);
            this.mSocket.on("unpublish_me", this.onUnpublish_me);
            this.mSocket.on("onBandwidthAlert", this.ononBandwidthAlert);
            this.mSocket.on("connection_failed", this.onConnection_failed);
            this.mSocket.on("error", this.onError);
            this.mSocket.on("reconnecting", this.onReconnecting);
            this.mSocket.on("reconnect", this.onReconnect);
            this.mSocket.on("reconnected", this.onReconnected);
            this.mSocket.on("reconnect_attempt", this.onReconnect_attempt);
            this.mSocket.on("reconnect_error", this.onReconnect_error);
            this.mSocket.on("reconnect_failed", this.onReConnectFailed);
            this.mSocket.on("user-connected", this.onUserConnected);
            this.mSocket.on("user-disconnected", this.onUserDisconnected);
            this.mSocket.on("user-subscribed", this.onUserSubscribed);
            this.mSocket.on("user-unsubscribed", this.onUserUnsubscribed);
            this.mSocket.on("floorRequested", this.onfloorRequestedProcessed);
            this.mSocket.on("floorGranted", this.onfloorGrantedSuccess);
            this.mSocket.on("floorDenied", this.onfloorDenySuccess);
            this.mSocket.on("floorReleased", this.onfloorReleasedSuccess);
            this.mSocket.on("hardMute", this.onhardMute);
            this.mSocket.on("hardMuteRoom", this.onhardMuteRoom);
            this.mSocket.on("room-record-on", this.roomRecordOn);
            this.mSocket.on("room-record-off", this.roomRecordOff);
            this.mSocket.connect();
        }
        catch (Exception e) {
            this.mVCXSignalingObserver.onRoomErrorInRoom(e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.mSocketLock;
        synchronized (object) {
            if (this.mSocket != null) {
                this.mSocket.disconnect();
                this.mSocket = null;
            }
        }
    }

    private final String decodeToken(String result) {
        try {
            String token = new String(Base64.decode((byte[])result.getBytes(), (int)0), "UTF-8");
            JSONObject jsonToken = new JSONObject(token);
            VCXConstant.LogId = jsonToken.getString("logId");
            Logging.d((String)VCXConstant.LogId, (String)("token decoded: " + token));
            return token;
        }
        catch (Exception e) {
            Logging.d((String)VCXConstant.LogId, (String)("Failed to decode token: " + e.getMessage()));
            return null;
        }
    }

    public void startRecording() {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject();
            jsonObject.put("to", null);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Logging.d((String)VCXConstant.LogId, (String)"Recording start:");
        this.mSocket.emit("startRecord", new Object[]{jsonObject, new Ack(){

            public void call(Object ... args) {
                VCXSignaling.this.mVCXSignalingObserver.onAcknowledgeStartRecording(args);
            }
        }});
    }

    public void stopRecording() {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject();
            jsonObject.put("id", null);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Logging.d((String)VCXConstant.LogId, (String)"Recording stop:");
        this.mSocket.emit("stopRecord", new Object[]{jsonObject, new Ack(){

            public void call(Object ... args) {
                VCXSignaling.this.mVCXSignalingObserver.onAcknowledgeStopRecording(args);
            }
        }});
    }

    public void postClientLogs() {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                VCXLogsUtil vcxLogsUtil = VCXLogsUtil.getInstance((Context)VCXSignaling.this.mActivity);
                String logs = vcxLogsUtil.readLogsFromFile();
                Logging.d((String)VCXConstant.LogId, (String)"posting client logs:");
                if (VCXConstant.LogId != null) {
                    VCXSignaling.this.mSocket.emit("clientLogPosted", new Object[]{VCXConstant.LogId, logs, VCXSignaling.this.onAcknowledgeClientLogs});
                }
            }
        });
    }

    public void requestFloor() {
        this.mSocket.emit("requestFloor", new Object[]{this.onAcknowledgerequestFlloor});
    }

    public void processFloorRequest(String processFloorRequestCode, String clientId) {
        this.clientId = clientId;
        String message = "";
        if (processFloorRequestCode.equalsIgnoreCase("grantFloor")) {
            message = "grantFloor";
        } else if (processFloorRequestCode.equalsIgnoreCase("denyFloor")) {
            message = "denyFloor";
        } else if (processFloorRequestCode.equalsIgnoreCase("releaseFloor")) {
            message = "releaseFloor";
        }
        this.mSocket.emit("processFloorRequest", new Object[]{clientId, message, this.onAcknowledgeprocessFloorRequest});
    }

    public void previousProcessFloorRequest(String processFloorRequestCode, String clientId) {
        this.mSocket.emit("processFloorRequest", new Object[]{clientId, processFloorRequestCode, new Ack(){

            public void call(Object ... args) {
            }
        }});
    }

    public void muteAll() {
        this.mSocket.emit("muteAll", new Object[]{this.onAcknowledgeMuteAll});
    }

    public void unMuteAll() {
        this.mSocket.emit("unMuteAll", new Object[]{this.onAcknowledgeUnMuteAll});
    }

    public void muteUser(String clientId) {
        this.mSocket.emit("muteUser", new Object[]{clientId, this.onAcknowledgeMuteUser});
    }

    public void unMuteUser(String clientId) {
        this.mSocket.emit("unMuteUser", new Object[]{clientId, this.onAcknowledgeUnMuteUser});
    }

    public void muteSelfAudio() {
    }

    private SSLContext trustEveryone() {
        SSLContext mySSLContext = null;
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            mySSLContext = SSLContext.getInstance("TLS");
            mySSLContext.init(null, trustAllCerts, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mySSLContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageSocket(String channel, Object param, Ack ack) {
        Object object = this.mSocketLock;
        synchronized (object) {
            if (this.mSocket == null) {
                return;
            }
            JSONArray jsonArgs = new JSONArray();
            jsonArgs.put(param);
            try {
                JSONObject jsonObject = new JSONObject(this.token);
                this.mSocket.emit(channel, new Object[]{jsonObject, ack});
            }
            catch (Exception e) {
                this.mVCXSignalingObserver.onRoomErrorInRoom(e);
                e.printStackTrace();
            }
        }
    }

    public void unpublishStream(String eventType, String streamId, Ack ack) {
        try {
            this.mSocket.emit(eventType, new Object[]{Long.parseLong(streamId), ack});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void emitEvent(String type, JSONObject jsonObject) {
        this.mSocket.emit(type, new Object[]{jsonObject, this.onAcknowledge});
    }

    public void emitEvent(String type, JSONObject jsonObject, Ack ack) {
        this.mSocket.emit(type, new Object[]{jsonObject, ack});
    }

    public void sendMessage(String type, JSONObject jsonObject) {
        this.mSocket.emit(type, new Object[]{jsonObject, null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendSDPSocket(String type, JSONObject param0, JSONObject param1, Ack ack, String str) {
        Object object = this.mSocketLock;
        synchronized (object) {
            if (this.mSocket == null) {
                return;
            }
            JSONArray jsonArgs = new JSONArray();
            jsonArgs.put((Object)param0);
            jsonArgs.put((Object)param1);
            this.mSocket.emit(type, new Object[]{param0, null, ack});
        }
    }
}

