/*
 * Decompiled with CFR 0.152.
 */
package vcxsdk.Controller;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.util.Base64;
import android.view.View;
import android.widget.RelativeLayout;
import io.socket.client.Ack;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.AudioTrack;
import org.webrtc.Camera1Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.ContextUtils;
import org.webrtc.DataChannel;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.Logging;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RtpReceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import vcxsdk.AudioVideoManager.VCXAudioManager;
import vcxsdk.Controller.VCXRoomObserver;
import vcxsdk.Controller.VCXSignaling;
import vcxsdk.Controller.VCXSignalingObserver;
import vcxsdk.Streams.VCXStream;
import vcxsdk.Streams.VCXStreamObserver;
import vcxsdk.Utilities.VCXConstant;
import vcxsdk.Utilities.VCXLogsUtil;
import vcxsdk.Utilities.VCXUtils;
import vcxsdk.services.VCXService;

public class VCXRoom
implements VCXSignalingObserver {
    private static boolean sInitializedAndroidGlobals;
    VCXSignaling vcxSignaling;
    volatile State mState = State.kUninitialized;
    JSONObject mTurnServer;
    String mStunServerUrl;
    int mDefaultVideoBW;
    int mMaxVideoBW = 75;
    int mMaxAudioBW = 25;
    ConcurrentHashMap<String, VCXStream> mRemoteStream = new ConcurrentHashMap();
    HashMap<String, VCXStream> mLocalStream = new HashMap();
    String mRoomId;
    ConcurrentLinkedQueue<VCXRoomObserver> mObservers = new ConcurrentLinkedQueue();
    private VideoSource mVideoSource;
    public static VideoCapturer mVideoCapturer;
    private boolean mVideoStopped = false;
    private static PeerConnectionFactory sFactory;
    PeerConnectionFactory.Options options = null;
    volatile ArrayList<PeerConnection.IceServer> mIceServers = new ArrayList();
    private static Object sVcLock;
    private boolean mPermissionPublish;
    private boolean mPermissionSubscribe;
    private static final String VIDEO_CODEC_VP9 = "VP9";
    private final ExecutorService executor;
    public String localStreamID = "";
    private JSONArray streams;
    boolean mAudio;
    boolean mVideo;
    boolean mData;
    public static boolean isvideoMute;
    int mMaxWidth;
    int mMaxHeight;
    String publisher_name;
    private PowerManager.WakeLock wl;
    private int field = 32;
    PowerManager pm;
    String clientId;
    String realeaseClientId;
    boolean moderatorHardMuteActiveState;
    public boolean participantHardMuteActiveState;
    public JSONObject roomMetadata;
    private CancelableRunnable mRefreshTokenRunnable;
    ArrayList<String> candidateList = new ArrayList();
    boolean muteVideoStatus;
    boolean unMuteVideoStatus;
    boolean frontFacing = true;
    private volatile Activity mActivity;
    VCXRoomObserver mVCXRoomObserver;
    private MediaStream lMS;
    EglBase rootEglBase;
    List<String> mStreamList;
    HashMap<String, VCXStream> hashMapRemoteStreamS;
    HashMap<String, RelativeLayout> hashMapRemoteStreamLayouts;
    MyPcObserver pcObsPublish;
    HashMap<String, MyPcObserver> pcObserverHashMap = new HashMap();
    VideoTrack videoTrack;
    VCXStream publishedStream;
    MediaConstraints videoConstraints;
    MediaConstraints audioConstraints;
    PeerConnection pc_local = null;
    boolean muteAll;
    public VCXAudioManager audioManager = null;
    RelativeLayout remoteRelativeLayout = null;
    int index = 0;
    VCXStreamObserver mVCXStreamObserver;
    private static String mMode;

    private void requesttoMuteVideo(boolean value) {
        if (!value) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        VCXRoom.this.muteVideoStatus = ((VideoTrack)((VCXRoom)VCXRoom.this).lMS.videoTracks.getFirst()).setEnabled(true);
                    }
                    catch (Exception e) {
                        Logging.d((String)VCXConstant.LogId, (String)("MuteUnMuteVideo: " + e));
                    }
                }
            });
        } else {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        VCXRoom.this.unMuteVideoStatus = ((VideoTrack)((VCXRoom)VCXRoom.this).lMS.videoTracks.getFirst()).setEnabled(false);
                    }
                    catch (Exception e) {
                        Logging.d((String)VCXConstant.LogId, (String)("MuteUnMuteVideo: " + e));
                    }
                }
            });
        }
    }

    public VCXRoom(VCXRoomObserver vCXRoomObserver, VCXStreamObserver vcxStreamObserver) {
        this.executor = Executors.newSingleThreadExecutor();
        this.rootEglBase = EglBase.create();
        this.mStreamList = new ArrayList<String>();
        this.hashMapRemoteStreamS = new HashMap();
        this.hashMapRemoteStreamLayouts = new HashMap();
        this.mVCXRoomObserver = vCXRoomObserver;
        this.mVCXStreamObserver = vcxStreamObserver;
    }

    public void onStart() {
    }

    public void onPause() {
        try {
            if (this.audioManager != null) {
                this.audioManager.stopProximitySensors();
            }
            if (this.mVideoSource != null) {
                this.mVideoStopped = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onStop() {
        try {
            if (mVideoCapturer != null) {
                mVideoCapturer.stopCapture();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onResume() {
        try {
            if (this.audioManager != null) {
                this.audioManager.startProximitySensors((Context)this.mActivity);
                this.audioManager.restoreAudioState();
            }
            if (this.mVideoSource != null && this.mVideoStopped) {
                this.mVideoStopped = false;
                if (mVideoCapturer != null) {
                    mVideoCapturer.startCapture(1280, 720, 30);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        try {
            this.removeObserver(this.mVCXRoomObserver);
            this.disconnectHandle();
            if (this.audioManager != null) {
                this.audioManager.stop();
            }
            this.mActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VCXRoom.this.mActivity.stopService(new Intent(VCXRoom.this.mActivity.getBaseContext(), VCXService.class));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public State getState() {
        return this.mState;
    }

    public boolean isConnected() {
        return this.mState == State.kConnected || this.mState == State.kConnecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Activity context) {
        Object object = sVcLock;
        synchronized (object) {
        }
        if (context == null) {
            throw new NullPointerException("Failed to initialize VCXRoom. Activity is required.");
        }
        this.mActivity = context;
        this.mState = State.kDisconnected;
        try {
            this.field = PowerManager.class.getClass().getField("PROXIMITY_SCREEN_OFF_WAKE_LOCK").getInt(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pm = (PowerManager)this.mActivity.getSystemService("power");
        this.wl = this.pm.newWakeLock(this.field, this.mActivity.getLocalClassName());
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VCXRoom.this.mActivity.getWindow().addFlags(128);
            }
        });
        VCXLogsUtil vcxLogsUtil = VCXLogsUtil.getInstance((Context)this.mActivity);
        if (vcxLogsUtil.getLogsEnable()) {
            this.mActivity.startService(new Intent(this.mActivity.getBaseContext(), VCXService.class));
        }
        Runnable init = new Runnable(){

            @Override
            public void run() {
                if (!sInitializedAndroidGlobals) {
                    sInitializedAndroidGlobals = true;
                    PeerConnectionFactory.initializeAndroidGlobals((Context)VCXRoom.this.mActivity, (boolean)sInitializedAndroidGlobals);
                }
                VCXRoom.this.options = new PeerConnectionFactory.Options();
                VCXRoom.this.options.networkIgnoreMask = 0;
                if (sFactory == null) {
                    sFactory = new PeerConnectionFactory(VCXRoom.this.options);
                }
            }
        };
        this.executor.execute(init);
    }

    public void setBandwidthLimits(int video, int audio) {
        this.mMaxVideoBW = video;
        this.mMaxAudioBW = audio;
    }

    public void connect(String token) {
        if (this.mState == State.kUninitialized) {
            return;
        }
        if (this.isConnected()) {
            return;
        }
        this.mState = State.kConnecting;
        if (this.vcxSignaling != null) {
            this.vcxSignaling.connectSignaling(token);
        }
    }

    private static final String decodeToken(String result) {
        try {
            String token = new String(Base64.decode((byte[])result.getBytes(), (int)0), "UTF-8");
            Logging.v((String)VCXConstant.LogId, (String)("VCX token decoded: " + token));
            return token;
        }
        catch (UnsupportedEncodingException e) {
            Logging.v((String)VCXConstant.LogId, (String)("Failed to decode token: " + e.getMessage()));
            return null;
        }
    }

    void disconnectHandle() {
        if (this.mState == State.kUninitialized || this.mState == State.kDisconnected || this.mState == State.kDisconnecting) {
            return;
        }
        if (this.mState == State.kConnecting) {
            // empty if block
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                VCXRoom.this.doDisconnect();
            }
        });
    }

    void doDisconnect() {
        this.mState = State.kDisconnecting;
        for (VCXRoomObserver obs : this.mObservers) {
            obs.onRoomDisConnected("Room Disconnected");
        }
        Set keyset = this.mRemoteStream.keySet();
        for (String key : keyset) {
            VCXStream stream = this.mRemoteStream.get(key);
            this.removeStream(stream, key);
            this.triggerStreamRemoved(stream, key);
        }
        if (this.mRemoteStream != null && this.mRemoteStream.size() > 0) {
            this.mRemoteStream.clear();
        }
        if (this.mLocalStream.size() > 0) {
            this.unpublish();
        }
        this.vcxSignaling.disconnect();
        this.mState = State.kDisconnected;
    }

    @Override
    public void onReceiveSignalingMessage(Object ... args) {
        try {
            JSONObject jsonObjectroot = (JSONObject)args[0];
            JSONObject jsonObject = ((JSONObject)args[0]).getJSONObject("mess");
            if (jsonObject.getString("type").equalsIgnoreCase("answer")) {
                VCXStream stream;
                String sdp = jsonObject.getString("sdp");
                Logging.d((String)VCXConstant.LogId, (String)("answer sdp: " + sdp));
                if (jsonObjectroot.toString().contains("streamId")) {
                    String StreamId = jsonObjectroot.getString("streamId");
                    stream = this.mLocalStream.get(StreamId);
                } else {
                    String StreamId = jsonObjectroot.getString("peerId");
                    stream = this.mRemoteStream.get(StreamId);
                }
                String preferredVideoCodec = VIDEO_CODEC_VP9;
                SessionDescription finalRemoteSdp = new SessionDescription(SessionDescription.Type.ANSWER, sdp);
                String sdpDescription = VCXRoom.preferCodec(finalRemoteSdp.description, preferredVideoCodec, false);
                SessionDescription sdpRemote = new SessionDescription(finalRemoteSdp.type, sdpDescription);
                try {
                    if (jsonObjectroot.toString().contains("streamId")) {
                        stream.pc.setRemoteDescription((SdpObserver)this.pcObsPublish.getSdpObserver(), sdpRemote);
                    } else {
                        stream.pc.setRemoteDescription((SdpObserver)this.pcObserverHashMap.get(jsonObjectroot.getString("peerId")).getSdpObserver(), sdpRemote);
                    }
                    Logging.d((String)VCXConstant.LogId, (String)("sdp for setting remote description: " + sdpRemote));
                }
                catch (Exception e) {
                    Logging.d((String)VCXConstant.LogId, (String)("sdp for setting remote description: " + e.getMessage()));
                    e.printStackTrace();
                }
            } else if (jsonObject.getString("type").equalsIgnoreCase("ready")) {
                String sdp = "";
            } else if (jsonObjectroot.toString().contains("peerId")) {
                VCXStream stream = this.mLocalStream.get(jsonObjectroot.getString("peerId"));
                JSONObject p1 = new JSONObject();
                p1.put("streamId", (Object)jsonObjectroot.getString("peerId"));
                JSONObject jsonObjectMsg = new JSONObject();
                jsonObjectMsg.put("type", (Object)"offer");
                jsonObjectMsg.put("sdp", (Object)this.pcObserverHashMap.get((Object)jsonObjectroot.getString((String)"peerId")).getSdpObserver().mLocalSdp.description);
                p1.put("msg", (Object)jsonObjectMsg);
                this.vcxSignaling.emitEvent("signaling_message", p1);
                Logging.d((String)VCXConstant.LogId, (String)("signalingMessage while peerId: " + stream));
            }
        }
        catch (Exception e) {
            Logging.d((String)VCXConstant.LogId, (String)("onsignalingMessage: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    @Override
    public void onAddStreamInRoom(Object ... args) {
        try {
            boolean isLocal;
            JSONObject jsonObject = (JSONObject)args[0];
            VCXStream stream = VCXStream.parseJson(jsonObject, this.vcxSignaling, this.mVCXStreamObserver);
            boolean bl = isLocal = this.mLocalStream.get(stream.getId()) != null;
            if (!isLocal) {
                this.mRemoteStream.put(stream.getId(), stream);
                this.triggerStreamAdded(stream);
                Logging.d((String)VCXConstant.LogId, (String)("AddStreamInRoom: " + jsonObject.toString()));
            }
        }
        catch (Exception e) {
            Logging.d((String)VCXConstant.LogId, (String)("AddStreamInRoom: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    @Override
    public void onDataAdded(Object ... args) {
        try {
            Logging.d((String)VCXConstant.LogId, (String)("Chat Messages Recieved success: " + args));
            JSONObject chatJsonObject = (JSONObject)args[0];
            this.triggerChatAdded(chatJsonObject);
        }
        catch (Exception e) {
            JSONObject chatJsonObject = this.getCustomJsonObject(e.getMessage(), 9006);
            this.triggerChatAdded(chatJsonObject);
            Logging.d((String)VCXConstant.LogId, (String)("Chat Messages Recieved exception: " + args));
        }
    }

    @Override
    public void onfloorRequestedProcessedInRoom(Object ... args) {
        this.triggerRecievedFloorRequest(args);
    }

    @Override
    public void onfloorGrantedSuccessInRoom(Object ... args) {
        this.setMode("group");
        this.triggerGrantSuccess(args);
    }

    @Override
    public void onfloorDenySuccessInRoom(Object ... args) {
        if (this.vcxSignaling.mode != null) {
            this.setMode(this.vcxSignaling.mode);
        }
        this.triggerDenySuccess(args);
    }

    @Override
    public void onfloorReleasedSuccessInRoom(Object ... args) {
        this.triggerReleasedSuccess(args);
    }

    @Override
    public void onhardMuteSuccessInRoom(Object ... args) {
        try {
            JSONObject jsonObject = (JSONObject)args[0];
            this.triggerhardMute(jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onhardMuteRoomSuccessInRoom(Object ... args) {
        try {
            JSONObject jsonObject = (JSONObject)args[0];
            this.triggerhardMuteRoom(jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void roomRecordOnSuccessInRoom(Object ... args) {
        try {
            JSONObject jsonObject = (JSONObject)args[0];
            this.triggerroomRecordOn(jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void roomRecordOffSuccessInRoom(Object ... args) {
        try {
            JSONObject jsonObject = (JSONObject)args[0];
            this.triggerroomRecordOff(jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onAcknowledgeLogsInRoom(Object ... args) {
        try {
            String str = args[0].toString();
            if (str.equalsIgnoreCase("log received")) {
                Logging.d((String)VCXConstant.LogId, (String)"log send successfully");
                VCXLogsUtil vcxLogsUtil = VCXLogsUtil.getInstance((Context)this.mActivity);
                vcxLogsUtil.cleanLogsFile(1);
                vcxLogsUtil.cleanLogsFile(2);
                Logging.d((String)VCXConstant.LogId, (String)"log file deleted");
                this.triggerAcknowledgeLogUpload(str);
            } else {
                this.triggerAcknowledgeLogUpload(str);
            }
        }
        catch (Exception e) {
            this.triggerAcknowledgeLogUpload(e.getMessage());
        }
    }

    @Override
    public void onAcknowledgerequestFlloorInRoom(Object ... args) {
        this.triggerAcknowledFloorRequest(args);
    }

    @Override
    public void onAcknowledprocessFloorInRoom(Object ... args) {
        this.triggerAcknowledProcessFloorRequest(args);
    }

    @Override
    public void onAcknowledgeMuteAllInRoom(Object ... args) {
        this.triggerAcknowledMuteAll(args);
    }

    @Override
    public void onAcknowledgeUnMuteAllInRoom(Object ... args) {
        this.triggerAcknowledUnMuteAll(args);
    }

    @Override
    public void onAcknowledgeMuteUserInRoom(Object ... args) {
        this.triggerAcknowledMuteUser(args);
    }

    @Override
    public void onAcknowledgeUnMuteUserInRoom(Object ... args) {
        this.triggerAcknowledUnMuteUser(args);
    }

    @Override
    public void onReconnectInRoom() {
        this.triggerReconnect();
    }

    @Override
    public void onRoomErrorInRoom(Exception e) {
    }

    @Override
    public void onRemoveStreamInRoom(Object ... args) {
        try {
            String streamId = new JSONObject(args[0].toString()).getString("id");
            VCXStream stream = this.mRemoteStream.get(streamId);
            if (stream != null) {
                Logging.d((String)VCXConstant.LogId, (String)("RemoveStreamInRoom: " + stream));
                this.removeStream(stream, streamId);
                this.mRemoteStream.remove(streamId);
                this.triggerStreamRemoved(stream, streamId);
                if (stream.pc != null) {
                    stream.pc.close();
                }
            }
        }
        catch (Exception e) {
            Logging.d((String)VCXConstant.LogId, (String)("RemoveStreamInRoom: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    @Override
    public void onUserConnectedInRoom(Object ... args) {
        try {
            JSONObject jsonObject = (JSONObject)args[0];
            this.triggerUserConnected(jsonObject);
        }
        catch (Exception e) {
            JSONObject jsonObject = this.getCustomJsonObject(e.getMessage(), 9004);
            this.triggerUserConnected(jsonObject);
        }
    }

    @Override
    public void onUserDisConnectedInRoom(Object ... args) {
        try {
            JSONObject jsonObject = (JSONObject)args[0];
            this.triggerUserDisConnected(jsonObject);
        }
        catch (Exception e) {
            JSONObject jsonObject = this.getCustomJsonObject(e.getMessage(), 9005);
            this.triggerUserDisConnected(jsonObject);
        }
    }

    @Override
    public void onBandWidthAlertInRoom(Object ... args) {
        try {
            JSONObject jsonObject = (JSONObject)args[0];
            VCXStream remoteStream = this.mRemoteStream.get("");
            this.publishedStream.setBandWidthAlert(remoteStream, jsonObject);
        }
        catch (Exception e) {
            JSONObject jsonObject = this.getCustomJsonObject(e.getMessage(), 9005);
            this.triggerUserDisConnected(jsonObject);
        }
    }

    @Override
    public void onAcknowledgeInRoom(Object ... args) {
        try {
            JSONObject jsonObject;
            this.roomMetadata = jsonObject = (JSONObject)args[1];
            this.parseVideoTokenResponseFromServer(jsonObject);
            Logging.d((String)VCXConstant.LogId, (String)("AcknowledgeInRoom: " + jsonObject.toString()));
            if (jsonObject.has("iceServers")) {
                JSONArray jsonArrayStun = jsonObject.getJSONArray("iceServers");
                for (int i = 0; i < jsonArrayStun.length(); ++i) {
                    if (jsonArrayStun.getJSONObject(i).has("username")) {
                        String url = jsonArrayStun.getJSONObject(i).getJSONArray("urls").get(0).toString();
                        String usr = jsonArrayStun.getJSONObject(i).getString("username");
                        String pwd = jsonArrayStun.getJSONObject(i).getString("credential");
                        if (url.isEmpty()) continue;
                        this.mIceServers.add(new PeerConnection.IceServer(url, usr, pwd));
                        continue;
                    }
                    this.mStunServerUrl = jsonArrayStun.getJSONObject(i).getJSONArray("urls").get(0).toString();
                    if (this.mStunServerUrl.isEmpty()) continue;
                    this.mIceServers.add(new PeerConnection.IceServer(this.mStunServerUrl, "", "", PeerConnection.TlsCertPolicy.TLS_CERT_POLICY_INSECURE_NO_CHECK));
                }
            }
            if (jsonObject.has("defaultVideoBW")) {
                this.mDefaultVideoBW = jsonObject.getInt("defaultVideoBW");
            }
            if (jsonObject.has("maxVideoBW")) {
                this.mMaxVideoBW = jsonObject.getInt("maxVideoBW");
            }
            this.mState = State.kConnected;
            this.mRoomId = jsonObject.getString("id");
            for (VCXRoomObserver obs : this.mObservers) {
                obs.onRoomConnected(this);
            }
            this.streams = jsonObject.getJSONArray("streams");
            JSONArray raishands = jsonObject.getJSONArray("raisedHands");
            JSONArray approvedHands = jsonObject.getJSONArray("approvedHands");
            JSONArray userList = jsonObject.getJSONArray("userList");
            if (approvedHands.length() > 0) {
                this.setMode("group");
            }
            JSONObject jsonObject1 = new JSONObject();
            jsonObject1.put("raisedHands", (Object)raishands);
            jsonObject1.put("approvedHands", (Object)approvedHands);
            jsonObject1.put("userList", (Object)userList);
            if (this.streams.length() > 0) {
                JSONObject arg = this.streams.getJSONObject(0);
                VCXStream stream = VCXStream.parseJson(arg, this.vcxSignaling, this.mVCXStreamObserver);
                this.mRemoteStream.put(stream.getId(), stream);
                this.triggerStreamAdded(stream);
            }
            this.triggerChairControlActivities(jsonObject1);
        }
        catch (Exception e) {
            Logging.d((String)VCXConstant.LogId, (String)("onAcknowledgeInRoom: " + e.getMessage()));
        }
    }

    public JSONObject getRoomMetadata() {
        return this.roomMetadata;
    }

    private void removeRenderedView(String streamId) {
        this.mStreamList.remove(streamId.trim());
        if (this.mVCXRoomObserver != null) {
            this.mVCXRoomObserver.onRemoveSubscribedStream(streamId.trim());
        }
        Logging.d((String)VCXConstant.LogId, (String)"remove stream from streamList");
    }

    public void sendDataSocket(String streamId, String message, String from) {
        JSONObject param = new JSONObject();
        try {
            if (streamId == null || streamId.trim().equalsIgnoreCase("")) {
                return;
            }
            param.put("id", Long.parseLong(streamId));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("message", (Object)message);
            jsonObject.put("from", (Object)from);
            jsonObject.put("type", (Object)"public");
            jsonObject.put("timestamp", (Object)VCXUtils.getCurrentTimeInMillSecond());
            param.put("msg", (Object)jsonObject);
            this.vcxSignaling.sendMessage("sendDataStream", param);
            Logging.d((String)VCXConstant.LogId, (String)("data sent: " + param));
        }
        catch (JSONException e) {
            Logging.d((String)VCXConstant.LogId, (String)("data sent: " + e.getMessage()));
        }
    }

    void removeStream(VCXStream stream, String id) {
        stream.onClosing();
    }

    public void unsubscribe(String streamId) {
        VCXStream stream = this.mRemoteStream.get(streamId);
        if (stream != null) {
            this.disable(stream);
        }
    }

    public void addObserver(final VCXRoomObserver observer) {
        this.mObservers.add(observer);
        if (this.isConnected()) {
            this.mActivity.getWindow().getDecorView().post(new Runnable(){

                @Override
                public void run() {
                    observer.onRoomConnected(VCXRoom.this);
                }
            });
        }
    }

    public void removeObserver(VCXRoomObserver observer) {
        this.mObservers.remove(observer);
    }

    private VideoCapturer getVideoCapturer() {
        Logging.d((String)VCXConstant.LogId, (String)"Creating capturer using camera1 API.");
        VideoCapturer videoCapturer = this.createCameraCapturer((CameraEnumerator)new Camera1Enumerator(false));
        return videoCapturer;
    }

    private VideoCapturer createCameraCapturer(CameraEnumerator enumerator) {
        CameraVideoCapturer videoCapturer;
        String[] deviceNames = enumerator.getDeviceNames();
        Logging.d((String)VCXConstant.LogId, (String)"Looking for front facing cameras.");
        for (String deviceName : deviceNames) {
            if (!enumerator.isFrontFacing(deviceName)) continue;
            Logging.d((String)VCXConstant.LogId, (String)"Creating front facing camera capturer.");
            videoCapturer = enumerator.createCapturer(deviceName, null);
            if (videoCapturer == null) continue;
            return videoCapturer;
        }
        Logging.d((String)VCXConstant.LogId, (String)"Looking for other cameras.");
        for (String deviceName : deviceNames) {
            if (enumerator.isFrontFacing(deviceName)) continue;
            Logging.d((String)VCXConstant.LogId, (String)"Creating other camera capturer.");
            videoCapturer = enumerator.createCapturer(deviceName, null);
            if (videoCapturer == null) continue;
            return videoCapturer;
        }
        return null;
    }

    private static String preferCodec(String sdpDescription, String codec, boolean isAudio) {
        String[] lines = sdpDescription.split("\r\n");
        int mLineIndex = VCXRoom.findMediaDescriptionLine(isAudio, lines);
        if (mLineIndex == -1) {
            Logging.d((String)VCXConstant.LogId, (String)("No mediaDescription line, so can't prefer " + codec));
            return sdpDescription;
        }
        ArrayList<String> codecPayloadTypes = new ArrayList<String>();
        Pattern codecPattern = Pattern.compile("^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$");
        for (int i = 0; i < lines.length; ++i) {
            Matcher codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches() || !codecMatcher.group(1).trim().contains("H264")) continue;
            codecPayloadTypes.add(codecMatcher.group(1));
        }
        if (codecPayloadTypes.isEmpty()) {
            return sdpDescription;
        }
        String newMLine = VCXRoom.movePayloadTypesToFront(codecPayloadTypes, lines[mLineIndex]);
        if (newMLine == null) {
            return sdpDescription;
        }
        lines[mLineIndex] = newMLine;
        return VCXRoom.joinString(Arrays.asList(lines), "\r\n", true);
    }

    private static int findMediaDescriptionLine(boolean isAudio, String[] sdpLines) {
        String mediaDescription = isAudio ? "m=audio " : "m=video ";
        for (int i = 0; i < sdpLines.length; ++i) {
            if (!sdpLines[i].startsWith(mediaDescription)) continue;
            return i;
        }
        return -1;
    }

    private static String joinString(Iterable<? extends CharSequence> s, String delimiter, boolean delimiterAtEnd) {
        Iterator<? extends CharSequence> iter = s.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(iter.next());
        }
        if (delimiterAtEnd) {
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private static String movePayloadTypesToFront(List<String> preferredPayloadTypes, String mLine) {
        List<String> origLineParts = Arrays.asList(mLine.split(" "));
        if (origLineParts.size() <= 3) {
            return null;
        }
        List<String> header = origLineParts.subList(0, 3);
        ArrayList<String> unpreferredPayloadTypes = new ArrayList<String>(origLineParts.subList(3, origLineParts.size()));
        unpreferredPayloadTypes.removeAll(preferredPayloadTypes);
        ArrayList<String> newLineParts = new ArrayList<String>();
        newLineParts.addAll(header);
        newLineParts.addAll(preferredPayloadTypes);
        newLineParts.addAll(unpreferredPayloadTypes);
        return VCXRoom.joinString(newLineParts, " ", false);
    }

    public boolean isVideoViewExist(String streamID) {
        boolean value = false;
        for (int i = 0; i < this.mStreamList.size(); ++i) {
            if (!this.mStreamList.get(i).equals(streamID)) continue;
            return true;
        }
        return value;
    }

    public MediaConstraints makePcConstraints() {
        MediaConstraints pcConstraints = new MediaConstraints();
        pcConstraints.optional.add(new MediaConstraints.KeyValuePair("RtpDataChannels", "true"));
        pcConstraints.optional.add(new MediaConstraints.KeyValuePair("EnableDtlsSrtp", "true"));
        pcConstraints.optional.add(new MediaConstraints.KeyValuePair("DtlsSrtpKeyAgreement", "true"));
        return pcConstraints;
    }

    public void publish() {
        if (this.mPermissionPublish && this.isConnected() && this.getMode() != null) {
            if (this.getMode().trim().equalsIgnoreCase("group")) {
                this.doPublish();
            } else if (VCXUtils.getRole().equalsIgnoreCase("moderator")) {
                this.doPublish();
            }
        }
    }

    public VCXStream getLocalStream(JSONObject publishInfo) {
        try {
            if (this.vcxSignaling == null) {
                this.vcxSignaling = new VCXSignaling(this.mActivity, this);
            }
            try {
                this.mAudio = publishInfo.getBoolean("audio");
                this.mVideo = publishInfo.getBoolean("video");
                this.mData = publishInfo.getBoolean("data");
                this.mMaxVideoBW = publishInfo.getInt("maxVideoBW");
                this.mMaxAudioBW = publishInfo.getInt("maxAudioBW");
                this.mMaxWidth = publishInfo.getInt("maxWidth");
                this.mMaxHeight = publishInfo.getInt("maxHeight");
                this.publisher_name = publishInfo.getString("name");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (sFactory == null) {
                if (!sInitializedAndroidGlobals) {
                    sInitializedAndroidGlobals = true;
                    PeerConnectionFactory.initializeAndroidGlobals((Context)this.mActivity, (boolean)sInitializedAndroidGlobals);
                }
                this.options = new PeerConnectionFactory.Options();
                this.options.networkIgnoreMask = 0;
                this.options.disableNetworkMonitor = true;
                if (sFactory == null) {
                    sFactory = new PeerConnectionFactory(this.options);
                }
            }
            this.videoConstraints = new MediaConstraints();
            this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair("maxWidth", String.valueOf(this.mMaxWidth)));
            this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair("maxHeight", String.valueOf(this.mMaxHeight)));
            this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair("maxVideoBW", String.valueOf(this.mMaxVideoBW)));
            this.videoConstraints.mandatory.add(new MediaConstraints.KeyValuePair("maxFrameRate", "100"));
            this.audioConstraints = new MediaConstraints();
            this.audioConstraints.optional.add(new MediaConstraints.KeyValuePair("googEchoCancellation2", "true"));
            this.audioConstraints.optional.add(new MediaConstraints.KeyValuePair("googEchoCancellation", "true"));
            this.audioConstraints.optional.add(new MediaConstraints.KeyValuePair("googNoiseSuppression", "true"));
            this.lMS = sFactory.createLocalMediaStream("ARDAMS");
            Logging.d((String)VCXConstant.LogId, (String)("Local Media Stream: " + this.lMS));
            if (this.videoConstraints != null) {
                mVideoCapturer = this.getVideoCapturer();
                this.mVideoSource = sFactory.createVideoSource(mVideoCapturer);
                this.videoTrack = sFactory.createVideoTrack("ARDAMSv0", this.mVideoSource);
                this.lMS.addTrack(this.videoTrack);
            }
            if (this.audioConstraints != null) {
                AudioTrack audioTrack = sFactory.createAudioTrack("ARDAMSa0", sFactory.createAudioSource(this.audioConstraints));
                this.lMS.addTrack(audioTrack);
            }
            this.publishedStream = new VCXStream("", this.mData, this.mVideo, this.mAudio, false, null, this.publisher_name, this.vcxSignaling, this.mVCXStreamObserver);
            this.publishedStream.setMedia(this.lMS);
            this.publishedStream.vcxRoom = this;
            mVideoCapturer.startCapture(this.mMaxWidth, this.mMaxHeight, 30);
            return this.publishedStream;
        }
        catch (Exception e) {
            Logging.d((String)VCXConstant.LogId, (String)("Local Media Stream: " + e.getMessage()));
            return this.publishedStream;
        }
    }

    void doPublish() {
        try {
            if (sFactory == null) {
                return;
            }
            VCXStream stream = this.publishedStream;
            MediaConstraints pcConstraints = this.makePcConstraints();
            this.pcObsPublish = new MyPcObserver(new VCXSdpObserver(stream, true), stream, true, this.pc_local);
            PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(this.mIceServers);
            rtcConfig.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_CONTINUALLY;
            this.pc_local = sFactory.createPeerConnection(rtcConfig, pcConstraints, (PeerConnection.Observer)this.pcObsPublish);
            this.pc_local.addStream(this.lMS);
            stream.initLocal(this.pc_local, this.pcObsPublish.getSdpObserver());
            Logging.d((String)VCXConstant.LogId, (String)"Publish Stream successfully");
        }
        catch (Exception e) {
            Logging.d((String)VCXConstant.LogId, (String)("Publish Stream Error: " + e.getMessage()));
        }
    }

    public void unpublish() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                VCXRoom.this.doUnpublish();
            }
        });
    }

    void doUnpublish() {
        for (String key : this.mLocalStream.keySet()) {
            VCXStream stream = this.mLocalStream.get(key);
            if (stream == null || !stream.isLocal()) continue;
            stream.pc.removeStream(this.lMS);
            for (VCXRoomObserver obs : this.mObservers) {
                this.streamRemoved(stream, key);
            }
            if (this.mObservers.size() != 0) continue;
            this.destroy(stream);
        }
        this.mLocalStream.clear();
        if (this.lMS != null) {
            this.lMS.dispose();
        }
        if (mVideoCapturer != null) {
            mVideoCapturer.dispose();
        }
        Logging.d((String)VCXConstant.LogId, (String)"Unpublish Successfully");
        this.lMS = null;
        mVideoCapturer = null;
        if (this.mVideoSource != null && !this.mVideoStopped) {
            this.mVideoSource.dispose();
        }
        this.mVideoSource = null;
    }

    public void subscribe(VCXStream stream) {
        if (this.mActivity == null) {
            return;
        }
        this.doSubscribe(stream);
    }

    private void streamRemoved(final VCXStream stream, final String streamId) {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                stream.detachRenderer();
                VCXRoom.this.destroy(stream);
                VCXRoom.this.removeRenderedView(streamId);
            }
        });
    }

    void doSubscribe(VCXStream stream) {
        try {
            if (stream.isLocal()) {
                Logging.d((String)VCXConstant.LogId, (String)"doSubscribe: Its a local stream");
                return;
            }
            if (sFactory == null) {
                Logging.d((String)VCXConstant.LogId, (String)"doSubscribe: PeerConnectionFactory(sFactory) object is null");
                return;
            }
            if (stream.getMedia() != null) {
                Logging.d((String)VCXConstant.LogId, (String)"doSubscribe: media available in stream and going for rendering");
                this.triggerMediaAvailable(stream);
                return;
            }
            PeerConnection pc = null;
            MyPcObserver pcObsSubscribe = new MyPcObserver(new VCXSdpObserver(stream, false), stream, false, pc);
            this.pcObserverHashMap.put(stream.getId().trim(), pcObsSubscribe);
            PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(this.mIceServers);
            rtcConfig.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_ONCE;
            pc = sFactory.createPeerConnection(rtcConfig, this.makePcConstraints(), (PeerConnection.Observer)pcObsSubscribe);
            stream.initRemote(pc, pcObsSubscribe.getSdpObserver());
            Logging.d((String)VCXConstant.LogId, (String)"doSubscribe: stream is subscribed");
        }
        catch (Exception e) {
            Logging.d((String)VCXConstant.LogId, (String)("doSubscribe: Error in subscribed" + e.getMessage()));
        }
    }

    void triggerStreamAdded(VCXStream stream) {
        for (VCXRoomObserver obs : this.mObservers) {
            obs.onStreamAdded(stream);
        }
    }

    void triggerChatAdded(JSONObject message) {
        this.publishedStream.recievedData(message);
    }

    void triggerRecievedFloorRequest(Object ... args) {
        for (VCXRoomObserver obs : this.mObservers) {
            try {
                JSONObject jsonObject = (JSONObject)args[0];
                obs.onFloorRequestRecieved(jsonObject);
            }
            catch (Exception exception) {}
        }
    }

    void triggerAcknowledProcessFloorRequest(Object ... args) {
        for (VCXRoomObserver obs : this.mObservers) {
            try {
                JSONObject jsonObject = (JSONObject)args[0];
                obs.onProcessFloorRequested(jsonObject);
                int result = jsonObject.getInt("result");
                if (result == 1708) {
                    this.realeaseClientId = this.clientId;
                    if (this.moderatorHardMuteActiveState && this.clientId != null) {
                        this.vcxSignaling.unMuteUser(this.clientId);
                    }
                }
                if (result != 1712) continue;
                this.realeaseClientId = null;
                if (!this.moderatorHardMuteActiveState || this.clientId == null) continue;
                this.vcxSignaling.muteUser(this.clientId);
            }
            catch (Exception e) {
                Logging.d((String)VCXConstant.LogId, (String)("onAcknowledgeprocessFloorRequest" + e));
            }
        }
    }

    void triggerAcknowledFloorRequest(Object ... args) {
        for (VCXRoomObserver obs : this.mObservers) {
            try {
                JSONObject jsonObject = (JSONObject)args[0];
                obs.onFloorRequested(jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void triggerGrantSuccess(Object ... args) {
        this.participantHardMuteActiveState = false;
        for (VCXRoomObserver obs : this.mObservers) {
            try {
                JSONObject jsonObject = (JSONObject)args[0];
                obs.onGrantedFloorRequest(jsonObject);
                this.publish();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void triggerDenySuccess(Object ... args) {
        for (VCXRoomObserver obs : this.mObservers) {
            try {
                JSONObject jsonObject = (JSONObject)args[0];
                obs.onDeniedFloorRequest(jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void triggerReleasedSuccess(Object ... args) {
        for (VCXRoomObserver obs : this.mObservers) {
            try {
                JSONObject jsonObject = (JSONObject)args[0];
                obs.onReleasedFloorRequest(jsonObject);
                this.releaseFloor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void triggerChairControlActivities(JSONObject jsonObject) {
        for (VCXRoomObserver obs : this.mObservers) {
            obs.onChairControlStates(jsonObject);
        }
    }

    void triggerhardMute(JSONObject jsonObject) {
        for (VCXRoomObserver obs : this.mObservers) {
            try {
                String msg;
                if (this.muteAll) {
                    this.participantHardMuteActiveState = false;
                }
                if ((msg = jsonObject.getString("status")).equalsIgnoreCase("on")) {
                    this.publishedStream.muteSelfAudio(false);
                    this.participantHardMuteActiveState = true;
                } else {
                    this.publishedStream.muteSelfAudio(true);
                    this.participantHardMuteActiveState = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            obs.onHardMutedUser(jsonObject);
        }
    }

    void triggerhardMuteRoom(JSONObject jsonObject) {
        for (VCXRoomObserver obs : this.mObservers) {
            try {
                String msg = jsonObject.getString("status");
                if (msg.equalsIgnoreCase("on")) {
                    this.publishedStream.muteSelfAudio(false);
                    this.participantHardMuteActiveState = this.muteAll = true;
                } else {
                    this.participantHardMuteActiveState = this.muteAll = false;
                    this.publishedStream.muteSelfAudio(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            obs.onHardMutedRoom(jsonObject);
        }
    }

    void triggerroomRecordOn(JSONObject jsonObject) {
        for (VCXRoomObserver obs : this.mObservers) {
            obs.onRecordingOn("Room Recording On");
        }
    }

    void triggerroomRecordOff(JSONObject jsonObject) {
        for (VCXRoomObserver obs : this.mObservers) {
            obs.onRecordingOff("Room Record Off");
        }
    }

    void triggerAcknowledgeLogUpload(String message) {
        for (VCXRoomObserver obs : this.mObservers) {
            obs.onLogUploaded(message);
        }
    }

    void triggerStreamRemoved(VCXStream stream, String streamId) {
        for (VCXRoomObserver obs : this.mObservers) {
            this.streamRemoved(stream, streamId);
        }
        if (this.mObservers.size() == 0) {
            this.destroy(stream);
        }
    }

    void triggerPublishAllowed() {
        for (VCXRoomObserver obs : this.mObservers) {
            this.publish();
        }
    }

    void triggerMediaAvailable(VCXStream stream) {
        for (VCXRoomObserver obs : this.mObservers) {
            this.startRendering(stream);
        }
    }

    private void startRendering(VCXStream stream) {
        boolean videoStreamPlaceholder = this.isVideoViewExist(stream.getId());
        if (videoStreamPlaceholder) {
            Logging.d((String)VCXConstant.LogId, (String)"stream is already rendered");
            return;
        }
        this.attachRenderer(stream);
    }

    void triggerReconnect() {
        for (VCXRoomObserver obs : this.mObservers) {
            obs.onReconnect();
        }
    }

    void triggerUserConnected(JSONObject jsonObject) {
        for (VCXRoomObserver obs : this.mObservers) {
            obs.onUserConnected(jsonObject);
        }
    }

    void triggerUserDisConnected(JSONObject jsonObject) {
        for (VCXRoomObserver obs : this.mObservers) {
            obs.onUserDisConnected(jsonObject);
        }
    }

    void triggerAcknowledgeRecordingStart(JSONObject jsonData) {
        for (VCXRoomObserver obs : this.mObservers) {
            obs.onStartRecordingEvent(jsonData);
        }
    }

    void triggerAcknowledgeRecordingStop(JSONObject jsonData) {
        for (VCXRoomObserver obs : this.mObservers) {
            obs.onStopRecordingEvent(jsonData);
        }
    }

    void triggerAcknowledMuteAll(Object ... args) {
        for (VCXRoomObserver obs : this.mObservers) {
            try {
                this.moderatorHardMuteActiveState = true;
                JSONObject jsonObject = (JSONObject)args[0];
                obs.onMutedAllUser(jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void triggerAcknowledUnMuteAll(Object ... args) {
        for (VCXRoomObserver obs : this.mObservers) {
            try {
                this.moderatorHardMuteActiveState = false;
                JSONObject jsonObject = (JSONObject)args[0];
                obs.onUnMutedAllUsers(jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void triggerAcknowledMuteUser(Object ... args) {
        for (VCXRoomObserver obs : this.mObservers) {
            try {
                JSONObject jsonObject = (JSONObject)args[0];
                obs.onMutedSingleUser(jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void triggerAcknowledUnMuteUser(Object ... args) {
        for (VCXRoomObserver obs : this.mObservers) {
            try {
                JSONObject jsonObject = (JSONObject)args[0];
                obs.onUnMutedSingleUser(jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void destroy(VCXStream param0) {
        try {
            VCXStream stream = param0;
            if (stream == null) {
                return;
            }
            if (stream.pc != null && stream.pc.iceConnectionState() == PeerConnection.IceConnectionState.CONNECTED) {
                stream.pc.close();
                stream.pc.dispose();
            }
            stream.onDestroyed();
            if (stream.isLocal()) {
                this.vcxSignaling.unpublishStream("unpublish", stream.getId(), new Ack(){

                    public void call(Object ... args) {
                        String str = "";
                    }
                });
            } else {
                this.mStreamList.remove(stream.getId().trim());
                if (this.mVCXRoomObserver != null) {
                    this.mVCXRoomObserver.onRemoveSubscribedStream(stream.getId().trim());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disable(VCXStream param0) {
        final VCXStream stream = param0;
        if (stream.isLocal()) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                VCXRoom.this.vcxSignaling.sendMessageSocket("unsubscribe", stream.getId(), null);
                stream.detachRenderer();
                stream.pc.close();
                stream.pc.dispose();
                stream.onDisable();
                Logging.d((String)VCXConstant.LogId, (String)"Unsubscribe Stream Successfully");
            }
        });
    }

    public void startRecord() {
        this.vcxSignaling.startRecording();
    }

    public void stopRecord() {
        this.vcxSignaling.stopRecording();
    }

    public boolean speakerActive(boolean value) {
        if (this.audioManager != null) {
            boolean status = this.audioManager.setSpeakerphoneOn(value);
            return status;
        }
        return false;
    }

    @Override
    public void onAcknowledgeStartRecording(Object ... args) {
        try {
            JSONObject jsonObject = (JSONObject)args[0];
            this.triggerAcknowledgeRecordingStart(jsonObject);
        }
        catch (Exception e) {
            JSONObject jsonObject = this.getCustomJsonObject(e.getMessage(), 9001);
            this.triggerAcknowledgeRecordingStart(jsonObject);
        }
    }

    @Override
    public void onAcknowledgeStopRecording(Object ... args) {
        try {
            boolean value = (Boolean)args[0];
            JSONObject jsonObject = this.getCustomJsonObject(String.valueOf(value), 0);
            this.triggerAcknowledgeRecordingStop(jsonObject);
        }
        catch (Exception e) {
            JSONObject jsonObject = this.getCustomJsonObject(e.getMessage(), 9003);
            this.triggerAcknowledgeRecordingStop(jsonObject);
            e.printStackTrace();
        }
    }

    public void setActivity(Activity activity) {
        this.mActivity = activity;
    }

    public Map<String, VCXStream> getRemoteStreams() {
        return this.mRemoteStream;
    }

    public boolean isPublishing() {
        return this.mLocalStream.size() > 0;
    }

    public void attachLocalStream(final View vsv) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                block0: {
                    Iterator<String> iterator = VCXRoom.this.mLocalStream.keySet().iterator();
                    if (!iterator.hasNext()) break block0;
                    String key = iterator.next();
                    VCXStream stream = VCXRoom.this.mLocalStream.get(key);
                    stream.attachRenderer(new VideoCallbacks(vsv, "LOCAL"));
                }
            }
        });
    }

    public void detachLocalStream() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (String key : VCXRoom.this.mLocalStream.keySet()) {
                    VCXStream stream = VCXRoom.this.mLocalStream.get(key);
                    if (stream == null) continue;
                    stream.detachRenderer();
                }
            }
        });
    }

    public void post(Runnable r) {
        this.executor.execute(r);
    }

    public void attachRenderer(VCXStream stream) {
        Logging.d((String)VCXConstant.LogId, (String)"stream return to user for rendering");
        this.mStreamList.add(stream.getId());
        this.hashMapRemoteStreamS.put(stream.getId(), stream);
        ++this.index;
        this.showNextStream(this.index);
        if (this.audioManager == null) {
            this.audioManager = VCXAudioManager.create(ContextUtils.getApplicationContext(), this);
            this.audioManager.start(new VCXAudioManager.AudioManagerEvents(){

                @Override
                public void onAudioDeviceChanged(VCXAudioManager.AudioDevice audioDevice, Set<VCXAudioManager.AudioDevice> availableAudioDevices) {
                    VCXRoom.this.onAudioManagerDevicesChanged(audioDevice, availableAudioDevices);
                }
            });
        }
        this.hashMapRemoteStreamLayouts.put(stream.getId(), this.remoteRelativeLayout);
        if (this.mVCXRoomObserver != null) {
            this.mVCXRoomObserver.onSubscribedStream(stream);
        }
    }

    private void onAudioManagerDevicesChanged(VCXAudioManager.AudioDevice device, Set<VCXAudioManager.AudioDevice> availableDevices) {
        Logging.d((String)VCXConstant.LogId, (String)("onAudioManagerDevicesChanged: " + availableDevices + ", selected: " + (Object)((Object)device)));
    }

    private void showNextStream(int i) {
        if (i < this.streams.length()) {
            try {
                JSONObject arg = this.streams.getJSONObject(i);
                VCXStream stream = VCXStream.parseJson(arg, this.vcxSignaling, this.mVCXStreamObserver);
                this.mRemoteStream.put(stream.getId(), stream);
                this.triggerStreamAdded(stream);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean requestPublish() {
        this.mPermissionPublish = true;
        if (this.mPermissionPublish) {
            this.triggerPublishAllowed();
            return true;
        }
        return false;
    }

    protected void parseVideoTokenResponseFromServer(JSONObject obj) {
        boolean success = false;
        String message = "";
        try {
            success = true;
            if (success) {
                boolean subscribe = false;
                boolean publish = false;
                if (obj.has("permissions")) {
                    JSONObject permissions = obj.getJSONObject("permissions");
                    subscribe = permissions.has("subscribe") && permissions.getBoolean("subscribe");
                    publish = permissions.has("publish") && permissions.getBoolean("publish");
                }
                this.mPermissionSubscribe = true;
                this.mPermissionPublish = true;
            }
        }
        catch (JSONException e) {
            Logging.d((String)VCXConstant.LogId, (String)("parseVideoTokenResponseFromServer: " + e.getMessage()));
        }
        if (!success) {
            Logging.v((String)VCXConstant.LogId, (String)("Token failed: " + message));
            this.disconnectHandle();
        }
    }

    public void onSensorNearState() {
        try {
            if (!this.wl.isHeld()) {
                this.wl.acquire();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!isvideoMute) {
            this.requesttoMuteVideo(true);
        }
    }

    public void onSensorFarState() {
        try {
            if (this.wl.isHeld()) {
                this.wl.release();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!isvideoMute) {
            this.requesttoMuteVideo(false);
        }
    }

    public void postClientLogs() {
        this.vcxSignaling.postClientLogs();
    }

    public void requestFloor() {
        this.vcxSignaling.requestFloor();
    }

    public void releaseFloor() {
        try {
            for (String key : this.mLocalStream.keySet()) {
                VCXStream stream = this.mLocalStream.get(key);
                if (stream == null || !stream.isLocal()) continue;
                if (stream.pc != null) {
                    stream.pc.removeStream(this.lMS);
                }
                for (VCXRoomObserver obs : this.mObservers) {
                    this.streamRemoved(stream, key);
                }
                if (this.mObservers.size() != 0) continue;
                this.destroy(stream);
            }
            this.mLocalStream.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processFloorRequest(String processFloorRequestCode, String clientId) {
        this.clientId = clientId;
        if (processFloorRequestCode != null && clientId != null) {
            this.vcxSignaling.processFloorRequest(processFloorRequestCode, clientId);
        }
    }

    public void muteAllUsers(VCXStreamObserver vcxStreamObserver) {
        this.vcxSignaling.muteAll();
    }

    public void unMuteAllUsers(VCXStreamObserver vcxStreamObserver) {
        this.vcxSignaling.unMuteAll();
    }

    public void muteSingleUser(String clientId) {
        this.vcxSignaling.muteUser(clientId);
    }

    public void unMuteSingleUser(String clientId) {
        this.vcxSignaling.unMuteUser(clientId);
    }

    @Override
    public String getMode() {
        return mMode;
    }

    @Override
    public void setMode(String mode) {
        mMode = mode;
    }

    private JSONObject getCustomJsonObject(String message, int errorCode) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("message", (Object)message);
            jsonObject.put("errorCode", errorCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    static {
        sVcLock = new Object();
        isvideoMute = false;
    }

    private class VCXSdpObserver
    implements SdpObserver {
        SessionDescription mLocalSdp = null;
        boolean mIsPublish = false;
        String mSignalChannel = "subscribe";
        final VCXStream mStream;
        boolean mIceReady = false;
        private Ack onAcknowledgeSDPPacket = new Ack(){

            public void call(Object ... args) {
                String str = "";
                Logging.d((String)VCXConstant.LogId, (String)("SdpObserver#sendLocalDescription#sendSDPSocket#Acknowledge: " + args.toString()));
                String streamId = null;
                try {
                    streamId = args[0].toString();
                    if (VCXSdpObserver.this.mIsPublish) {
                        VCXRoom.this.localStreamID = streamId;
                        VCXRoom.this.publishedStream.setLocalStreamId(VCXRoom.this.localStreamID);
                        VCXSdpObserver.this.mStream.setId(streamId);
                        VCXRoom.this.mLocalStream.put(streamId, VCXSdpObserver.this.mStream);
                        JSONObject p1 = new JSONObject();
                        p1.put("streamId", (Object)streamId);
                        JSONObject jsonObjectMsg = new JSONObject();
                        jsonObjectMsg.put("type", (Object)"offer");
                        jsonObjectMsg.put("sdp", (Object)VCXSdpObserver.this.mLocalSdp.description);
                        p1.put("msg", (Object)jsonObjectMsg);
                        Logging.d((String)VCXConstant.LogId, (String)("SdpObserver#sendLocalDescription#sendSDPSocket#Acknowledge: " + streamId));
                        VCXRoom.this.vcxSignaling.emitEvent("signaling_message", p1, null);
                    }
                }
                catch (Exception e) {
                    Logging.d((String)VCXConstant.LogId, (String)("SdpObserver#sendLocalDescription#sendSDPSocket#Acknowledge: " + e.getMessage()));
                    e.printStackTrace();
                }
            }
        };

        VCXSdpObserver(VCXStream stream, boolean publishing) {
            this.mStream = stream;
            this.mIsPublish = publishing;
            this.mSignalChannel = this.mIsPublish ? "publish" : "subscribe";
        }

        public boolean isLocal() {
            return this.mStream == null ? false : this.mStream.isLocal();
        }

        public void iceReady() {
            this.mIceReady = true;
            this.startConnecting();
        }

        private void startConnecting() {
            this.mStream.pc.createOffer((SdpObserver)this, this.mStream.sdpConstraints());
        }

        public void onCreateFailure(String arg0) {
            Logging.d((String)VCXConstant.LogId, (String)("SdpObserver#onCreateFailure: " + arg0));
        }

        public void onCreateSuccess(SessionDescription sdp) {
            if (this.mLocalSdp != null) {
                return;
            }
            if (this.mIceReady) {
                this.mLocalSdp = sdp;
            }
            String preferredVideoCodec = VCXRoom.VIDEO_CODEC_VP9;
            String sdpDescription = VCXRoom.preferCodec(sdp.description, preferredVideoCodec, false);
            sdpDescription = VCXRoom.preferCodec(sdp.description, preferredVideoCodec, false);
            Logging.d((String)VCXConstant.LogId, (String)("Create SDP description: " + sdpDescription));
            SessionDescription finalSdp = new SessionDescription(sdp.type, sdpDescription);
            this.mStream.pc.setLocalDescription((SdpObserver)this, finalSdp);
            Logging.d((String)VCXConstant.LogId, (String)("Setting local description: " + finalSdp));
        }

        public void onSetFailure(String arg0) {
            Logging.d((String)VCXConstant.LogId, (String)("#onSetFaSdpObserverilure: " + arg0));
        }

        public void onSetSuccess() {
            if (this.mLocalSdp == null) {
                return;
            }
            if (this.mStream.pc.getRemoteDescription() == null) {
                Logging.d((String)VCXConstant.LogId, (String)"onSetSuccess for sending local description");
                this.sendLocalDescription();
            }
        }

        void sendLocalDescription() {
            JSONObject jsonObjectRoot = null;
            if (this.mIsPublish) {
                jsonObjectRoot = this.mStream.toJsonOffer("media_engine");
            } else {
                jsonObjectRoot = this.mStream.toJsonOffer(null);
                try {
                    jsonObjectRoot.put("streamId", (Object)this.mStream.getId());
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            JSONObject p1 = new JSONObject();
            Logging.d((String)VCXConstant.LogId, (String)("SdpObserver#sendLocalDescription; to: " + this.mSignalChannel + "; msg: " + jsonObjectRoot.toString()));
            VCXRoom.this.vcxSignaling.sendSDPSocket(this.mSignalChannel, jsonObjectRoot, p1, this.onAcknowledgeSDPPacket, "");
        }
    }

    public static class VideoCallbacks
    implements VideoRenderer.Callbacks {
        private final View view;
        private final String streamId;

        public VideoCallbacks(View view, String streamId) {
            this.view = view;
            this.streamId = streamId;
        }

        public void renderFrame(VideoRenderer.I420Frame frame) {
        }
    }

    private class MyPcObserver
    implements PeerConnection.Observer {
        private VCXSdpObserver mSdpObserver;
        private VCXStream mDesc;
        public boolean isPublishing = true;
        PeerConnection peerConnection;
        public boolean isStartCall = false;
        public int count = 0;

        public MyPcObserver(VCXSdpObserver observer, VCXStream desc, boolean isPublishing, PeerConnection peerConnection) {
            this.mSdpObserver = observer;
            this.mDesc = desc;
            this.isPublishing = isPublishing;
            this.peerConnection = peerConnection;
        }

        public VCXSdpObserver getSdpObserver() {
            return this.mSdpObserver;
        }

        public void onSignalingChange(PeerConnection.SignalingState arg0) {
            Logging.d((String)VCXConstant.LogId, (String)("IceGatheringChange: " + arg0));
        }

        public void onRemoveStream(MediaStream arg0) {
            Logging.d((String)VCXConstant.LogId, (String)("IceGatheringChange: " + arg0));
        }

        public void onIceGatheringChange(PeerConnection.IceGatheringState iceGatherState) {
            Logging.d((String)VCXConstant.LogId, (String)("IceGatheringChange: " + iceGatherState));
            if (iceGatherState == PeerConnection.IceGatheringState.COMPLETE) {
                this.mSdpObserver.iceReady();
            }
        }

        public void onIceConnectionChange(PeerConnection.IceConnectionState arg0) {
            Logging.d((String)VCXConstant.LogId, (String)("IceCandidate: " + arg0.toString()));
        }

        public void onIceConnectionReceivingChange(boolean b) {
            String str = "";
        }

        public void onIceCandidate(IceCandidate iceCandidate) {
            String str = iceCandidate.toString();
            try {
                if (this.mSdpObserver.mStream.pc.getRemoteDescription() != null) {
                    this.mSdpObserver.mStream.pc.addIceCandidate(iceCandidate);
                }
                Logging.d((String)VCXConstant.LogId, (String)("IceCandidate: " + str.toString()));
                JSONObject jsonObjectRoot = new JSONObject();
                jsonObjectRoot.put("streamId", (Object)this.mSdpObserver.mStream.getId());
                JSONObject jsonObjectmsg = new JSONObject();
                jsonObjectRoot.put("msg", (Object)jsonObjectmsg);
                jsonObjectmsg.put("type", (Object)"candidate");
                JSONObject jsonObjectCandidate = new JSONObject();
                jsonObjectmsg.put("candidate", (Object)jsonObjectCandidate);
                jsonObjectCandidate.put("sdpMid", (Object)iceCandidate.sdpMid);
                jsonObjectCandidate.put("sdpMLineIndex", iceCandidate.sdpMLineIndex);
                jsonObjectCandidate.put("candidate", (Object)iceCandidate.toString());
                VCXRoom.this.vcxSignaling.sendSDPSocket("signaling_message", jsonObjectRoot, null, new Ack(){

                    public void call(Object ... args) {
                        String str = "";
                    }
                }, "");
                if (!this.isStartCall) {
                    this.isStartCall = true;
                    this.mSdpObserver.iceReady();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onIceCandidatesRemoved(IceCandidate[] iceCandidates) {
            String str = iceCandidates.toString();
            Logging.d((String)VCXConstant.LogId, (String)("IceCandidateRemoved: " + str));
        }

        public void onDataChannel(DataChannel arg0) {
            Logging.d((String)VCXConstant.LogId, (String)("DataChannel: " + arg0));
            String str = "";
        }

        public void onAddStream(MediaStream media) {
            if (this.mSdpObserver.isLocal()) {
                return;
            }
            if (media.videoTracks.size() == 1 && this.mDesc != null) {
                this.mDesc.setMedia(media);
                Logging.d((String)VCXConstant.LogId, (String)"onAddStream: going for rendering");
                VCXRoom.this.triggerMediaAvailable(this.mDesc);
            }
        }

        public void onRenegotiationNeeded() {
            Logging.v((String)VCXConstant.LogId, (String)"PeerConnectionObserver.onRenegotiationNeeded");
        }

        public void onAddTrack(RtpReceiver rtpReceiver, MediaStream[] mediaStreams) {
            String str = "";
        }
    }

    private static interface CancelableRunnable
    extends Runnable {
        public void cancel();
    }

    static enum State {
        kUninitialized,
        kDisconnected,
        kConnecting,
        kConnectingWaitingForToken,
        kConnected,
        kDisconnecting;

    }
}

