/*
 * Decompiled with CFR 0.152.
 */
package vcxsdk.AudioVideoManager;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.util.Log;
import org.webrtc.ThreadUtils;
import vcxsdk.Controller.VCXRoom;
import vcxsdk.Utilities.VCXUtils;

public class VCXProximitySensor
implements SensorEventListener {
    private static final String TAG = "VCXProximitySensor";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final Runnable onSensorStateListener;
    private final SensorManager sensorManager;
    private Sensor proximitySensor = null;
    private boolean lastStateReportIsNear = false;
    VCXRoom vcxRoom;

    static VCXProximitySensor create(VCXRoom vcxRoom, Context context, Runnable sensorStateListener) {
        return new VCXProximitySensor(vcxRoom, context, sensorStateListener);
    }

    private VCXProximitySensor(VCXRoom vcxRoom, Context context, Runnable sensorStateListener) {
        Log.d((String)TAG, (String)(TAG + VCXUtils.getThreadInfo()));
        this.onSensorStateListener = sensorStateListener;
        this.vcxRoom = vcxRoom;
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
    }

    public boolean start() {
        Log.d((String)TAG, (String)("start" + VCXUtils.getThreadInfo()));
        if (!this.initDefaultSensor()) {
            return false;
        }
        this.sensorManager.registerListener((SensorEventListener)this, this.proximitySensor, 3);
        return true;
    }

    public void stop() {
        try {
            Log.d((String)TAG, (String)("stop" + VCXUtils.getThreadInfo()));
            if (this.proximitySensor == null) {
                return;
            }
            this.sensorManager.unregisterListener((SensorEventListener)this, this.proximitySensor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean sensorReportsNearState() {
        return this.lastStateReportIsNear;
    }

    public final void onAccuracyChanged(Sensor sensor, int accuracy) {
        VCXUtils.assertIsTrue(sensor.getType() == 8);
        if (accuracy == 0) {
            Log.e((String)TAG, (String)"The values returned by this sensor cannot be trusted");
        }
    }

    public final void onSensorChanged(SensorEvent event) {
        VCXUtils.assertIsTrue(event.sensor.getType() == 8);
        float distanceInCentimeters = event.values[0];
        if (distanceInCentimeters < this.proximitySensor.getMaximumRange()) {
            Log.d((String)TAG, (String)"Proximity sensor => NEAR state");
            this.vcxRoom.onSensorNearState();
            this.lastStateReportIsNear = true;
        } else {
            this.vcxRoom.onSensorFarState();
            Log.d((String)TAG, (String)"Proximity sensor => FAR state");
            this.lastStateReportIsNear = false;
        }
        if (this.onSensorStateListener != null) {
            // empty if block
        }
        Log.d((String)TAG, (String)("onSensorChanged" + VCXUtils.getThreadInfo() + ": accuracy=" + event.accuracy + ", timestamp=" + event.timestamp + ", distance=" + event.values[0]));
    }

    private boolean initDefaultSensor() {
        if (this.proximitySensor != null) {
            return true;
        }
        this.proximitySensor = this.sensorManager.getDefaultSensor(8);
        if (this.proximitySensor == null) {
            return false;
        }
        this.logProximitySensorInfo();
        return true;
    }

    private void logProximitySensorInfo() {
        if (this.proximitySensor == null) {
            return;
        }
        StringBuilder info = new StringBuilder("Proximity sensor: ");
        info.append("name=").append(this.proximitySensor.getName());
        info.append(", vendor: ").append(this.proximitySensor.getVendor());
        info.append(", power: ").append(this.proximitySensor.getPower());
        info.append(", resolution: ").append(this.proximitySensor.getResolution());
        info.append(", max range: ").append(this.proximitySensor.getMaximumRange());
        info.append(", min delay: ").append(this.proximitySensor.getMinDelay());
        if (Build.VERSION.SDK_INT >= 20) {
            info.append(", type: ").append(this.proximitySensor.getStringType());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            info.append(", max delay: ").append(this.proximitySensor.getMaxDelay());
            info.append(", reporting mode: ").append(this.proximitySensor.getReportingMode());
            info.append(", isWakeUpSensor: ").append(this.proximitySensor.isWakeUpSensor());
        }
        Log.d((String)TAG, (String)info.toString());
    }
}

