/*
 * Decompiled with CFR 0.152.
 */
package com.vccorp.imaloader.playerIma;

import android.os.Bundle;
import android.os.CountDownTimer;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdErrorEvent;
import com.google.ads.interactivemedia.v3.api.AdEvent;
import com.google.ads.interactivemedia.v3.api.AdsLoader;
import com.google.ads.interactivemedia.v3.api.AdsManager;
import com.google.ads.interactivemedia.v3.api.AdsManagerLoadedEvent;
import com.google.ads.interactivemedia.v3.api.AdsRequest;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.vccorp.imaloader.R;
import com.vccorp.imaloader.playerIma.ControlAds;
import com.vccorp.imaloader.playerIma.ControlShowAds;
import java.util.Objects;

public class VideoFragment
extends Fragment
implements View.OnClickListener,
AdErrorEvent.AdErrorListener,
AdEvent.AdEventListener,
ControlShowAds {
    private ControlAds callBackControlAds;
    private static final String TAG = VideoFragment.class.getName();
    private static String LOGTAG = "ImaExample";
    private Button buttonSkipAds;
    private AdEvent mAdEvent;
    private ViewGroup mAdUiContainer;
    private ImaSdkFactory mSdkFactory;
    private AdsLoader mAdsLoader;
    private AdsManager mAdsManager;
    private boolean mIsAdDisplayed = false;
    private boolean isEnd;
    private int timeCanSkip;

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        if (this.getActivity() instanceof ControlAds) {
            this.callBackControlAds = (ControlAds)this.getActivity();
        }
        this.mSdkFactory = ImaSdkFactory.getInstance();
        bundle = this.mSdkFactory.createAdDisplayContainer();
        bundle.setAdContainer(this.mAdUiContainer);
        ImaSdkSettings imaSdkSettings = this.mSdkFactory.createImaSdkSettings();
        this.mAdsLoader = this.mSdkFactory.createAdsLoader(this.getContext(), imaSdkSettings, (AdDisplayContainer)bundle);
        this.mAdsLoader.addAdErrorListener((AdErrorEvent.AdErrorListener)this);
        this.mAdsLoader.addAdsLoadedListener(new AdsLoader.AdsLoadedListener(){

            public final void onAdsManagerLoaded(AdsManagerLoadedEvent adsManagerLoadedEvent) {
                VideoFragment.this.mAdsManager = adsManagerLoadedEvent.getAdsManager();
                VideoFragment.this.mAdsManager.addAdErrorListener((AdErrorEvent.AdErrorListener)VideoFragment.this);
                VideoFragment.this.mAdsManager.addAdEventListener((AdEvent.AdEventListener)VideoFragment.this);
                VideoFragment.this.mAdsManager.init();
            }
        });
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        layoutInflater = layoutInflater.inflate(R.layout.fragment_video, viewGroup, false);
        this.buttonSkipAds = (Button)layoutInflater.findViewById(R.id.button_skip_ad);
        this.mAdUiContainer = (ViewGroup)layoutInflater.findViewById(R.id.videoPlayerWithAdPlayback);
        this.buttonSkipAds.setOnClickListener((View.OnClickListener)this);
        return layoutInflater;
    }

    private void requestAds(String string2) {
        AdsRequest adsRequest = this.mSdkFactory.createAdsRequest();
        adsRequest.setAdTagUrl(string2);
        this.mAdsLoader.requestAds(adsRequest);
    }

    public void onAdEvent(AdEvent adEvent) {
        switch (adEvent.getType()) {
            case LOADED: {
                if (this.mAdsManager == null) break;
                this.mAdsManager.start();
                return;
            }
            case CONTENT_PAUSE_REQUESTED: {
                this.mIsAdDisplayed = true;
                this.callBackControlAds.playAds();
                this.buttonSkipAds.setVisibility(0);
                if (this.mAdsManager.getCurrentAd().isSkippable()) {
                    this.buttonSkipAds.setVisibility(8);
                } else {
                    this.buttonSkipAds.setVisibility(0);
                    VideoFragment videoFragment = this;
                    videoFragment.showTextSkipAd(videoFragment.timeCanSkip);
                }
                Log.i((String)TAG, (String)("process: play AD: " + this.mIsAdDisplayed));
                return;
            }
            case CONTENT_RESUME_REQUESTED: {
                this.callBackControlAds.stopAds();
                this.mIsAdDisplayed = false;
                Log.i((String)TAG, (String)("process: stop AD: " + this.mIsAdDisplayed));
                return;
            }
            case ALL_ADS_COMPLETED: {
                if (this.mAdsManager != null) {
                    this.mAdsManager.destroy();
                    this.mAdsManager = null;
                }
                this.mAdUiContainer.removeAllViews();
            }
        }
    }

    public void onAdError(AdErrorEvent adErrorEvent) {
        Log.e((String)LOGTAG, (String)("Ad Error: " + adErrorEvent.getError().getMessage()));
    }

    public void onResume() {
        ((AppCompatActivity)Objects.requireNonNull(this.getActivity())).getSupportActionBar().hide();
        if (this.mAdsManager != null) {
            this.mAdsManager.resume();
        }
        super.onResume();
    }

    public void onPause() {
        if (this.mAdsManager != null) {
            this.mAdsManager.pause();
        }
        super.onPause();
    }

    public void onClick(View view) {
        if (view.getId() == R.id.button_skip_ad && this.timeCanSkip == 0) {
            this.skipAdWithTime();
        }
    }

    private void skipAdWithTime() {
        if (this.mAdsManager != null) {
            this.mAdsManager.destroy();
            this.mAdsManager = null;
            this.mAdUiContainer.removeAllViews();
            this.callBackControlAds.stopAds();
            this.mIsAdDisplayed = false;
            this.buttonSkipAds.setVisibility(8);
            Log.i((String)TAG, (String)("process: stop AD: " + this.mIsAdDisplayed));
        }
    }

    @Override
    public void requestAds(String string2, String string3, int n) {
        this.requestAds(string2);
        Log.i((String)TAG, (String)"SkipOffSet bf: ".concat(String.valueOf(n)));
        this.timeCanSkip = n;
        Log.i((String)TAG, (String)"SkipOffSet af: ".concat(String.valueOf(n)));
    }

    private void showTextSkipAd(int n) {
        if (n > 0) {
            this.buttonSkipAds.setVisibility(0);
            VideoFragment videoFragment = this;
            new CountDownTimer((videoFragment.timeCanSkip + 1) * 1000){

                public final void onTick(long l) {
                    if (VideoFragment.this.timeCanSkip >= 0) {
                        VideoFragment.this.timeCanSkip--;
                        VideoFragment.this.setTextViewAd((int)l / 1000);
                        Log.i((String)TAG, (String)("SkipOffSet bf: " + VideoFragment.this.timeCanSkip));
                    }
                }

                public final void onFinish() {
                    if (VideoFragment.this.buttonSkipAds != null) {
                        VideoFragment.this.buttonSkipAds.setText((CharSequence)VideoFragment.this.getString(R.string.string_skip_ad));
                    }
                }
            }.start();
            return;
        }
        if (n == 0) {
            this.buttonSkipAds.setVisibility(8);
        }
    }

    private void setTextViewAd(int n) {
        if (this.buttonSkipAds != null) {
            this.buttonSkipAds.setText((CharSequence)"You can skip in ".concat(String.valueOf(n)));
        }
    }

    @Override
    public boolean isShowAd() {
        return this.mIsAdDisplayed;
    }

    @Override
    public void setValueShowAd(boolean bl) {
        this.mIsAdDisplayed = bl;
    }
}

