package com.vccorp.imaloader.playerIma;

import android.os.Bundle;
import android.os.CountDownTimer;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdErrorEvent;
import com.google.ads.interactivemedia.v3.api.AdEvent;
import com.google.ads.interactivemedia.v3.api.AdEvent.AdEventType;
import com.google.ads.interactivemedia.v3.api.AdsLoader;
import com.google.ads.interactivemedia.v3.api.AdsManager;
import com.google.ads.interactivemedia.v3.api.AdsManagerLoadedEvent;
import com.google.ads.interactivemedia.v3.api.AdsRequest;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.vccorp.imaloader.R;

import java.util.Objects;

import static com.google.ads.interactivemedia.v3.api.AdEvent.AdEventType.*;
import static com.google.ads.interactivemedia.v3.api.AdEvent.AdEventType.LOADED;

public class VideoFragment extends Fragment implements AdEvent.AdEventListener,
        AdErrorEvent.AdErrorListener, ControlShowAds, View.OnClickListener {
    private ControlAds callBackControlAds;
    private static final String TAG = VideoFragment.class.getName();
    private static String LOGTAG = "ImaExample";
    private Button buttonSkipAds;
    // The video player.
//    private SampleVideoPlayer mVideoPlayer;
    private AdEvent mAdEvent;
    // The container for the ad's UI.
    private ViewGroup mAdUiContainer;

    // Factory class for creating SDK objects.
    private ImaSdkFactory mSdkFactory;

    // The AdsLoader instance exposes the requestAds method.
    private AdsLoader mAdsLoader;

    // AdsManager exposes methods to control ad playback and listen to ad events.
    private AdsManager mAdsManager;

    // Whether an ad is displayed.
    private boolean mIsAdDisplayed = false;
    private boolean isEnd;
    private int timeCanSkip;

    // The play button to trigger the ad request.
    public VideoFragment() {
        // Required empty public constructor
    }

    @Override
    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);

        //callback
        if (getActivity() instanceof ControlAds)
            callBackControlAds = (ControlAds) getActivity();

        // Create an AdsLoader.
        mSdkFactory = ImaSdkFactory.getInstance();
        AdDisplayContainer adDisplayContainer = mSdkFactory.createAdDisplayContainer();
        adDisplayContainer.setAdContainer(mAdUiContainer);
        ImaSdkSettings settings = mSdkFactory.createImaSdkSettings();
        mAdsLoader = mSdkFactory.createAdsLoader(
                this.getContext(), settings, adDisplayContainer);

        // Add listeners for when ads are loaded and for errors.
        mAdsLoader.addAdErrorListener(this);
        mAdsLoader.addAdsLoadedListener(new AdsLoader.AdsLoadedListener() {
            @Override
            public void onAdsManagerLoaded(AdsManagerLoadedEvent adsManagerLoadedEvent) {
                // Ads were successfully loaded, so get the AdsManager instance. AdsManager has
                // events for ad playback and errors.
                mAdsManager = adsManagerLoadedEvent.getAdsManager();

                // Attach event and error event listeners.
                mAdsManager.addAdErrorListener(VideoFragment.this);
                mAdsManager.addAdEventListener(VideoFragment.this);
                mAdsManager.init();
            }
        });

        // Add listener for when the content video finishes.
//        mVideoPlayer.addVideoCompletedListener(new SampleVideoPlayer.OnVideoCompletedListener() {
//            @Override
//            public void onVideoCompleted() {
//                // Handle completed event for playing post-rolls.
//                if (mAdsLoader != null) {
//                    mAdsLoader.contentComplete();
//                }
//            }
//        });

//        requestAds(getString(R.string.ad_tag_url));
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_video, container, false);
        buttonSkipAds = rootView.findViewById(R.id.button_skip_ad);
//        mVideoPlayer = rootView.findViewById(R.id.sampleVideoPlayer);
        mAdUiContainer = rootView.findViewById(R.id.videoPlayerWithAdPlayback);
        buttonSkipAds.setOnClickListener(this);
        return rootView;
    }

    /**
     * Request video ads from the given VAST ad tag.
     *
     * @param adTagUrl URL of the ad's VAST XML
     */
    private void requestAds(String adTagUrl) {
        // Create the ads request.
        AdsRequest request = mSdkFactory.createAdsRequest();
        request.setAdTagUrl(adTagUrl);
        mAdsLoader.requestAds(request);
    }

    @Override
    public void onAdEvent(AdEvent adEvent) {
        // These are the suggested event types to handle. For full list of all ad event
        // types, see the documentation for AdEvent.AdEventType.
        switch (adEvent.getType()) {
            case LOADED:
                // AdEventType.LOADED will be fired when ads are ready to be played.
                // AdsManager.start() begins ad playback. This method is ignored for VMAP or
                // ad rules playlists, as the SDK will automatically start executing the
                // playlist.
                if (mAdsManager != null) {
                    mAdsManager.start();
                }

                break;
            case CONTENT_PAUSE_REQUESTED:
                // AdEventType.CONTENT_PAUSE_REQUESTED is fired immediately before a video
                // ad is played.
//                mVideoPlayer.pause();
                mIsAdDisplayed = true;
                callBackControlAds.playAds();
                buttonSkipAds.setVisibility(View.VISIBLE);
                if (mAdsManager.getCurrentAd().isSkippable()) {
                    buttonSkipAds.setVisibility(View.GONE);
                } else {
                    buttonSkipAds.setVisibility(View.VISIBLE);
                    showTextSkipAd(timeCanSkip);
                }

                Log.i(TAG, "process: play AD: " + mIsAdDisplayed);


                break;
            case CONTENT_RESUME_REQUESTED:
                // AdEventType.CONTENT_RESUME_REQUESTED is fired when the ad is completed
                // and you should start playing your content.
//                mVideoPlayer.play();
                callBackControlAds.stopAds();

                mIsAdDisplayed = false;
                Log.i(TAG, "process: stop AD: " + mIsAdDisplayed);


                break;
            case ALL_ADS_COMPLETED:
                if (mAdsManager != null) {
                    mAdsManager.destroy();
                    mAdsManager = null;
                }
                mAdUiContainer.removeAllViews();
                break;
            default:
                break;
        }
    }

    @Override
    public void onAdError(AdErrorEvent adErrorEvent) {
        Log.e(LOGTAG, "Ad Error: " + adErrorEvent.getError().getMessage());
//        mVideoPlayer.play();
    }

    @Override
    public void onResume() {
        ((AppCompatActivity) Objects.requireNonNull(getActivity())).getSupportActionBar().hide();
        if (mAdsManager != null) {
            mAdsManager.resume();
        } else {
//            mVideoPlayer.play();
        }
        super.onResume();
    }

    @Override
    public void onPause() {
        if (mAdsManager != null) {
            mAdsManager.pause();
        } else {
//            mVideoPlayer.pause();
        }
        super.onPause();
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.button_skip_ad) {
            if (timeCanSkip == 0) {
                skipAdWithTime();
            }

        }
    }

    private void skipAdWithTime() {
        if (mAdsManager != null) {

            mAdsManager.destroy();
            mAdsManager = null;
            mAdUiContainer.removeAllViews();
            callBackControlAds.stopAds();
            mIsAdDisplayed = false;
            buttonSkipAds.setVisibility(View.GONE);
            Log.i(TAG, "process: stop AD: " + mIsAdDisplayed);

        }
    }

    @Override
    public void requestAds(String url, String type, int SkipOffSet) {
        requestAds(url);
        Log.i(TAG, "SkipOffSet bf: " + SkipOffSet);
        timeCanSkip = SkipOffSet;
        Log.i(TAG, "SkipOffSet af: " + SkipOffSet);

    }

    private void showTextSkipAd(int time) {

        if (time > 0) {
            buttonSkipAds.setVisibility(View.VISIBLE);
            new CountDownTimer((timeCanSkip + 1) * 1000, 1000) {

                public void onTick(long millisUntilFinished) {
                    if (timeCanSkip >= 0) {
                        timeCanSkip--;
                        setTextViewAd((int) millisUntilFinished / 1000);
                        Log.i(TAG, "SkipOffSet bf: " + timeCanSkip);

                    }
                }

                public void onFinish() {
                    if (buttonSkipAds != null) {
                        buttonSkipAds.setText(getString(R.string.string_skip_ad));

                    }

                }

            }.start();

        } else if (time == 0) {
            buttonSkipAds.setVisibility(View.GONE);

        }
    }

    private void setTextViewAd(int timeCanSkip) {
        if (buttonSkipAds != null) {
            buttonSkipAds.setText("You can skip in " + timeCanSkip);
        }
    }

    @Override
    public boolean isShowAd() {

        return mIsAdDisplayed;
    }

    @Override
    public void setValueShowAd(boolean isShowAd) {
        mIsAdDisplayed = isShowAd;
    }

}
