/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.gl;

import android.graphics.SurfaceTexture;
import android.util.Log;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.ui.gl.SurfaceTextureListener;

@JNINamespace(value="gl")
@MainDex
public class SurfaceTexturePlatformWrapper {
    public static final String TAG = "SurfaceTexturePlatformWrapper";

    public static SurfaceTexture create(int n2) {
        return new SurfaceTexture(n2);
    }

    public static void destroy(SurfaceTexture surfaceTexture) {
        SurfaceTexture surfaceTexture2 = surfaceTexture;
        surfaceTexture2.setOnFrameAvailableListener(null);
        surfaceTexture2.release();
    }

    public static void setFrameAvailableCallback(SurfaceTexture surfaceTexture, long l2) {
        surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)new SurfaceTextureListener(l2));
    }

    public static void updateTexImage(SurfaceTexture surfaceTexture) {
        try {
            surfaceTexture.updateTexImage();
        }
        catch (RuntimeException runtimeException) {
            Log.e((String)TAG, (String)"Error calling updateTexImage", (Throwable)runtimeException);
        }
    }

    public static void getTransformMatrix(SurfaceTexture surfaceTexture, float[] fArray) {
        surfaceTexture.getTransformMatrix(fArray);
    }

    public static void attachToGLContext(SurfaceTexture surfaceTexture, int n2) {
        surfaceTexture.attachToGLContext(n2);
    }

    public static void detachFromGLContext(SurfaceTexture surfaceTexture) {
        surfaceTexture.detachFromGLContext();
    }

    public static void release(SurfaceTexture surfaceTexture) {
        surfaceTexture.release();
    }

    public static void setDefaultBufferSize(SurfaceTexture surfaceTexture, int n2, int n3) {
        surfaceTexture.setDefaultBufferSize(n2, n3);
    }
}

