/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.view.InputDevice;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="ui")
public class TouchDevice {
    public static int maxTouchPoints() {
        if (ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch.jazzhand")) {
            return 5;
        }
        if (ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch.distinct")) {
            return 2;
        }
        if (ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch")) {
            return 2;
        }
        if (ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen")) {
            return 1;
        }
        return 0;
    }

    public static int[] availablePointerAndHoverTypes() {
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[1] = 0;
        nArray[0] = 0;
        int[] nArray3 = InputDevice.getDeviceIds();
        int n2 = nArray3.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            InputDevice inputDevice = null;
            try {
                inputDevice = InputDevice.getDevice((int)nArray3[i2]);
            }
            catch (RuntimeException runtimeException) {}
            if (inputDevice == null) continue;
            int n3 = inputDevice.getSources();
            if (!(TouchDevice.hasSource(n3, 8194) || TouchDevice.hasSource(n3, 16386) || TouchDevice.hasSource(n3, 0x100008) || TouchDevice.hasSource(n3, 65540))) {
                if (TouchDevice.hasSource(n3, 4098)) {
                    nArray2[0] = nArray2[0] | 2;
                }
            } else {
                nArray2[0] = nArray2[0] | 4;
            }
            if (!TouchDevice.hasSource(n3, 8194) && !TouchDevice.hasSource(n3, 0x100008) && !TouchDevice.hasSource(n3, 65540)) continue;
            nArray2[1] = nArray2[1] | 2;
        }
        if (nArray2[0] == 0) {
            nArray2[0] = 1;
        }
        if (nArray2[1] == 0) {
            nArray2[1] = 1;
        }
        return nArray2;
    }

    public static boolean hasSource(int n2, int n3) {
        return (n2 & n3) == n3;
    }
}

