/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import a.b.p.o.a;
import android.content.Context;
import android.support.annotation.UiThread;
import com.vccorp.content.R;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.ui.base.WindowAndroid;

public class DeviceFormFactor {
    public static final int MINIMUM_TABLET_WIDTH_DP = 600;
    public static final int SCREEN_BUCKET_TABLET = 2;
    public static final int SCREEN_BUCKET_LARGET_TABLET = 3;

    @Deprecated
    public static boolean isTablet() {
        return DeviceFormFactor.detectScreenWidthBucket(ContextUtils.getApplicationContext()) >= 2;
    }

    public static boolean isNonMultiDisplayContextOnTablet(Context context) {
        return DeviceFormFactor.detectScreenWidthBucket(context) >= 2;
    }

    @UiThread
    public static boolean isWindowOnTablet(WindowAndroid windowAndroid) {
        return DeviceFormFactor.detectScreenWidthBucket(windowAndroid) >= 2;
    }

    public static boolean isNonMultiDisplayContextOnLargeTablet(Context context) {
        return DeviceFormFactor.detectScreenWidthBucket(context) == 3;
    }

    public static int detectScreenWidthBucket(Context context) {
        return context.getResources().getInteger(R.integer.min_screen_width_bucket);
    }

    public static int detectScreenWidthBucket(WindowAndroid windowAndroid) {
        ThreadUtils.assertOnUiThread();
        windowAndroid = (Context)windowAndroid.getContext().get();
        if (windowAndroid == null) {
            return 0;
        }
        return windowAndroid.getResources().getInteger(R.integer.min_screen_width_bucket);
    }

    @UiThread
    public static int getNonMultiDisplayMinimumTabletWidthPx(Context context) {
        return DeviceFormFactor.getMinimumTabletWidthPx(a.a(context));
    }

    public static int getMinimumTabletWidthPx(a a2) {
        return (int)((float)600 * a2.d + 0.5f);
    }
}

