/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import a.b.a.h;
import a.b.l.a;
import a.b.l.c;
import a.b.l.d;
import android.annotation.SuppressLint;
import android.net.ConnectivityManager;
import android.os.Build;
import java.util.ArrayList;
import java.util.Iterator;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net")
public class NetworkChangeNotifier {
    @SuppressLint(value={"StaticFieldLeak"})
    public static NetworkChangeNotifier sInstance;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final ArrayList<Long> mNativeChangeNotifiers = new ArrayList();
    public final h<ConnectionTypeObserver> mConnectionTypeObservers = new h();
    public final ConnectivityManager mConnectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
    public a mAutoDetector;
    public int mCurrentConnectionType = 0;

    public static NetworkChangeNotifier init() {
        if (sInstance == null) {
            sInstance = new NetworkChangeNotifier();
        }
        return sInstance;
    }

    public static boolean isInitialized() {
        return sInstance != null;
    }

    public static void resetInstanceForTests(NetworkChangeNotifier networkChangeNotifier) {
        sInstance = networkChangeNotifier;
    }

    public static NetworkChangeNotifier getInstance() {
        if (!$assertionsDisabled && sInstance == null) {
            throw new AssertionError();
        }
        return sInstance;
    }

    public static void setAutoDetectConnectivityState(boolean bl) {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(bl, new d());
    }

    public static void registerToReceiveNotificationsAlways() {
        c c2;
        c c3 = c2;
        c2 = new c();
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(true, c3);
    }

    public static void setAutoDetectConnectivityState(a.h h2) {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(true, h2);
    }

    private void destroyAutoDetector() {
        a a2 = this.mAutoDetector;
        if (a2 != null) {
            a a3 = a2;
            a3.a();
            a3.e.a();
            a3.f();
            this.mAutoDetector = null;
        }
    }

    private void setAutoDetectConnectivityStateInternal(boolean bl, a.h h2) {
        if (bl) {
            if (((NetworkChangeNotifier)((Object)f2)).mAutoDetector == null) {
                NetworkChangeNotifier networkChangeNotifier = f2;
                networkChangeNotifier.mAutoDetector = new a(new a.g(){

                    @Override
                    public void onConnectionTypeChanged(int n2) {
                        NetworkChangeNotifier.this.updateCurrentConnectionType(n2);
                    }

                    @Override
                    public void onConnectionSubtypeChanged(int n2) {
                        NetworkChangeNotifier.this.notifyObserversOfConnectionSubtypeChange(n2);
                    }

                    @Override
                    public void onNetworkConnect(long l2, int n2) {
                        NetworkChangeNotifier.this.notifyObserversOfNetworkConnect(l2, n2);
                    }

                    @Override
                    public void onNetworkSoonToDisconnect(long l2) {
                        NetworkChangeNotifier.this.notifyObserversOfNetworkSoonToDisconnect(l2);
                    }

                    @Override
                    public void onNetworkDisconnect(long l2) {
                        NetworkChangeNotifier.this.notifyObserversOfNetworkDisconnect(l2);
                    }

                    @Override
                    public void purgeActiveNetworkList(long[] lArray) {
                        NetworkChangeNotifier.this.notifyObserversToPurgeActiveNetworkList(lArray);
                    }
                }, h2);
                a.f f2 = networkChangeNotifier.mAutoDetector.c();
                networkChangeNotifier.updateCurrentConnectionType(f2.b());
                networkChangeNotifier.notifyObserversOfConnectionSubtypeChange(f2.a());
            }
        } else {
            ((NetworkChangeNotifier)((Object)f2)).destroyAutoDetector();
        }
    }

    public static void forceConnectivityState(boolean bl) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().forceConnectivityStateInternal(bl);
    }

    private void forceConnectivityStateInternal(boolean bl) {
        if (this.mCurrentConnectionType != 6 != bl) {
            int n2 = bl ? 0 : 6;
            this.updateCurrentConnectionType(n2);
            this.notifyObserversOfConnectionSubtypeChange(bl ^ 1);
        }
    }

    public static void fakeNetworkConnected(long l2, int n2) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkConnect(l2, n2);
    }

    public static void fakeNetworkSoonToBeDisconnected(long l2) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkSoonToDisconnect(l2);
    }

    public static void fakeNetworkDisconnected(long l2) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkDisconnect(l2);
    }

    public static void fakePurgeActiveNetworkList(long[] lArray) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversToPurgeActiveNetworkList(lArray);
    }

    public static void fakeDefaultNetwork(long l2, int n2) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfConnectionTypeChange(n2, l2);
    }

    public static void fakeConnectionSubtypeChanged(int n2) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfConnectionSubtypeChange(n2);
    }

    private void updateCurrentConnectionType(int n2) {
        this.mCurrentConnectionType = n2;
        this.notifyObserversOfConnectionTypeChange(n2);
    }

    private void notifyObserversOfConnectionTypeChange(int n2, long l2) {
        Iterator<Long> iterator = ((NetworkChangeNotifier)((Object)iterator2)).mNativeChangeNotifiers.iterator();
        while (iterator.hasNext()) {
            ((NetworkChangeNotifier)((Object)iterator2)).nativeNotifyConnectionTypeChanged(iterator.next(), n2, l2);
        }
        Iterator<ConnectionTypeObserver> iterator2 = ((NetworkChangeNotifier)((Object)iterator2)).mConnectionTypeObservers.iterator();
        while (iterator2.hasNext()) {
            ((ConnectionTypeObserver)iterator2.next()).onConnectionTypeChanged(n2);
        }
    }

    public static void addConnectionTypeObserver(ConnectionTypeObserver connectionTypeObserver) {
        NetworkChangeNotifier.getInstance().addConnectionTypeObserverInternal(connectionTypeObserver);
    }

    private void addConnectionTypeObserverInternal(ConnectionTypeObserver connectionTypeObserver) {
        this.mConnectionTypeObservers.a(connectionTypeObserver);
    }

    public static void removeConnectionTypeObserver(ConnectionTypeObserver connectionTypeObserver) {
        NetworkChangeNotifier.getInstance().removeConnectionTypeObserverInternal(connectionTypeObserver);
    }

    private void removeConnectionTypeObserverInternal(ConnectionTypeObserver connectionTypeObserver) {
        this.mConnectionTypeObservers.b(connectionTypeObserver);
    }

    private boolean isProcessBoundToNetworkInternal() {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 < 21) {
            return false;
        }
        if (n2 < 23) {
            return ConnectivityManager.getProcessDefaultNetwork() != null;
        }
        return this.mConnectivityManager.getBoundNetworkForProcess() != null;
    }

    public static boolean isProcessBoundToNetwork() {
        return NetworkChangeNotifier.getInstance().isProcessBoundToNetworkInternal();
    }

    private native void nativeNotifyConnectionTypeChanged(long var1, int var3, long var4);

    private native void nativeNotifyMaxBandwidthChanged(long var1, int var3);

    private native void nativeNotifyOfNetworkConnect(long var1, long var3, int var5);

    private native void nativeNotifyOfNetworkSoonToDisconnect(long var1, long var3);

    private native void nativeNotifyOfNetworkDisconnect(long var1, long var3);

    private native void nativeNotifyPurgeActiveNetworkList(long var1, long[] var3);

    public static a getAutoDetectorForTest() {
        return NetworkChangeNotifier.getInstance().mAutoDetector;
    }

    public static boolean isOnline() {
        return NetworkChangeNotifier.getInstance().getCurrentConnectionType() != 6;
    }

    static {
        $assertionsDisabled = NetworkChangeNotifier.class.desiredAssertionStatus() ^ true;
    }

    public int getCurrentConnectionType() {
        return this.mCurrentConnectionType;
    }

    public int getCurrentConnectionSubtype() {
        Object object = object.mAutoDetector;
        return object == null ? 0 : ((a)((Object)object)).c().a();
    }

    public long getCurrentDefaultNetId() {
        Object object = object.mAutoDetector;
        return object == null ? -1L : ((a)((Object)object)).d();
    }

    public long[] getCurrentNetworksAndTypes() {
        Object object = object.mAutoDetector;
        return object == null ? new long[]{} : ((a)((Object)object)).e();
    }

    public void addNativeObserver(long l2) {
        this.mNativeChangeNotifiers.add(l2);
    }

    public void removeNativeObserver(long l2) {
        this.mNativeChangeNotifiers.remove(l2);
    }

    public boolean registerNetworkCallbackFailed() {
        Object object = object.mAutoDetector;
        boolean bl = object == null ? false : ((a)((Object)object)).o;
        return bl;
    }

    public void notifyObserversOfConnectionTypeChange(int n2) {
        this.notifyObserversOfConnectionTypeChange(n2, this.getCurrentDefaultNetId());
    }

    public void notifyObserversOfConnectionSubtypeChange(int n2) {
        Iterator<Long> iterator = this.mNativeChangeNotifiers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyMaxBandwidthChanged(iterator.next(), n2);
        }
    }

    public void notifyObserversOfNetworkConnect(long l2, int n2) {
        Iterator<Long> iterator = this.mNativeChangeNotifiers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyOfNetworkConnect(iterator.next(), l2, n2);
        }
    }

    public void notifyObserversOfNetworkSoonToDisconnect(long l2) {
        Iterator<Long> iterator = this.mNativeChangeNotifiers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyOfNetworkSoonToDisconnect(iterator.next(), l2);
        }
    }

    public void notifyObserversOfNetworkDisconnect(long l2) {
        Iterator<Long> iterator = this.mNativeChangeNotifiers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyOfNetworkDisconnect(iterator.next(), l2);
        }
    }

    public void notifyObserversToPurgeActiveNetworkList(long[] lArray) {
        Iterator<Long> iterator = this.mNativeChangeNotifiers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyPurgeActiveNetworkList(iterator.next(), lArray);
        }
    }

    public static interface ConnectionTypeObserver {
        public void onConnectionTypeChanged(int var1);
    }
}

