/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.b.a.g;
import android.content.Context;
import android.media.MediaPlayer;
import android.os.SystemClock;
import com.vccorp.content.R;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="media")
public class MediaServerCrashListener
implements MediaPlayer.OnErrorListener {
    public static final String TAG = "crMediaCrashListener";
    public static final long UNKNOWN_TIME = -1L;
    public static final int APPROX_MEDIA_SERVER_RESTART_TIME_IN_MS = 5000;
    public MediaPlayer mPlayer;
    public final Object mLock = new Object();
    public long mLastReportedWatchdogCreationFailure = -1L;
    public long mNativeMediaServerCrashListener;

    public static MediaServerCrashListener create(long l2) {
        return new MediaServerCrashListener(l2);
    }

    public MediaServerCrashListener(long l2) {
        this.mNativeMediaServerCrashListener = l2;
    }

    private native void nativeOnMediaServerCrashDetected(long var1, boolean var3);

    public void releaseWatchdog() {
        MediaPlayer mediaPlayer = this.mPlayer;
        if (mediaPlayer == null) {
            return;
        }
        mediaPlayer.release();
        this.mPlayer = null;
    }

    public boolean startListening() {
        if (objectArray4.mPlayer != null) {
            return true;
        }
        try {
            objectArray4.mPlayer = MediaPlayer.create((Context)ContextUtils.getApplicationContext(), (int)R.raw.empty);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = runtimeException;
            g.b(TAG, "Exception while creating the watchdog player.", objectArray2);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray3 = objectArray;
            objectArray[0] = illegalStateException;
            g.b(TAG, "Exception while creating the watchdog player.", objectArray3);
        }
        MediaPlayer mediaPlayer = objectArray4.mPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)objectArray4);
            objectArray4.mLastReportedWatchdogCreationFailure = -1L;
            return true;
        }
        long l2 = SystemClock.elapsedRealtime();
        long l3 = objectArray4.mLastReportedWatchdogCreationFailure;
        if (l3 == -1L || l2 - l3 > 5000L) {
            Object[] objectArray = objectArray4;
            Object[] objectArray4 = new Object[]{};
            g.b(TAG, "Unable to create watchdog player, treating it as server crash.", objectArray4);
            super.nativeOnMediaServerCrashDetected(objectArray4.mNativeMediaServerCrashListener, false);
            objectArray.mLastReportedWatchdogCreationFailure = l2;
        }
        return false;
    }

    public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
        if (n2 == 100) {
            MediaServerCrashListener mediaServerCrashListener = this;
            mediaServerCrashListener.nativeOnMediaServerCrashDetected(mediaServerCrashListener.mNativeMediaServerCrashListener, true);
            mediaServerCrashListener.releaseWatchdog();
        }
        return true;
    }
}

