/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import a.b.c.b.i;
import a.b.c.b.p;
import a.b.c.b.q;
import a.b.c.b.u.k;
import a.b.c.b.u.l;
import a.b.c.b.u.m;
import a.b.c.b.u.o;
import android.content.Context;
import android.view.View;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.webcontents.WebContentsImpl;
import org.chromium.content_public.browser.WebContents;
import org.chromium.ui.base.ViewAndroidDelegate;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="content")
public class TextSuggestionHost
implements p,
i.a,
a.b.a.k {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public long mNativeTextSuggestionHost;
    public final WebContentsImpl mWebContents;
    public final Context mContext;
    public final ViewAndroidDelegate mViewDelegate;
    public boolean mIsAttachedToWindow;
    public WindowAndroid mWindowAndroid;
    public k mSpellCheckPopupWindow;
    public o mTextSuggestionsPopupWindow;

    public static TextSuggestionHost fromWebContents(WebContents webContents) {
        return ((WebContentsImpl)webContents).getOrSetUserData(TextSuggestionHost.class, UserDataFactoryLazyHolder.INSTANCE);
    }

    public static TextSuggestionHost create(WebContents webContents, long l2) {
        TextSuggestionHost textSuggestionHost = TextSuggestionHost.fromWebContents(webContents);
        textSuggestionHost.setNativePtr(l2);
        return textSuggestionHost;
    }

    public TextSuggestionHost(WebContents webContents) {
        TextSuggestionHost textSuggestionHost = this;
        textSuggestionHost.mWebContents = (WebContentsImpl)webContents;
        textSuggestionHost.mContext = textSuggestionHost.mWebContents.getContext();
        textSuggestionHost.mWindowAndroid = textSuggestionHost.mWebContents.getTopLevelNativeWindow();
        textSuggestionHost.mViewDelegate = textSuggestionHost.mWebContents.getViewAndroidDelegate();
        if (!$assertionsDisabled && this.mViewDelegate == null) {
            throw new AssertionError();
        }
        TextSuggestionHost textSuggestionHost2 = this;
        i.a(textSuggestionHost2.mWebContents, this);
        q.a(textSuggestionHost2.mWebContents).a(this);
    }

    private void setNativePtr(long l2) {
        this.mNativeTextSuggestionHost = l2;
    }

    private float getContentOffsetYPix() {
        return this.mWebContents.getRenderCoordinates().k;
    }

    private void showSpellCheckSuggestionMenu(double d2, double d3, String string2, String[] stringArray) {
        if (!this.mIsAttachedToWindow) {
            this.onSuggestionMenuClosed(false);
            return;
        }
        TextSuggestionHost textSuggestionHost = this;
        textSuggestionHost.hidePopups();
        TextSuggestionHost textSuggestionHost2 = this;
        textSuggestionHost.mSpellCheckPopupWindow = new k(this.mContext, textSuggestionHost2, textSuggestionHost2.mWindowAndroid, (View)this.mViewDelegate.getContainerView());
        textSuggestionHost.mSpellCheckPopupWindow.a(d2, d3 + (double)this.getContentOffsetYPix(), string2, stringArray);
    }

    private void showTextSuggestionMenu(double d2, double d3, String string2, l[] lArray) {
        if (!this.mIsAttachedToWindow) {
            this.onSuggestionMenuClosed(false);
            return;
        }
        TextSuggestionHost textSuggestionHost = this;
        textSuggestionHost.hidePopups();
        TextSuggestionHost textSuggestionHost2 = this;
        textSuggestionHost.mTextSuggestionsPopupWindow = new o(this.mContext, textSuggestionHost2, textSuggestionHost2.mWindowAndroid, (View)this.mViewDelegate.getContainerView());
        textSuggestionHost.mTextSuggestionsPopupWindow.a(d2, d3 + (double)this.getContentOffsetYPix(), string2, lArray);
    }

    private void onNativeDestroyed() {
        this.hidePopups();
        this.mNativeTextSuggestionHost = 0L;
    }

    private native void nativeApplySpellCheckSuggestion(long var1, String var3);

    private native void nativeApplyTextSuggestion(long var1, int var3, int var4);

    private native void nativeDeleteActiveSuggestionRange(long var1);

    private native void nativeOnNewWordAddedToDictionary(long var1, String var3);

    private native void nativeOnSuggestionMenuClosed(long var1);

    static {
        $assertionsDisabled = TextSuggestionHost.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public void onWindowAndroidChanged(WindowAndroid object) {
        this.mWindowAndroid = object;
        object = this.mSpellCheckPopupWindow;
        if (object != null) {
            ((m)object).m = this.mWindowAndroid;
        }
        if ((object = this.mTextSuggestionsPopupWindow) != null) {
            ((m)object).m = this.mWindowAndroid;
        }
    }

    @Override
    public void onAttachedToWindow() {
        this.mIsAttachedToWindow = true;
    }

    @Override
    public void onDetachedFromWindow() {
        this.mIsAttachedToWindow = false;
    }

    @Override
    public void onRotationChanged(int n2) {
        this.hidePopups();
    }

    @Override
    public void hide() {
        this.hidePopups();
    }

    public void hidePopups() {
        m m2 = this.mTextSuggestionsPopupWindow;
        if (m2 != null && m2.p.isShowing()) {
            this.mTextSuggestionsPopupWindow.p.dismiss();
            this.mTextSuggestionsPopupWindow = null;
        }
        if ((m2 = this.mSpellCheckPopupWindow) != null && m2.p.isShowing()) {
            this.mSpellCheckPopupWindow.p.dismiss();
            this.mSpellCheckPopupWindow = null;
        }
    }

    public void applySpellCheckSuggestion(String string2) {
        TextSuggestionHost textSuggestionHost = this;
        textSuggestionHost.nativeApplySpellCheckSuggestion(textSuggestionHost.mNativeTextSuggestionHost, string2);
    }

    public void applyTextSuggestion(int n2, int n3) {
        TextSuggestionHost textSuggestionHost = this;
        textSuggestionHost.nativeApplyTextSuggestion(textSuggestionHost.mNativeTextSuggestionHost, n2, n3);
    }

    public void deleteActiveSuggestionRange() {
        TextSuggestionHost textSuggestionHost = this;
        textSuggestionHost.nativeDeleteActiveSuggestionRange(textSuggestionHost.mNativeTextSuggestionHost);
    }

    public void onNewWordAddedToDictionary(String string2) {
        TextSuggestionHost textSuggestionHost = this;
        textSuggestionHost.nativeOnNewWordAddedToDictionary(textSuggestionHost.mNativeTextSuggestionHost, string2);
    }

    public void onSuggestionMenuClosed(boolean bl) {
        if (!bl) {
            TextSuggestionHost textSuggestionHost = this;
            textSuggestionHost.nativeOnSuggestionMenuClosed(textSuggestionHost.mNativeTextSuggestionHost);
        }
        TextSuggestionHost textSuggestionHost = this;
        textSuggestionHost.mSpellCheckPopupWindow = null;
        textSuggestionHost.mTextSuggestionsPopupWindow = null;
    }

    public m getTextSuggestionsPopupWindowForTesting() {
        return this.mTextSuggestionsPopupWindow;
    }

    public m getSpellCheckPopupWindowForTesting() {
        return this.mSpellCheckPopupWindow;
    }

    public static final class UserDataFactoryLazyHolder {
        public static final WebContentsImpl.UserDataFactory<TextSuggestionHost> INSTANCE = TextSuggestionHost::new;
    }
}

