/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ReceiverCallNotAllowedException;
import android.text.SpannableString;
import android.text.style.LocaleSpan;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.Locale;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.accessibility.KitKatWebContentsAccessibility;
import org.chromium.content_public.browser.WebContents;

@JNINamespace(value="content")
@TargetApi(value=21)
public class LollipopWebContentsAccessibility
extends KitKatWebContentsAccessibility {
    public static SparseArray<AccessibilityNodeInfo.AccessibilityAction> sAccessibilityActionMap = new SparseArray();
    public String mSystemLanguageTag;
    public BroadcastReceiver mBroadcastReceiver;

    public LollipopWebContentsAccessibility(WebContents webContents) {
        super(webContents);
    }

    private void registerLocaleChangeReceiver() {
        IntentFilter intentFilter;
        if (!this.isNativeInitialized()) {
            return;
        }
        IntentFilter intentFilter2 = intentFilter;
        try {
            intentFilter = new IntentFilter("android.intent.action.LOCALE_CHANGED");
            ContextUtils.getApplicationContext().registerReceiver(this.mBroadcastReceiver, intentFilter2);
        }
        catch (ReceiverCallNotAllowedException receiverCallNotAllowedException) {}
        this.mSystemLanguageTag = Locale.getDefault().toLanguageTag();
    }

    public static /* synthetic */ String access$002(LollipopWebContentsAccessibility lollipopWebContentsAccessibility, String string2) {
        lollipopWebContentsAccessibility.mSystemLanguageTag = string2;
        return string2;
    }

    @Override
    public void onNativeInit() {
        LollipopWebContentsAccessibility lollipopWebContentsAccessibility = this;
        super.onNativeInit();
        lollipopWebContentsAccessibility.mBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                LollipopWebContentsAccessibility.access$002(LollipopWebContentsAccessibility.this, Locale.getDefault().toLanguageTag());
            }
        };
        if (lollipopWebContentsAccessibility.mView.isAttachedToWindow()) {
            this.registerLocaleChangeReceiver();
        }
    }

    @Override
    public void setAccessibilityNodeInfoLollipopAttributes(AccessibilityNodeInfo accessibilityNodeInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3, String string2) {
        accessibilityNodeInfo.setCanOpenPopup(bl);
        accessibilityNodeInfo.setContentInvalid(bl2);
        accessibilityNodeInfo.setDismissable(bl2);
        accessibilityNodeInfo.setMultiLine(bl4);
        accessibilityNodeInfo.setInputType(n2);
        accessibilityNodeInfo.setLiveRegion(n3);
        accessibilityNodeInfo.setError((CharSequence)string2);
    }

    @Override
    public void setAccessibilityNodeInfoCollectionInfo(AccessibilityNodeInfo accessibilityNodeInfo, int n2, int n3, boolean bl) {
        accessibilityNodeInfo.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain((int)n2, (int)n3, (boolean)bl));
    }

    @Override
    public void setAccessibilityNodeInfoCollectionItemInfo(AccessibilityNodeInfo accessibilityNodeInfo, int n2, int n3, int n4, int n5, boolean bl) {
        accessibilityNodeInfo.setCollectionItemInfo(AccessibilityNodeInfo.CollectionItemInfo.obtain((int)n2, (int)n3, (int)n4, (int)n5, (boolean)bl));
    }

    @Override
    public void setAccessibilityNodeInfoRangeInfo(AccessibilityNodeInfo accessibilityNodeInfo, int n2, float f2, float f3, float f4) {
        accessibilityNodeInfo.setRangeInfo(AccessibilityNodeInfo.RangeInfo.obtain((int)n2, (float)f2, (float)f3, (float)f4));
    }

    @Override
    public void setAccessibilityNodeInfoViewIdResourceName(AccessibilityNodeInfo accessibilityNodeInfo, String string2) {
        accessibilityNodeInfo.setViewIdResourceName(string2);
    }

    @Override
    public void setAccessibilityEventLollipopAttributes(AccessibilityEvent accessibilityEvent, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3) {
    }

    @Override
    public void setAccessibilityEventCollectionInfo(AccessibilityEvent accessibilityEvent, int n2, int n3, boolean bl) {
    }

    @Override
    public void setAccessibilityEventHeadingFlag(AccessibilityEvent accessibilityEvent, boolean bl) {
    }

    @Override
    public void setAccessibilityEventCollectionItemInfo(AccessibilityEvent accessibilityEvent, int n2, int n3, int n4, int n5) {
    }

    @Override
    public void setAccessibilityEventRangeInfo(AccessibilityEvent accessibilityEvent, int n2, float f2, float f3, float f4) {
    }

    @Override
    public void addAction(AccessibilityNodeInfo accessibilityNodeInfo, int n2) {
        LollipopWebContentsAccessibility lollipopWebContentsAccessibility = (AccessibilityNodeInfo.AccessibilityAction)sAccessibilityActionMap.get(n2);
        if (lollipopWebContentsAccessibility == null) {
            AccessibilityNodeInfo.AccessibilityAction accessibilityAction;
            lollipopWebContentsAccessibility = accessibilityAction;
            accessibilityAction = new AccessibilityNodeInfo.AccessibilityAction(n2, null);
            sAccessibilityActionMap.put(n2, (Object)lollipopWebContentsAccessibility);
        }
        accessibilityNodeInfo.addAction((AccessibilityNodeInfo.AccessibilityAction)lollipopWebContentsAccessibility);
    }

    @Override
    public CharSequence computeText(String object, boolean bl, String string2) {
        object = super.computeText((String)object, bl, string2);
        if (!string2.isEmpty() && !string2.equals(lollipopWebContentsAccessibility.mSystemLanguageTag)) {
            LollipopWebContentsAccessibility lollipopWebContentsAccessibility;
            if (object instanceof SpannableString) {
                lollipopWebContentsAccessibility = (SpannableString)object;
            } else {
                SpannableString spannableString;
                lollipopWebContentsAccessibility = spannableString;
                spannableString = new SpannableString((CharSequence)object);
            }
            LollipopWebContentsAccessibility lollipopWebContentsAccessibility2 = lollipopWebContentsAccessibility;
            object = Locale.forLanguageTag(string2);
            lollipopWebContentsAccessibility2.setSpan(new LocaleSpan((Locale)object), 0, lollipopWebContentsAccessibility.length(), 0);
            return lollipopWebContentsAccessibility2;
        }
        return object;
    }

    @Override
    public void onDetachedFromWindow() {
        LollipopWebContentsAccessibility lollipopWebContentsAccessibility = this;
        super.onDetachedFromWindow();
        if (!lollipopWebContentsAccessibility.isNativeInitialized()) {
            return;
        }
        ContextUtils.getApplicationContext().unregisterReceiver(this.mBroadcastReceiver);
    }

    @Override
    public void onAttachedToWindow() {
        LollipopWebContentsAccessibility lollipopWebContentsAccessibility = this;
        super.onAttachedToWindow();
        lollipopWebContentsAccessibility.registerLocaleChangeReceiver();
    }
}

