/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="base::android")
@MainDex
public class RecordHistogram {
    public static Throwable sDisabledBy;
    public static Map<String, Long> sCache;
    public static final /* synthetic */ boolean $assertionsDisabled;

    public static void setDisabledForTests(boolean bl) {
        Throwable throwable;
        Throwable throwable2;
        if (bl && (throwable2 = sDisabledBy) != null) {
            throw new IllegalStateException("Histograms are already disabled.", throwable2);
        }
        if (bl) {
            Throwable throwable3;
            throwable = throwable3;
            throwable3 = new Throwable();
        } else {
            throwable = null;
        }
        sDisabledBy = throwable;
    }

    public static long getCachedHistogramKey(String object) {
        return (object = sCache.get(object)) == null ? 0L : (Long)object;
    }

    public static void recordBooleanHistogram(String string2, boolean bl) {
        if (sDisabledBy != null) {
            return;
        }
        String string3 = string2;
        long l2 = RecordHistogram.getCachedHistogramKey(string3);
        long l3 = RecordHistogram.nativeRecordBooleanHistogram(string3, l2, bl);
        if (l3 != l2) {
            sCache.put(string2, l3);
        }
    }

    public static void recordEnumeratedHistogram(String string2, int n2, int n3) {
        if (sDisabledBy != null) {
            return;
        }
        String string3 = string2;
        long l2 = RecordHistogram.getCachedHistogramKey(string3);
        long l3 = RecordHistogram.nativeRecordEnumeratedHistogram(string3, l2, n2, n3);
        if (l3 != l2) {
            sCache.put(string2, l3);
        }
    }

    public static void recordCountHistogram(String string2, int n2) {
        RecordHistogram.recordCustomCountHistogram(string2, n2, 1, 1000000, 50);
    }

    public static void recordCount100Histogram(String string2, int n2) {
        RecordHistogram.recordCustomCountHistogram(string2, n2, 1, 100, 50);
    }

    public static void recordCount1000Histogram(String string2, int n2) {
        RecordHistogram.recordCustomCountHistogram(string2, n2, 1, 1000, 50);
    }

    public static void recordCustomCountHistogram(String string2, int n2, int n3, int n4, int n5) {
        if (sDisabledBy != null) {
            return;
        }
        String string3 = string2;
        long l2 = RecordHistogram.getCachedHistogramKey(string3);
        long l3 = RecordHistogram.nativeRecordCustomCountHistogram(string3, l2, n2, n3, n4, n5);
        if (l3 != l2) {
            sCache.put(string2, l3);
        }
    }

    public static void recordLinearCountHistogram(String string2, int n2, int n3, int n4, int n5) {
        if (sDisabledBy != null) {
            return;
        }
        String string3 = string2;
        long l2 = RecordHistogram.getCachedHistogramKey(string3);
        long l3 = RecordHistogram.nativeRecordLinearCountHistogram(string3, l2, n2, n3, n4, n5);
        if (l3 != l2) {
            sCache.put(string2, l3);
        }
    }

    public static void recordPercentageHistogram(String string2, int n2) {
        if (sDisabledBy != null) {
            return;
        }
        String string3 = string2;
        long l2 = RecordHistogram.getCachedHistogramKey(string3);
        long l3 = RecordHistogram.nativeRecordEnumeratedHistogram(string3, l2, n2, 101);
        if (l3 != l2) {
            sCache.put(string2, l3);
        }
    }

    public static void recordSparseHistogram(String string2, int n2) {
        if (sDisabledBy != null) {
            return;
        }
        String string3 = string2;
        long l2 = RecordHistogram.getCachedHistogramKey(string3);
        long l3 = RecordHistogram.nativeRecordSparseHistogram(string3, l2, n2);
        if (l3 != l2) {
            sCache.put(string2, l3);
        }
    }

    public static void recordTimesHistogram(String string2, long l2) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(string2, l2, 1L, 10000L, 50);
    }

    public static void recordMediumTimesHistogram(String string2, long l2) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(string2, l2, 10L, 180000L, 50);
    }

    public static void recordLongTimesHistogram(String string2, long l2) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(string2, l2, 1L, 3600000L, 50);
    }

    public static void recordLongTimesHistogram100(String string2, long l2) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(string2, l2, 1L, 3600000L, 100);
    }

    public static void recordCustomTimesHistogram(String string2, long l2, long l3, long l4, int n2) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(string2, l2, l3, l4, n2);
    }

    public static void recordMemoryKBHistogram(String string2, int n2) {
        RecordHistogram.recordCustomCountHistogram(string2, n2, 1000, 500000, 50);
    }

    public static int clampToInt(long l2) {
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l2;
    }

    public static void recordCustomTimesHistogramMilliseconds(String string2, long l2, long l3, long l4, int n2) {
        if (sDisabledBy != null) {
            return;
        }
        long l5 = RecordHistogram.getCachedHistogramKey(string2);
        if (!$assertionsDisabled) {
            long l6 = l4;
            if (l6 != (long)RecordHistogram.clampToInt(l6)) {
                throw new AssertionError();
            }
        }
        if ((l2 = RecordHistogram.nativeRecordCustomTimesHistogramMilliseconds(string2, l5, RecordHistogram.clampToInt(l2), RecordHistogram.clampToInt(l3), RecordHistogram.clampToInt(l4), n2)) != l5) {
            sCache.put(string2, l2);
        }
    }

    public static int getHistogramValueCountForTesting(String string2, int n2) {
        return RecordHistogram.nativeGetHistogramValueCountForTesting(string2, n2);
    }

    public static int getHistogramTotalCountForTesting(String string2) {
        return RecordHistogram.nativeGetHistogramTotalCountForTesting(string2);
    }

    public static native long nativeRecordCustomTimesHistogramMilliseconds(String var0, long var1, int var3, int var4, int var5, int var6);

    public static native long nativeRecordBooleanHistogram(String var0, long var1, boolean var3);

    public static native long nativeRecordEnumeratedHistogram(String var0, long var1, int var3, int var4);

    public static native long nativeRecordCustomCountHistogram(String var0, long var1, int var3, int var4, int var5, int var6);

    public static native long nativeRecordLinearCountHistogram(String var0, long var1, int var3, int var4, int var5, int var6);

    public static native long nativeRecordSparseHistogram(String var0, long var1, int var3);

    public static native int nativeGetHistogramValueCountForTesting(String var0, int var1);

    public static native int nativeGetHistogramTotalCountForTesting(String var0);

    static {
        $assertionsDisabled = RecordHistogram.class.desiredAssertionStatus() ^ true;
        sCache = Collections.synchronizedMap(new HashMap());
    }
}

