// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package org.chromium.services.device;

import com.vccorp.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.device.vibration.VibrationManagerImpl;

import com.vccorp.device.battery.BatteryMonitorFactory;
import com.vccorp.device.mojom.BatteryMonitor;
import com.vccorp.device.mojom.NfcProvider;
import com.vccorp.device.mojom.VibrationManager;
import org.chromium.device.nfc.NfcDelegate;
import com.vccorp.device.nfc.NfcProviderImpl;

import org.chromium.mojo.system.impl.CoreImpl;
import com.vccorp.services.service_manager.InterfaceRegistry;

@JNINamespace("device")
class InterfaceRegistrar {
    @CalledByNative
    static void createInterfaceRegistryForContext(
            int nativeHandle, NfcDelegate nfcDelegate) {
        // Note: The bindings code manages the lifetime of this object, so it
        // is not necessary to hold on to a reference to it explicitly.
        InterfaceRegistry registry = InterfaceRegistry.create(
                CoreImpl.getInstance().acquireNativeHandle(nativeHandle).toMessagePipeHandle());
        registry.addInterface(BatteryMonitor.MANAGER, new BatteryMonitorFactory());
        registry.addInterface(NfcProvider.MANAGER, new NfcProviderImpl.Factory(nfcDelegate));
        registry.addInterface(VibrationManager.MANAGER, new VibrationManagerImpl.Factory());
    }
}
