
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/transferable_resource.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class TransferableResource extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int id;
    public int format;
    public int filter;
    public com.vccorp.gfx.mojom.Size size;
    public com.vccorp.gpu.mojom.MailboxHolder mailboxHolder;
    public boolean readLockFencesEnabled;
    public boolean isSoftware;
    public boolean isOverlayCandidate;
    public boolean isBackedBySurfaceTexture;
    public boolean wantsPromotionHint;
    public com.vccorp.gfx.mojom.ColorSpace colorSpace;

    private TransferableResource(int version) {
        super(STRUCT_SIZE, version);
    }

    public TransferableResource() {
        this(0);
    }

    public static TransferableResource deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static TransferableResource deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static TransferableResource decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        TransferableResource result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new TransferableResource(elementsOrVersion);
                {
                    
                result.id = decoder0.readInt(8);
                }
                {
                    
                result.format = decoder0.readInt(12);
                    ResourceFormat.validate(result.format);
                }
                {
                    
                result.filter = decoder0.readInt(16);
                }
                {
                    
                result.readLockFencesEnabled = decoder0.readBoolean(20, 0);
                }
                {
                    
                result.isSoftware = decoder0.readBoolean(20, 1);
                }
                {
                    
                result.isOverlayCandidate = decoder0.readBoolean(20, 2);
                }
                {
                    
                result.isBackedBySurfaceTexture = decoder0.readBoolean(20, 3);
                }
                {
                    
                result.wantsPromotionHint = decoder0.readBoolean(20, 4);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.size = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.mailboxHolder = com.vccorp.gpu.mojom.MailboxHolder.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.colorSpace = com.vccorp.gfx.mojom.ColorSpace.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.id, 8);
        
        encoder0.encode(this.format, 12);
        
        encoder0.encode(this.filter, 16);
        
        encoder0.encode(this.readLockFencesEnabled, 20, 0);
        
        encoder0.encode(this.isSoftware, 20, 1);
        
        encoder0.encode(this.isOverlayCandidate, 20, 2);
        
        encoder0.encode(this.isBackedBySurfaceTexture, 20, 3);
        
        encoder0.encode(this.wantsPromotionHint, 20, 4);
        
        encoder0.encode(this.size, 24, false);
        
        encoder0.encode(this.mailboxHolder, 32, false);
        
        encoder0.encode(this.colorSpace, 40, false);
    }
}