
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/shape_detection/public/mojom/facedetection_provider.mojom
//

package com.vccorp.shape_detection.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class FaceDetectionProvider_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<FaceDetectionProvider, FaceDetectionProvider.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<FaceDetectionProvider, FaceDetectionProvider.Proxy>() {

        @Override
        public String getName() {
            return "shape_detection.mojom.FaceDetectionProvider";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, FaceDetectionProvider impl) {
            return new Stub(core, impl);
        }

        @Override
        public FaceDetectionProvider[] buildArray(int size) {
          return new FaceDetectionProvider[size];
        }
    };


    private static final int CREATE_FACE_DETECTION_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements FaceDetectionProvider.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void createFaceDetection(
com.vccorp.mojo.bindings.InterfaceRequest<FaceDetection> request, FaceDetectorOptions options) {

            FaceDetectionProviderCreateFaceDetectionParams _message = new FaceDetectionProviderCreateFaceDetectionParams();

            _message.request = request;

            _message.options = options;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_FACE_DETECTION_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<FaceDetectionProvider> {

        Stub(com.vccorp.mojo.system.Core core, FaceDetectionProvider impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                FaceDetectionProvider_Internal.MANAGER, messageWithHeader);





                    case CREATE_FACE_DETECTION_ORDINAL: {

                        FaceDetectionProviderCreateFaceDetectionParams data =
                                FaceDetectionProviderCreateFaceDetectionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createFaceDetection(data.request, data.options);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), FaceDetectionProvider_Internal.MANAGER, messageWithHeader, receiver);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class FaceDetectionProviderCreateFaceDetectionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<FaceDetection> request;
        public FaceDetectorOptions options;

        private FaceDetectionProviderCreateFaceDetectionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public FaceDetectionProviderCreateFaceDetectionParams() {
            this(0);
        }

        public static FaceDetectionProviderCreateFaceDetectionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static FaceDetectionProviderCreateFaceDetectionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static FaceDetectionProviderCreateFaceDetectionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            FaceDetectionProviderCreateFaceDetectionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new FaceDetectionProviderCreateFaceDetectionParams(elementsOrVersion);
                    {
                        
                    result.request = decoder0.readInterfaceRequest(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.options = FaceDetectorOptions.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.request, 8, false);
            
            encoder0.encode(this.options, 16, false);
        }
    }



}
