// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package com.vccorp.services.service_manager;

import com.vccorp.mojo.bindings.ConnectionErrorHandler;
import com.vccorp.mojo.bindings.Interface;
import com.vccorp.mojo.bindings.InterfaceRequest;
import com.vccorp.mojo.system.Core;
import com.vccorp.mojo.system.MessagePipeHandle;
import com.vccorp.mojo.system.MojoException;
import com.vccorp.mojo.system.Pair;

/**
 * Provides access to interfaces exposed by an InterfaceProvider mojo interface.
 */
public class InterfaceProvider implements ConnectionErrorHandler {
    private Core mCore;
    private com.vccorp.service_manager.mojom.InterfaceProvider.Proxy mInterfaceProvider;

    public InterfaceProvider(MessagePipeHandle pipe) {
        mCore = pipe.getCore();
        mInterfaceProvider =
                com.vccorp.service_manager.mojom.InterfaceProvider.MANAGER.attachProxy(pipe, 0);
        mInterfaceProvider.getProxyHandler().setErrorHandler(this);
    }

    /**
     * Binds |request| to an implementation of I in the remote application.
     *
     * @param manager The Manager for interface I.
     * @param request The request for the interface I.
     */
    public <I extends Interface> void getInterface(
            Interface.Manager<I, ? extends Interface.Proxy> manager, InterfaceRequest<I> request) {
        mInterfaceProvider.getInterface(manager.getName(), request.passHandle());
    }

    /**
     * Binds and returns a proxy to an implementation of I in the remote application.
     *
     * @param manager The Manager for interface I.
     * @return A bound Proxy for interface I.
     */
    public <I extends Interface, P extends Interface.Proxy> P getInterface(
            Interface.Manager<I, P> manager) {
        Pair<P, InterfaceRequest<I>> result = manager.getInterfaceRequest(mCore);
        getInterface(manager, result.second);
        return result.first;
    }

    @Override
    public void onConnectionError(MojoException e) {
        mInterfaceProvider.close();
    }
}
