
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/payments/payment_request.mojom
//

package com.vccorp.payments.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class PaymentRequestClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<PaymentRequestClient, PaymentRequestClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<PaymentRequestClient, PaymentRequestClient.Proxy>() {

        @Override
        public String getName() {
            return "payments.mojom.PaymentRequestClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, PaymentRequestClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public PaymentRequestClient[] buildArray(int size) {
          return new PaymentRequestClient[size];
        }
    };


    private static final int ON_PAYMENT_METHOD_CHANGE_ORDINAL = 0;

    private static final int ON_SHIPPING_ADDRESS_CHANGE_ORDINAL = 1;

    private static final int ON_SHIPPING_OPTION_CHANGE_ORDINAL = 2;

    private static final int ON_PAYER_DETAIL_CHANGE_ORDINAL = 3;

    private static final int ON_PAYMENT_RESPONSE_ORDINAL = 4;

    private static final int ON_ERROR_ORDINAL = 5;

    private static final int ON_COMPLETE_ORDINAL = 6;

    private static final int ON_ABORT_ORDINAL = 7;

    private static final int ON_CAN_MAKE_PAYMENT_ORDINAL = 8;

    private static final int ON_HAS_ENROLLED_INSTRUMENT_ORDINAL = 9;

    private static final int WARN_NO_FAVICON_ORDINAL = 10;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements PaymentRequestClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onPaymentMethodChange(
String methodName, String stringifiedDetails) {

            PaymentRequestClientOnPaymentMethodChangeParams _message = new PaymentRequestClientOnPaymentMethodChangeParams();

            _message.methodName = methodName;

            _message.stringifiedDetails = stringifiedDetails;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_PAYMENT_METHOD_CHANGE_ORDINAL)));

        }


        @Override
        public void onShippingAddressChange(
PaymentAddress address) {

            PaymentRequestClientOnShippingAddressChangeParams _message = new PaymentRequestClientOnShippingAddressChangeParams();

            _message.address = address;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_SHIPPING_ADDRESS_CHANGE_ORDINAL)));

        }


        @Override
        public void onShippingOptionChange(
String shippingOptionId) {

            PaymentRequestClientOnShippingOptionChangeParams _message = new PaymentRequestClientOnShippingOptionChangeParams();

            _message.shippingOptionId = shippingOptionId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_SHIPPING_OPTION_CHANGE_ORDINAL)));

        }


        @Override
        public void onPayerDetailChange(
PayerDetail detail) {

            PaymentRequestClientOnPayerDetailChangeParams _message = new PaymentRequestClientOnPayerDetailChangeParams();

            _message.detail = detail;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_PAYER_DETAIL_CHANGE_ORDINAL)));

        }


        @Override
        public void onPaymentResponse(
PaymentResponse response) {

            PaymentRequestClientOnPaymentResponseParams _message = new PaymentRequestClientOnPaymentResponseParams();

            _message.response = response;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_PAYMENT_RESPONSE_ORDINAL)));

        }


        @Override
        public void onError(
int error) {

            PaymentRequestClientOnErrorParams _message = new PaymentRequestClientOnErrorParams();

            _message.error = error;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_ERROR_ORDINAL)));

        }


        @Override
        public void onComplete(
) {

            PaymentRequestClientOnCompleteParams _message = new PaymentRequestClientOnCompleteParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_COMPLETE_ORDINAL)));

        }


        @Override
        public void onAbort(
boolean abortedSuccessfully) {

            PaymentRequestClientOnAbortParams _message = new PaymentRequestClientOnAbortParams();

            _message.abortedSuccessfully = abortedSuccessfully;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_ABORT_ORDINAL)));

        }


        @Override
        public void onCanMakePayment(
int result) {

            PaymentRequestClientOnCanMakePaymentParams _message = new PaymentRequestClientOnCanMakePaymentParams();

            _message.result = result;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_CAN_MAKE_PAYMENT_ORDINAL)));

        }


        @Override
        public void onHasEnrolledInstrument(
int result) {

            PaymentRequestClientOnHasEnrolledInstrumentParams _message = new PaymentRequestClientOnHasEnrolledInstrumentParams();

            _message.result = result;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_HAS_ENROLLED_INSTRUMENT_ORDINAL)));

        }


        @Override
        public void warnNoFavicon(
) {

            PaymentRequestClientWarnNoFaviconParams _message = new PaymentRequestClientWarnNoFaviconParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(WARN_NO_FAVICON_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<PaymentRequestClient> {

        Stub(com.vccorp.mojo.system.Core core, PaymentRequestClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                PaymentRequestClient_Internal.MANAGER, messageWithHeader);





                    case ON_PAYMENT_METHOD_CHANGE_ORDINAL: {

                        PaymentRequestClientOnPaymentMethodChangeParams data =
                                PaymentRequestClientOnPaymentMethodChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onPaymentMethodChange(data.methodName, data.stringifiedDetails);
                        return true;
                    }





                    case ON_SHIPPING_ADDRESS_CHANGE_ORDINAL: {

                        PaymentRequestClientOnShippingAddressChangeParams data =
                                PaymentRequestClientOnShippingAddressChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onShippingAddressChange(data.address);
                        return true;
                    }





                    case ON_SHIPPING_OPTION_CHANGE_ORDINAL: {

                        PaymentRequestClientOnShippingOptionChangeParams data =
                                PaymentRequestClientOnShippingOptionChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onShippingOptionChange(data.shippingOptionId);
                        return true;
                    }





                    case ON_PAYER_DETAIL_CHANGE_ORDINAL: {

                        PaymentRequestClientOnPayerDetailChangeParams data =
                                PaymentRequestClientOnPayerDetailChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onPayerDetailChange(data.detail);
                        return true;
                    }





                    case ON_PAYMENT_RESPONSE_ORDINAL: {

                        PaymentRequestClientOnPaymentResponseParams data =
                                PaymentRequestClientOnPaymentResponseParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onPaymentResponse(data.response);
                        return true;
                    }





                    case ON_ERROR_ORDINAL: {

                        PaymentRequestClientOnErrorParams data =
                                PaymentRequestClientOnErrorParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onError(data.error);
                        return true;
                    }





                    case ON_COMPLETE_ORDINAL: {

                        PaymentRequestClientOnCompleteParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onComplete();
                        return true;
                    }





                    case ON_ABORT_ORDINAL: {

                        PaymentRequestClientOnAbortParams data =
                                PaymentRequestClientOnAbortParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onAbort(data.abortedSuccessfully);
                        return true;
                    }





                    case ON_CAN_MAKE_PAYMENT_ORDINAL: {

                        PaymentRequestClientOnCanMakePaymentParams data =
                                PaymentRequestClientOnCanMakePaymentParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onCanMakePayment(data.result);
                        return true;
                    }





                    case ON_HAS_ENROLLED_INSTRUMENT_ORDINAL: {

                        PaymentRequestClientOnHasEnrolledInstrumentParams data =
                                PaymentRequestClientOnHasEnrolledInstrumentParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onHasEnrolledInstrument(data.result);
                        return true;
                    }





                    case WARN_NO_FAVICON_ORDINAL: {

                        PaymentRequestClientWarnNoFaviconParams.deserialize(messageWithHeader.getPayload());

                        getImpl().warnNoFavicon();
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), PaymentRequestClient_Internal.MANAGER, messageWithHeader, receiver);
























                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class PaymentRequestClientOnPaymentMethodChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String methodName;
        public String stringifiedDetails;

        private PaymentRequestClientOnPaymentMethodChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestClientOnPaymentMethodChangeParams() {
            this(0);
        }

        public static PaymentRequestClientOnPaymentMethodChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestClientOnPaymentMethodChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestClientOnPaymentMethodChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestClientOnPaymentMethodChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestClientOnPaymentMethodChangeParams(elementsOrVersion);
                    {
                        
                    result.methodName = decoder0.readString(8, false);
                    }
                    {
                        
                    result.stringifiedDetails = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.methodName, 8, false);
            
            encoder0.encode(this.stringifiedDetails, 16, false);
        }
    }



    
    static final class PaymentRequestClientOnShippingAddressChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PaymentAddress address;

        private PaymentRequestClientOnShippingAddressChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestClientOnShippingAddressChangeParams() {
            this(0);
        }

        public static PaymentRequestClientOnShippingAddressChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestClientOnShippingAddressChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestClientOnShippingAddressChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestClientOnShippingAddressChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestClientOnShippingAddressChangeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.address = PaymentAddress.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.address, 8, false);
        }
    }



    
    static final class PaymentRequestClientOnShippingOptionChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String shippingOptionId;

        private PaymentRequestClientOnShippingOptionChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestClientOnShippingOptionChangeParams() {
            this(0);
        }

        public static PaymentRequestClientOnShippingOptionChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestClientOnShippingOptionChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestClientOnShippingOptionChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestClientOnShippingOptionChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestClientOnShippingOptionChangeParams(elementsOrVersion);
                    {
                        
                    result.shippingOptionId = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.shippingOptionId, 8, false);
        }
    }



    
    static final class PaymentRequestClientOnPayerDetailChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PayerDetail detail;

        private PaymentRequestClientOnPayerDetailChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestClientOnPayerDetailChangeParams() {
            this(0);
        }

        public static PaymentRequestClientOnPayerDetailChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestClientOnPayerDetailChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestClientOnPayerDetailChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestClientOnPayerDetailChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestClientOnPayerDetailChangeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.detail = PayerDetail.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.detail, 8, false);
        }
    }



    
    static final class PaymentRequestClientOnPaymentResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PaymentResponse response;

        private PaymentRequestClientOnPaymentResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestClientOnPaymentResponseParams() {
            this(0);
        }

        public static PaymentRequestClientOnPaymentResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestClientOnPaymentResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestClientOnPaymentResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestClientOnPaymentResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestClientOnPaymentResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.response = PaymentResponse.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.response, 8, false);
        }
    }



    
    static final class PaymentRequestClientOnErrorParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int error;

        private PaymentRequestClientOnErrorParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestClientOnErrorParams() {
            this(0);
        }

        public static PaymentRequestClientOnErrorParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestClientOnErrorParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestClientOnErrorParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestClientOnErrorParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestClientOnErrorParams(elementsOrVersion);
                    {
                        
                    result.error = decoder0.readInt(8);
                        PaymentErrorReason.validate(result.error);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.error, 8);
        }
    }



    
    static final class PaymentRequestClientOnCompleteParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private PaymentRequestClientOnCompleteParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestClientOnCompleteParams() {
            this(0);
        }

        public static PaymentRequestClientOnCompleteParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestClientOnCompleteParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestClientOnCompleteParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestClientOnCompleteParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestClientOnCompleteParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class PaymentRequestClientOnAbortParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean abortedSuccessfully;

        private PaymentRequestClientOnAbortParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestClientOnAbortParams() {
            this(0);
        }

        public static PaymentRequestClientOnAbortParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestClientOnAbortParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestClientOnAbortParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestClientOnAbortParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestClientOnAbortParams(elementsOrVersion);
                    {
                        
                    result.abortedSuccessfully = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.abortedSuccessfully, 8, 0);
        }
    }



    
    static final class PaymentRequestClientOnCanMakePaymentParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;

        private PaymentRequestClientOnCanMakePaymentParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestClientOnCanMakePaymentParams() {
            this(0);
        }

        public static PaymentRequestClientOnCanMakePaymentParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestClientOnCanMakePaymentParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestClientOnCanMakePaymentParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestClientOnCanMakePaymentParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestClientOnCanMakePaymentParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                        CanMakePaymentQueryResult.validate(result.result);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
        }
    }



    
    static final class PaymentRequestClientOnHasEnrolledInstrumentParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;

        private PaymentRequestClientOnHasEnrolledInstrumentParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestClientOnHasEnrolledInstrumentParams() {
            this(0);
        }

        public static PaymentRequestClientOnHasEnrolledInstrumentParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestClientOnHasEnrolledInstrumentParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestClientOnHasEnrolledInstrumentParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestClientOnHasEnrolledInstrumentParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestClientOnHasEnrolledInstrumentParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                        HasEnrolledInstrumentQueryResult.validate(result.result);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
        }
    }



    
    static final class PaymentRequestClientWarnNoFaviconParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private PaymentRequestClientWarnNoFaviconParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestClientWarnNoFaviconParams() {
            this(0);
        }

        public static PaymentRequestClientWarnNoFaviconParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestClientWarnNoFaviconParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestClientWarnNoFaviconParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestClientWarnNoFaviconParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestClientWarnNoFaviconParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



}
