
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/payments/payment_app.mojom
//

package com.vccorp.payments.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class PaymentManager_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<PaymentManager, PaymentManager.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<PaymentManager, PaymentManager.Proxy>() {

        @Override
        public String getName() {
            return "payments.mojom.PaymentManager";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, PaymentManager impl) {
            return new Stub(core, impl);
        }

        @Override
        public PaymentManager[] buildArray(int size) {
          return new PaymentManager[size];
        }
    };


    private static final int INIT_ORDINAL = 0;

    private static final int DELETE_PAYMENT_INSTRUMENT_ORDINAL = 1;

    private static final int GET_PAYMENT_INSTRUMENT_ORDINAL = 2;

    private static final int KEYS_OF_PAYMENT_INSTRUMENTS_ORDINAL = 3;

    private static final int HAS_PAYMENT_INSTRUMENT_ORDINAL = 4;

    private static final int SET_PAYMENT_INSTRUMENT_ORDINAL = 5;

    private static final int CLEAR_PAYMENT_INSTRUMENTS_ORDINAL = 6;

    private static final int SET_USER_HINT_ORDINAL = 7;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements PaymentManager.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void init(
com.vccorp.url.mojom.Url contextUrl, String serviceWorkerScope) {

            PaymentManagerInitParams _message = new PaymentManagerInitParams();

            _message.contextUrl = contextUrl;

            _message.serviceWorkerScope = serviceWorkerScope;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(INIT_ORDINAL)));

        }


        @Override
        public void deletePaymentInstrument(
String instrumentKey, 
DeletePaymentInstrumentResponse callback) {

            PaymentManagerDeletePaymentInstrumentParams _message = new PaymentManagerDeletePaymentInstrumentParams();

            _message.instrumentKey = instrumentKey;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DELETE_PAYMENT_INSTRUMENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PaymentManagerDeletePaymentInstrumentResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getPaymentInstrument(
String instrumentKey, 
GetPaymentInstrumentResponse callback) {

            PaymentManagerGetPaymentInstrumentParams _message = new PaymentManagerGetPaymentInstrumentParams();

            _message.instrumentKey = instrumentKey;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_PAYMENT_INSTRUMENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PaymentManagerGetPaymentInstrumentResponseParamsForwardToCallback(callback));

        }


        @Override
        public void keysOfPaymentInstruments(

KeysOfPaymentInstrumentsResponse callback) {

            PaymentManagerKeysOfPaymentInstrumentsParams _message = new PaymentManagerKeysOfPaymentInstrumentsParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    KEYS_OF_PAYMENT_INSTRUMENTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PaymentManagerKeysOfPaymentInstrumentsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void hasPaymentInstrument(
String instrumentKey, 
HasPaymentInstrumentResponse callback) {

            PaymentManagerHasPaymentInstrumentParams _message = new PaymentManagerHasPaymentInstrumentParams();

            _message.instrumentKey = instrumentKey;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    HAS_PAYMENT_INSTRUMENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PaymentManagerHasPaymentInstrumentResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setPaymentInstrument(
String instrumentKey, PaymentInstrument instrument, 
SetPaymentInstrumentResponse callback) {

            PaymentManagerSetPaymentInstrumentParams _message = new PaymentManagerSetPaymentInstrumentParams();

            _message.instrumentKey = instrumentKey;

            _message.instrument = instrument;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_PAYMENT_INSTRUMENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PaymentManagerSetPaymentInstrumentResponseParamsForwardToCallback(callback));

        }


        @Override
        public void clearPaymentInstruments(

ClearPaymentInstrumentsResponse callback) {

            PaymentManagerClearPaymentInstrumentsParams _message = new PaymentManagerClearPaymentInstrumentsParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_PAYMENT_INSTRUMENTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PaymentManagerClearPaymentInstrumentsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setUserHint(
String userHint) {

            PaymentManagerSetUserHintParams _message = new PaymentManagerSetUserHintParams();

            _message.userHint = userHint;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_USER_HINT_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<PaymentManager> {

        Stub(com.vccorp.mojo.system.Core core, PaymentManager impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                PaymentManager_Internal.MANAGER, messageWithHeader);





                    case INIT_ORDINAL: {

                        PaymentManagerInitParams data =
                                PaymentManagerInitParams.deserialize(messageWithHeader.getPayload());

                        getImpl().init(data.contextUrl, data.serviceWorkerScope);
                        return true;
                    }

















                    case SET_USER_HINT_ORDINAL: {

                        PaymentManagerSetUserHintParams data =
                                PaymentManagerSetUserHintParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setUserHint(data.userHint);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), PaymentManager_Internal.MANAGER, messageWithHeader, receiver);









                    case DELETE_PAYMENT_INSTRUMENT_ORDINAL: {

                        PaymentManagerDeletePaymentInstrumentParams data =
                                PaymentManagerDeletePaymentInstrumentParams.deserialize(messageWithHeader.getPayload());

                        getImpl().deletePaymentInstrument(data.instrumentKey, new PaymentManagerDeletePaymentInstrumentResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_PAYMENT_INSTRUMENT_ORDINAL: {

                        PaymentManagerGetPaymentInstrumentParams data =
                                PaymentManagerGetPaymentInstrumentParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getPaymentInstrument(data.instrumentKey, new PaymentManagerGetPaymentInstrumentResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case KEYS_OF_PAYMENT_INSTRUMENTS_ORDINAL: {

                        PaymentManagerKeysOfPaymentInstrumentsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().keysOfPaymentInstruments(new PaymentManagerKeysOfPaymentInstrumentsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case HAS_PAYMENT_INSTRUMENT_ORDINAL: {

                        PaymentManagerHasPaymentInstrumentParams data =
                                PaymentManagerHasPaymentInstrumentParams.deserialize(messageWithHeader.getPayload());

                        getImpl().hasPaymentInstrument(data.instrumentKey, new PaymentManagerHasPaymentInstrumentResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SET_PAYMENT_INSTRUMENT_ORDINAL: {

                        PaymentManagerSetPaymentInstrumentParams data =
                                PaymentManagerSetPaymentInstrumentParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setPaymentInstrument(data.instrumentKey, data.instrument, new PaymentManagerSetPaymentInstrumentResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CLEAR_PAYMENT_INSTRUMENTS_ORDINAL: {

                        PaymentManagerClearPaymentInstrumentsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearPaymentInstruments(new PaymentManagerClearPaymentInstrumentsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class PaymentManagerInitParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url contextUrl;
        public String serviceWorkerScope;

        private PaymentManagerInitParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerInitParams() {
            this(0);
        }

        public static PaymentManagerInitParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerInitParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerInitParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerInitParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerInitParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.contextUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.serviceWorkerScope = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.contextUrl, 8, false);
            
            encoder0.encode(this.serviceWorkerScope, 16, false);
        }
    }



    
    static final class PaymentManagerDeletePaymentInstrumentParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String instrumentKey;

        private PaymentManagerDeletePaymentInstrumentParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerDeletePaymentInstrumentParams() {
            this(0);
        }

        public static PaymentManagerDeletePaymentInstrumentParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerDeletePaymentInstrumentParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerDeletePaymentInstrumentParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerDeletePaymentInstrumentParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerDeletePaymentInstrumentParams(elementsOrVersion);
                    {
                        
                    result.instrumentKey = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.instrumentKey, 8, false);
        }
    }



    
    static final class PaymentManagerDeletePaymentInstrumentResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private PaymentManagerDeletePaymentInstrumentResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerDeletePaymentInstrumentResponseParams() {
            this(0);
        }

        public static PaymentManagerDeletePaymentInstrumentResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerDeletePaymentInstrumentResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerDeletePaymentInstrumentResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerDeletePaymentInstrumentResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerDeletePaymentInstrumentResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        PaymentHandlerStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class PaymentManagerDeletePaymentInstrumentResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final PaymentManager.DeletePaymentInstrumentResponse mCallback;

        PaymentManagerDeletePaymentInstrumentResponseParamsForwardToCallback(PaymentManager.DeletePaymentInstrumentResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DELETE_PAYMENT_INSTRUMENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                PaymentManagerDeletePaymentInstrumentResponseParams response = PaymentManagerDeletePaymentInstrumentResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PaymentManagerDeletePaymentInstrumentResponseParamsProxyToResponder implements PaymentManager.DeletePaymentInstrumentResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PaymentManagerDeletePaymentInstrumentResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            PaymentManagerDeletePaymentInstrumentResponseParams _response = new PaymentManagerDeletePaymentInstrumentResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DELETE_PAYMENT_INSTRUMENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class PaymentManagerGetPaymentInstrumentParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String instrumentKey;

        private PaymentManagerGetPaymentInstrumentParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerGetPaymentInstrumentParams() {
            this(0);
        }

        public static PaymentManagerGetPaymentInstrumentParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerGetPaymentInstrumentParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerGetPaymentInstrumentParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerGetPaymentInstrumentParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerGetPaymentInstrumentParams(elementsOrVersion);
                    {
                        
                    result.instrumentKey = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.instrumentKey, 8, false);
        }
    }



    
    static final class PaymentManagerGetPaymentInstrumentResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PaymentInstrument instrument;
        public int status;

        private PaymentManagerGetPaymentInstrumentResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerGetPaymentInstrumentResponseParams() {
            this(0);
        }

        public static PaymentManagerGetPaymentInstrumentResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerGetPaymentInstrumentResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerGetPaymentInstrumentResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerGetPaymentInstrumentResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerGetPaymentInstrumentResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.instrument = PaymentInstrument.decode(decoder1);
                    }
                    {
                        
                    result.status = decoder0.readInt(16);
                        PaymentHandlerStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.instrument, 8, false);
            
            encoder0.encode(this.status, 16);
        }
    }

    static class PaymentManagerGetPaymentInstrumentResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final PaymentManager.GetPaymentInstrumentResponse mCallback;

        PaymentManagerGetPaymentInstrumentResponseParamsForwardToCallback(PaymentManager.GetPaymentInstrumentResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_PAYMENT_INSTRUMENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                PaymentManagerGetPaymentInstrumentResponseParams response = PaymentManagerGetPaymentInstrumentResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.instrument, response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PaymentManagerGetPaymentInstrumentResponseParamsProxyToResponder implements PaymentManager.GetPaymentInstrumentResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PaymentManagerGetPaymentInstrumentResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(PaymentInstrument instrument, Integer status) {
            PaymentManagerGetPaymentInstrumentResponseParams _response = new PaymentManagerGetPaymentInstrumentResponseParams();

            _response.instrument = instrument;

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_PAYMENT_INSTRUMENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class PaymentManagerKeysOfPaymentInstrumentsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private PaymentManagerKeysOfPaymentInstrumentsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerKeysOfPaymentInstrumentsParams() {
            this(0);
        }

        public static PaymentManagerKeysOfPaymentInstrumentsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerKeysOfPaymentInstrumentsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerKeysOfPaymentInstrumentsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerKeysOfPaymentInstrumentsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerKeysOfPaymentInstrumentsParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class PaymentManagerKeysOfPaymentInstrumentsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String[] keys;
        public int status;

        private PaymentManagerKeysOfPaymentInstrumentsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerKeysOfPaymentInstrumentsResponseParams() {
            this(0);
        }

        public static PaymentManagerKeysOfPaymentInstrumentsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerKeysOfPaymentInstrumentsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerKeysOfPaymentInstrumentsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerKeysOfPaymentInstrumentsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerKeysOfPaymentInstrumentsResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.keys = new String[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            result.keys[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        }
                    }
                    }
                    {
                        
                    result.status = decoder0.readInt(16);
                        PaymentHandlerStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.keys == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.keys.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.keys.length; ++i0) {
                    
                    encoder1.encode(this.keys[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            encoder0.encode(this.status, 16);
        }
    }

    static class PaymentManagerKeysOfPaymentInstrumentsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final PaymentManager.KeysOfPaymentInstrumentsResponse mCallback;

        PaymentManagerKeysOfPaymentInstrumentsResponseParamsForwardToCallback(PaymentManager.KeysOfPaymentInstrumentsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(KEYS_OF_PAYMENT_INSTRUMENTS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                PaymentManagerKeysOfPaymentInstrumentsResponseParams response = PaymentManagerKeysOfPaymentInstrumentsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.keys, response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PaymentManagerKeysOfPaymentInstrumentsResponseParamsProxyToResponder implements PaymentManager.KeysOfPaymentInstrumentsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PaymentManagerKeysOfPaymentInstrumentsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(String[] keys, Integer status) {
            PaymentManagerKeysOfPaymentInstrumentsResponseParams _response = new PaymentManagerKeysOfPaymentInstrumentsResponseParams();

            _response.keys = keys;

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    KEYS_OF_PAYMENT_INSTRUMENTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class PaymentManagerHasPaymentInstrumentParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String instrumentKey;

        private PaymentManagerHasPaymentInstrumentParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerHasPaymentInstrumentParams() {
            this(0);
        }

        public static PaymentManagerHasPaymentInstrumentParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerHasPaymentInstrumentParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerHasPaymentInstrumentParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerHasPaymentInstrumentParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerHasPaymentInstrumentParams(elementsOrVersion);
                    {
                        
                    result.instrumentKey = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.instrumentKey, 8, false);
        }
    }



    
    static final class PaymentManagerHasPaymentInstrumentResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private PaymentManagerHasPaymentInstrumentResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerHasPaymentInstrumentResponseParams() {
            this(0);
        }

        public static PaymentManagerHasPaymentInstrumentResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerHasPaymentInstrumentResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerHasPaymentInstrumentResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerHasPaymentInstrumentResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerHasPaymentInstrumentResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        PaymentHandlerStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class PaymentManagerHasPaymentInstrumentResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final PaymentManager.HasPaymentInstrumentResponse mCallback;

        PaymentManagerHasPaymentInstrumentResponseParamsForwardToCallback(PaymentManager.HasPaymentInstrumentResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(HAS_PAYMENT_INSTRUMENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                PaymentManagerHasPaymentInstrumentResponseParams response = PaymentManagerHasPaymentInstrumentResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PaymentManagerHasPaymentInstrumentResponseParamsProxyToResponder implements PaymentManager.HasPaymentInstrumentResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PaymentManagerHasPaymentInstrumentResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            PaymentManagerHasPaymentInstrumentResponseParams _response = new PaymentManagerHasPaymentInstrumentResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    HAS_PAYMENT_INSTRUMENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class PaymentManagerSetPaymentInstrumentParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String instrumentKey;
        public PaymentInstrument instrument;

        private PaymentManagerSetPaymentInstrumentParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerSetPaymentInstrumentParams() {
            this(0);
        }

        public static PaymentManagerSetPaymentInstrumentParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerSetPaymentInstrumentParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerSetPaymentInstrumentParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerSetPaymentInstrumentParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerSetPaymentInstrumentParams(elementsOrVersion);
                    {
                        
                    result.instrumentKey = decoder0.readString(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.instrument = PaymentInstrument.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.instrumentKey, 8, false);
            
            encoder0.encode(this.instrument, 16, false);
        }
    }



    
    static final class PaymentManagerSetPaymentInstrumentResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private PaymentManagerSetPaymentInstrumentResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerSetPaymentInstrumentResponseParams() {
            this(0);
        }

        public static PaymentManagerSetPaymentInstrumentResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerSetPaymentInstrumentResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerSetPaymentInstrumentResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerSetPaymentInstrumentResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerSetPaymentInstrumentResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        PaymentHandlerStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class PaymentManagerSetPaymentInstrumentResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final PaymentManager.SetPaymentInstrumentResponse mCallback;

        PaymentManagerSetPaymentInstrumentResponseParamsForwardToCallback(PaymentManager.SetPaymentInstrumentResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_PAYMENT_INSTRUMENT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                PaymentManagerSetPaymentInstrumentResponseParams response = PaymentManagerSetPaymentInstrumentResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PaymentManagerSetPaymentInstrumentResponseParamsProxyToResponder implements PaymentManager.SetPaymentInstrumentResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PaymentManagerSetPaymentInstrumentResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            PaymentManagerSetPaymentInstrumentResponseParams _response = new PaymentManagerSetPaymentInstrumentResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_PAYMENT_INSTRUMENT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class PaymentManagerClearPaymentInstrumentsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private PaymentManagerClearPaymentInstrumentsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerClearPaymentInstrumentsParams() {
            this(0);
        }

        public static PaymentManagerClearPaymentInstrumentsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerClearPaymentInstrumentsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerClearPaymentInstrumentsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerClearPaymentInstrumentsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerClearPaymentInstrumentsParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class PaymentManagerClearPaymentInstrumentsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private PaymentManagerClearPaymentInstrumentsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerClearPaymentInstrumentsResponseParams() {
            this(0);
        }

        public static PaymentManagerClearPaymentInstrumentsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerClearPaymentInstrumentsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerClearPaymentInstrumentsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerClearPaymentInstrumentsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerClearPaymentInstrumentsResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        PaymentHandlerStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }

    static class PaymentManagerClearPaymentInstrumentsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final PaymentManager.ClearPaymentInstrumentsResponse mCallback;

        PaymentManagerClearPaymentInstrumentsResponseParamsForwardToCallback(PaymentManager.ClearPaymentInstrumentsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLEAR_PAYMENT_INSTRUMENTS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                PaymentManagerClearPaymentInstrumentsResponseParams response = PaymentManagerClearPaymentInstrumentsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PaymentManagerClearPaymentInstrumentsResponseParamsProxyToResponder implements PaymentManager.ClearPaymentInstrumentsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PaymentManagerClearPaymentInstrumentsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            PaymentManagerClearPaymentInstrumentsResponseParams _response = new PaymentManagerClearPaymentInstrumentsResponseParams();

            _response.status = status;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_PAYMENT_INSTRUMENTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class PaymentManagerSetUserHintParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String userHint;

        private PaymentManagerSetUserHintParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentManagerSetUserHintParams() {
            this(0);
        }

        public static PaymentManagerSetUserHintParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentManagerSetUserHintParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentManagerSetUserHintParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentManagerSetUserHintParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentManagerSetUserHintParams(elementsOrVersion);
                    {
                        
                    result.userHint = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.userHint, 8, false);
        }
    }



}
