
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_change_manager.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class NetworkChangeManager_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<NetworkChangeManager, NetworkChangeManager.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<NetworkChangeManager, NetworkChangeManager.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.NetworkChangeManager";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, NetworkChangeManager impl) {
            return new Stub(core, impl);
        }

        @Override
        public NetworkChangeManager[] buildArray(int size) {
          return new NetworkChangeManager[size];
        }
    };


    private static final int REQUEST_NOTIFICATIONS_ORDINAL = 0;

    private static final int ON_NETWORK_CHANGED_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements NetworkChangeManager.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void requestNotifications(
NetworkChangeManagerClient clientPtr) {

            NetworkChangeManagerRequestNotificationsParams _message = new NetworkChangeManagerRequestNotificationsParams();

            _message.clientPtr = clientPtr;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(REQUEST_NOTIFICATIONS_ORDINAL)));

        }


        @Override
        public void onNetworkChanged(
boolean dnsChanged, boolean ipAddressChanged, boolean connectionTypeChanged, int newConnectionType, boolean connectionSubtypeChanged, int newConnectionSubtype) {

            NetworkChangeManagerOnNetworkChangedParams _message = new NetworkChangeManagerOnNetworkChangedParams();

            _message.dnsChanged = dnsChanged;

            _message.ipAddressChanged = ipAddressChanged;

            _message.connectionTypeChanged = connectionTypeChanged;

            _message.newConnectionType = newConnectionType;

            _message.connectionSubtypeChanged = connectionSubtypeChanged;

            _message.newConnectionSubtype = newConnectionSubtype;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_NETWORK_CHANGED_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<NetworkChangeManager> {

        Stub(com.vccorp.mojo.system.Core core, NetworkChangeManager impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                NetworkChangeManager_Internal.MANAGER, messageWithHeader);





                    case REQUEST_NOTIFICATIONS_ORDINAL: {

                        NetworkChangeManagerRequestNotificationsParams data =
                                NetworkChangeManagerRequestNotificationsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().requestNotifications(data.clientPtr);
                        return true;
                    }





                    case ON_NETWORK_CHANGED_ORDINAL: {

                        NetworkChangeManagerOnNetworkChangedParams data =
                                NetworkChangeManagerOnNetworkChangedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onNetworkChanged(data.dnsChanged, data.ipAddressChanged, data.connectionTypeChanged, data.newConnectionType, data.connectionSubtypeChanged, data.newConnectionSubtype);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), NetworkChangeManager_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class NetworkChangeManagerRequestNotificationsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkChangeManagerClient clientPtr;

        private NetworkChangeManagerRequestNotificationsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkChangeManagerRequestNotificationsParams() {
            this(0);
        }

        public static NetworkChangeManagerRequestNotificationsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkChangeManagerRequestNotificationsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkChangeManagerRequestNotificationsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkChangeManagerRequestNotificationsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkChangeManagerRequestNotificationsParams(elementsOrVersion);
                    {
                        
                    result.clientPtr = decoder0.readServiceInterface(8, false, NetworkChangeManagerClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.clientPtr, 8, false, NetworkChangeManagerClient.MANAGER);
        }
    }



    
    static final class NetworkChangeManagerOnNetworkChangedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean dnsChanged;
        public boolean ipAddressChanged;
        public boolean connectionTypeChanged;
        public int newConnectionType;
        public boolean connectionSubtypeChanged;
        public int newConnectionSubtype;

        private NetworkChangeManagerOnNetworkChangedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkChangeManagerOnNetworkChangedParams() {
            this(0);
        }

        public static NetworkChangeManagerOnNetworkChangedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkChangeManagerOnNetworkChangedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkChangeManagerOnNetworkChangedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkChangeManagerOnNetworkChangedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkChangeManagerOnNetworkChangedParams(elementsOrVersion);
                    {
                        
                    result.dnsChanged = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    result.ipAddressChanged = decoder0.readBoolean(8, 1);
                    }
                    {
                        
                    result.connectionTypeChanged = decoder0.readBoolean(8, 2);
                    }
                    {
                        
                    result.connectionSubtypeChanged = decoder0.readBoolean(8, 3);
                    }
                    {
                        
                    result.newConnectionType = decoder0.readInt(12);
                        ConnectionType.validate(result.newConnectionType);
                    }
                    {
                        
                    result.newConnectionSubtype = decoder0.readInt(16);
                        ConnectionSubtype.validate(result.newConnectionSubtype);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.dnsChanged, 8, 0);
            
            encoder0.encode(this.ipAddressChanged, 8, 1);
            
            encoder0.encode(this.connectionTypeChanged, 8, 2);
            
            encoder0.encode(this.connectionSubtypeChanged, 8, 3);
            
            encoder0.encode(this.newConnectionType, 12);
            
            encoder0.encode(this.newConnectionSubtype, 16);
        }
    }



}
