
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/cors.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class CorsError {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int DISALLOWED_BY_MODE = 0;
    public static final int INVALID_RESPONSE = 1; // DISALLOWED_BY_MODE + 1
    public static final int WILDCARD_ORIGIN_NOT_ALLOWED = 2; // INVALID_RESPONSE + 1
    public static final int MISSING_ALLOW_ORIGIN_HEADER = 3; // WILDCARD_ORIGIN_NOT_ALLOWED + 1
    public static final int MULTIPLE_ALLOW_ORIGIN_VALUES = 4; // MISSING_ALLOW_ORIGIN_HEADER + 1
    public static final int INVALID_ALLOW_ORIGIN_VALUE = 5; // MULTIPLE_ALLOW_ORIGIN_VALUES + 1
    public static final int ALLOW_ORIGIN_MISMATCH = 6; // INVALID_ALLOW_ORIGIN_VALUE + 1
    public static final int INVALID_ALLOW_CREDENTIALS = 7; // ALLOW_ORIGIN_MISMATCH + 1
    public static final int CORS_DISABLED_SCHEME = 8; // INVALID_ALLOW_CREDENTIALS + 1
    public static final int PREFLIGHT_INVALID_STATUS = 9; // CORS_DISABLED_SCHEME + 1
    public static final int PREFLIGHT_DISALLOWED_REDIRECT = 10; // PREFLIGHT_INVALID_STATUS + 1
    public static final int PREFLIGHT_WILDCARD_ORIGIN_NOT_ALLOWED = 11; // PREFLIGHT_DISALLOWED_REDIRECT + 1
    public static final int PREFLIGHT_MISSING_ALLOW_ORIGIN_HEADER = 12; // PREFLIGHT_WILDCARD_ORIGIN_NOT_ALLOWED + 1
    public static final int PREFLIGHT_MULTIPLE_ALLOW_ORIGIN_VALUES = 13; // PREFLIGHT_MISSING_ALLOW_ORIGIN_HEADER + 1
    public static final int PREFLIGHT_INVALID_ALLOW_ORIGIN_VALUE = 14; // PREFLIGHT_MULTIPLE_ALLOW_ORIGIN_VALUES + 1
    public static final int PREFLIGHT_ALLOW_ORIGIN_MISMATCH = 15; // PREFLIGHT_INVALID_ALLOW_ORIGIN_VALUE + 1
    public static final int PREFLIGHT_INVALID_ALLOW_CREDENTIALS = 16; // PREFLIGHT_ALLOW_ORIGIN_MISMATCH + 1
    public static final int PREFLIGHT_MISSING_ALLOW_EXTERNAL = 17; // PREFLIGHT_INVALID_ALLOW_CREDENTIALS + 1
    public static final int PREFLIGHT_INVALID_ALLOW_EXTERNAL = 18; // PREFLIGHT_MISSING_ALLOW_EXTERNAL + 1
    public static final int INVALID_ALLOW_METHODS_PREFLIGHT_RESPONSE = 19; // PREFLIGHT_INVALID_ALLOW_EXTERNAL + 1
    public static final int INVALID_ALLOW_HEADERS_PREFLIGHT_RESPONSE = 20; // INVALID_ALLOW_METHODS_PREFLIGHT_RESPONSE + 1
    public static final int METHOD_DISALLOWED_BY_PREFLIGHT_RESPONSE = 21; // INVALID_ALLOW_HEADERS_PREFLIGHT_RESPONSE + 1
    public static final int HEADER_DISALLOWED_BY_PREFLIGHT_RESPONSE = 22; // METHOD_DISALLOWED_BY_PREFLIGHT_RESPONSE + 1
    public static final int REDIRECT_CONTAINS_CREDENTIALS = 23; // HEADER_DISALLOWED_BY_PREFLIGHT_RESPONSE + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 23;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private CorsError() {}
}