
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/cookie_manager.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class CookieInclusionStatus {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int INCLUDE = 0;
    public static final int EXCLUDE_HTTP_ONLY = 1; // INCLUDE + 1
    public static final int EXCLUDE_SECURE_ONLY = 2; // EXCLUDE_HTTP_ONLY + 1
    public static final int EXCLUDE_DOMAIN_MISMATCH = 3; // EXCLUDE_SECURE_ONLY + 1
    public static final int EXCLUDE_NOT_ON_PATH = 4; // EXCLUDE_DOMAIN_MISMATCH + 1
    public static final int EXCLUDE_SAMESITE_STRICT = 5; // EXCLUDE_NOT_ON_PATH + 1
    public static final int EXCLUDE_SAMESITE_LAX = 6; // EXCLUDE_SAMESITE_STRICT + 1
    public static final int EXCLUDE_USER_PREFERENCES = 7; // EXCLUDE_SAMESITE_LAX + 1
    public static final int EXCLUDE_FAILURE_TO_STORE = 8; // EXCLUDE_USER_PREFERENCES + 1
    public static final int EXCLUDE_NONCOOKIEABLE_SCHEME = 9; // EXCLUDE_FAILURE_TO_STORE + 1
    public static final int EXCLUDE_OVERWRITE_SECURE = 10; // EXCLUDE_NONCOOKIEABLE_SCHEME + 1
    public static final int EXCLUDE_OVERWRITE_HTTP_ONLY = 11; // EXCLUDE_OVERWRITE_SECURE + 1
    public static final int EXCLUDE_INVALID_DOMAIN = 12; // EXCLUDE_OVERWRITE_HTTP_ONLY + 1
    public static final int EXCLUDE_INVALID_PREFIX = 13; // EXCLUDE_INVALID_DOMAIN + 1
    public static final int EXCLUDE_UNKNOWN_ERROR = 14; // EXCLUDE_INVALID_PREFIX + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 14;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private CookieInclusionStatus() {}
}