
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/chunked_data_pipe_getter.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class ChunkedDataPipeGetter_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ChunkedDataPipeGetter, ChunkedDataPipeGetter.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ChunkedDataPipeGetter, ChunkedDataPipeGetter.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.ChunkedDataPipeGetter";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ChunkedDataPipeGetter impl) {
            return new Stub(core, impl);
        }

        @Override
        public ChunkedDataPipeGetter[] buildArray(int size) {
          return new ChunkedDataPipeGetter[size];
        }
    };


    private static final int GET_SIZE_ORDINAL = 0;

    private static final int START_READING_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ChunkedDataPipeGetter.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void getSize(

GetSizeResponse callback) {

            ChunkedDataPipeGetterGetSizeParams _message = new ChunkedDataPipeGetterGetSizeParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_SIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ChunkedDataPipeGetterGetSizeResponseParamsForwardToCallback(callback));

        }


        @Override
        public void startReading(
com.vccorp.mojo.system.DataPipe.ProducerHandle pipe) {

            ChunkedDataPipeGetterStartReadingParams _message = new ChunkedDataPipeGetterStartReadingParams();

            _message.pipe = pipe;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(START_READING_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ChunkedDataPipeGetter> {

        Stub(com.vccorp.mojo.system.Core core, ChunkedDataPipeGetter impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ChunkedDataPipeGetter_Internal.MANAGER, messageWithHeader);







                    case START_READING_ORDINAL: {

                        ChunkedDataPipeGetterStartReadingParams data =
                                ChunkedDataPipeGetterStartReadingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().startReading(data.pipe);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ChunkedDataPipeGetter_Internal.MANAGER, messageWithHeader, receiver);







                    case GET_SIZE_ORDINAL: {

                        ChunkedDataPipeGetterGetSizeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getSize(new ChunkedDataPipeGetterGetSizeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ChunkedDataPipeGetterGetSizeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private ChunkedDataPipeGetterGetSizeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ChunkedDataPipeGetterGetSizeParams() {
            this(0);
        }

        public static ChunkedDataPipeGetterGetSizeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ChunkedDataPipeGetterGetSizeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ChunkedDataPipeGetterGetSizeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ChunkedDataPipeGetterGetSizeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ChunkedDataPipeGetterGetSizeParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class ChunkedDataPipeGetterGetSizeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;
        public long size;

        private ChunkedDataPipeGetterGetSizeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ChunkedDataPipeGetterGetSizeResponseParams() {
            this(0);
        }

        public static ChunkedDataPipeGetterGetSizeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ChunkedDataPipeGetterGetSizeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ChunkedDataPipeGetterGetSizeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ChunkedDataPipeGetterGetSizeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ChunkedDataPipeGetterGetSizeResponseParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                    }
                    {
                        
                    result.size = decoder0.readLong(16);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
            
            encoder0.encode(this.size, 16);
        }
    }

    static class ChunkedDataPipeGetterGetSizeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ChunkedDataPipeGetter.GetSizeResponse mCallback;

        ChunkedDataPipeGetterGetSizeResponseParamsForwardToCallback(ChunkedDataPipeGetter.GetSizeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_SIZE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ChunkedDataPipeGetterGetSizeResponseParams response = ChunkedDataPipeGetterGetSizeResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.status, response.size);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ChunkedDataPipeGetterGetSizeResponseParamsProxyToResponder implements ChunkedDataPipeGetter.GetSizeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ChunkedDataPipeGetterGetSizeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status, Long size) {
            ChunkedDataPipeGetterGetSizeResponseParams _response = new ChunkedDataPipeGetterGetSizeResponseParams();

            _response.status = status;

            _response.size = size;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_SIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class ChunkedDataPipeGetterStartReadingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.system.DataPipe.ProducerHandle pipe;

        private ChunkedDataPipeGetterStartReadingParams(int version) {
            super(STRUCT_SIZE, version);
            this.pipe = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public ChunkedDataPipeGetterStartReadingParams() {
            this(0);
        }

        public static ChunkedDataPipeGetterStartReadingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ChunkedDataPipeGetterStartReadingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ChunkedDataPipeGetterStartReadingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ChunkedDataPipeGetterStartReadingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ChunkedDataPipeGetterStartReadingParams(elementsOrVersion);
                    {
                        
                    result.pipe = decoder0.readProducerHandle(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.pipe, 8, false);
        }
    }



}
