
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     ui/gfx/mojo/ca_layer_params.mojom
//

package com.vccorp.gfx.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class CaLayerContent extends com.vccorp.mojo.bindings.Union {

    public static final class Tag {
        public static final int CaContextId = 0;
        public static final int IoSurfaceMachPort = 1;
    };
    private int mCaContextId;
    private com.vccorp.mojo.system.UntypedHandle mIoSurfaceMachPort;

    public void setCaContextId(int caContextId) {
        this.mTag = Tag.CaContextId;
        this.mCaContextId = caContextId;
    }

    public int getCaContextId() {
        assert this.mTag == Tag.CaContextId;
        return this.mCaContextId;
    }

    public void setIoSurfaceMachPort(com.vccorp.mojo.system.UntypedHandle ioSurfaceMachPort) {
        this.mTag = Tag.IoSurfaceMachPort;
        this.mIoSurfaceMachPort = ioSurfaceMachPort;
    }

    public com.vccorp.mojo.system.UntypedHandle getIoSurfaceMachPort() {
        assert this.mTag == Tag.IoSurfaceMachPort;
        return this.mIoSurfaceMachPort;
    }


    @Override
    public final void encode(org.chromium.mojo.bindings.Encoder encoder0, int offset) {
        encoder0.encode(com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE, offset);
        encoder0.encode(this.mTag, offset + 4);
        switch (mTag) {
            case Tag.CaContextId: {
                
                encoder0.encode(this.mCaContextId, offset + 8);
                break;
            }
            case Tag.IoSurfaceMachPort: {
                
                encoder0.encode(this.mIoSurfaceMachPort, offset + 8, false);
                break;
            }
            default: {
                break;
            }
        }
    }

    public static CaLayerContent deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message).decoderForSerializedUnion(), 0);
    }

    public static final CaLayerContent decode(com.vccorp.mojo.bindings.Decoder decoder0, int offset) {
        com.vccorp.mojo.bindings.DataHeader dataHeader = decoder0.readDataHeaderForUnion(offset);
        if (dataHeader.size == 0) {
            return null;
        }
        CaLayerContent result = new CaLayerContent();
        switch (dataHeader.elementsOrVersion) {
            case Tag.CaContextId: {
                
                result.mCaContextId = decoder0.readInt(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE);
                result.mTag = Tag.CaContextId;
                break;
            }
            case Tag.IoSurfaceMachPort: {
                
                result.mIoSurfaceMachPort = decoder0.readUntypedHandle(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mTag = Tag.IoSurfaceMachPort;
                break;
            }
            default: {
                break;
            }
        }
        return result;
    }
}