
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class PictureInPictureService_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<PictureInPictureService, PictureInPictureService.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<PictureInPictureService, PictureInPictureService.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.PictureInPictureService";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, PictureInPictureService impl) {
            return new Stub(core, impl);
        }

        @Override
        public PictureInPictureService[] buildArray(int size) {
          return new PictureInPictureService[size];
        }
    };


    private static final int START_SESSION_ORDINAL = 0;

    private static final int END_SESSION_ORDINAL = 1;

    private static final int UPDATE_SESSION_ORDINAL = 2;

    private static final int SET_DELEGATE_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements PictureInPictureService.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void startSession(
int playerId, com.vccorp.viz.mojom.SurfaceId surfaceId, com.vccorp.gfx.mojom.Size naturalSize, boolean showPlayPauseButton, boolean showMuteButton,
StartSessionResponse callback) {

            PictureInPictureServiceStartSessionParams _message = new PictureInPictureServiceStartSessionParams();

            _message.playerId = playerId;

            _message.surfaceId = surfaceId;

            _message.naturalSize = naturalSize;

            _message.showPlayPauseButton = showPlayPauseButton;

            _message.showMuteButton = showMuteButton;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    START_SESSION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PictureInPictureServiceStartSessionResponseParamsForwardToCallback(callback));

        }


        @Override
        public void endSession(

EndSessionResponse callback) {

            PictureInPictureServiceEndSessionParams _message = new PictureInPictureServiceEndSessionParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    END_SESSION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PictureInPictureServiceEndSessionResponseParamsForwardToCallback(callback));

        }


        @Override
        public void updateSession(
int playerId, com.vccorp.viz.mojom.SurfaceId surfaceId, com.vccorp.gfx.mojom.Size naturalSize, boolean showPlayPauseButton, boolean showMuteButton) {

            PictureInPictureServiceUpdateSessionParams _message = new PictureInPictureServiceUpdateSessionParams();

            _message.playerId = playerId;

            _message.surfaceId = surfaceId;

            _message.naturalSize = naturalSize;

            _message.showPlayPauseButton = showPlayPauseButton;

            _message.showMuteButton = showMuteButton;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(UPDATE_SESSION_ORDINAL)));

        }


        @Override
        public void setDelegate(
PictureInPictureDelegate delegate) {

            PictureInPictureServiceSetDelegateParams _message = new PictureInPictureServiceSetDelegateParams();

            _message.delegate = delegate;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_DELEGATE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<PictureInPictureService> {

        Stub(com.vccorp.mojo.system.Core core, PictureInPictureService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                PictureInPictureService_Internal.MANAGER, messageWithHeader);









                    case UPDATE_SESSION_ORDINAL: {

                        PictureInPictureServiceUpdateSessionParams data =
                                PictureInPictureServiceUpdateSessionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().updateSession(data.playerId, data.surfaceId, data.naturalSize, data.showPlayPauseButton, data.showMuteButton);
                        return true;
                    }





                    case SET_DELEGATE_ORDINAL: {

                        PictureInPictureServiceSetDelegateParams data =
                                PictureInPictureServiceSetDelegateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setDelegate(data.delegate);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), PictureInPictureService_Internal.MANAGER, messageWithHeader, receiver);







                    case START_SESSION_ORDINAL: {

                        PictureInPictureServiceStartSessionParams data =
                                PictureInPictureServiceStartSessionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().startSession(data.playerId, data.surfaceId, data.naturalSize, data.showPlayPauseButton, data.showMuteButton, new PictureInPictureServiceStartSessionResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case END_SESSION_ORDINAL: {

                        PictureInPictureServiceEndSessionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().endSession(new PictureInPictureServiceEndSessionResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class PictureInPictureServiceStartSessionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int playerId;
        public com.vccorp.viz.mojom.SurfaceId surfaceId;
        public com.vccorp.gfx.mojom.Size naturalSize;
        public boolean showPlayPauseButton;
        public boolean showMuteButton;

        private PictureInPictureServiceStartSessionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PictureInPictureServiceStartSessionParams() {
            this(0);
        }

        public static PictureInPictureServiceStartSessionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PictureInPictureServiceStartSessionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PictureInPictureServiceStartSessionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PictureInPictureServiceStartSessionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PictureInPictureServiceStartSessionParams(elementsOrVersion);
                    {
                        
                    result.playerId = decoder0.readInt(8);
                    }
                    {
                        
                    result.showPlayPauseButton = decoder0.readBoolean(12, 0);
                    }
                    {
                        
                    result.showMuteButton = decoder0.readBoolean(12, 1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.surfaceId = com.vccorp.viz.mojom.SurfaceId.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.naturalSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.playerId, 8);
            
            encoder0.encode(this.showPlayPauseButton, 12, 0);
            
            encoder0.encode(this.showMuteButton, 12, 1);
            
            encoder0.encode(this.surfaceId, 16, true);
            
            encoder0.encode(this.naturalSize, 24, false);
        }
    }



    
    static final class PictureInPictureServiceStartSessionResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.gfx.mojom.Size size;

        private PictureInPictureServiceStartSessionResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PictureInPictureServiceStartSessionResponseParams() {
            this(0);
        }

        public static PictureInPictureServiceStartSessionResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PictureInPictureServiceStartSessionResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PictureInPictureServiceStartSessionResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PictureInPictureServiceStartSessionResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PictureInPictureServiceStartSessionResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.size = com.vccorp.gfx.mojom.Size.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.size, 8, false);
        }
    }

    static class PictureInPictureServiceStartSessionResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final PictureInPictureService.StartSessionResponse mCallback;

        PictureInPictureServiceStartSessionResponseParamsForwardToCallback(PictureInPictureService.StartSessionResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(START_SESSION_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                PictureInPictureServiceStartSessionResponseParams response = PictureInPictureServiceStartSessionResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.size);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PictureInPictureServiceStartSessionResponseParamsProxyToResponder implements PictureInPictureService.StartSessionResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PictureInPictureServiceStartSessionResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.gfx.mojom.Size size) {
            PictureInPictureServiceStartSessionResponseParams _response = new PictureInPictureServiceStartSessionResponseParams();

            _response.size = size;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    START_SESSION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class PictureInPictureServiceEndSessionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private PictureInPictureServiceEndSessionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PictureInPictureServiceEndSessionParams() {
            this(0);
        }

        public static PictureInPictureServiceEndSessionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PictureInPictureServiceEndSessionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PictureInPictureServiceEndSessionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PictureInPictureServiceEndSessionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PictureInPictureServiceEndSessionParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class PictureInPictureServiceEndSessionResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private PictureInPictureServiceEndSessionResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PictureInPictureServiceEndSessionResponseParams() {
            this(0);
        }

        public static PictureInPictureServiceEndSessionResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PictureInPictureServiceEndSessionResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PictureInPictureServiceEndSessionResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PictureInPictureServiceEndSessionResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PictureInPictureServiceEndSessionResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class PictureInPictureServiceEndSessionResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final PictureInPictureService.EndSessionResponse mCallback;

        PictureInPictureServiceEndSessionResponseParamsForwardToCallback(PictureInPictureService.EndSessionResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(END_SESSION_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PictureInPictureServiceEndSessionResponseParamsProxyToResponder implements PictureInPictureService.EndSessionResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PictureInPictureServiceEndSessionResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            PictureInPictureServiceEndSessionResponseParams _response = new PictureInPictureServiceEndSessionResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    END_SESSION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class PictureInPictureServiceUpdateSessionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int playerId;
        public com.vccorp.viz.mojom.SurfaceId surfaceId;
        public com.vccorp.gfx.mojom.Size naturalSize;
        public boolean showPlayPauseButton;
        public boolean showMuteButton;

        private PictureInPictureServiceUpdateSessionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PictureInPictureServiceUpdateSessionParams() {
            this(0);
        }

        public static PictureInPictureServiceUpdateSessionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PictureInPictureServiceUpdateSessionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PictureInPictureServiceUpdateSessionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PictureInPictureServiceUpdateSessionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PictureInPictureServiceUpdateSessionParams(elementsOrVersion);
                    {
                        
                    result.playerId = decoder0.readInt(8);
                    }
                    {
                        
                    result.showPlayPauseButton = decoder0.readBoolean(12, 0);
                    }
                    {
                        
                    result.showMuteButton = decoder0.readBoolean(12, 1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.surfaceId = com.vccorp.viz.mojom.SurfaceId.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.naturalSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.playerId, 8);
            
            encoder0.encode(this.showPlayPauseButton, 12, 0);
            
            encoder0.encode(this.showMuteButton, 12, 1);
            
            encoder0.encode(this.surfaceId, 16, true);
            
            encoder0.encode(this.naturalSize, 24, false);
        }
    }



    
    static final class PictureInPictureServiceSetDelegateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PictureInPictureDelegate delegate;

        private PictureInPictureServiceSetDelegateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PictureInPictureServiceSetDelegateParams() {
            this(0);
        }

        public static PictureInPictureServiceSetDelegateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PictureInPictureServiceSetDelegateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PictureInPictureServiceSetDelegateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PictureInPictureServiceSetDelegateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PictureInPictureServiceSetDelegateParams(elementsOrVersion);
                    {
                        
                    result.delegate = decoder0.readServiceInterface(8, false, PictureInPictureDelegate.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.delegate, 8, false, PictureInPictureDelegate.MANAGER);
        }
    }



}
