
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/devtools/console_message.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class ConsoleMessageSource {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int XML = 0;
    public static final int JAVA_SCRIPT = 1; // XML + 1
    public static final int NETWORK = 2; // JAVA_SCRIPT + 1
    public static final int CONSOLE_API = 3; // NETWORK + 1
    public static final int STORAGE = 4; // CONSOLE_API + 1
    public static final int APP_CACHE = 5; // STORAGE + 1
    public static final int RENDERING = 6; // APP_CACHE + 1
    public static final int SECURITY = 7; // RENDERING + 1
    public static final int OTHER = 8; // SECURITY + 1
    public static final int DEPRECATION = 9; // OTHER + 1
    public static final int WORKER = 10; // DEPRECATION + 1
    public static final int VIOLATION = 11; // WORKER + 1
    public static final int INTERVENTION = 12; // VIOLATION + 1
    public static final int RECOMMENDATION = 13; // INTERVENTION + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 13;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private ConsoleMessageSource() {}
}