
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/messaging/cloneable_message.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class CloneableMessage extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 64;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(64, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.mojo_base.mojom.BigBuffer encodedMessage;
    public SerializedBlob[] blobs;
    public long stackTraceId;
    public long stackTraceDebuggerIdFirst;
    public long stackTraceDebuggerIdSecond;
    public com.vccorp.mojo_base.mojom.UnguessableToken lockedAgentClusterId;

    private CloneableMessage(int version) {
        super(STRUCT_SIZE, version);
    }

    public CloneableMessage() {
        this(0);
    }

    public static CloneableMessage deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static CloneableMessage deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static CloneableMessage decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        CloneableMessage result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new CloneableMessage(elementsOrVersion);
                {
                    
                result.encodedMessage = com.vccorp.mojo_base.mojom.BigBuffer.decode(decoder0, 8);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.blobs = new SerializedBlob[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.blobs[i1] = SerializedBlob.decode(decoder2);
                    }
                }
                }
                {
                    
                result.stackTraceId = decoder0.readLong(32);
                }
                {
                    
                result.stackTraceDebuggerIdFirst = decoder0.readLong(40);
                }
                {
                    
                result.stackTraceDebuggerIdSecond = decoder0.readLong(48);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, true);
                result.lockedAgentClusterId = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.encodedMessage, 8, false);
        
        if (this.blobs == null) {
            encoder0.encodeNullPointer(24, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.blobs.length, 24, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.blobs.length; ++i0) {
                
                encoder1.encode(this.blobs[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.stackTraceId, 32);
        
        encoder0.encode(this.stackTraceDebuggerIdFirst, 40);
        
        encoder0.encode(this.stackTraceDebuggerIdSecond, 48);
        
        encoder0.encode(this.lockedAgentClusterId, 56, true);
    }
}