/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import a.b.a.e;
import android.annotation.TargetApi;
import android.content.ClipData;
import android.os.Build;
import android.view.DragEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="ui")
public class EventForwarder {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final boolean mIsDragDropEnabled;
    public long mNativeEventForwarder;
    public float mCurrentTouchOffsetX;
    public float mCurrentTouchOffsetY;
    public int mLastMouseButtonState;

    public static EventForwarder create(long l2, boolean bl) {
        return new EventForwarder(l2, bl);
    }

    public EventForwarder(long l2, boolean bl) {
        this.mNativeEventForwarder = l2;
        this.mIsDragDropEnabled = bl;
    }

    private void destroy() {
        this.mNativeEventForwarder = 0L;
    }

    private float getEventSourceScaling() {
        EventForwarder eventForwarder = this;
        return eventForwarder.nativeGetJavaWindowAndroid(eventForwarder.mNativeEventForwarder).getDisplay().a();
    }

    private boolean hasTouchEventOffset() {
        return this.mCurrentTouchOffsetX != 0.0f || this.mCurrentTouchOffsetY != 0.0f;
    }

    /*
     * Unable to fully structure code
     */
    private boolean sendTouchEvent(MotionEvent var1_2, boolean var2_3) {
        block63: {
            block62: {
                block61: {
                    block60: {
                        block59: {
                            block58: {
                                block57: {
                                    block56: {
                                        if (!EventForwarder.$assertionsDisabled && this.mNativeEventForwarder == 0L) {
                                            throw new AssertionError();
                                        }
                                        TraceEvent.begin("sendTouchEvent");
                                        if (var1_2.getHistorySize() <= 0) break block56;
                                        v0 = var1_2.getHistoricalEventTime(0);
lbl8:
                                        // 2 sources

                                        while (true) {
                                            var3_4 = v0;
                                            ** GOTO lbl15
                                            break;
                                        }
                                    }
                                    v0 = var1_2.getEventTime();
                                    ** continue;
lbl15:
                                    // 1 sources

                                    var5_5 = e.a(var1_2.getActionMasked());
                                    if (EventForwarder.isValidTouchEventActionForNative(var5_5)) break block57;
                                    TraceEvent.end("sendTouchEvent");
                                    return false;
                                }
                                var6_6 = false;
                                if (!this.hasTouchEventOffset()) break block58;
                                var1_2 = this.createOffsetMotionEventIfNeeded(var1_2);
                                var6_6 = true;
                            }
                            var7_7 = var1_2.getPointerCount();
                            v1 = new float[2];
                            var8_8 = v1;
                            v1[0] = var1_2.getTouchMajor();
                            var9_10 = 1;
                            if (var7_7 <= 1) break block59;
                            var10_13 = var1_2.getTouchMajor(1);
                            break block60;
                        }
                        var10_13 = 0.0f;
                    }
                    v2 = var7_7;
                    var8_8[var9_10] = var10_13;
                    v3 = new float[2];
                    var9_11 = v3;
                    v3[0] = var1_2.getTouchMinor();
                    var10_14 = 1;
                    if (v2 > 1) {
                        var11_17 = var1_2.getTouchMinor(1);
                    } else {
                        var11_17 = 0.0f;
                    }
                    var9_11[var10_14] = var11_17;
                    for (var10_14 = 0; var10_14 < 2; ++var10_14) {
                        if (!(var8_8[var10_14] < var9_11[var10_14])) continue;
                        var8_8[var10_14] = var9_11[var10_14];
                        var9_11[var10_14] = var8_8[var10_14];
                    }
                    if (var7_7 > 1) {
                        var10_15 = var1_2.getX(1);
                    } else {
                        var10_15 = 0.0f;
                    }
                    if (var7_7 > 1) {
                        var11_17 = var1_2.getY(1);
                    } else {
                        var11_17 = 0.0f;
                    }
                    try {
                        v4 = var7_7;
                        v5 = var1_2;
                        v6 = var11_17;
                        var11_17 = this.getEventSourceScaling();
                    }
                    catch (Throwable v7) {
                        TraceEvent.end("sendTouchEvent");
                        throw v7;
                    }
                    v8 = var10_15;
                    v9 = var11_17;
                    v10 = var1_2;
                    v11 = v10;
                    v12 = v10;
                    v13 = v10;
                    v14 = v10;
                    var12_18 = this.mNativeEventForwarder;
                    var10_16 = v11.getHistorySize();
                    var14_19 = v12.getActionIndex();
                    var15_20 = v13.getX() / var11_17;
                    var16_21 = v14.getY() / var11_17;
                    var17_22 = v8 / v9;
                    var18_23 = v6 / var11_17;
                    var19_24 = v5.getPointerId(0);
                    if (v4 > 1) {
                        var20_25 = var1_2.getPointerId(1);
                    } else {
                        var20_25 = -1;
                    }
                    v15 = var7_7;
                    v16 = var1_2;
                    v17 = var9_11;
                    v18 = var9_11;
                    v19 = var8_8;
                    var8_9 = var8_8[0] / var11_17;
                    var9_12 = v19[1] / var11_17;
                    var21_26 = v17[0] / var11_17;
                    var22_27 = v18[1] / var11_17;
                    var23_28 = v16.getOrientation();
                    if (v15 > 1) {
                        var24_29 = var1_2.getOrientation(1);
                    } else {
                        var24_29 = 0.0f;
                    }
                    var25_30 = var1_2.getAxisValue(25);
                    if (var7_7 <= 1) break block61;
                    var26_31 = var1_2.getAxisValue(25, 1);
                    break block62;
                }
                var26_31 = 0.0f;
            }
            v20 = var7_7;
            v21 = var1_2;
            v22 = v21;
            v23 = v21;
            var27_32 = v21.getRawX() / var11_17;
            var11_17 = v23.getRawY() / var11_17;
            var28_33 = v22.getToolType(0);
            if (v20 > 1) {
                var29_34 = var1_2.getToolType(1);
            } else {
                var29_34 = 0;
            }
            var0_1 = this.nativeOnTouchEvent(var12_18, var1_2, var3_4, var5_5, var7_7, var10_16, var14_19, var15_20, var16_21, var17_22, var18_23, var19_24, var20_25, var8_9, var9_12, var21_26, var22_27, var23_28, var24_29, var25_30, var26_31, var27_32, var11_17, var28_33, var29_34, var1_2.getButtonState(), var1_2.getMetaState(), var2_3);
            if (!var6_6) break block63;
            var1_2.recycle();
        }
        TraceEvent.end("sendTouchEvent");
        return var0_1;
    }

    public static boolean isValidTouchEventActionForNative(int n2) {
        return n2 == 0 || n2 == 1 || n2 == 3 || n2 == 2 || n2 == 5 || n2 == 6;
    }

    private boolean sendNativeMouseEvent(MotionEvent motionEvent) {
        if (!$assertionsDisabled && this.mNativeEventForwarder == 0L) {
            throw new AssertionError();
        }
        int n2 = motionEvent.getActionMasked();
        if (n2 != 9 && n2 != 10) {
            if (n2 != 0 && n2 != 1) {
                EventForwarder eventForwarder = this;
                float f2 = eventForwarder.getEventSourceScaling();
                eventForwarder.nativeOnMouseEvent(eventForwarder.mNativeEventForwarder, motionEvent.getEventTime(), n2, motionEvent.getX() / f2, motionEvent.getY() / f2, motionEvent.getPointerId(0), motionEvent.getPressure(0), motionEvent.getOrientation(0), motionEvent.getAxisValue(25, 0), EventForwarder.getMouseEventActionButton(motionEvent), motionEvent.getButtonState(), motionEvent.getMetaState(), motionEvent.getToolType(0));
                return true;
            }
            return true;
        }
        return false;
    }

    private void updateMouseEventState(MotionEvent motionEvent) {
        int n2 = motionEvent.getActionMasked();
        if (n2 == 11 || n2 == 12) {
            this.mLastMouseButtonState = motionEvent.getButtonState();
        }
    }

    @TargetApi(value=23)
    public static int getMouseEventActionButton(MotionEvent motionEvent) {
        if (Build.VERSION.SDK_INT >= 23) {
            return motionEvent.getActionButton();
        }
        return 0;
    }

    private native WindowAndroid nativeGetJavaWindowAndroid(long var1);

    private native boolean nativeOnTouchEvent(long var1, MotionEvent var3, long var4, int var6, int var7, int var8, int var9, float var10, float var11, float var12, float var13, int var14, int var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22, float var23, float var24, float var25, int var26, int var27, int var28, int var29, boolean var30);

    private native void nativeOnMouseEvent(long var1, long var3, int var5, float var6, float var7, int var8, float var9, float var10, float var11, int var12, int var13, int var14, int var15);

    private native void nativeOnDragEvent(long var1, int var3, int var4, int var5, int var6, int var7, String[] var8, String var9);

    private native boolean nativeOnGestureEvent(long var1, int var3, long var4, float var6);

    private native boolean nativeOnGenericMotionEvent(long var1, MotionEvent var3, long var4);

    private native boolean nativeOnKeyUp(long var1, KeyEvent var3, int var4);

    private native boolean nativeDispatchKeyEvent(long var1, KeyEvent var3);

    private native void nativeScrollBy(long var1, float var3, float var4);

    private native void nativeScrollTo(long var1, float var3, float var4);

    private native void nativeDoubleTap(long var1, long var3, int var5, int var6);

    private native void nativeStartFling(long var1, long var3, float var5, float var6, boolean var7, boolean var8);

    private native void nativeCancelFling(long var1, long var3, boolean var5);

    static {
        $assertionsDisabled = EventForwarder.class.desiredAssertionStatus() ^ true;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getToolType(0) == 3) {
            int n2 = Build.VERSION.SDK_INT;
            boolean bl = motionEvent.getButtonState() == 0 && (motionEvent.getActionMasked() == 0 || motionEvent.getActionMasked() == 2 || motionEvent.getActionMasked() == 1);
            if (n2 >= 23 && !bl) {
                return this.onMouseEvent(motionEvent);
            }
        }
        return this.sendTouchEvent(motionEvent, false);
    }

    public boolean onTouchHandleEvent(MotionEvent motionEvent) {
        return this.sendTouchEvent(motionEvent, true);
    }

    public void setCurrentTouchEventOffsets(float f2, float f3) {
        this.mCurrentTouchOffsetX = f2;
        this.mCurrentTouchOffsetY = f3;
    }

    public MotionEvent createOffsetMotionEventIfNeeded(MotionEvent motionEvent) {
        if (!this.hasTouchEventOffset()) {
            return motionEvent;
        }
        MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
        motionEvent2.offsetLocation(this.mCurrentTouchOffsetX, this.mCurrentTouchOffsetY);
        return motionEvent2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onHoverEvent(MotionEvent motionEvent) {
        boolean bl;
        block8: {
            TraceEvent.begin("onHoverEvent");
            boolean bl2 = false;
            try {
                if (this.hasTouchEventOffset()) {
                    motionEvent = this.createOffsetMotionEventIfNeeded(motionEvent);
                    bl2 = true;
                }
                if (motionEvent.getActionMasked() == 9) {
                    if (this.mLastMouseButtonState == 1) {
                        EventForwarder eventForwarder = this;
                        float f2 = eventForwarder.getEventSourceScaling();
                        eventForwarder.nativeOnMouseEvent(eventForwarder.mNativeEventForwarder, motionEvent.getEventTime(), 12, motionEvent.getX() / f2, motionEvent.getY() / f2, motionEvent.getPointerId(0), motionEvent.getPressure(0), motionEvent.getOrientation(0), motionEvent.getAxisValue(25, 0), 1, motionEvent.getButtonState(), motionEvent.getMetaState(), motionEvent.getToolType(0));
                    }
                    this.mLastMouseButtonState = 0;
                }
                bl = this.sendNativeMouseEvent(motionEvent);
                if (!bl2) break block8;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    motionEvent.recycle();
                }
                TraceEvent.end("onHoverEvent");
                throw throwable;
            }
            motionEvent.recycle();
        }
        TraceEvent.end("onHoverEvent");
        return bl;
    }

    public boolean onMouseEvent(MotionEvent motionEvent) {
        boolean bl;
        block6: {
            boolean bl2;
            block5: {
                TraceEvent.begin("sendMouseEvent");
                bl2 = false;
                try {
                    if (!this.hasTouchEventOffset()) break block5;
                }
                catch (Throwable throwable) {
                    if (bl2) {
                        motionEvent.recycle();
                    }
                    TraceEvent.end("sendMouseEvent");
                    throw throwable;
                }
                motionEvent = this.createOffsetMotionEventIfNeeded(motionEvent);
                bl2 = true;
            }
            this.updateMouseEventState(motionEvent);
            bl = this.sendNativeMouseEvent(motionEvent);
            if (!bl2) break block6;
            motionEvent.recycle();
        }
        TraceEvent.end("sendMouseEvent");
        return bl;
    }

    @TargetApi(value=24)
    public boolean onDragEvent(DragEvent dragEvent, View object) {
        if (this.mNativeEventForwarder != 0L && Build.VERSION.SDK_INT > 23) {
            int n2;
            StringBuilder stringBuilder;
            String[] stringArray = dragEvent.getClipDescription();
            stringArray = stringArray == null ? new String[]{} : stringArray.filterMimeTypes("text/*");
            if (dragEvent.getAction() == 1) {
                return stringArray != null && stringArray.length > 0 && this.mIsDragDropEnabled;
            }
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder("");
            if (dragEvent.getAction() == 3) {
                ClipData clipData = dragEvent.getClipData();
                n2 = clipData.getItemCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringBuilder2.append(clipData.getItemAt(i2).coerceToStyledText(object.getContext()));
                }
            }
            EventForwarder eventForwarder = this;
            DragEvent dragEvent2 = dragEvent;
            View view = object;
            int[] nArray = new int[2];
            object = nArray;
            view.getLocationOnScreen(nArray);
            int n3 = (int)(dragEvent2.getX() + this.mCurrentTouchOffsetX);
            int n4 = (int)(dragEvent2.getY() + this.mCurrentTouchOffsetY);
            int n5 = n3 + object[0];
            n2 = n4 + object[1];
            float f2 = eventForwarder.getEventSourceScaling();
            eventForwarder.nativeOnDragEvent(eventForwarder.mNativeEventForwarder, dragEvent.getAction(), (int)((float)n3 / f2), (int)((float)n4 / f2), (int)((float)n5 / f2), (int)((float)n2 / f2), stringArray, stringBuilder2.toString());
            return true;
        }
        return false;
    }

    public boolean onGestureEvent(int n2, long l2, float f2) {
        long l3 = this.mNativeEventForwarder;
        if (l3 == 0L) {
            return false;
        }
        return this.nativeOnGestureEvent(l3, n2, l2, f2);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if (this.mNativeEventForwarder == 0L) {
            return false;
        }
        if ((motionEvent.getSource() & 2) != 0 && motionEvent.getToolType(0) == 3) {
            this.updateMouseEventState(motionEvent);
        }
        EventForwarder eventForwarder = this;
        MotionEvent motionEvent2 = motionEvent;
        return eventForwarder.nativeOnGenericMotionEvent(eventForwarder.mNativeEventForwarder, motionEvent2, motionEvent2.getEventTime());
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        long l2 = this.mNativeEventForwarder;
        if (l2 == 0L) {
            return false;
        }
        return this.nativeOnKeyUp(l2, keyEvent, n2);
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        long l2 = this.mNativeEventForwarder;
        if (l2 == 0L) {
            return false;
        }
        return this.nativeDispatchKeyEvent(l2, keyEvent);
    }

    public void scrollBy(float f2, float f3) {
        long l2 = this.mNativeEventForwarder;
        if (l2 == 0L) {
            return;
        }
        this.nativeScrollBy(l2, f2, f3);
    }

    public void scrollTo(float f2, float f3) {
        long l2 = this.mNativeEventForwarder;
        if (l2 == 0L) {
            return;
        }
        this.nativeScrollTo(l2, f2, f3);
    }

    public void doubleTapForTest(long l2, int n2, int n3) {
        long l3 = this.mNativeEventForwarder;
        if (l3 == 0L) {
            return;
        }
        this.nativeDoubleTap(l3, l2, n2, n3);
    }

    public void startFling(long l2, float f2, float f3, boolean bl, boolean bl2) {
        long l3 = this.mNativeEventForwarder;
        if (l3 == 0L) {
            return;
        }
        this.nativeStartFling(l3, l2, f2, f3, bl, bl2);
    }

    public void cancelFling(long l2) {
        long l3 = this.mNativeEventForwarder;
        if (l3 == 0L) {
            return;
        }
        this.nativeCancelFling(l3, l2, true);
    }
}

