/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.services.media_session;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="media_session")
public final class MediaImage {
    @NonNull
    public String mSrc;
    public String mType;
    @NonNull
    public List<Rect> mSizes = new ArrayList<Rect>();

    public MediaImage(@NonNull String string2, @NonNull String string3, @NonNull List<Rect> list) {
        this.mSrc = string2;
        this.mType = string3;
        this.mSizes = list;
    }

    public static MediaImage create(String string2, String string3, Rect[] rectArray) {
        return new MediaImage(string2, string3, Arrays.asList(rectArray));
    }

    public static Rect createRect(int n2, int n3) {
        return new Rect(0, 0, n2, n3);
    }

    @NonNull
    public String getSrc() {
        return this.mSrc;
    }

    public String getType() {
        return this.mType;
    }

    public List<Rect> getSizes() {
        return this.mSizes;
    }

    public void setSrc(@NonNull String string2) {
        this.mSrc = string2;
    }

    public void setType(@NonNull String string2) {
        this.mType = string2;
    }

    public void setSizes(@NonNull List<Rect> list) {
        this.mSizes = list;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MediaImage)) {
            return false;
        }
        object = (MediaImage)object;
        return TextUtils.equals((CharSequence)this.mSrc, (CharSequence)((MediaImage)object).mSrc) && TextUtils.equals((CharSequence)this.mType, (CharSequence)((MediaImage)object).mType) && this.mSizes.equals(((MediaImage)object).mSizes);
    }

    public int hashCode() {
        MediaImage mediaImage = this;
        int n2 = mediaImage.mSrc.hashCode() * 31;
        n2 = (mediaImage.mType.hashCode() + n2) * 31;
        return mediaImage.mSizes.hashCode() + n2;
    }
}

