/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.http.X509TrustManagerExtensions;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.net.AndroidCertVerifyResult;

@JNINamespace(value="net")
@MainDex
public class X509Util {
    public static final String TAG = "X509Util";
    public static CertificateFactory sCertificateFactory;
    public static final String OID_TLS_SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    public static final String OID_ANY_EKU = "2.5.29.37.0";
    public static final String OID_SERVER_GATED_NETSCAPE = "2.16.840.1.113730.4.1";
    public static final String OID_SERVER_GATED_MICROSOFT = "1.3.6.1.4.1.311.10.3.3";
    public static X509TrustManagerImplementation sDefaultTrustManager;
    public static TrustStorageListener sTrustStorageListener;
    public static X509TrustManagerImplementation sTestTrustManager;
    public static KeyStore sTestKeyStore;
    public static KeyStore sSystemKeyStore;
    public static File sSystemCertificateDirectory;
    public static Set<Pair<X500Principal, PublicKey>> sSystemTrustAnchorCache;
    public static boolean sLoadedSystemKeyStore;
    public static final Object sLock;
    public static boolean sDisableNativeCodeForTest;
    public static final char[] HEX_DIGITS;
    public static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureInitialized() {
        Object object = sLock;
        synchronized (object) {
            X509Util.ensureInitializedLocked();
            return;
        }
    }

    public static void ensureInitializedLocked() {
        String string2;
        if (!$assertionsDisabled && !Thread.holdsLock(sLock)) {
            throw new AssertionError();
        }
        if (sCertificateFactory == null) {
            sCertificateFactory = CertificateFactory.getInstance("X.509");
        }
        if (sDefaultTrustManager == null) {
            sDefaultTrustManager = X509Util.createTrustManager(null);
        }
        if (!sLoadedSystemKeyStore) {
            try {
                sSystemKeyStore = KeyStore.getInstance("AndroidCAStore");
                try {
                    sSystemKeyStore.load(null);
                }
                catch (IOException iOException) {}
            }
            catch (KeyStoreException keyStoreException) {}
            sSystemCertificateDirectory = new File(System.getenv("ANDROID_ROOT") + "/etc/security/cacerts");
            if (!sDisableNativeCodeForTest && Build.VERSION.SDK_INT >= 17) {
                string2 = "Net.FoundSystemTrustRootsAndroid";
                boolean bl = sSystemKeyStore != null;
                RecordHistogram.recordBooleanHistogram(string2, bl);
            }
            sLoadedSystemKeyStore = true;
        }
        if (sSystemTrustAnchorCache == null) {
            sSystemTrustAnchorCache = new HashSet<Pair<X500Principal, PublicKey>>();
        }
        if (sTestKeyStore == null) {
            sTestKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try {
                sTestKeyStore.load(null);
            }
            catch (IOException iOException) {}
        }
        if (sTestTrustManager == null) {
            sTestTrustManager = X509Util.createTrustManager(sTestKeyStore);
        }
        if (sTrustStorageListener == null) {
            IntentFilter intentFilter;
            sTrustStorageListener = new TrustStorageListener(null);
            string2 = intentFilter;
            intentFilter = new IntentFilter();
            if (Build.VERSION.SDK_INT >= 26) {
                String string3 = string2;
                string3.addAction("android.security.action.KEYCHAIN_CHANGED");
                string3.addAction("android.security.action.KEY_ACCESS_CHANGED");
                string3.addAction("android.security.action.TRUST_STORE_CHANGED");
            } else {
                string2.addAction("android.security.STORAGE_CHANGED");
            }
            ContextUtils.getApplicationContext().registerReceiver((BroadcastReceiver)sTrustStorageListener, (IntentFilter)string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static X509TrustManagerImplementation createTrustManager(KeyStore trustManagerArray) {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)trustManagerArray);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            if (Build.VERSION.SDK_INT < 17) return new X509TrustManagerIceCreamSandwich((X509TrustManager)trustManager);
            try {
                return new X509TrustManagerJellyBean((X509TrustManager)trustManager);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)TAG, (String)("Error creating trust manager (" + trustManager.getClass().getName() + "): " + illegalArgumentException));
            }
        }
        Log.e((String)TAG, (String)"Could not find suitable trust manager");
        return null;
    }

    public static void reloadTestTrustManager() {
        if (!$assertionsDisabled && !Thread.holdsLock(sLock)) {
            throw new AssertionError();
        }
        sTestTrustManager = X509Util.createTrustManager(sTestKeyStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void reloadDefaultTrustManager() {
        Object object = sLock;
        synchronized (object) {
            sDefaultTrustManager = null;
            sSystemTrustAnchorCache = null;
            X509Util.ensureInitializedLocked();
        }
        X509Util.nativeNotifyKeyChainChanged();
    }

    public static X509Certificate createCertificateFromBytes(byte[] byArray) {
        X509Util.ensureInitialized();
        return (X509Certificate)sCertificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTestRootCertificate(byte[] object) {
        X509Util.ensureInitialized();
        object = X509Util.createCertificateFromBytes(object);
        Object object2 = sLock;
        synchronized (object2) {
            sTestKeyStore.setCertificateEntry("root_cert_" + Integer.toString(sTestKeyStore.size()), (Certificate)object);
            X509Util.reloadTestTrustManager();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void clearTestRootCertificates() {
        X509Util.ensureInitialized();
        Object object = sLock;
        synchronized (object) {
            Throwable throwable2;
            try {
                try {
                    sTestKeyStore.load(null);
                    X509Util.reloadTestTrustManager();
                }
                catch (Throwable throwable2) {
                }
            }
            catch (IOException iOException) {}
            return;
            throw throwable2;
        }
    }

    public static String hashPrincipal(X500Principal object) {
        object = MessageDigest.getInstance("MD5").digest(((X500Principal)object).getEncoded());
        char[] cArray = new char[8];
        for (int i2 = 0; i2 < 4; ++i2) {
            int n2 = i2 * 2;
            char[] cArray2 = HEX_DIGITS;
            int n3 = 3 - i2;
            cArray[n2] = HEX_DIGITS[object[n3] >> 4 & 0xF];
            cArray[n2 + 1] = cArray2[object[n3] & 0xF];
        }
        return new String(cArray);
    }

    public static boolean isKnownRoot(X509Certificate x509Certificate) {
        Pair pair;
        if (!$assertionsDisabled && !Thread.holdsLock(sLock)) {
            throw new AssertionError();
        }
        if (sSystemKeyStore == null) {
            return false;
        }
        Pair pair2 = pair;
        pair = new Pair((Object)x509Certificate.getSubjectX500Principal(), (Object)x509Certificate.getPublicKey());
        if (sSystemTrustAnchorCache.contains(pair2)) {
            return true;
        }
        String string2 = X509Util.hashPrincipal(x509Certificate.getSubjectX500Principal());
        int n2 = 0;
        Object object;
        while (new File(sSystemCertificateDirectory, (String)(object = string2 + '.' + n2)).exists()) {
            Certificate certificate = sSystemKeyStore.getCertificate("system:" + (String)object);
            if (certificate != null) {
                if (!(certificate instanceof X509Certificate)) {
                    Log.e((String)TAG, (String)("Anchor " + (String)object + " not an X509Certificate: " + certificate.getClass().getName()));
                } else {
                    object = (X509Certificate)certificate;
                    if (x509Certificate.getSubjectX500Principal().equals(((X509Certificate)object).getSubjectX500Principal()) && x509Certificate.getPublicKey().equals(((Certificate)object).getPublicKey())) {
                        sSystemTrustAnchorCache.add((Pair<X500Principal, PublicKey>)pair2);
                        return true;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean verifyKeyUsage(X509Certificate iterator) {
        block3: {
            try {
                iterator = ((X509Certificate)((Object)iterator)).getExtendedKeyUsage();
                if (iterator != null) break block3;
                return true;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals(OID_TLS_SERVER_AUTH) && !string2.equals(OID_ANY_EKU) && !string2.equals(OID_SERVER_GATED_NETSCAPE) && !string2.equals(OID_SERVER_GATED_MICROSOFT)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static AndroidCertVerifyResult verifyServerCertificates(byte[][] var0, String var1_2, String var2_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 18[TRYBLOCK] [24 : 297->300)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void setDisableNativeCodeForTest(boolean bl) {
        sDisableNativeCodeForTest = bl;
    }

    public static native void nativeNotifyKeyChainChanged();

    static {
        $assertionsDisabled = X509Util.class.desiredAssertionStatus() ^ true;
        sLock = new Object();
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public static final class X509TrustManagerJellyBean
    implements X509TrustManagerImplementation {
        public final X509TrustManagerExtensions mTrustManagerExtensions;

        @SuppressLint(value={"NewApi"})
        public X509TrustManagerJellyBean(X509TrustManager x509TrustManager) {
            this.mTrustManagerExtensions = new X509TrustManagerExtensions(x509TrustManager);
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public List<X509Certificate> checkServerTrusted(X509Certificate[] x509CertificateArray, String string2, String string3) {
            return this.mTrustManagerExtensions.checkServerTrusted(x509CertificateArray, string2, string3);
        }
    }

    public static final class X509TrustManagerIceCreamSandwich
    implements X509TrustManagerImplementation {
        public final X509TrustManager mTrustManager;

        public X509TrustManagerIceCreamSandwich(X509TrustManager x509TrustManager) {
            this.mTrustManager = x509TrustManager;
        }

        @Override
        public List<X509Certificate> checkServerTrusted(X509Certificate[] x509CertificateArray, String string2, String string3) {
            this.mTrustManager.checkServerTrusted(x509CertificateArray, string2);
            return Collections.emptyList();
        }
    }

    public static interface X509TrustManagerImplementation {
        public List<X509Certificate> checkServerTrusted(X509Certificate[] var1, String var2, String var3);
    }

    public static final class TrustStorageListener
    extends BroadcastReceiver {
        public TrustStorageListener() {
        }

        public /* synthetic */ TrustStorageListener(1 var1_1) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        public void onReceive(Context context, Intent intent) {
            block8: {
                boolean bl = false;
                if (Build.VERSION.SDK_INT >= 26) {
                    if ("android.security.action.KEYCHAIN_CHANGED".equals(intent.getAction()) || "android.security.action.TRUST_STORE_CHANGED".equals(intent.getAction()) || "android.security.action.KEY_ACCESS_CHANGED".equals(intent.getAction()) && !intent.getBooleanExtra("android.security.extra.KEY_ACCESSIBLE", false)) {
                        bl = true;
                    }
                } else {
                    bl = "android.security.STORAGE_CHANGED".equals(intent.getAction());
                }
                if (bl) {
                    void var0_5;
                    try {
                        X509Util.reloadDefaultTrustManager();
                        break block8;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    }
                    catch (KeyStoreException keyStoreException) {
                    }
                    catch (CertificateException certificateException) {
                        // empty catch block
                    }
                    Log.e((String)X509Util.TAG, (String)"Unable to reload the default TrustManager", (Throwable)var0_5);
                }
            }
        }
    }
}

