/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.view.WindowManager;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.media.PhotoCapabilities;
import org.chromium.media.VideoCaptureFormat;

@JNINamespace(value="media")
public abstract class VideoCapture {
    public int mCameraNativeOrientation;
    public boolean mInvertDeviceOrientationReadings;
    public VideoCaptureFormat mCaptureFormat;
    public final int mId;
    public final long mNativeVideoCaptureDeviceAndroid;
    public boolean mUseBackgroundThreadForTesting;

    public VideoCapture(int n2, long l2) {
        this.mId = n2;
        this.mNativeVideoCaptureDeviceAndroid = l2;
    }

    public static FramerateRange getClosestFramerateRange(List<FramerateRange> list, final int n2) {
        return Collections.min(list, new Comparator<FramerateRange>(){
            public static final int MAX_FPS_DIFF_THRESHOLD = 5000;
            public static final int MAX_FPS_LOW_DIFF_WEIGHT = 1;
            public static final int MAX_FPS_HIGH_DIFF_WEIGHT = 3;
            public static final int MIN_FPS_THRESHOLD = 8000;
            public static final int MIN_FPS_LOW_VALUE_WEIGHT = 1;
            public static final int MIN_FPS_HIGH_VALUE_WEIGHT = 4;

            private int progressivePenalty(int n22, int n3, int n4, int n5) {
                int n6;
                if (n22 < n3) {
                    n6 = n22 * n4;
                } else {
                    int n7 = n3;
                    int n8 = n7 * n4;
                    n6 = (n22 - n7) * n5 + n8;
                }
                return n6;
            }

            public int diff(FramerateRange framerateRange) {
                1 v0 = this;
                return this.progressivePenalty(framerateRange.min, 8000, 1, 4) + v0.progressivePenalty(Math.abs(v0.n2 - framerateRange.max), 5000, 1, 3);
            }

            @Override
            public int compare(FramerateRange framerateRange, FramerateRange framerateRange2) {
                return this.diff(framerateRange) - this.diff(framerateRange2);
            }
        });
    }

    public static int[] integerArrayListToArray(ArrayList<Integer> arrayList) {
        int[] nArray = new int[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            nArray[i2] = arrayList.get(i2);
        }
        return nArray;
    }

    public abstract boolean allocate(int var1, int var2, int var3, boolean var4);

    public abstract boolean startCaptureMaybeAsync();

    public abstract boolean stopCaptureAndBlockUntilStopped();

    public abstract void getPhotoCapabilitiesAsync(long var1);

    public abstract void setPhotoOptions(double var1, int var3, double var4, int var6, double var7, double var9, double[] var11, boolean var12, double var13, double var15, int var17, double var18, boolean var20, boolean var21, int var22, boolean var23, boolean var24, double var25);

    public abstract void takePhotoAsync(long var1);

    public abstract void deallocate();

    public final int queryWidth() {
        return this.mCaptureFormat.mWidth;
    }

    public final int queryHeight() {
        return this.mCaptureFormat.mHeight;
    }

    public final int queryFrameRate() {
        return this.mCaptureFormat.mFramerate;
    }

    public final int getColorspace() {
        int n2 = this.mCaptureFormat.mPixelFormat;
        if (n2 != 17) {
            if (n2 != 35) {
                if (n2 != 842094169) {
                    return 0;
                }
                return 842094169;
            }
            return 35;
        }
        return 17;
    }

    public final void setTestMode() {
        this.mUseBackgroundThreadForTesting = true;
    }

    public final int getCameraRotation() {
        int n2 = this.mInvertDeviceOrientationReadings ? 360 - this.getDeviceRotation() : this.getDeviceRotation();
        return (this.mCameraNativeOrientation + n2) % 360;
    }

    public final int getDeviceRotation() {
        int n2 = ((WindowManager)ContextUtils.getApplicationContext().getSystemService("window")).getDefaultDisplay().getRotation();
        return n2 != 1 ? (n2 != 2 ? (n2 != 3 ? 0 : 270) : 180) : 90;
    }

    public void notifyTakePhotoError(long l2) {
        VideoCapture videoCapture = this;
        videoCapture.nativeOnPhotoTaken(videoCapture.mNativeVideoCaptureDeviceAndroid, l2, null);
    }

    public native void nativeOnFrameAvailable(long var1, byte[] var3, int var4, int var5);

    public native void nativeOnI420FrameAvailable(long var1, ByteBuffer var3, int var4, ByteBuffer var5, ByteBuffer var6, int var7, int var8, int var9, int var10, int var11, long var12);

    public native void nativeOnError(long var1, int var3, String var4);

    public native void nativeOnFrameDropped(long var1, int var3);

    public native void nativeOnGetPhotoCapabilitiesReply(long var1, long var3, PhotoCapabilities var5);

    public native void nativeOnPhotoTaken(long var1, long var3, byte[] var5);

    public native void nativeOnStarted(long var1);

    public native void nativeDCheckCurrentlyOnIncomingTaskRunner(long var1);

    public static class FramerateRange {
        public int min;
        public int max;

        public FramerateRange(int n2, int n3) {
            this.min = n2;
            this.max = n3;
        }
    }
}

