/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.a.a.a.a;
import a.b.a.g;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.media.MediaCodecUtil;

@JNINamespace(value="media")
public class MediaCodecBridge {
    public static final String TAG = "cr_MediaCodecBridge";
    public static final long MAX_PRESENTATION_TIMESTAMP_SHIFT_US = 100000L;
    public static final int PCM16_BYTES_PER_SAMPLE = 2;
    public static final int MEDIA_CODEC_UNKNOWN_CIPHER_MODE = -1;
    public static final String KEY_CROP_LEFT = "crop-left";
    public static final String KEY_CROP_RIGHT = "crop-right";
    public static final String KEY_CROP_BOTTOM = "crop-bottom";
    public static final String KEY_CROP_TOP = "crop-top";
    public static HandlerThread sCallbackHandlerThread;
    public static Handler sCallbackHandler;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public MediaCodec mMediaCodec;
    public ByteBuffer[] mInputBuffers;
    public ByteBuffer[] mOutputBuffers;
    public boolean mFlushed;
    public long mLastPresentationTimeUs;
    public int mBitrateAdjuster;
    public boolean mUseAsyncApi;
    public Queue<GetOutputFormatResult> mPendingFormat;
    public GetOutputFormatResult mCurrentFormat;
    public boolean mPendingError;
    public boolean mPendingStart;
    public long mNativeMediaCodecBridge;
    public int mSequenceCounter;
    public Queue<DequeueInputResult> mPendingInputBuffers;
    public Queue<DequeueOutputResult> mPendingOutputBuffers;

    public MediaCodecBridge(MediaCodec mediaCodec, int n2, boolean bl) {
        if (!$assertionsDisabled && mediaCodec == null) {
            throw new AssertionError();
        }
        MediaCodecBridge mediaCodecBridge = this;
        mediaCodecBridge.mMediaCodec = mediaCodec;
        mediaCodecBridge.mLastPresentationTimeUs = 0L;
        mediaCodecBridge.mFlushed = true;
        this.mBitrateAdjuster = n2;
        this.mUseAsyncApi = bl;
        if (!this.mUseAsyncApi) {
            return;
        }
        MediaCodecBridge mediaCodecBridge2 = this;
        mediaCodecBridge2.enableAsyncApi();
        mediaCodecBridge2.prepareAsyncApiForRestart();
    }

    @TargetApi(value=23)
    private void enableAsyncApi() {
        this.mPendingError = false;
        this.mPendingFormat = new LinkedList<GetOutputFormatResult>();
        this.mPendingInputBuffers = new LinkedList<DequeueInputResult>();
        this.mPendingOutputBuffers = new LinkedList<DequeueOutputResult>();
        MediaCodecBridge mediaCodecBridge = this;
        this.mMediaCodec.setCallback((MediaCodec.Callback)mediaCodecBridge.new MediaCodecCallback(mediaCodecBridge), sCallbackHandler);
    }

    private synchronized void prepareAsyncApiForRestart() {
        MediaCodecBridge mediaCodecBridge = this;
        mediaCodecBridge.mPendingFormat.clear();
        mediaCodecBridge.mPendingInputBuffers.clear();
        mediaCodecBridge.mPendingOutputBuffers.clear();
        mediaCodecBridge.mPendingStart = true;
        mediaCodecBridge.mCurrentFormat = null;
        ++mediaCodecBridge.mSequenceCounter;
    }

    private synchronized void setBuffersAvailableListener(long l2) {
        this.mNativeMediaCodecBridge = l2;
        if (!this.mPendingInputBuffers.isEmpty() || !this.mPendingOutputBuffers.isEmpty() || this.mPendingError) {
            this.notifyBuffersAvailable();
        }
    }

    private synchronized void notifyBuffersAvailable() {
        long l2 = this.mNativeMediaCodecBridge;
        if (l2 != 0L) {
            this.nativeOnBuffersAvailable(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DequeueInputResult dequeueInputBuffer(long l2) {
        int n2;
        if (this.mUseAsyncApi) {
            MediaCodecBridge mediaCodecBridge = this;
            synchronized (mediaCodecBridge) {
                if (mediaCodecBridge.mPendingError) {
                    // ** MonitorExit[this] (shouldn't be in output)
                    return new DequeueInputResult(5, -1, null);
                }
                if (!this.mPendingStart) {
                    if (!this.mPendingInputBuffers.isEmpty()) return this.mPendingInputBuffers.remove();
                }
                // ** MonitorExit[this] (shouldn't be in output)
                return new DequeueInputResult(1, -1, null);
            }
        }
        int n3 = 5;
        int n4 = -1;
        try {
            n2 = this.mMediaCodec.dequeueInputBuffer(l2);
            if (n2 >= 0) {
                n3 = 0;
                return new DequeueInputResult(n3, n2, null);
            }
            if (n2 == -1) {
                n3 = 1;
                n2 = n4;
                return new DequeueInputResult(n3, n2, null);
            }
            g.b(TAG, "Unexpected index_or_status: " + n2, new Object[0]);
            if (!$assertionsDisabled) throw new AssertionError();
            n2 = n4;
            return new DequeueInputResult(n3, n2, null);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = exception;
            g.b(TAG, "Failed to dequeue input buffer", objectArray2);
            n2 = n4;
        }
        return new DequeueInputResult(n3, n2, null);
    }

    private int flush() {
        block3: {
            try {
                MediaCodecBridge mediaCodecBridge = this;
                mediaCodecBridge.mFlushed = true;
                mediaCodecBridge.mMediaCodec.flush();
                if (!mediaCodecBridge.mUseAsyncApi) break block3;
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = exception;
                g.b(TAG, "Failed to flush MediaCodec", objectArray2);
                return 5;
            }
            MediaCodecBridge mediaCodecBridge = this;
            mediaCodecBridge.prepareAsyncApiForRestart();
            if (mediaCodecBridge.start()) break block3;
            return 5;
        }
        return 0;
    }

    private void stop() {
        block3: {
            MediaCodecBridge mediaCodecBridge = this;
            mediaCodecBridge.mMediaCodec.stop();
            if (!mediaCodecBridge.mUseAsyncApi) break block3;
            try {
                this.prepareAsyncApiForRestart();
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = illegalStateException;
                g.b(TAG, "Failed to stop MediaCodec", objectArray2);
            }
        }
    }

    @TargetApi(value=19)
    private String getName() {
        MediaCodecBridge mediaCodecBridge = object;
        Object object = "unknown";
        try {
            object = mediaCodecBridge.mMediaCodec.getName();
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            g.b(TAG, "Cannot get codec name", objectArray2);
        }
        return object;
    }

    private GetOutputFormatResult getOutputFormat() {
        GetOutputFormatResult getOutputFormatResult;
        if (mediaCodecBridge2.mUseAsyncApi && (getOutputFormatResult = mediaCodecBridge2.mCurrentFormat) != null) {
            return getOutputFormatResult;
        }
        MediaCodecBridge mediaCodecBridge = mediaCodecBridge2;
        MediaCodecBridge mediaCodecBridge2 = null;
        int n2 = 0;
        try {
            mediaCodecBridge2 = mediaCodecBridge.mMediaCodec.getOutputFormat();
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            g.b(TAG, "Failed to get output format", objectArray2);
            n2 = 5;
        }
        return new GetOutputFormatResult(n2, (MediaFormat)mediaCodecBridge2, null);
    }

    @SuppressLint(value={"NewApi"})
    private ByteBuffer getInputBuffer(int n2) {
        if (Build.VERSION.SDK_INT > 19) {
            try {
                return this.mMediaCodec.getInputBuffer(n2);
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = illegalStateException;
                g.b(TAG, "Failed to get input buffer", objectArray2);
                return null;
            }
        }
        return this.mInputBuffers[n2];
    }

    private int queueInputBuffer(int n2, int n3, int n4, long l2, int n5) {
        MediaCodecBridge mediaCodecBridge = this;
        mediaCodecBridge.resetLastPresentationTimeIfNeeded(l2);
        try {
            mediaCodecBridge.mMediaCodec.queueInputBuffer(n2, n3, n4, l2, n5);
            return 0;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = exception;
            g.b(TAG, "Failed to queue input buffer", objectArray2);
            return 5;
        }
    }

    /*
     * Unable to fully structure code
     */
    @TargetApi(value=19)
    private void setVideoBitrate(int var1_2, int var2_4) {
        var3_6 = this.mBitrateAdjuster;
        if (var3_6 == 0) ** GOTO lbl-1000
        if (var3_6 != 1) {
            var3_6 = 0;
        } else if (var2_4 == 0) lbl-1000:
        // 2 sources

        {
            var3_6 = var1_2;
        } else {
            var3_6 = var1_2 * 30 / var2_4;
        }
        v0 = this;
        this = v1;
        new Bundle().putInt("video-bitrate", var3_6);
        try {
            v0.mMediaCodec.setParameters((Bundle)this);
        }
        catch (IllegalStateException var0_1) {
            v2 = new Object[1];
            var4_7 = v2;
            v2[0] = var0_1;
            g.b("cr_MediaCodecBridge", "Failed to set MediaCodec parameters", var4_7);
        }
        this = "cr_MediaCodecBridge";
        var1_3 = "setVideoBitrate: input " + var1_2 + "bps@" + var2_4 + ", targetBps " + var3_6;
        v3 = new Object[]{};
        var1_3 = g.b(var1_3, v3);
        var2_5 = g.a(v3);
        if (var2_5 != null) {
            Log.v((String)g.a((String)this), (String)var1_3, (Throwable)var2_5);
        } else {
            Log.v((String)g.a((String)this), (String)var1_3);
        }
    }

    @TargetApi(value=19)
    private void requestKeyFrameSoon() {
        Bundle bundle;
        MediaCodecBridge mediaCodecBridge = mediaCodecBridge2;
        MediaCodecBridge mediaCodecBridge2 = bundle;
        new Bundle().putInt("request-sync", 0);
        try {
            mediaCodecBridge.mMediaCodec.setParameters((Bundle)mediaCodecBridge2);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            g.b(TAG, "Failed to set MediaCodec parameters", objectArray2);
        }
    }

    private int translateCipherModeValue(int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    Object[] objectArray = new Object[]{};
                    g.b(TAG, "Unsupported cipher mode: " + n2, objectArray);
                    return -1;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @SuppressLint(value={"WrongConstant"})
    private int queueSecureInputBuffer(int n2, int n3, byte[] byArray, byte[] byArray2, int[] nArray, int[] nArray2, int n4, int n5, int n6, int n7, long l2) {
        MediaCodec.CryptoInfo cryptoInfo;
        boolean bl;
        block16: {
            this.resetLastPresentationTimeIfNeeded(l2);
            n5 = this.translateCipherModeValue(n5);
            if (n5 == -1) {
                return 5;
            }
            bl = n5 == 2;
            if (!bl) break block16;
            if (MediaCodecUtil.platformSupportsCbcsEncryption(Build.VERSION.SDK_INT)) break block16;
            g.b(TAG, "Encryption scheme 'cbcs' not supported on this platform.", new Object[0]);
            return 5;
        }
        int n8 = n6;
        MediaCodec.CryptoInfo cryptoInfo2 = cryptoInfo;
        cryptoInfo2();
        cryptoInfo.set(n4, nArray, nArray2, byArray2, byArray, n5);
        if (n8 != 0 && n7 != 0) {
            if (bl) {
                MediaCodecUtil.setPatternIfSupported(cryptoInfo2, n6, n7);
            } else {
                g.b(TAG, "Pattern encryption only supported for 'cbcs' scheme (CBC mode).", new Object[0]);
                return 5;
            }
        }
        try {
            this.mMediaCodec.queueSecureInputBuffer(n2, n3, cryptoInfo2, l2, 0);
            return 0;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[]{};
            g.b(TAG, "Failed to queue secure input buffer, IllegalStateException " + illegalStateException, objectArray);
            return 5;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[]{};
            g.b(TAG, "Failed to queue secure input buffer, IllegalArgumentException " + illegalArgumentException, objectArray);
            return 5;
        }
        catch (MediaCodec.CryptoException cryptoException) {
            if (cryptoException.getErrorCode() == 1) {
                g.a(TAG, "Failed to queue secure input buffer: CryptoException.ERROR_NO_KEY");
                return 4;
            }
            Object[] objectArray = new Object[]{};
            g.b(TAG, a.a("Failed to queue secure input buffer, CryptoException with error code ").append(cryptoException.getErrorCode()).toString(), objectArray);
            return 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DequeueOutputResult dequeueOutputBuffer(long l2) {
        int n2;
        int n3;
        int n4;
        MediaCodec.BufferInfo bufferInfo;
        block17: {
            block16: {
                MediaCodec.BufferInfo bufferInfo2;
                if (this.mUseAsyncApi) {
                    MediaCodecBridge mediaCodecBridge = this;
                    synchronized (mediaCodecBridge) {
                        if (mediaCodecBridge.mPendingError) {
                            // ** MonitorExit[this] (shouldn't be in output)
                            return new DequeueOutputResult(5, -1, 0, 0, 0L, 0, null);
                        }
                        if (this.mPendingOutputBuffers.isEmpty()) {
                            // ** MonitorExit[this] (shouldn't be in output)
                            return new DequeueOutputResult(1, -1, 0, 0, 0L, 0, null);
                        }
                        if (this.mPendingOutputBuffers.peek().status() != 3) return this.mPendingOutputBuffers.remove();
                        if (!$assertionsDisabled) {
                            if (this.mPendingFormat.isEmpty()) throw new AssertionError();
                        }
                        this.mCurrentFormat = this.mPendingFormat.remove();
                        // ** MonitorExit[this] (shouldn't be in output)
                        return this.mPendingOutputBuffers.remove();
                    }
                }
                bufferInfo = bufferInfo2;
                bufferInfo();
                n4 = 5;
                n3 = -1;
                n2 = this.dequeueOutputBufferInternal(bufferInfo2, l2);
                this.updateLastPresentationTime(bufferInfo);
                if (n2 >= 0) {
                    n4 = 0;
                    return new DequeueOutputResult(n4, n2, bufferInfo.flags, bufferInfo.offset, bufferInfo.presentationTimeUs, bufferInfo.size, null);
                }
                if (n2 == -3) {
                    this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                    n4 = 2;
                    n2 = n3;
                    return new DequeueOutputResult(n4, n2, bufferInfo.flags, bufferInfo.offset, bufferInfo.presentationTimeUs, bufferInfo.size, null);
                }
                if (n2 != -2) break block16;
                n4 = 3;
                this.mMediaCodec.getOutputFormat();
                break block17;
            }
            if (n2 == -1) {
                n4 = 1;
                n2 = n3;
                return new DequeueOutputResult(n4, n2, bufferInfo.flags, bufferInfo.offset, bufferInfo.presentationTimeUs, bufferInfo.size, null);
            }
            try {
                g.b(TAG, "Unexpected index_or_status: " + n2, new Object[0]);
                if (!$assertionsDisabled) throw new AssertionError();
            }
            catch (IllegalStateException illegalStateException) {
                n4 = 5;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = illegalStateException;
                g.b(TAG, "Failed to dequeue output buffer", objectArray2);
                n2 = n3;
            }
        }
        n2 = n3;
        return new DequeueOutputResult(n4, n2, bufferInfo.flags, bufferInfo.offset, bufferInfo.presentationTimeUs, bufferInfo.size, null);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=23)
    private boolean setSurface(Surface objectArray) {
        void var0_3;
        try {
            this.mMediaCodec.setOutputSurface((Surface)objectArray);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = var0_3;
        g.b(TAG, "Cannot set output surface", objectArray);
        return false;
    }

    private void resetLastPresentationTimeIfNeeded(long l2) {
        if (this.mFlushed) {
            MediaCodecBridge mediaCodecBridge = this;
            mediaCodecBridge.mLastPresentationTimeUs = Math.max(l2 - 100000L, 0L);
            mediaCodecBridge.mFlushed = false;
        }
    }

    private int getAudioFormat(int n2) {
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 4) {
                    if (n2 != 6) {
                        if (n2 != 8) {
                            return 1;
                        }
                        if (Build.VERSION.SDK_INT >= 23) {
                            return 6396;
                        }
                        return 1020;
                    }
                    return 252;
                }
                return 204;
            }
            return 12;
        }
        return 4;
    }

    public static void createCallbackHandlerForTesting() {
        if (sCallbackHandlerThread != null) {
            return;
        }
        sCallbackHandlerThread = new HandlerThread("TestCallbackThread");
        sCallbackHandlerThread.start();
        sCallbackHandler = new Handler(sCallbackHandlerThread.getLooper());
    }

    private native void nativeOnBuffersAvailable(long var1);

    static {
        $assertionsDisabled = MediaCodecBridge.class.desiredAssertionStatus() ^ true;
    }

    public synchronized void onError(MediaCodec.CodecException codecException) {
        MediaCodecBridge mediaCodecBridge = this;
        mediaCodecBridge.mPendingError = true;
        mediaCodecBridge.mPendingInputBuffers.clear();
        mediaCodecBridge.mPendingOutputBuffers.clear();
        mediaCodecBridge.notifyBuffersAvailable();
    }

    public synchronized void onInputBufferAvailable(int n2) {
        if (this.mPendingStart) {
            return;
        }
        MediaCodecBridge mediaCodecBridge = this;
        mediaCodecBridge.mPendingInputBuffers.add(new DequeueInputResult(0, n2, null));
        mediaCodecBridge.notifyBuffersAvailable();
    }

    public synchronized void onOutputBufferAvailable(int n2, MediaCodec.BufferInfo bufferInfo) {
        if (this.mPendingStart) {
            return;
        }
        MediaCodecBridge mediaCodecBridge = this;
        mediaCodecBridge.updateLastPresentationTime(bufferInfo);
        MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
        int n3 = bufferInfo2.flags;
        int n4 = bufferInfo2.offset;
        long l2 = bufferInfo2.presentationTimeUs;
        int n5 = bufferInfo2.size;
        mediaCodecBridge.mPendingOutputBuffers.add(new DequeueOutputResult(0, n2, n3, n4, l2, n5, null));
        mediaCodecBridge.notifyBuffersAvailable();
    }

    public synchronized void onOutputFormatChanged(MediaFormat mediaFormat) {
        MediaCodecBridge mediaCodecBridge = this;
        mediaCodecBridge.mPendingOutputBuffers.add(new DequeueOutputResult(3, -1, 0, 0, 0L, 0, null));
        mediaCodecBridge.mPendingFormat.add(new GetOutputFormatResult(0, mediaFormat, null));
        mediaCodecBridge.notifyBuffersAvailable();
    }

    public synchronized void onPendingStartComplete(int n2) {
        if (this.mSequenceCounter != n2) {
            return;
        }
        this.mPendingStart = false;
    }

    public void updateLastPresentationTime(MediaCodec.BufferInfo bufferInfo) {
        long l2 = this.mLastPresentationTimeUs;
        if (bufferInfo.presentationTimeUs < l2) {
            bufferInfo.presentationTimeUs = l2;
        }
        this.mLastPresentationTimeUs = bufferInfo.presentationTimeUs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        String string2;
        block9: {
            if (this.mUseAsyncApi) {
                MediaCodecBridge mediaCodecBridge = this;
                synchronized (mediaCodecBridge) {
                    mediaCodecBridge.mNativeMediaCodecBridge = 0L;
                }
            }
            string2 = "unknown";
            if (Build.VERSION.SDK_INT < 18) break block9;
            string2 = this.mMediaCodec.getName();
        }
        g.d(TAG, "Releasing: " + string2, new Object[0]);
        this.mMediaCodec.release();
        try {
            g.d(TAG, "Codec released", new Object[0]);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            g.b(TAG, "Cannot release media codec", objectArray2);
        }
        this.mMediaCodec = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean start() {
        if (!this.mUseAsyncApi) ** GOTO lbl28
        v0 = this;
        v1 = v0;
        ** synchronized (v0)
lbl-1000:
        // 1 sources

        {
            block11: {
                if (v1.mPendingError) {
                    // ** MonitorExit[this] (shouldn't be in output)
                    return false;
                }
                if (MediaCodecBridge.sCallbackHandler != null) ** GOTO lbl15
                var1_3 = v2;
                v2 = new Handler(Looper.getMainLooper());
                break block11;
lbl15:
                // 1 sources

                var1_3 = MediaCodecBridge.sCallbackHandler;
            }
            v3 = this;
            v4 = this;
            var1_3.post((Runnable)v4.new CompletePendingStartTask(v4.mSequenceCounter));
            try {
                // ** MonitorExit[v3] (shouldn't be in output)
                ** GOTO lbl28
            }
            catch (Throwable v5) {
                // ** MonitorExit[this] (shouldn't be in output)
                try {
                    throw v5;
lbl28:
                    // 2 sources

                    this.mMediaCodec.start();
                    if (Build.VERSION.SDK_INT <= 19) {
                        v6 = this;
                        v6.mInputBuffers = v6.mMediaCodec.getInputBuffers();
                        v6.mOutputBuffers = v6.mMediaCodec.getOutputBuffers();
                    }
                    return true;
                }
                catch (IllegalArgumentException var0_1) {
                    v7 = new Object[1];
                    var1_3 = v7;
                    v7[0] = var0_1;
                    g.b("cr_MediaCodecBridge", "Cannot start the media codec", (Object[])var1_3);
                    return false;
                }
                catch (IllegalStateException var0_2) {
                    v8 = new Object[1];
                    var1_3 = v8;
                    v8[0] = var0_2;
                    g.b("cr_MediaCodecBridge", "Cannot start the media codec", (Object[])var1_3);
                    return false;
                }
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public ByteBuffer getOutputBuffer(int n2) {
        if (Build.VERSION.SDK_INT > 19) {
            try {
                return this.mMediaCodec.getOutputBuffer(n2);
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = illegalStateException;
                g.b(TAG, "Failed to get output buffer", objectArray2);
                return null;
            }
        }
        return this.mOutputBuffers[n2];
    }

    public void releaseOutputBuffer(int n2, boolean bl) {
        try {
            this.mMediaCodec.releaseOutputBuffer(n2, bl);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            g.b(TAG, "Failed to release output buffer", objectArray2);
        }
    }

    public int dequeueOutputBufferInternal(MediaCodec.BufferInfo bufferInfo, long l2) {
        return this.mMediaCodec.dequeueOutputBuffer(bufferInfo, l2);
    }

    public boolean configureVideo(MediaFormat objectArray, Surface surface, MediaCrypto mediaCrypto, int n2) {
        try {
            this.mMediaCodec.configure((MediaFormat)objectArray, surface, mediaCrypto, n2);
            return true;
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = exception;
            g.b(TAG, "Cannot configure the video codec", objectArray);
        }
        catch (MediaCodec.CryptoException cryptoException) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = cryptoException;
            g.b(TAG, "Cannot configure the video codec: DRM error", objectArray);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = illegalStateException;
            g.b(TAG, "Cannot configure the video codec", objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = illegalArgumentException;
            g.b(TAG, "Cannot configure the video codec, wrong format or surface", objectArray);
        }
        return false;
    }

    public boolean configureAudio(MediaFormat objectArray, MediaCrypto mediaCrypto, int n2) {
        try {
            this.mMediaCodec.configure((MediaFormat)objectArray, null, mediaCrypto, n2);
            return true;
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = exception;
            g.b(TAG, "Cannot configure the audio codec", objectArray);
        }
        catch (MediaCodec.CryptoException cryptoException) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = cryptoException;
            g.b(TAG, "Cannot configure the audio codec: DRM error", objectArray);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = illegalStateException;
            g.b(TAG, "Cannot configure the audio codec", objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = illegalArgumentException;
            g.b(TAG, "Cannot configure the audio codec", objectArray);
        }
        return false;
    }

    @MainDex
    @TargetApi(value=23)
    public class MediaCodecCallback
    extends MediaCodec.Callback {
        public MediaCodecBridge mMediaCodecBridge;

        public MediaCodecCallback(MediaCodecBridge mediaCodecBridge2) {
            this.mMediaCodecBridge = mediaCodecBridge2;
        }

        public void onError(MediaCodec mediaCodec, MediaCodec.CodecException codecException) {
            Object[] objectArray = objectArray2;
            Object[] objectArray2 = new Object[]{};
            g.b(MediaCodecBridge.TAG, a.a("MediaCodec.onError: ").append(codecException.getDiagnosticInfo()).toString(), objectArray2);
            objectArray.mMediaCodecBridge.onError(codecException);
        }

        public void onInputBufferAvailable(MediaCodec mediaCodec, int n2) {
            this.mMediaCodecBridge.onInputBufferAvailable(n2);
        }

        public void onOutputBufferAvailable(MediaCodec mediaCodec, int n2, MediaCodec.BufferInfo bufferInfo) {
            this.mMediaCodecBridge.onOutputBufferAvailable(n2, bufferInfo);
        }

        public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
            this.mMediaCodecBridge.onOutputFormatChanged(mediaFormat);
        }
    }

    @MainDex
    public static class GetOutputFormatResult {
        public final int mStatus;
        public final MediaFormat mFormat;

        public GetOutputFormatResult(int n2, MediaFormat mediaFormat) {
            this.mStatus = n2;
            this.mFormat = mediaFormat;
        }

        private boolean formatHasCropValues() {
            return this.mFormat.containsKey(MediaCodecBridge.KEY_CROP_RIGHT) && this.mFormat.containsKey(MediaCodecBridge.KEY_CROP_LEFT) && this.mFormat.containsKey(MediaCodecBridge.KEY_CROP_BOTTOM) && this.mFormat.containsKey(MediaCodecBridge.KEY_CROP_TOP);
        }

        private int status() {
            return this.mStatus;
        }

        private int width() {
            return this.formatHasCropValues() ? this.mFormat.getInteger(MediaCodecBridge.KEY_CROP_RIGHT) - this.mFormat.getInteger(MediaCodecBridge.KEY_CROP_LEFT) + 1 : this.mFormat.getInteger("width");
        }

        private int height() {
            return this.formatHasCropValues() ? this.mFormat.getInteger(MediaCodecBridge.KEY_CROP_BOTTOM) - this.mFormat.getInteger(MediaCodecBridge.KEY_CROP_TOP) + 1 : this.mFormat.getInteger("height");
        }

        private int sampleRate() {
            return this.mFormat.getInteger("sample-rate");
        }

        private int channelCount() {
            return this.mFormat.getInteger("channel-count");
        }

        public /* synthetic */ GetOutputFormatResult(int n2, MediaFormat mediaFormat, 1 var3_3) {
            this(n2, mediaFormat);
        }
    }

    @MainDex
    public static class DequeueOutputResult {
        public final int mStatus;
        public final int mIndex;
        public final int mFlags;
        public final int mOffset;
        public final long mPresentationTimeMicroseconds;
        public final int mNumBytes;

        public DequeueOutputResult(int n2, int n3, int n4, int n5, long l2, int n6) {
            this.mStatus = n2;
            this.mIndex = n3;
            this.mFlags = n4;
            this.mOffset = n5;
            this.mPresentationTimeMicroseconds = l2;
            this.mNumBytes = n6;
        }

        private int status() {
            return this.mStatus;
        }

        private int index() {
            return this.mIndex;
        }

        private int flags() {
            return this.mFlags;
        }

        private int offset() {
            return this.mOffset;
        }

        private long presentationTimeMicroseconds() {
            return this.mPresentationTimeMicroseconds;
        }

        private int numBytes() {
            return this.mNumBytes;
        }

        public /* synthetic */ DequeueOutputResult(int n2, int n3, int n4, int n5, long l2, int n6, 1 var8_7) {
            this(n2, n3, n4, n5, l2, n6);
        }
    }

    @MainDex
    public static class DequeueInputResult {
        public final int mStatus;
        public final int mIndex;

        public DequeueInputResult(int n2, int n3) {
            this.mStatus = n2;
            this.mIndex = n3;
        }

        private int status() {
            return this.mStatus;
        }

        private int index() {
            return this.mIndex;
        }

        public /* synthetic */ DequeueInputResult(int n2, int n3, 1 var3_3) {
            this(n2, n3);
        }
    }
}

