/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.media.MediaCodecInfo;
import java.util.ArrayList;
import java.util.List;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="media")
@MainDex
public class CodecProfileLevelList {
    public static final String TAG = "CodecProfileLevelList";
    public final List<CodecProfileLevelAdapter> mList = new ArrayList<CodecProfileLevelAdapter>();

    public static int getCodecFromMime(String string2) {
        if (string2.endsWith("vp9")) {
            return 7;
        }
        if (string2.endsWith("vp8")) {
            return 6;
        }
        if (string2.endsWith("avc")) {
            return 1;
        }
        if (string2.endsWith("hevc")) {
            return 8;
        }
        throw new UnsupportedCodecProfileException(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int mediaCodecProfileToChromiumMediaProfile(int n2, int n3) {
        if (n2 != 1) {
            switch (n2) {
                default: {
                    throw new UnsupportedCodecProfileException(null);
                }
                case 8: {
                    if (n3 == 1) return 16;
                    if (n3 == 2 || n3 == 4096) return 17;
                    throw new UnsupportedCodecProfileException(null);
                }
                case 7: {
                    if (n3 == 1) return 12;
                    if (n3 == 2) return 13;
                    if (n3 == 4) return 14;
                    if (n3 == 8) return 15;
                    if (n3 == 4096) return 14;
                    if (n3 == 8192) return 15;
                    throw new UnsupportedCodecProfileException(null);
                }
                case 6: 
            }
            if (n3 != 1) throw new UnsupportedCodecProfileException(null);
            return 11;
        }
        if (n3 == 1) return 0;
        if (n3 == 2) return 1;
        if (n3 == 4) return 2;
        if (n3 == 8) return 3;
        if (n3 == 16) return 4;
        if (n3 == 32) return 5;
        if (n3 != 64) throw new UnsupportedCodecProfileException(null);
        return 6;
    }

    public static int mediaCodecLevelToChromiumMediaLevel(int n2, int n3) {
        if (n2 != 1) {
            switch (n2) {
                default: {
                    throw new UnsupportedCodecProfileException(null);
                }
                case 8: {
                    switch (n3) {
                        default: {
                            throw new UnsupportedCodecProfileException(null);
                        }
                        case 0x1000000: 
                        case 0x2000000: {
                            return 186;
                        }
                        case 0x400000: 
                        case 0x800000: {
                            return 183;
                        }
                        case 0x100000: 
                        case 0x200000: {
                            return 180;
                        }
                        case 262144: 
                        case 524288: {
                            return 156;
                        }
                        case 65536: 
                        case 131072: {
                            return 153;
                        }
                        case 16384: 
                        case 32768: {
                            return 150;
                        }
                        case 4096: 
                        case 8192: {
                            return 123;
                        }
                        case 1024: 
                        case 2048: {
                            return 120;
                        }
                        case 256: 
                        case 512: {
                            return 93;
                        }
                        case 64: 
                        case 128: {
                            return 90;
                        }
                        case 16: 
                        case 32: {
                            return 63;
                        }
                        case 4: 
                        case 8: {
                            return 60;
                        }
                        case 1: 
                        case 2: 
                    }
                    return 30;
                }
                case 7: {
                    switch (n3) {
                        default: {
                            throw new UnsupportedCodecProfileException(null);
                        }
                        case 8192: {
                            return 62;
                        }
                        case 4096: {
                            return 61;
                        }
                        case 2048: {
                            return 60;
                        }
                        case 1024: {
                            return 52;
                        }
                        case 512: {
                            return 51;
                        }
                        case 256: {
                            return 50;
                        }
                        case 128: {
                            return 41;
                        }
                        case 64: {
                            return 40;
                        }
                        case 32: {
                            return 31;
                        }
                        case 16: {
                            return 30;
                        }
                        case 8: {
                            return 21;
                        }
                        case 4: {
                            return 20;
                        }
                        case 2: {
                            return 11;
                        }
                        case 1: 
                    }
                    return 10;
                }
                case 6: 
            }
            if (n3 != 1) {
                if (n3 != 2) {
                    if (n3 != 4) {
                        if (n3 == 8) {
                            return 3;
                        }
                        throw new UnsupportedCodecProfileException(null);
                    }
                    return 2;
                }
                return 1;
            }
            return 0;
        }
        switch (n3) {
            default: {
                throw new UnsupportedCodecProfileException(null);
            }
            case 65536: {
                return 52;
            }
            case 32768: {
                return 51;
            }
            case 16384: {
                return 50;
            }
            case 8192: {
                return 42;
            }
            case 4096: {
                return 41;
            }
            case 2048: {
                return 40;
            }
            case 1024: {
                return 32;
            }
            case 512: {
                return 31;
            }
            case 256: {
                return 30;
            }
            case 128: {
                return 22;
            }
            case 64: {
                return 21;
            }
            case 32: {
                return 20;
            }
            case 16: {
                return 13;
            }
            case 8: {
                return 12;
            }
            case 4: {
                return 11;
            }
            case 1: 
        }
        return 10;
    }

    public boolean addCodecProfileLevel(String string2, MediaCodecInfo.CodecProfileLevel codecProfileLevel) {
        int n2;
        CodecProfileLevelList codecProfileLevelList;
        try {
            codecProfileLevelList = this;
            n2 = CodecProfileLevelList.getCodecFromMime(string2);
        }
        catch (UnsupportedCodecProfileException unsupportedCodecProfileException) {
            return false;
        }
        int n3 = n2;
        codecProfileLevelList.mList.add(new CodecProfileLevelAdapter(n3, CodecProfileLevelList.mediaCodecProfileToChromiumMediaProfile(n3, codecProfileLevel.profile), CodecProfileLevelList.mediaCodecLevelToChromiumMediaLevel(n2, codecProfileLevel.level)));
        return true;
    }

    public boolean addCodecProfileLevel(int n2, int n3, int n4) {
        this.mList.add(new CodecProfileLevelAdapter(n2, n3, n4));
        return true;
    }

    public Object[] toArray() {
        return this.mList.toArray();
    }

    public static class UnsupportedCodecProfileException
    extends RuntimeException {
        public UnsupportedCodecProfileException() {
        }

        public /* synthetic */ UnsupportedCodecProfileException(1 var1_1) {
            this();
        }
    }

    public static class CodecProfileLevelAdapter {
        public final int mCodec;
        public final int mProfile;
        public final int mLevel;

        public CodecProfileLevelAdapter(int n2, int n3, int n4) {
            this.mCodec = n2;
            this.mProfile = n3;
            this.mLevel = n4;
        }

        public int getCodec() {
            return this.mCodec;
        }

        public int getProfile() {
            return this.mProfile;
        }

        public int getLevel() {
            return this.mLevel;
        }
    }
}

