/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.sensors;

import android.content.Context;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import java.util.HashSet;
import java.util.Set;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.device.sensors.PlatformSensor;

@JNINamespace(value="device")
public class PlatformSensorProvider {
    public SensorManager mSensorManager;
    public HandlerThread mSensorsThread;
    public Handler mHandler;
    public final Set<PlatformSensor> mActiveSensors = new HashSet<PlatformSensor>();

    public PlatformSensorProvider(Context context) {
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
    }

    public static PlatformSensorProvider createForTest(Context context) {
        return new PlatformSensorProvider(context);
    }

    public static PlatformSensorProvider create() {
        return new PlatformSensorProvider(ContextUtils.getApplicationContext());
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public SensorManager getSensorManager() {
        return this.mSensorManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sensorStarted(PlatformSensor platformSensor) {
        PlatformSensorProvider platformSensorProvider = this;
        Set<PlatformSensor> set = platformSensorProvider.mActiveSensors;
        synchronized (set) {
            if (platformSensorProvider.mActiveSensors.isEmpty()) {
                this.startSensorThread();
            }
            Set<PlatformSensor> set2 = set;
            this.mActiveSensors.add(platformSensor);
            {
                // ** MonitorExit[v1] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sensorStopped(PlatformSensor platformSensor) {
        PlatformSensorProvider platformSensorProvider = this;
        Set<PlatformSensor> set = platformSensorProvider.mActiveSensors;
        synchronized (set) {
            platformSensorProvider.mActiveSensors.remove(platformSensor);
            {
                if (platformSensorProvider.mActiveSensors.isEmpty()) {
                    this.stopSensorThread();
                }
                return;
            }
        }
    }

    public void startSensorThread() {
        if (this.mSensorsThread == null) {
            this.mSensorsThread = new HandlerThread("SensorsHandlerThread");
            this.mSensorsThread.start();
            this.mHandler = new Handler(this.mSensorsThread.getLooper());
        }
    }

    public void stopSensorThread() {
        HandlerThread handlerThread = this.mSensorsThread;
        if (handlerThread != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                handlerThread.quitSafely();
            } else {
                handlerThread.quit();
            }
            PlatformSensorProvider platformSensorProvider = this;
            platformSensorProvider.mSensorsThread = null;
            platformSensorProvider.mHandler = null;
        }
    }

    public void setSensorManagerToNullForTesting() {
        this.mSensorManager = null;
    }

    public boolean hasSensorType(int n2) {
        if (this.mSensorManager == null) {
            return false;
        }
        switch (n2) {
            default: {
                return false;
            }
            case 10: {
                n2 = 15;
                break;
            }
            case 8: {
                n2 = 11;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 10;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 0: {
                n2 = 5;
            }
        }
        return this.mSensorManager.getSensorList(n2).isEmpty() ^ true;
    }

    public PlatformSensor createSensor(int n2) {
        if (this.mSensorManager == null) {
            return null;
        }
        switch (n2) {
            default: {
                return null;
            }
            case 10: {
                return PlatformSensor.create(15, 4, this);
            }
            case 8: {
                return PlatformSensor.create(11, 4, this);
            }
            case 5: {
                return PlatformSensor.create(2, 3, this);
            }
            case 4: {
                return PlatformSensor.create(4, 3, this);
            }
            case 3: {
                return PlatformSensor.create(10, 3, this);
            }
            case 2: {
                return PlatformSensor.create(1, 3, this);
            }
            case 0: 
        }
        return PlatformSensor.create(5, 1, this);
    }
}

