/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content_shell;

import a.a.a.a.a;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.vccorp.object.UserInfo;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DatabaseHandler
extends SQLiteOpenHelper {
    public static final String DATABASE_NAME = "VivaHistory";
    public static final int DATABASE_VERSION = 1;
    public static final String TABLE_NAME_USER = "User";
    public static final String VIVA_BROWSER_UIDKEY = "uid";
    public static final String VIVA_BROWSER_NAMEKEY = "name";
    public static final String VIVA_BROWSER_EMAILKEY = "email";
    public static final String VIVA_BROWSER_EXTRAKEY = "extra";
    public static final String VIVA_BROWSER_TIMECREATEKEY = "timeCreated";
    public static final String VIVA_BROWSER_IDKEY = "id";
    public static final String TABLE_NAME_VISIT = "LinkVisited";
    public static final String KEY_LINK_ID = "linkId";
    public static final String VIVA_BROWSER_DOMAINNAMEKEY = "domainName";
    public static final String VIVA_BROWSER_URLKEY = "url";
    public static final String VIVA_BROWSER_TITLE = "title";
    public static final String VIVA_BROWSER_REF_IDKEY = "pid";
    public static final String VIVA_BROWSER_TIMEVISITEDKEY = "timeVisited";

    public DatabaseHandler(Context context) {
        super(context, DATABASE_NAME, null, 1);
    }

    public DatabaseHandler(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n2) {
        super(context, string2, cursorFactory, n2);
    }

    public DatabaseHandler(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n2, DatabaseErrorHandler databaseErrorHandler) {
        super(context, string2, cursorFactory, n2, databaseErrorHandler);
    }

    public DatabaseHandler(Context context, String string2, int n2, SQLiteDatabase.OpenParams openParams) {
        super(context, string2, n2, openParams);
    }

    private void createTable(SQLiteDatabase sQLiteDatabase) {
        Object[] objectArray = new Object[6];
        Object object = objectArray;
        objectArray[0] = TABLE_NAME_USER;
        objectArray[1] = VIVA_BROWSER_UIDKEY;
        objectArray[2] = VIVA_BROWSER_NAMEKEY;
        objectArray[3] = VIVA_BROWSER_EMAILKEY;
        objectArray[4] = VIVA_BROWSER_EXTRAKEY;
        objectArray[5] = VIVA_BROWSER_TIMECREATEKEY;
        object = String.format("CREATE TABLE IF NOT EXISTS %s (%s INTEGER PRIMARY KEY, %s TEXT, %s TEXT, %s TEXT, %s TEXT)", object);
        Object[] objectArray2 = new Object[7];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = TABLE_NAME_VISIT;
        objectArray2[1] = VIVA_BROWSER_IDKEY;
        objectArray2[2] = VIVA_BROWSER_DOMAINNAMEKEY;
        objectArray2[3] = VIVA_BROWSER_URLKEY;
        objectArray2[4] = VIVA_BROWSER_TITLE;
        objectArray2[5] = VIVA_BROWSER_REF_IDKEY;
        objectArray2[6] = VIVA_BROWSER_TIMEVISITEDKEY;
        String string2 = String.format("CREATE TABLE IF NOT EXISTS %s (%s INTEGER PRIMARY KEY AUTOINCREMENT, %s TEXT, %s TEXT, %s TEXT, %s TEXT, %s TEXT)", objectArray3);
        sQLiteDatabase.execSQL((String)object);
        sQLiteDatabase.execSQL(string2);
    }

    private String convertMinisecondToDate(String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(Long.parseLong(string2));
        return simpleDateFormat.format(calendar.getTime());
    }

    private boolean updateUser(UserInfo userInfo) {
        ContentValues contentValues;
        SQLiteDatabase sQLiteDatabase = stringArray2.getWritableDatabase();
        ContentValues contentValues2 = contentValues;
        contentValues2();
        contentValues2.put(VIVA_BROWSER_NAMEKEY, userInfo.getName());
        contentValues2.put(VIVA_BROWSER_EMAILKEY, userInfo.getExtra());
        contentValues2.put(VIVA_BROWSER_EXTRAKEY, userInfo.getExtra());
        contentValues.put(VIVA_BROWSER_TIMECREATEKEY, stringArray2.convertMinisecondToDate(userInfo.getTimeCreate()));
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = String.valueOf(userInfo.getUid());
        int n2 = sQLiteDatabase.update(TABLE_NAME_USER, contentValues2, "uid = ?", stringArray2);
        sQLiteDatabase.close();
        return n2 > 0;
    }

    private String getFirstRowOfTable() {
        Cursor cursor = this.getReadableDatabase().rawQuery("SELECT * FROM LinkVisited ORDER BY timeVisited ASC LIMIT 1", null);
        if (cursor != null) {
            cursor.moveToFirst();
        }
        if (cursor.getCount() > 0) {
            return cursor.getString(5);
        }
        return this.convertMinisecondToDate(String.valueOf(System.currentTimeMillis()));
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        this.createTable(sQLiteDatabase);
    }

    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
        SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
        sQLiteDatabase2.execSQL("DROP TABLE IF EXISTS User");
        sQLiteDatabase2.execSQL("DROP TABLE IF EXISTS LinkVisited");
    }

    public boolean addUser(UserInfo userInfo) {
        ContentValues contentValues;
        ContentValues contentValues2 = contentValues;
        contentValues = new ContentValues();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        if (sQLiteDatabase.rawQuery(a.a("SELECT uid FROM User where uid= ").append(userInfo.getUid()).toString(), null).getCount() > 0) {
            sQLiteDatabase.close();
            return this.updateUser(userInfo);
        }
        contentValues2.put(VIVA_BROWSER_UIDKEY, Integer.valueOf(userInfo.getUid()));
        contentValues2.put(VIVA_BROWSER_NAMEKEY, userInfo.getName());
        contentValues2.put(VIVA_BROWSER_EMAILKEY, userInfo.getEmail());
        contentValues2.put(VIVA_BROWSER_EXTRAKEY, userInfo.getExtra());
        contentValues2.put(VIVA_BROWSER_TIMECREATEKEY, userInfo.getTimeCreate());
        long l2 = sQLiteDatabase.insert(TABLE_NAME_USER, null, contentValues2);
        sQLiteDatabase.close();
        return l2 > 0L;
    }

    public boolean removeUserByUserId(int n2) {
        DatabaseHandler databaseHandler = databaseHandler.getWritableDatabase();
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = String.valueOf(n2);
        int n3 = databaseHandler.delete(TABLE_NAME_USER, "uid = ?", stringArray2);
        databaseHandler.close();
        return n3 > 0;
    }

    public boolean removeUserByName(String string2) {
        DatabaseHandler databaseHandler = databaseHandler.getWritableDatabase();
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = String.valueOf(string2);
        int n2 = databaseHandler.delete(TABLE_NAME_USER, "name = ?", stringArray2);
        databaseHandler.close();
        return n2 > 0;
    }

    public boolean removeUserByEmail(String string2) {
        DatabaseHandler databaseHandler = databaseHandler.getWritableDatabase();
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = String.valueOf(string2);
        int n2 = databaseHandler.delete(TABLE_NAME_USER, "email = ?", stringArray2);
        databaseHandler.close();
        return n2 > 0;
    }

    public UserInfo getUserInfo(int n2) {
        SQLiteDatabase sQLiteDatabase = cursor2.getReadableDatabase();
        Cursor cursor = new String[1];
        Cursor cursor2 = cursor;
        cursor[0] = String.valueOf(n2);
        if ((cursor2 = sQLiteDatabase.query(TABLE_NAME_USER, null, "uid = ?", (String[])cursor2, null, null, null)) != null) {
            cursor2.moveToFirst();
        }
        return new UserInfo(cursor2.getInt(0), cursor2.getString(1), cursor2.getString(2), cursor2.getString(3), cursor2.getString(4));
    }

    public List<UserInfo> getAllUserInfo() {
        ArrayList arrayList;
        DatabaseHandler databaseHandler = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Cursor cursor = databaseHandler.getReadableDatabase().rawQuery("SELECT * FROM User", null);
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            arrayList2.add(new UserInfo(cursor.getInt(0), cursor.getString(1), cursor.getString(2), cursor.getString(3), cursor.getString(4)));
            cursor.moveToNext();
        }
        return arrayList2;
    }

    public List<a.b.m.a> getAllHistoryOfUser(int n2) {
        ArrayList arrayList;
        DatabaseHandler databaseHandler = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Cursor cursor = databaseHandler.getReadableDatabase().rawQuery("SELECT * FROM LinkVisited where uid= " + n2, null);
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            arrayList2.add(new a.b.m.a(cursor.getString(0), cursor.getString(1), cursor.getString(2), cursor.getInt(3), cursor.getString(4)));
            cursor.moveToNext();
        }
        return arrayList2;
    }

    public List<a.b.m.a> getAllHistory() {
        ArrayList arrayList;
        DatabaseHandler databaseHandler = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Cursor cursor = databaseHandler.getReadableDatabase().rawQuery("SELECT * FROM LinkVisited", null);
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            arrayList2.add(new a.b.m.a(cursor.getString(0), cursor.getString(1), cursor.getString(2), cursor.getInt(3), cursor.getString(4)));
            cursor.moveToNext();
        }
        return arrayList2;
    }

    public List<a.b.m.a> getHistoryByRange(Date date, Date date2) {
        ArrayList arrayList;
        DatabaseHandler databaseHandler = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        date = databaseHandler.getReadableDatabase().rawQuery("SELECT * FROM LinkVisited WHERE timeVisited BETWEEN '" + date + "' AND '" + date2 + "'", null);
        date.moveToFirst();
        while (!date.isAfterLast()) {
            arrayList2.add(new a.b.m.a(date.getString(0), date.getString(1), date.getString(2), date.getInt(3), date.getString(4)));
            date.moveToNext();
        }
        return arrayList2;
    }

    public void addLinkVisited(a.b.m.a a2) {
        ContentValues contentValues;
        DatabaseHandler databaseHandler = databaseHandler2;
        DatabaseHandler databaseHandler2 = contentValues;
        contentValues = new ContentValues();
        SQLiteDatabase sQLiteDatabase = databaseHandler.getWritableDatabase();
        DatabaseHandler databaseHandler3 = databaseHandler2;
        databaseHandler3.put(VIVA_BROWSER_DOMAINNAMEKEY, a2.a);
        databaseHandler3.put(VIVA_BROWSER_URLKEY, a2.b);
        databaseHandler3.put(VIVA_BROWSER_TITLE, a2.c);
        databaseHandler3.put(VIVA_BROWSER_REF_IDKEY, a2.d);
        databaseHandler3.put(VIVA_BROWSER_TIMEVISITEDKEY, a2.e);
        sQLiteDatabase.insert(TABLE_NAME_VISIT, null, (ContentValues)databaseHandler2);
        sQLiteDatabase.close();
    }

    public void removeHistory30Days() {
        block6: {
            SimpleDateFormat simpleDateFormat;
            Object object = this.getFirstRowOfTable();
            Cloneable cloneable = simpleDateFormat;
            cloneable("yyyy-MM-dd hh:mm:ss");
            object = cloneable.parse((String)object);
            cloneable = simpleDateFormat.parse(this.convertMinisecondToDate(String.valueOf(System.currentTimeMillis())));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            calendar.add(5, 30);
            Date date = simpleDateFormat.parse(simpleDateFormat.format(calendar.getTime()));
            if (date.compareTo((Date)cloneable) >= 0) break block6;
            try {
                this.removeHistoryByRange((Date)object, date);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
    }

    public void removeHistoryByRange(Date object, Date date) {
        SimpleDateFormat simpleDateFormat;
        DatabaseHandler databaseHandler = object2;
        Object object2 = simpleDateFormat;
        ((SimpleDateFormat)object2)("yyyy-MM-dd hh:mm:ss");
        object2 = ((DateFormat)object2).format((Date)object);
        object = simpleDateFormat.format(date);
        databaseHandler.getWritableDatabase().execSQL("DELETE FROM LinkVisited WHERE timeVisited BETWEEN '" + (String)object2 + "' AND '" + (String)object + "'");
    }

    public void removeHistoryByUserId(int n2) {
        this.getWritableDatabase().execSQL("DELETE FROM LinkVisited WHERE pid = " + n2);
    }
}

