/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import a.b.a.h;
import a.b.a.k;
import a.b.c.b.i;
import a.b.c.b.j;
import a.b.c.b.p;
import a.b.c.b.q;
import a.b.d.a.e;
import a.b.d.a.z;
import android.view.ViewGroup;
import com.vccorp.content_public.browser.GestureStateListener;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.input.ImeAdapterImpl;
import org.chromium.content.browser.selection.SelectionPopupControllerImpl;
import org.chromium.content.browser.webcontents.WebContentsImpl;
import org.chromium.content_public.browser.WebContents;
import org.chromium.ui.base.ViewAndroidDelegate;

@JNINamespace(value="content")
public class GestureListenerManagerImpl
implements e,
p,
k {
    public final WebContentsImpl mWebContents;
    public final h<GestureStateListener> mListeners;
    public final h.c<GestureStateListener> mIterator;
    public ViewAndroidDelegate mViewDelegate;
    public z.a mScrollDelegate;
    public long mNativeGestureListenerManager;
    public boolean mIsTouchScrollInProgress;
    public boolean mHasActiveFlingScroll;

    public static GestureListenerManagerImpl fromWebContents(WebContents webContents) {
        return ((WebContentsImpl)webContents).getOrSetUserData(GestureListenerManagerImpl.class, UserDataFactoryLazyHolder.INSTANCE);
    }

    public GestureListenerManagerImpl(WebContents webContents) {
        GestureListenerManagerImpl gestureListenerManagerImpl = this;
        gestureListenerManagerImpl.mWebContents = (WebContentsImpl)webContents;
        gestureListenerManagerImpl.mListeners = new h();
        gestureListenerManagerImpl.mIterator = gestureListenerManagerImpl.mListeners.c();
        gestureListenerManagerImpl.mViewDelegate = gestureListenerManagerImpl.mWebContents.getViewAndroidDelegate();
        q.a(gestureListenerManagerImpl.mWebContents).a(this);
        gestureListenerManagerImpl.mNativeGestureListenerManager = gestureListenerManagerImpl.nativeInit(gestureListenerManagerImpl.mWebContents);
    }

    private void resetGestureDetection() {
        long l2 = this.mNativeGestureListenerManager;
        if (l2 != 0L) {
            this.nativeResetGestureDetection(l2);
        }
    }

    private void updateOnTouchDown() {
        ((h.b)this.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((GestureStateListener)this.mIterator.next()).onTouchDown();
        }
    }

    private void resetFlingGesture() {
        if (this.mHasActiveFlingScroll) {
            this.onFlingEnd();
            this.mHasActiveFlingScroll = false;
        }
    }

    private void onFlingEnd() {
        GestureListenerManagerImpl gestureListenerManagerImpl = this;
        gestureListenerManagerImpl.mHasActiveFlingScroll = false;
        gestureListenerManagerImpl.setTouchScrollInProgress(false);
        ((h.b)gestureListenerManagerImpl.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((GestureStateListener)this.mIterator.next()).onFlingEndGesture(this.verticalScrollOffset(), this.verticalScrollExtent());
        }
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private void onEventAck(int n2, boolean bl) {
        int n3 = 0;
        block10: do {
            switch (n3 == 0 ? n2 : n3) {
                default: {
                    return;
                }
                case 23: {
                    if (!bl) {
                        return;
                    }
                    GestureListenerManagerImpl gestureListenerManagerImpl = this;
                    gestureListenerManagerImpl.mViewDelegate.getContainerView().performHapticFeedback(0);
                    ((h.b)gestureListenerManagerImpl.mIterator).b();
                    while (this.mIterator.hasNext()) {
                        ((GestureStateListener)this.mIterator.next()).onLongPress();
                    }
                    return;
                }
                case 21: {
                    GestureListenerManagerImpl gestureListenerManagerImpl = this;
                    gestureListenerManagerImpl.destroyPastePopup();
                    ((h.b)gestureListenerManagerImpl.mIterator).b();
                    while (this.mIterator.hasNext()) {
                        ((GestureStateListener)this.mIterator.next()).onSingleTap(bl);
                    }
                    return;
                }
                case 17: {
                    ((h.b)this.mIterator).b();
                    while (this.mIterator.hasNext()) {
                        ((GestureStateListener)this.mIterator.next()).onPinchEnded();
                    }
                    return;
                }
                case 16: {
                    ((h.b)this.mIterator).b();
                    while (this.mIterator.hasNext()) {
                        ((GestureStateListener)this.mIterator.next()).onPinchStarted();
                    }
                    return;
                }
                case 14: {
                    n3 = 12;
                    if (!bl) continue block10;
                    GestureListenerManagerImpl gestureListenerManagerImpl = this;
                    gestureListenerManagerImpl.mHasActiveFlingScroll = true;
                    gestureListenerManagerImpl.setTouchScrollInProgress(false);
                    ((h.b)gestureListenerManagerImpl.mIterator).b();
                    while (this.mIterator.hasNext()) {
                        ((GestureStateListener)this.mIterator.next()).onFlingStartGesture(this.verticalScrollOffset(), this.verticalScrollExtent());
                    }
                    return;
                }
                case 13: {
                    if (!bl) {
                        return;
                    }
                    GestureListenerManagerImpl gestureListenerManagerImpl = this;
                    gestureListenerManagerImpl.destroyPastePopup();
                    ((h.b)gestureListenerManagerImpl.mIterator).b();
                    while (this.mIterator.hasNext()) {
                        ((GestureStateListener)this.mIterator.next()).onScrollUpdateGestureConsumed();
                    }
                    return;
                }
                case 12: {
                    this.updateOnScrollEnd();
                    return;
                }
                case 11: 
            }
            break;
        } while (true);
        GestureListenerManagerImpl gestureListenerManagerImpl = this;
        gestureListenerManagerImpl.setTouchScrollInProgress(true);
        ((h.b)gestureListenerManagerImpl.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((GestureStateListener)this.mIterator.next()).onScrollStarted(this.verticalScrollOffset(), this.verticalScrollExtent());
        }
    }

    private void destroyPastePopup() {
        if ((this = ((GestureListenerManagerImpl)this).getSelectionPopupController()) != null) {
            ((SelectionPopupControllerImpl)this).destroyPastePopup();
        }
    }

    private void resetPopupsAndInput(boolean bl) {
        GestureListenerManagerImpl gestureListenerManagerImpl = this;
        i.b(gestureListenerManagerImpl.mWebContents);
        gestureListenerManagerImpl.resetScrollInProgress();
        if (bl && (this = ImeAdapterImpl.fromWebContents(((GestureListenerManagerImpl)this).mWebContents)) != null) {
            ((ImeAdapterImpl)this).resetAndHideKeyboard();
        }
    }

    private void onNativeDestroyed() {
        ((h.b)this.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((GestureStateListener)this.mIterator.next()).onDestroyed();
        }
        this.mListeners.a();
        this.mNativeGestureListenerManager = 0L;
    }

    private boolean filterTapOrPressEvent(int n2, int n3, int n4) {
        return n2 == 5 && this.offerLongPressToEmbedder();
    }

    private void updateScrollInfo(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, boolean bl) {
        float f12 = f8;
        GestureListenerManagerImpl gestureListenerManagerImpl = this;
        TraceEvent.begin("GestureListenerManagerImpl:updateScrollInfo");
        j j2 = gestureListenerManagerImpl.mWebContents.getRenderCoordinates();
        f8 = j2.j;
        ViewGroup viewGroup = gestureListenerManagerImpl.mViewDelegate.getContainerView();
        float f13 = Math.max(f7, (float)viewGroup.getWidth() / (f8 *= f4));
        f8 = Math.max(f12, (float)viewGroup.getHeight() / f8);
        boolean bl2 = f5 != j2.h || f6 != j2.i;
        boolean bl3 = f4 != j2.g || f2 != j2.a || f3 != j2.b;
        if (bl3) {
            float f14 = j2.g;
            float f15 = j2.j;
            j j3 = j2;
            j j4 = j2;
            this.mScrollDelegate.onScrollChanged((int)(f2 * f14 * f15), (int)(f3 * f14 * f15), (int)j3.a(j3.a), (int)j4.a(j4.b));
        }
        j2.a = f2;
        j2.b = f3;
        j2.g = f4;
        j2.h = f5;
        j2.i = f6;
        j2.k = f11;
        j2.c = f13;
        j2.d = f8;
        j2.e = f9;
        j2.f = f10;
        if (bl3 || bl) {
            GestureListenerManagerImpl gestureListenerManagerImpl2 = this;
            gestureListenerManagerImpl2.updateOnScrollChanged(gestureListenerManagerImpl2.verticalScrollOffset(), this.verticalScrollExtent());
        }
        if (bl2) {
            this.updateOnScaleLimitsChanged(f5, f6);
        }
        TraceEvent.end("GestureListenerManagerImpl:updateScrollInfo");
    }

    private void setTouchScrollInProgress(boolean bl) {
        this.mIsTouchScrollInProgress = bl;
        this.getSelectionPopupController().setScrollInProgress(bl);
    }

    private void resetScrollInProgress() {
        if (!this.isScrollInProgress()) {
            return;
        }
        this.setTouchScrollInProgress(false);
        if (this.mIsTouchScrollInProgress) {
            this.updateOnScrollEnd();
        }
        this.resetFlingGesture();
    }

    private SelectionPopupControllerImpl getSelectionPopupController() {
        return SelectionPopupControllerImpl.fromWebContents(this.mWebContents);
    }

    private boolean offerLongPressToEmbedder() {
        return this.mViewDelegate.getContainerView().performLongClick();
    }

    private int verticalScrollOffset() {
        j j2 = this.mWebContents.getRenderCoordinates();
        return (int)Math.floor(j2.a(j2.b));
    }

    private int verticalScrollExtent() {
        j j2 = this.mWebContents.getRenderCoordinates();
        return (int)Math.ceil(j2.a(j2.f));
    }

    private native long nativeInit(WebContentsImpl var1);

    private native void nativeResetGestureDetection(long var1);

    private native void nativeSetDoubleTapSupportEnabled(long var1, boolean var3);

    private native void nativeSetMultiTouchZoomSupportEnabled(long var1, boolean var3);

    public void setScrollDelegate(z.a a2) {
        this.mScrollDelegate = a2;
    }

    public void addListener(GestureStateListener gestureStateListener) {
        this.mListeners.a(gestureStateListener);
    }

    public void removeListener(GestureStateListener gestureStateListener) {
        this.mListeners.b(gestureStateListener);
    }

    public void updateMultiTouchZoomSupport(boolean bl) {
        long l2 = this.mNativeGestureListenerManager;
        if (l2 == 0L) {
            return;
        }
        this.nativeSetMultiTouchZoomSupportEnabled(l2, bl);
    }

    public void updateDoubleTapSupport(boolean bl) {
        long l2 = this.mNativeGestureListenerManager;
        if (l2 == 0L) {
            return;
        }
        this.nativeSetDoubleTapSupportEnabled(l2, bl);
    }

    public boolean hasActiveFlingScroll() {
        return this.mHasActiveFlingScroll;
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        if (!bl) {
            this.resetGestureDetection();
        }
        ((h.b)this.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((GestureStateListener)this.mIterator.next()).onWindowFocusChanged(bl);
        }
    }

    public void updateOnScrollChanged(int n2, int n3) {
        ((h.b)this.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((GestureStateListener)this.mIterator.next()).onScrollOffsetOrExtentChanged(n2, n3);
        }
    }

    public void updateOnScrollEnd() {
        GestureListenerManagerImpl gestureListenerManagerImpl = this;
        gestureListenerManagerImpl.setTouchScrollInProgress(false);
        ((h.b)gestureListenerManagerImpl.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((GestureStateListener)this.mIterator.next()).onScrollEnded(this.verticalScrollOffset(), this.verticalScrollExtent());
        }
    }

    public void updateOnScaleLimitsChanged(float f2, float f3) {
        ((h.b)this.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((GestureStateListener)this.mIterator.next()).onScaleLimitsChanged(f2, f3);
        }
    }

    public boolean isScrollInProgress() {
        return this.mIsTouchScrollInProgress || this.mHasActiveFlingScroll;
    }

    public static final class UserDataFactoryLazyHolder {
        public static final WebContentsImpl.UserDataFactory<GestureListenerManagerImpl> INSTANCE = GestureListenerManagerImpl::new;
    }
}

