/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import a.b.a.k;
import a.b.c.b.f;
import a.b.c.b.g;
import a.b.c.b.j;
import a.b.d.a.z;
import android.os.SystemClock;
import android.view.KeyEvent;
import android.view.MotionEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.GestureListenerManagerImpl;
import org.chromium.content.browser.input.ImeAdapterImpl;
import org.chromium.content.browser.webcontents.WebContentsImpl;
import org.chromium.content_public.browser.WebContents;
import org.chromium.ui.base.EventForwarder;

@JNINamespace(value="content")
public class ContentUiEventHandler
implements k {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final WebContentsImpl mWebContents;
    public z.a mEventDelegate;
    public long mNativeContentUiEventHandler;

    public static ContentUiEventHandler fromWebContents(WebContents webContents) {
        return ((WebContentsImpl)webContents).getOrSetUserData(ContentUiEventHandler.class, UserDataFactoryLazyHolder.INSTANCE);
    }

    public ContentUiEventHandler(WebContents webContents) {
        this.mWebContents = (WebContentsImpl)webContents;
        this.mNativeContentUiEventHandler = this.nativeInit(webContents);
    }

    private EventForwarder getEventForwarder() {
        return this.mWebContents.getEventForwarder();
    }

    private float getEventSourceScaling() {
        return this.mWebContents.getTopLevelNativeWindow().getDisplay().a();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if (this.mWebContents.getOrSetUserData(f.class, f.a.a).a(motionEvent)) {
            return true;
        }
        g g2 = this.mWebContents.getOrSetUserData(g.class, g.b.a);
        if (g2.k && (motionEvent.getSource() & 0x10) != 0) {
            float f2;
            float f3;
            float f4 = motionEvent.getAxisValue(0);
            f4 = Math.abs(f3) <= 0.2f ? 0.0f : -f4;
            float f5 = motionEvent.getAxisValue(1);
            f5 = Math.abs(f2) <= 0.2f ? 0.0f : -f5;
            if (f4 != 0.0f || f5 != 0.0f) {
                g2.j.startFling(motionEvent.getEventTime(), f4, f5, true, true);
                return true;
            }
        }
        boolean bl = false;
        if (bl) {
            return true;
        }
        if ((motionEvent.getSource() & 2) == 0) return this.mEventDelegate.super_onGenericMotionEvent(motionEvent);
        int n2 = motionEvent.getActionMasked();
        if (n2 != 8) {
            if (n2 != 11 && n2 != 12) return this.mEventDelegate.super_onGenericMotionEvent(motionEvent);
            if (motionEvent.getToolType(0) != 3) return this.mEventDelegate.super_onGenericMotionEvent(motionEvent);
            return this.onMouseEvent(motionEvent);
        }
        this.onMouseWheelEvent(motionEvent);
        return true;
    }

    private void onMouseWheelEvent(MotionEvent motionEvent) {
        if (!$assertionsDisabled && this.mNativeContentUiEventHandler == 0L) {
            throw new AssertionError();
        }
        ContentUiEventHandler contentUiEventHandler = this;
        float f2 = contentUiEventHandler.getEventSourceScaling();
        contentUiEventHandler.nativeSendMouseWheelEvent(contentUiEventHandler.mNativeContentUiEventHandler, motionEvent.getEventTime(), motionEvent.getX() / f2, motionEvent.getY() / f2, motionEvent.getAxisValue(10), motionEvent.getAxisValue(9));
    }

    private boolean onMouseEvent(MotionEvent motionEvent) {
        if (!$assertionsDisabled && this.mNativeContentUiEventHandler == 0L) {
            throw new AssertionError();
        }
        boolean bl = false;
        MotionEvent motionEvent2 = this.mWebContents.getEventForwarder().createOffsetMotionEventIfNeeded(motionEvent);
        if (motionEvent2 != motionEvent) {
            bl = true;
        } else {
            motionEvent2 = motionEvent;
        }
        ContentUiEventHandler contentUiEventHandler = this;
        float f2 = contentUiEventHandler.getEventSourceScaling();
        contentUiEventHandler.nativeSendMouseEvent(contentUiEventHandler.mNativeContentUiEventHandler, motionEvent2.getEventTime(), motionEvent2.getActionMasked(), motionEvent2.getX() / f2, motionEvent2.getY() / f2, motionEvent2.getPointerId(0), motionEvent2.getPressure(0), motionEvent2.getOrientation(0), motionEvent2.getAxisValue(25, 0), EventForwarder.getMouseEventActionButton(motionEvent2), motionEvent2.getButtonState(), motionEvent2.getMetaState(), motionEvent2.getToolType(0));
        if (bl) {
            motionEvent2.recycle();
        }
        return true;
    }

    private boolean onKeyUp(int n2, KeyEvent keyEvent) {
        return this.mEventDelegate.super_onKeyUp(n2, keyEvent);
    }

    private boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.mWebContents.getOrSetUserData(f.class, f.a.a).a(keyEvent)) {
            return true;
        }
        if (!ContentUiEventHandler.shouldPropagateKeyEvent(keyEvent)) {
            return this.mEventDelegate.super_dispatchKeyEvent(keyEvent);
        }
        if (ImeAdapterImpl.fromWebContents(this.mWebContents).dispatchKeyEvent(keyEvent)) {
            return true;
        }
        return this.mEventDelegate.super_dispatchKeyEvent(keyEvent);
    }

    public static boolean shouldPropagateKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        return n2 != 82 && n2 != 3 && n2 != 4 && n2 != 5 && n2 != 6 && n2 != 26 && n2 != 79 && n2 != 27 && n2 != 80 && n2 != 25 && n2 != 164 && n2 != 24;
        {
        }
    }

    private void scrollBy(float f2, float f3) {
        if (f2 == 0.0f && f3 == 0.0f) {
            return;
        }
        long l2 = SystemClock.uptimeMillis();
        if (GestureListenerManagerImpl.fromWebContents(this.mWebContents).hasActiveFlingScroll()) {
            ContentUiEventHandler contentUiEventHandler = this;
            contentUiEventHandler.nativeCancelFling(contentUiEventHandler.mNativeContentUiEventHandler, l2);
        }
        ContentUiEventHandler contentUiEventHandler = this;
        contentUiEventHandler.nativeSendScrollEvent(contentUiEventHandler.mNativeContentUiEventHandler, l2, f2, f3);
    }

    private void scrollTo(float f2, float f3) {
        j j2 = this.mWebContents.getRenderCoordinates();
        j j3 = this.mWebContents.getRenderCoordinates();
        float f4 = j3.a(j3.b);
        this.scrollBy(f2 - j2.a(j2.a), f3 - f4);
    }

    private native long nativeInit(WebContents var1);

    private native void nativeSendMouseWheelEvent(long var1, long var3, float var5, float var6, float var7, float var8);

    private native void nativeSendMouseEvent(long var1, long var3, int var5, float var6, float var7, int var8, float var9, float var10, float var11, int var12, int var13, int var14, int var15);

    private native void nativeSendScrollEvent(long var1, long var3, float var5, float var6);

    private native void nativeCancelFling(long var1, long var3);

    static {
        $assertionsDisabled = ContentUiEventHandler.class.desiredAssertionStatus() ^ true;
    }

    public void setEventDelegate(z.a a2) {
        this.mEventDelegate = a2;
    }

    public static final class UserDataFactoryLazyHolder {
        public static final WebContentsImpl.UserDataFactory<ContentUiEventHandler> INSTANCE = ContentUiEventHandler::new;
    }
}

