/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import a.b.a.b;
import a.b.a.q.c;
import a.b.a.q.d;
import a.b.a.q.g;
import a.b.a.q.h;
import a.b.a.q.i;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.TaskExecutor;

@JNINamespace(value="base")
public class PostTask {
    public static final Object sLock;
    public static Set<h> sPreNativeTaskRunners;
    public static final Executor sPrenativeThreadPoolExecutor;
    public static Executor sPrenativeThreadPoolExecutorOverride;
    public static final TaskExecutor[] sTaskExecutors;
    public static final /* synthetic */ boolean $assertionsDisabled;

    public static TaskExecutor[] getInitialTaskExecutors() {
        c c2;
        TaskExecutor[] taskExecutorArray = new TaskExecutor[5];
        c c3 = c2;
        c2 = new c();
        taskExecutorArray[0] = c3;
        return taskExecutorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static h createTaskRunner(i i2) {
        Object object = sLock;
        synchronized (object) {
            return PostTask.getTaskExecutorForTraits(i2).createTaskRunner(i2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static d createSequencedTaskRunner(i i2) {
        Object object = sLock;
        synchronized (object) {
            return PostTask.getTaskExecutorForTraits(i2).createSequencedTaskRunner(i2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static g createSingleThreadTaskRunner(i i2) {
        Object object = sLock;
        synchronized (object) {
            return PostTask.getTaskExecutorForTraits(i2).createSingleThreadTaskRunner(i2);
        }
    }

    public static void postTask(i i2, Runnable runnable) {
        PostTask.postDelayedTask(i2, runnable, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void postDelayedTask(i i2, Runnable runnable, long l2) {
        Object object = sLock;
        synchronized (object) {
            if (sPreNativeTaskRunners != null) {
                PostTask.getTaskExecutorForTraits(i2).postDelayedTask(i2, runnable, l2);
            } else {
                PostTask.nativePostDelayedTask(i2.a, i2.b, i2.c, i2.d, i2.e, runnable, l2);
            }
            return;
        }
    }

    public static void runOrPostTask(i i2, Runnable runnable) {
        if (PostTask.getTaskExecutorForTraits(i2).canRunTaskImmediately(i2)) {
            runnable.run();
        } else {
            PostTask.postTask(i2, runnable);
        }
    }

    @Deprecated
    public static <T> T runSynchronously(i i2, Callable<T> callable) {
        return PostTask.runSynchronouslyInternal(i2, new FutureTask<T>(callable));
    }

    @Deprecated
    public static void runSynchronously(i i2, Runnable runnable) {
        PostTask.runSynchronouslyInternal(i2, new FutureTask<Object>(runnable, null));
    }

    public static <T> T runSynchronouslyInternal(i i2, FutureTask<T> futureTask) {
        PostTask.runOrPostTask(i2, futureTask);
        try {
            return futureTask.get();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void registerTaskExecutor(int n2, TaskExecutor taskExecutor) {
        Object object = sLock;
        synchronized (object) {
            if (!$assertionsDisabled && n2 == 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n2 > 4) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && sTaskExecutors[n2] != null) {
                throw new AssertionError();
            }
            PostTask.sTaskExecutors[n2] = taskExecutor;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPrenativeThreadPoolExecutorForTesting(Executor executor) {
        Object object = sLock;
        synchronized (object) {
            sPrenativeThreadPoolExecutorOverride = executor;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPrenativeThreadPoolExecutorForTesting() {
        Object object = sLock;
        synchronized (object) {
            sPrenativeThreadPoolExecutorOverride = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Executor getPrenativeThreadPoolExecutor() {
        Object object = sLock;
        synchronized (object) {
            if (sPrenativeThreadPoolExecutorOverride != null) {
                return sPrenativeThreadPoolExecutorOverride;
            }
            return sPrenativeThreadPoolExecutor;
        }
    }

    public static boolean registerPreNativeTaskRunnerLocked(h h2) {
        Set<h> set = sPreNativeTaskRunners;
        if (set != null) {
            set.add(h2);
            return true;
        }
        return false;
    }

    public static TaskExecutor getTaskExecutorForTraits(i i2) {
        return sTaskExecutors[i2.d];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void onNativeSchedulerReady() {
        Object object = sLock;
        synchronized (object) {
            Iterator<h> iterator = sPreNativeTaskRunners.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    sPreNativeTaskRunners = null;
                    return;
                }
                iterator.next().initNativeTaskRunner();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onNativeSchedulerShutdown() {
        Object object = sLock;
        synchronized (object) {
            sPreNativeTaskRunners = Collections.newSetFromMap(new WeakHashMap());
            return;
        }
    }

    public static native void nativePostDelayedTask(boolean var0, int var1, boolean var2, byte var3, byte[] var4, Runnable var5, long var6);

    static {
        $assertionsDisabled = PostTask.class.desiredAssertionStatus() ^ true;
        sLock = new Object();
        sPreNativeTaskRunners = Collections.newSetFromMap(new WeakHashMap());
        sPrenativeThreadPoolExecutor = new b.b();
        sTaskExecutors = PostTask.getInitialTaskExecutors();
    }
}

