/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.library_loader;

import a.b.a.e;
import a.b.a.g;
import a.b.a.i;
import a.b.a.m.a;
import a.b.a.m.b;
import a.b.a.m.c;
import a.b.a.o.a;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.StrictMode;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.system.Os;
import com.vccorp.base.library_loader.Linker;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.chromium.base.BuildInfo;
import org.chromium.base.CommandLine;
import org.chromium.base.ContextUtils;
import org.chromium.base.SysUtils;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.base.task.PostTask;

@JNINamespace(value="base::android")
@MainDex
public class LibraryLoader {
    public static final String TAG = "LibraryLoader";
    public static final boolean DEBUG = false;
    public static final boolean PLATFORM_REQUIRES_NATIVE_FALLBACK_EXTRACTION;
    public static final String LIBRARY_DIR = "native_libraries";
    public static final String DONT_PREFETCH_LIBRARIES_KEY = "dont_prefetch_libraries";
    public static final String REACHED_CODE_PROFILER_ENABLED_KEY = "reached_code_profiler_enabled";
    public static final a.e sRelinkerCountHistogram;
    public static LibraryLoader sInstance;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public volatile boolean mInitialized;
    public final AtomicBoolean mPrefetchLibraryHasBeenCalled = new AtomicBoolean();
    public final Object mLock = new Object();
    public b mLibraryPreloader;
    public boolean mLibraryPreloaderCalled;
    public boolean mLoaded;
    public boolean mLoadedByZygote;
    public boolean mCommandLineSwitched;
    public boolean mIsUsingBrowserSharedRelros;
    public boolean mLoadAtFixedAddressFailed;
    public boolean mLibraryWasLoadedFromApk;
    public int mLibraryProcessType;
    public long mLibraryLoadTimeMs;
    public int mLibraryPreloaderStatus = -1;

    public static boolean useCrazyLinker() {
        return false;
    }

    public static boolean isInZipFile() {
        return false;
    }

    public static LibraryLoader getInstance() {
        return sInstance;
    }

    private void preloadAlreadyLocked(ApplicationInfo applicationInfo) {
        block8: {
            TraceEvent traceEvent = TraceEvent.scoped("LibraryLoader.preloadAlreadyLocked");
            try {
                if ($assertionsDisabled) break block8;
            }
            catch (Throwable throwable) {
                if (traceEvent != null) {
                    try {
                        traceEvent.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            if (!LibraryLoader.useCrazyLinker()) break block8;
            throw new AssertionError();
        }
        if (traceEvent != null) {
            traceEvent.close();
        }
    }

    public static void setDontPrefetchLibrariesOnNextRuns(boolean bl) {
        ContextUtils.getAppSharedPreferences().edit().putBoolean(DONT_PREFETCH_LIBRARIES_KEY, bl).apply();
    }

    public static boolean isNotPrefetchingLibraries() {
        boolean bl;
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            bl = ContextUtils.getAppSharedPreferences().getBoolean(DONT_PREFETCH_LIBRARIES_KEY, false);
        }
        catch (Throwable throwable) {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            throw throwable;
        }
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        return bl;
    }

    public static void setReachedCodeProfilerEnabledOnNextRuns(boolean bl) {
        ContextUtils.getAppSharedPreferences().edit().putBoolean(REACHED_CODE_PROFILER_ENABLED_KEY, bl).apply();
    }

    public static boolean isReachedCodeProfilerEnabled() {
        try (i i2 = i.g();){
            return ContextUtils.getAppSharedPreferences().getBoolean(REACHED_CODE_PROFILER_ENABLED_KEY, false);
        }
    }

    private void loadLibraryWithCustomLinkerAlreadyLocked(Linker objectArray, @Nullable String string2, String string3) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.mLock)) {
            throw new AssertionError();
        }
        if (objectArray.f()) {
            this.mIsUsingBrowserSharedRelros = true;
            try {
                objectArray.a(string3, true);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{};
                g.d(TAG, "Failed to load native library with shared RELRO, retrying without", objectArray);
                this.mLoadAtFixedAddressFailed = true;
                objectArray2.a(string3, false);
            }
        } else {
            objectArray.a(string3, true);
        }
        if (string2 != null) {
            this.mLibraryWasLoadedFromApk = true;
        }
    }

    public static void incrementRelinkerCountHitHistogram() {
        sRelinkerCountHistogram.a(1);
    }

    public static void incrementRelinkerCountNotHitHistogram() {
        sRelinkerCountHistogram.a(0);
    }

    public static String getExtractedLibraryPath(ApplicationInfo objectArray, String string2) {
        if (!$assertionsDisabled && !PLATFORM_REQUIRES_NATIVE_FALLBACK_EXTRACTION) {
            throw new AssertionError();
        }
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = string2;
        g.d(TAG, "Failed to load libName %s, attempting fallback extraction then trying again", objectArray);
        return LibraryLoader.extractFileIfStale((ApplicationInfo)objectArray2, LibraryLoader.makeLibraryPathInZipFile(string2, false, false), LibraryLoader.makeLibraryDirAndSetPermission());
    }

    /*
     * Exception decompiling
     */
    @SuppressLint(value={"DefaultLocale", "UnsafeDynamicallyLoadedCode"})
    private void loadAlreadyLocked(ApplicationInfo var1_4, boolean var2_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [46[FORLOOP]], but top level block is 20[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static String makeLibraryPathInZipFile(String string2, boolean bl, boolean bl2) {
        String string3;
        int n2 = a.b;
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) throw new RuntimeException("Unknown CPU ABI for native libraries");
                string3 = bl2 ? "x86_64" : "x86";
            } else {
                string3 = bl2 ? "mips64" : "mips";
            }
        } else {
            string3 = bl2 ? "arm64-v8a" : "armeabi-v7a";
        }
        String string4 = bl ? "crazy." : "";
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = string3;
        objectArray2[1] = string4;
        objectArray[2] = System.mapLibraryName(string2);
        return String.format("lib/%s/%s%s", objectArray2);
    }

    private void ensureCommandLineSwitchedAlreadyLocked() {
        if (!$assertionsDisabled && !this.mLoaded) {
            throw new AssertionError();
        }
        if (this.mCommandLineSwitched) {
            return;
        }
        CommandLine.enableNativeProxy();
        this.mCommandLineSwitched = true;
    }

    private void initializeAlreadyLocked(int n2) {
        if (objectArray4.mInitialized) {
            if (objectArray4.mLibraryProcessType == n2) {
                return;
            }
            throw new c(2);
        }
        objectArray4.mLibraryProcessType = n2;
        if (objectArray4.mLibraryProcessType == 1 && LibraryLoader.isReachedCodeProfilerEnabled()) {
            CommandLine.getInstance().appendSwitch("enable-reached-code-profiler");
        }
        Object[] objectArray = objectArray4;
        objectArray.ensureCommandLineSwitchedAlreadyLocked();
        if (objectArray4.nativeLibraryLoaded(objectArray.mLibraryProcessType)) {
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = "";
            objectArray2[1] = super.nativeGetVersionNumber();
            String string2 = String.format("Expected native library version number \"%s\", actual native library version number \"%s\"", objectArray3);
            objectArray3 = new Object[]{};
            g.c(TAG, string2, objectArray3);
            if ("".equals(super.nativeGetVersionNumber())) {
                TraceEvent.registerNativeEnabledObserver();
                if (n2 == 1 && PLATFORM_REQUIRES_NATIVE_FALLBACK_EXTRACTION) {
                    PostTask.postTask(a.b.a.q.i.f, () -> {
                        String string2 = BuildInfo.getInstance().extractedFileSuffix;
                        File[] fileArray = LibraryLoader.getLibraryDir().listFiles();
                        if (fileArray == null) {
                            return;
                        }
                        for (File file : fileArray) {
                            Object[] objectArray;
                            if (file.getName().contains(string2)) continue;
                            File file2 = file;
                            String string3 = file2.getName();
                            if (!file2.delete()) {
                                Object[] objectArray2 = new Object[1];
                                objectArray = objectArray2;
                                objectArray2[0] = string3;
                                g.d(TAG, "Unable to remove %s", objectArray);
                                continue;
                            }
                            Object[] objectArray3 = new Object[1];
                            objectArray = objectArray3;
                            objectArray3[0] = string3;
                            g.c(TAG, "Removed obsolete file %s", objectArray);
                        }
                    });
                }
                objectArray4.mInitialized = true;
                return;
            }
            throw new c(3);
        }
        Object[] objectArray4 = new Object[]{};
        g.b(TAG, "error calling nativeLibraryLoaded", objectArray4);
        throw new c(1);
    }

    private void recordBrowserProcessHistogramAlreadyLocked() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.mLock)) {
            throw new AssertionError();
        }
        if (LibraryLoader.useCrazyLinker()) {
            LibraryLoader libraryLoader = this;
            boolean bl = libraryLoader.mIsUsingBrowserSharedRelros;
            boolean bl2 = libraryLoader.mLoadAtFixedAddressFailed;
            int n2 = libraryLoader.mLibraryWasLoadedFromApk ? 3 : 0;
            this.nativeRecordChromiumAndroidLinkerBrowserHistogram(bl, bl2, n2, this.mLibraryLoadTimeMs);
        }
    }

    public static void setLibraryLoaderForTesting(LibraryLoader libraryLoader) {
        sInstance = libraryLoader;
    }

    public static void setEnvForNative() {
        if (a.b.a.c.c && Build.VERSION.SDK_INT >= 21) {
            try {
                Os.setenv((String)"UBSAN_OPTIONS", (String)"print_stacktrace=1 stack_trace_format='#%n pc %o %m' handle_segv=0 handle_sigbus=0 handle_sigfpe=0", (boolean)true);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = exception;
                g.d(TAG, "failed to set UBSAN_OPTIONS", objectArray2);
            }
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @SuppressLint(value={"SetWorldReadable"})
    public static String extractFileIfStale(ApplicationInfo object, String string2, File file) {
        File file22;
        block21: {
            File file3;
            if (!$assertionsDisabled && !PLATFORM_REQUIRES_NATIVE_FALLBACK_EXTRACTION) {
                throw new AssertionError();
            }
            object = object.sourceDir;
            Object object2 = new File(string2).getName() + BuildInfo.getInstance().extractedFileSuffix;
            file22 = file3;
            if (!new File(file, (String)object2).exists()) {
                void throwable;
                block20: {
                    block19: {
                        block18: {
                            ZipFile zipFile;
                            file = null;
                            object2 = zipFile;
                            String string3 = string2;
                            ((ZipFile)object2)((String)object);
                            object = zipFile.getEntry(string3);
                            if (object == null) break block18;
                            Object object3 = object2;
                            File file4 = file22;
                            File file5 = file4;
                            e.a(((ZipFile)object2).getInputStream((ZipEntry)object), file22, new byte[16384]);
                            file4.setReadable(true, false);
                            file5.setExecutable(true, false);
                            try {
                                ((ZipFile)object3).close();
                            }
                            catch (IOException iOException) {}
                            break block21;
                        }
                        try {
                            throw new RuntimeException("Cannot find ZipEntry" + string2);
                        }
                        catch (IOException iOException) {
                            break block19;
                        }
                        catch (Throwable throwable2) {
                            object2 = file;
                            break block20;
                        }
                        catch (IOException iOException) {
                            object2 = file;
                        }
                    }
                    try {
                        throw new RuntimeException((Throwable)object);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    try {
                        ((ZipFile)object2).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
        }
        return file22.getAbsolutePath();
    }

    public static File makeLibraryDirAndSetPermission() {
        if (!ContextUtils.isIsolatedProcess()) {
            File file;
            File file2 = ContextCompat.getCodeCacheDir((Context)ContextUtils.getApplicationContext());
            File file3 = file;
            File file4 = file2;
            file3(file2, LIBRARY_DIR);
            file4.mkdir();
            file4.setExecutable(true, false);
            file.mkdir();
            file.setExecutable(true, false);
        }
        return LibraryLoader.getLibraryDir();
    }

    public static File getLibraryDir() {
        return new File(ContextCompat.getCodeCacheDir((Context)ContextUtils.getApplicationContext()), LIBRARY_DIR);
    }

    private native boolean nativeLibraryLoaded(int var1);

    private native void nativeRecordChromiumAndroidLinkerBrowserHistogram(boolean var1, boolean var2, int var3, long var4);

    private native void nativeRecordLibraryPreloaderBrowserHistogram(int var1);

    private native void nativeRegisterChromiumAndroidLinkerRendererHistogram(boolean var1, boolean var2, long var3);

    private native void nativeRegisterLibraryPreloaderRendererHistogram(int var1);

    private native String nativeGetVersionNumber();

    public static native void nativeForkAndPrefetchNativeLibrary();

    public static native int nativePercentageOfResidentNativeLibraryCode();

    public static native void nativePeriodicallyCollectResidency();

    static {
        $assertionsDisabled = LibraryLoader.class.desiredAssertionStatus() ^ true;
        PLATFORM_REQUIRES_NATIVE_FALLBACK_EXTRACTION = Build.VERSION.SDK_INT <= 19;
        sRelinkerCountHistogram = new a.e("ChromiumAndroidLinker.RelinkerFallbackCount", 2);
        sInstance = new LibraryLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setNativeLibraryPreloader(b object) {
        object = this.mLock;
        synchronized (object) {
            if (!$assertionsDisabled && this.mLoaded) {
                throw new AssertionError();
            }
            return;
        }
    }

    public boolean isLoadedByZygote() {
        return this.mLoadedByZygote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ensureInitialized(int n2) {
        LibraryLoader libraryLoader = this;
        Object object = libraryLoader.mLock;
        synchronized (object) {
            if (libraryLoader.mInitialized) {
                return;
            }
            this.loadAlreadyLocked(ContextUtils.getApplicationContext().getApplicationInfo(), false);
            this.initializeAlreadyLocked(n2);
            return;
        }
    }

    public void preloadNow() {
        this.preloadNowOverrideApplicationContext(ContextUtils.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void preloadNowOverrideApplicationContext(Context context) {
        Object object = this.mLock;
        synchronized (object) {
            if (!LibraryLoader.useCrazyLinker()) {
                this.preloadAlreadyLocked(context.getApplicationInfo());
            }
            return;
        }
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public void loadNow() {
        this.loadNowOverrideApplicationContext(ContextUtils.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadNowOverrideApplicationContext(Context context) {
        LibraryLoader libraryLoader = this;
        Object object = libraryLoader.mLock;
        synchronized (object) {
            if (libraryLoader.mLoaded && context != ContextUtils.getApplicationContext()) {
                throw new IllegalStateException("Attempt to load again from alternate context.");
            }
            this.loadAlreadyLocked(context.getApplicationInfo(), false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadNowInZygote(ApplicationInfo applicationInfo) {
        Object object = this.mLock;
        synchronized (object) {
            if (!$assertionsDisabled && this.mLoaded) {
                throw new AssertionError();
            }
            this.loadAlreadyLocked(applicationInfo, true);
            this.mLoadedByZygote = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(int n2) {
        Object object = this.mLock;
        synchronized (object) {
            this.initializeAlreadyLocked(n2);
            return;
        }
    }

    public void asyncPrefetchLibrariesToMemory() {
        SysUtils.logPageFaultCountToTracing();
        if (LibraryLoader.isNotPrefetchingLibraries()) {
            return;
        }
        boolean bl = this.mPrefetchLibraryHasBeenCalled.compareAndSet(false, true);
        if (bl && CommandLine.getInstance().hasSwitch("log-native-library-residency")) {
            new Thread(LibraryLoader::nativePeriodicallyCollectResidency).start();
            return;
        }
        PostTask.postTask(a.b.a.q.i.h, () -> {
            TraceEvent traceEvent;
            block7: {
                Throwable throwable2;
                block6: {
                    int n2 = LibraryLoader.nativePercentageOfResidentNativeLibraryCode();
                    traceEvent = TraceEvent.scoped("LibraryLoader.asyncPrefetchLibrariesToMemory", Integer.toString(n2));
                    if (bl && n2 < 90) {
                        try {
                            LibraryLoader.nativeForkAndPrefetchNativeLibrary();
                        }
                        catch (Throwable throwable2) {
                            break block6;
                        }
                    }
                    if (n2 != -1) {
                        StringBuilder stringBuilder = new StringBuilder().append("LibraryLoader.PercentageOfResidentCodeBeforePrefetch");
                        String string2 = bl ? ".ColdStartup" : ".WarmStartup";
                        RecordHistogram.recordPercentageHistogram(stringBuilder.append(string2).toString(), n2);
                    }
                    break block7;
                }
                if (traceEvent == null) throw throwable2;
                try {
                    traceEvent.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            if (traceEvent == null) return;
            traceEvent.close();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchCommandLineForWebView() {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureCommandLineSwitchedAlreadyLocked();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNativeInitializationComplete() {
        Object object = this.mLock;
        synchronized (object) {
            this.recordBrowserProcessHistogramAlreadyLocked();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerRendererProcessHistogram(boolean bl, boolean bl2) {
        Object object = this.mLock;
        synchronized (object) {
            if (LibraryLoader.useCrazyLinker()) {
                this.nativeRegisterChromiumAndroidLinkerRendererHistogram(bl, bl2, this.mLibraryLoadTimeMs);
            }
            return;
        }
    }
}

