/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import a.a.a.a.a;
import android.text.TextUtils;
import android.util.Patterns;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PiiElider {
    public static final String EMAIL_ELISION = "XXX@EMAIL.ELIDED";
    public static final String URL_ELISION = "HTTP://WEBADDRESS.ELIDED";
    public static final String GOOD_IRI_CHAR = "a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef";
    public static final Pattern IP_ADDRESS = Pattern.compile("((25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[0-9]))");
    public static final String IRI = "[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]){0,1}";
    public static final String GOOD_GTLD_CHAR = "a-zA-Z\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef";
    public static final String GTLD = "[a-zA-Z\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{2,63}";
    public static final String HOST_NAME = "([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]){0,1}\\.)+[a-zA-Z\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{2,63}";
    public static final Pattern DOMAIN_NAME = Pattern.compile(a.a("(([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]){0,1}\\.)+[a-zA-Z\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{2,63}|").append(IP_ADDRESS).append(")").toString());
    public static final Pattern LIKELY_EXCEPTION_LOG = Pattern.compile("\\sat\\sorg\\.chromium\\.[^ ]+.");
    public static final Pattern WEB_URL = Pattern.compile(a.a("(?:\\b|^)((?:(http|https|Http|Https|rtsp|Rtsp):\\/\\/(?:(?:[a-zA-Z0-9\\$\\-\\_\\.\\+\\!\\*\\'\\(\\)\\,\\;\\?\\&\\=]|(?:\\%[a-fA-F0-9]{2})){1,64}(?:\\:(?:[a-zA-Z0-9\\$\\-\\_\\.\\+\\!\\*\\'\\(\\)\\,\\;\\?\\&\\=]|(?:\\%[a-fA-F0-9]{2})){1,25})?\\@)?)?(?:").append(DOMAIN_NAME).append(")(?:\\:\\d{1,5})?)(\\/(?:(?:[").append("a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef").append("\\;\\/\\?\\:\\@\\&\\=\\#\\~\\-\\.\\+\\!\\*\\'\\(\\)\\,\\_])|(?:\\%[a-fA-F0-9]{2}))*)?(?:\\b|$)").toString());
    public static final String IP_ELISION = "1.2.3.4";
    public static final String MAC_ELISION = "01:23:45:67:89:AB";
    public static final String CONSOLE_ELISION = "[ELIDED:CONSOLE(0)] ELIDED CONSOLE MESSAGE";
    public static final Pattern MAC_ADDRESS = Pattern.compile("([0-9a-fA-F]{2}[-:]+){5}[0-9a-fA-F]{2}");
    public static final Pattern CONSOLE_MSG = Pattern.compile("\\[\\w*:CONSOLE.*\\].*");
    public static final String[] APP_NAMESPACE = new String[]{"com.vccorp.", "com.google."};
    public static final String[] SYSTEM_NAMESPACE = new String[]{"android.accessibilityservice", "android.accounts", "android.animation", "android.annotation", "android.app", "android.appwidget", "android.bluetooth", "android.content", "android.database", "android.databinding", "android.drm", "android.gesture", "android.graphics", "android.hardware", "android.inputmethodservice", "android.location", "android.media", "android.mtp", "android.net", "android.nfc", "android.opengl", "android.os", "android.preference", "android.print", "android.printservice", "android.provider", "android.renderscript", "android.sax", "android.security", "android.service", "android.speech", "android.support", "android.system", "android.telecom", "android.telephony", "android.test", "android.text", "android.transition", "android.util", "android.view", "android.webkit", "android.widget", "com.android.", "dalvik.", "java.", "javax.", "org.apache.", "org.json.", "org.w3c.dom.", "org.xml.", "org.xmlpull."};

    public static String elideEmail(String string2) {
        return Patterns.EMAIL_ADDRESS.matcher(string2).replaceAll(EMAIL_ELISION);
    }

    public static String elideUrl(String object) {
        StringBuilder stringBuilder;
        if (LIKELY_EXCEPTION_LOG.matcher((CharSequence)object).find()) {
            return object;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder((String)object);
        object = WEB_URL.matcher(stringBuilder2);
        int n2 = 0;
        while (((Matcher)object).find(n2)) {
            int n3;
            n2 = ((Matcher)object).start();
            String string2 = stringBuilder2.substring(n2, n3 = ((Matcher)object).end());
            if (!PiiElider.likelyToBeAppNamespace(string2) && !PiiElider.likelyToBeSystemNamespace(string2)) {
                stringBuilder2.replace(n2, n3, URL_ELISION);
                n3 = n2 + 24;
                object = WEB_URL.matcher(stringBuilder2);
            }
            n2 = n3;
        }
        return stringBuilder2.toString();
    }

    public static boolean likelyToBeAppNamespace(String string2) {
        String[] stringArray = APP_NAMESPACE;
        int n2 = APP_NAMESPACE.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string2.startsWith(stringArray[i2])) continue;
            return true;
        }
        return false;
    }

    public static boolean likelyToBeSystemNamespace(String string2) {
        String[] stringArray = SYSTEM_NAMESPACE;
        int n2 = SYSTEM_NAMESPACE.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string2.startsWith(stringArray[i2])) continue;
            return true;
        }
        return false;
    }

    public static String elideIp(String string2) {
        return Patterns.IP_ADDRESS.matcher(string2).replaceAll(IP_ELISION);
    }

    public static String elideMac(String string2) {
        return MAC_ADDRESS.matcher(string2).replaceAll(MAC_ELISION);
    }

    public static String elideConsole(String string2) {
        return CONSOLE_MSG.matcher(string2).replaceAll(CONSOLE_ELISION);
    }

    public static String sanitizeStacktrace(String objectArray) {
        Object[] objectArray2 = objectArray.split("\\n");
        objectArray = objectArray2;
        objectArray2[0] = PiiElider.elideUrl(objectArray2[0]);
        for (int i2 = 1; i2 < objectArray.length; ++i2) {
            if (!objectArray[i2].startsWith("Caused by:")) continue;
            objectArray[i2] = PiiElider.elideUrl((String)objectArray[i2]);
        }
        return TextUtils.join((CharSequence)"\n", (Object[])objectArray);
    }
}

