/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import a.b.a.c;
import a.b.a.h;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.AnyThread;
import android.support.annotation.GuardedBy;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.view.Window;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class ApplicationStatus {
    public static final String TOOLBAR_CALLBACK_INTERNAL_WRAPPER_CLASS = "android.support.v7.internal.app.ToolbarActionBar$ToolbarCallbackWrapper";
    public static final String TOOLBAR_CALLBACK_WRAPPER_CLASS = "android.support.v7.app.ToolbarActionBar$ToolbarCallbackWrapper";
    public static final String WINDOW_PROFILER_CALLBACK = "com.android.tools.profiler.support.event.WindowProfilerCallback";
    public static final Map<Activity, ActivityInfo> sActivityInfo;
    @SuppressLint(value={"SupportAnnotationUsage"})
    @GuardedBy(value="sActivityInfo")
    public static int sCurrentApplicationState;
    @SuppressLint(value={"StaticFieldLeak"})
    public static Activity sActivity;
    public static ApplicationStateListener sNativeApplicationStateListener;
    public static final h<ActivityStateListener> sGeneralActivityStateListeners;
    public static final h<ApplicationStateListener> sApplicationStateListeners;
    public static final h<WindowFocusChangedListener> sWindowFocusListeners;
    public static final /* synthetic */ boolean $assertionsDisabled;

    @MainThread
    public static void registerWindowFocusChangedListener(WindowFocusChangedListener windowFocusChangedListener) {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        sWindowFocusListeners.a(windowFocusChangedListener);
    }

    @MainThread
    public static void unregisterWindowFocusChangedListener(WindowFocusChangedListener windowFocusChangedListener) {
        sWindowFocusListeners.b(windowFocusChangedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            boolean bl = sCurrentApplicationState != 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public static void initialize(Application object) {
        if (!$assertionsDisabled && ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        Object object2 = object;
        object = sActivityInfo;
        synchronized (object) {
            sCurrentApplicationState = 4;
        }
        ApplicationStatus.registerWindowFocusChangedListener(new WindowFocusChangedListener(){

            @Override
            public void onWindowFocusChanged(Activity activity, boolean bl) {
                if (bl && activity != sActivity) {
                    int n2 = ApplicationStatus.getStateForActivity(activity);
                    if (n2 != 6 && n2 != 5) {
                        sActivity = activity;
                    }
                    return;
                }
            }
        });
        object2.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){
            public static final /* synthetic */ boolean $assertionsDisabled;

            private void checkCallback(Activity activity) {
                if (c.b) {
                    Class<?> clazz = activity.getWindow().getCallback().getClass();
                    if (!($assertionsDisabled || Proxy.isProxyClass(clazz) || clazz.getName().equals(ApplicationStatus.TOOLBAR_CALLBACK_WRAPPER_CLASS) || clazz.getName().equals(ApplicationStatus.TOOLBAR_CALLBACK_INTERNAL_WRAPPER_CLASS) || clazz.getName().equals(ApplicationStatus.WINDOW_PROFILER_CALLBACK))) {
                        throw new AssertionError();
                    }
                }
            }

            static {
                $assertionsDisabled = ApplicationStatus.class.desiredAssertionStatus() ^ true;
            }

            public void onActivityCreated(Activity activity, Bundle bundle) {
                Activity activity2 = activity;
                ApplicationStatus.onStateChange(activity2, 1);
                2 this_ = activity2.getWindow().getCallback();
                activity2.getWindow().setCallback((Window.Callback)Proxy.newProxyInstance(Window.Callback.class.getClassLoader(), new Class[]{Window.Callback.class}, (InvocationHandler)new WindowCallbackProxy(activity, (Window.Callback)this_)));
            }

            public void onActivityDestroyed(Activity activity) {
                Activity activity2 = activity;
                ApplicationStatus.onStateChange(activity2, 6);
                this.checkCallback(activity2);
            }

            public void onActivityPaused(Activity activity) {
                Activity activity2 = activity;
                ApplicationStatus.onStateChange(activity2, 4);
                this.checkCallback(activity2);
            }

            public void onActivityResumed(Activity activity) {
                Activity activity2 = activity;
                ApplicationStatus.onStateChange(activity2, 3);
                this.checkCallback(activity2);
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                this.checkCallback(activity);
            }

            public void onActivityStarted(Activity activity) {
                Activity activity2 = activity;
                ApplicationStatus.onStateChange(activity2, 2);
                this.checkCallback(activity2);
            }

            public void onActivityStopped(Activity activity) {
                Activity activity2 = activity;
                ApplicationStatus.onStateChange(activity2, 5);
                this.checkCallback(activity2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void onStateChange(Activity var0, int var1_2) {
        block15: {
            if (var0 == null) break block15;
            if (ApplicationStatus.sActivity == null || var1_2 == 1 || var1_2 == 3 || var1_2 == 2) {
                ApplicationStatus.sActivity = var0;
            }
            var2_4 = ApplicationStatus.getStateForApplication();
            var3_5 = ApplicationStatus.sActivityInfo;
            synchronized (var3_5) {
                block16: {
                    if (var1_2 != 1) break block16;
                    if (ApplicationStatus.$assertionsDisabled) ** GOTO lbl14
                    if (!ApplicationStatus.sActivityInfo.containsKey(var0)) ** GOTO lbl14
                    throw new AssertionError();
lbl14:
                    // 2 sources

                    ApplicationStatus.sActivityInfo.put(var0, new ActivityInfo(null));
                }
                v0 = var1_2;
                var4_6 = ApplicationStatus.sActivityInfo.get(var0);
                var4_6.setStatus(var1_2);
                if (v0 != 6) ** GOTO lbl31
                v1 = var0;
                ApplicationStatus.sActivityInfo.remove(var0);
                if (v1 != ApplicationStatus.sActivity) ** GOTO lbl31
                ApplicationStatus.sActivity = null;
lbl31:
                // 3 sources

                ApplicationStatus.sCurrentApplicationState = ApplicationStatus.determineApplicationStateLocked();
                // MONITOREXIT @DISABLED, blocks:[7, 8] lbl31 : MonitorExitStatement: MONITOREXIT : var3_5
                var3_5 = var4_6.getListeners().iterator();
            }
            while (var3_5.hasNext()) {
                ((ActivityStateListener)var3_5.next()).onActivityStateChange(var0, var1_2);
            }
            var3_5 = ApplicationStatus.sGeneralActivityStateListeners.iterator();
            while (var3_5.hasNext()) {
                var3_5.next().onActivityStateChange(var0, var1_2);
            }
            var0_1 = ApplicationStatus.getStateForApplication();
            if (var0_1 != var2_4) {
                var1_3 = ApplicationStatus.sApplicationStateListeners.iterator();
                while (var1_3.hasNext()) {
                    var1_3.next().onApplicationStateChange(var0_1);
                }
            }
            return;
            {
                catch (Throwable v2) {
                    throw v2;
                }
            }
        }
        throw new IllegalArgumentException("null activity is not supported");
    }

    @MainThread
    public static void onStateChangeForTesting(Activity activity, int n2) {
        ApplicationStatus.onStateChange(activity, n2);
    }

    @MainThread
    public static Activity getLastTrackedFocusedActivity() {
        return sActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public static List<Activity> getRunningActivities() {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            return new ArrayList<Activity>(sActivityInfo.keySet());
        }
    }

    @AnyThread
    public static int getStateForActivity(@Nullable Activity object) {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        if (object == null) {
            return 6;
        }
        return (object = sActivityInfo.get(object)) != null ? ((ActivityInfo)object).getStatus() : 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public static int getStateForApplication() {
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            return sCurrentApplicationState;
        }
    }

    @AnyThread
    public static boolean hasVisibleActivities() {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        int n2 = ApplicationStatus.getStateForApplication();
        return n2 == 1 || n2 == 2;
    }

    @AnyThread
    public static boolean isEveryActivityDestroyed() {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        return sActivityInfo.isEmpty();
    }

    @MainThread
    public static void registerStateListenerForAllActivities(ActivityStateListener activityStateListener) {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        sGeneralActivityStateListeners.a(activityStateListener);
    }

    @MainThread
    @SuppressLint(value={"NewApi"})
    public static void registerStateListenerForActivity(ActivityStateListener activityStateListener, Activity object) {
        if (!$assertionsDisabled && !ApplicationStatus.isInitialized()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        object = sActivityInfo.get(object);
        if (!$assertionsDisabled && ((ActivityInfo)object).getStatus() == 6) {
            throw new AssertionError();
        }
        ((ActivityInfo)object).getListeners().a(activityStateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void unregisterActivityStateListener(ActivityStateListener activityStateListener) {
        sGeneralActivityStateListeners.b(activityStateListener);
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            Iterator<ActivityInfo> iterator = sActivityInfo.values().iterator();
            while (true) {
                if (!iterator.hasNext()) break;
                iterator.next().getListeners().b(activityStateListener);
            }
            return;
        }
    }

    @MainThread
    public static void registerApplicationStateListener(ApplicationStateListener applicationStateListener) {
        sApplicationStateListeners.a(applicationStateListener);
    }

    @MainThread
    public static void unregisterApplicationStateListener(ApplicationStateListener applicationStateListener) {
        sApplicationStateListeners.b(applicationStateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void destroyForJUnitTests() {
        Map<Activity, ActivityInfo> map = sActivityInfo;
        synchronized (map) {
            sApplicationStateListeners.a();
            sGeneralActivityStateListeners.a();
            sActivityInfo.clear();
            sWindowFocusListeners.a();
            sCurrentApplicationState = 0;
            sActivity = null;
            sNativeApplicationStateListener = null;
            return;
        }
    }

    public static void registerThreadSafeNativeApplicationStateListener() {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (sNativeApplicationStateListener != null) {
                    return;
                }
                sNativeApplicationStateListener = new ApplicationStateListener(){

                    @Override
                    public void onApplicationStateChange(int n2) {
                        ApplicationStatus.nativeOnApplicationStateChange(n2);
                    }
                };
                ApplicationStatus.registerApplicationStateListener(sNativeApplicationStateListener);
            }
        });
    }

    @GuardedBy(value="sActivityInfo")
    public static int determineApplicationStateLocked() {
        boolean bl = false;
        boolean bl2 = false;
        Iterator<ActivityInfo> iterator = sActivityInfo.values().iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next().getStatus();
            if (n2 != 4 && n2 != 5 && n2 != 6) {
                return 1;
            }
            if (n2 == 4) {
                bl = true;
                continue;
            }
            if (n2 != 5) continue;
            bl2 = true;
        }
        if (bl) {
            return 2;
        }
        if (bl2) {
            return 3;
        }
        return 4;
    }

    public static native void nativeOnApplicationStateChange(int var0);

    static {
        $assertionsDisabled = ApplicationStatus.class.desiredAssertionStatus() ^ true;
        sActivityInfo = Collections.synchronizedMap(new HashMap());
        sCurrentApplicationState = 0;
        sGeneralActivityStateListeners = new h();
        sApplicationStateListeners = new h();
        sWindowFocusListeners = new h();
    }

    public static class WindowCallbackProxy
    implements InvocationHandler {
        public final Window.Callback mCallback;
        public final Activity mActivity;

        public WindowCallbackProxy(Activity activity, Window.Callback callback) {
            this.mCallback = callback;
            this.mActivity = activity;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) {
            if (method.getName().equals("onWindowFocusChanged") && objectArray.length == 1 && objectArray[0] instanceof Boolean) {
                this.onWindowFocusChanged((Boolean)objectArray[0]);
                return null;
            }
            try {
                return method.invoke((Object)this.mCallback, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof AbstractMethodError) {
                    throw invocationTargetException.getCause();
                }
                throw invocationTargetException;
            }
        }

        public void onWindowFocusChanged(boolean bl) {
            this.mCallback.onWindowFocusChanged(bl);
            Iterator iterator = sWindowFocusListeners.iterator();
            while (iterator.hasNext()) {
                ((WindowFocusChangedListener)iterator.next()).onWindowFocusChanged(this.mActivity, bl);
            }
        }
    }

    public static interface WindowFocusChangedListener {
        public void onWindowFocusChanged(Activity var1, boolean var2);
    }

    public static interface ActivityStateListener {
        public void onActivityStateChange(Activity var1, int var2);
    }

    public static interface ApplicationStateListener {
        public void onApplicationStateChange(int var1);
    }

    public static class ActivityInfo {
        public int mStatus = 6;
        public h<ActivityStateListener> mListeners = new h();

        public ActivityInfo() {
        }

        public /* synthetic */ ActivityInfo(1 var1_1) {
            this();
        }

        public int getStatus() {
            return this.mStatus;
        }

        public void setStatus(int n2) {
            this.mStatus = n2;
        }

        public h<ActivityStateListener> getListeners() {
            return this.mListeners;
        }
    }
}

