/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import a.b.a.j;
import a.b.a.l;
import a.b.p.a.e;
import a.b.p.b.a;
import a.b.p.d.a;
import a.b.p.d.b;
import a.b.p.e.f;
import a.b.p.m;
import a.b.p.q;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.chromium.base.BuildInfo;
import org.chromium.base.Callback;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="ui")
public class WindowAndroid
implements e,
a.a {
    public static final String TAG = "WindowAndroid";
    public static final float MAX_REFRESH_RATE_DELTA = 2.0f;
    public static final String WINDOW_CALLBACK_ERRORS = "window_callback_errors";
    public static final int START_INTENT_FAILURE = -1;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public m mKeyboardVisibilityDelegate;
    public long mNativeWindowAndroid;
    public final q mVSyncMonitor;
    public final a.b.p.b.a mDisplayAndroid;
    public boolean mWindowisWideColorGamut;
    public SparseArray<IntentCallback> mOutstandingIntents;
    public WeakReference<Context> mContextRef;
    public HashMap<Integer, String> mIntentErrors;
    public HashSet<Animator> mAnimationsOverContent;
    public View mAnimationPlaceholderView;
    public final AccessibilityManager mAccessibilityManager;
    public boolean mIsTouchExplorationEnabled;
    public TouchExplorationMonitor mTouchExplorationMonitor;
    public e mPermissionDelegate;
    public boolean mPendingVSyncRequest;
    public boolean mVSyncPaused;
    public List<Display.Mode> mSupportedRefreshRateModes;
    public l<ActivityStateObserver> mActivityStateObservers;
    public final l<OnCloseContextMenuListener> mContextMenuCloseListeners;
    public final q.a mVSyncListener;
    public final a mCursorObserver;

    public static Activity activityFromContext(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return WindowAndroid.activityFromContext(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    public WindowAndroid(Context context) {
        Context context2 = context;
        this(context2, a.b.p.b.a.a(context2));
    }

    @SuppressLint(value={"UseSparseArrays"})
    public WindowAndroid(Context object, a.b.p.b.a a2) {
        Throwable throwable;
        a.b.a.m m2;
        block13: {
            Throwable throwable22;
            block12: {
                this.mKeyboardVisibilityDelegate = m.a;
                this.mAnimationsOverContent = new HashSet();
                this.mActivityStateObservers = new l();
                this.mContextMenuCloseListeners = new l();
                this.mVSyncListener = new q.a(){

                    @Override
                    public void onVSync(q q2, long l2) {
                        if (WindowAndroid.this.mVSyncPaused) {
                            WindowAndroid.access$402(WindowAndroid.this, true);
                            return;
                        }
                        if (WindowAndroid.this.mNativeWindowAndroid != 0L) {
                            WindowAndroid windowAndroid = WindowAndroid.this;
                            windowAndroid.nativeOnVSync(windowAndroid.mNativeWindowAndroid, l2, WindowAndroid.this.mVSyncMonitor.b());
                        }
                    }
                };
                this.mCursorObserver = new a(){

                    public void onCursorVisibilityChanged(boolean bl) {
                        if (WindowAndroid.this.mNativeWindowAndroid != 0L) {
                            WindowAndroid windowAndroid = WindowAndroid.this;
                            windowAndroid.nativeOnCursorVisibilityChanged(windowAndroid.mNativeWindowAndroid, bl);
                        }
                    }

                    public void onFallbackCursorModeToggled(boolean bl) {
                        if (WindowAndroid.this.mNativeWindowAndroid != 0L) {
                            WindowAndroid windowAndroid = WindowAndroid.this;
                            windowAndroid.nativeOnFallbackCursorModeToggled(windowAndroid.mNativeWindowAndroid, bl);
                        }
                    }
                };
                this.mContextRef = new WeakReference<Context>((Context)object);
                this.mOutstandingIntents = new SparseArray();
                this.mIntentErrors = new HashMap();
                this.mDisplayAndroid = a2;
                this.mDisplayAndroid.c.put(this, null);
                if (Build.VERSION.SDK_INT >= 23) {
                    this.recomputeSupportedRefreshRates();
                }
                m2 = a.b.a.m.g();
                WindowAndroid windowAndroid = this;
                Throwable throwable3 = null;
                windowAndroid.mVSyncMonitor = new q((Context)object, this.mVSyncListener, this.mDisplayAndroid.j);
                Context context = ContextUtils.sApplicationContext;
                try {
                    windowAndroid.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
                    m2.close();
                }
                catch (Throwable throwable22) {
                    break block12;
                }
                catch (Throwable throwable4) {
                    object = throwable4;
                    throwable = throwable3;
                    break block13;
                }
                if (Build.VERSION.SDK_INT >= 26 && !Build.VERSION.RELEASE.equals("8.0.0") && WindowAndroid.activityFromContext(object) != null) {
                    object = object.getResources().getConfiguration().isScreenWideColorGamut();
                    a2.a(null, null, null, null, null, null, (Boolean)object, null, null, null);
                }
                return;
            }
            try {
                throw throwable22;
            }
            catch (Throwable throwable5) {
                // empty catch block
            }
        }
        if (throwable != null) {
            try {
                m2.close();
            }
            catch (Throwable throwable6) {
                throwable.addSuppressed(throwable6);
            }
        } else {
            m2.close();
        }
        throw object;
    }

    public static long createForTesting() {
        Context context = ContextUtils.sApplicationContext;
        return new WindowAndroid(context, a.b.p.b.a.a(context)).getNativePointer();
    }

    private void clearNativePointer() {
        this.mNativeWindowAndroid = 0L;
    }

    private void requestVSyncUpdate() {
        if (this.mVSyncPaused) {
            this.mPendingVSyncRequest = true;
            return;
        }
        this.mVSyncMonitor.c();
    }

    private long getNativePointer() {
        if (this.mNativeWindowAndroid == 0L) {
            WindowAndroid windowAndroid = this;
            windowAndroid.mNativeWindowAndroid = windowAndroid.nativeInit(windowAndroid.mDisplayAndroid.d, this.getMouseWheelScrollFactor(), this.getWindowIsWideColorGamut());
            windowAndroid.nativeSetVSyncPaused(windowAndroid.mNativeWindowAndroid, this.mVSyncPaused);
        }
        return this.mNativeWindowAndroid;
    }

    private float getMouseWheelScrollFactor() {
        TypedValue typedValue;
        WindowAndroid windowAndroid = windowAndroid2;
        WindowAndroid windowAndroid2 = typedValue;
        typedValue = new TypedValue();
        Context context = (Context)windowAndroid.getContext().get();
        if (context != null && context.getTheme().resolveAttribute(16842829, (TypedValue)windowAndroid2, true)) {
            return windowAndroid2.getDimension(context.getResources().getDisplayMetrics());
        }
        return 0.0f;
    }

    private Window getWindow() {
        WindowAndroid windowAndroid = WindowAndroid.activityFromContext((Context)windowAndroid.mContextRef.get());
        if (windowAndroid == null) {
            return null;
        }
        return windowAndroid.getWindow();
    }

    private boolean getWindowIsWideColorGamut() {
        if (!BuildInfo.isAtLeastQ()) {
            return false;
        }
        if ((this = this.getWindow()) == null) {
            return false;
        }
        return this.isWideColorGamut();
    }

    private void refreshWillNotDraw() {
        boolean bl = !this.mIsTouchExplorationEnabled && this.mAnimationsOverContent.isEmpty();
        if (this.mAnimationPlaceholderView.willNotDraw() != bl) {
            this.mAnimationPlaceholderView.setWillNotDraw(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"NewApi"})
    @TargetApi(value=23)
    private void recomputeSupportedRefreshRates() {
        ArrayList<Display.Mode> arrayList;
        Display.Mode mode = this.mDisplayAndroid.k;
        if (!$assertionsDisabled && mode == null) {
            throw new AssertionError();
        }
        List<Display.Mode> list = this.mDisplayAndroid.l;
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && list.size() <= 0) {
            throw new AssertionError();
        }
        ArrayList<Display.Mode> arrayList2 = arrayList;
        arrayList = new ArrayList<Display.Mode>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!mode.equals((Object)list.get(i2)) && (mode.getPhysicalWidth() != list.get(i2).getPhysicalWidth() || mode.getPhysicalHeight() != list.get(i2).getPhysicalHeight() || mode.getRefreshRate() == list.get(i2).getRefreshRate())) continue;
            arrayList2.add(list.get(i2));
        }
        if (arrayList2.equals(this.mSupportedRefreshRateModes) ^ true) {
            this.mSupportedRefreshRateModes = arrayList2;
            long l2 = this.mNativeWindowAndroid;
            if (l2 != 0L) {
                this.nativeOnSupportedRefreshRatesUpdated(l2, this.getSupportedRefreshRates());
            }
        }
    }

    private float getRefreshRate() {
        return this.mDisplayAndroid.j;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=23)
    private float[] getSupportedRefreshRates() {
        List<Display.Mode> list = this.mSupportedRefreshRateModes;
        if (list == null) {
            return null;
        }
        list = (List<Display.Mode>)new float[list.size()];
        for (int i2 = 0; i2 < this.mSupportedRefreshRateModes.size(); ++i2) {
            list[i2] = this.mSupportedRefreshRateModes.get(i2).getRefreshRate();
        }
        return list;
    }

    @SuppressLint(value={"NewApi"})
    private void setPreferredRefreshRate(float f2) {
        Object[] objectArray;
        if (objectArray.mSupportedRefreshRateModes == null) {
            return;
        }
        Display.Mode mode = null;
        float f3 = Float.MAX_VALUE;
        for (int i2 = 0; i2 < objectArray.mSupportedRefreshRateModes.size(); ++i2) {
            float f4;
            Display.Mode mode2 = objectArray.mSupportedRefreshRateModes.get(i2);
            float f5 = Math.abs(f2 - mode2.getRefreshRate());
            if (!(f4 < f3)) {
                f5 = f3;
                mode2 = mode;
            }
            mode = mode2;
            f3 = f5;
        }
        if (f3 > 2.0f) {
            objectArray = new Object[]{};
            j.b(TAG, "Refresh rate not supported : " + f2, objectArray);
            return;
        }
        objectArray = objectArray.getWindow();
        WindowManager.LayoutParams layoutParams = objectArray.getAttributes();
        if (layoutParams.preferredDisplayModeId == mode.getModeId()) {
            return;
        }
        layoutParams.preferredDisplayModeId = mode.getModeId();
        objectArray.setAttributes(layoutParams);
    }

    private native long nativeInit(int var1, float var2, boolean var3);

    private native void nativeOnVSync(long var1, long var3, long var5);

    private native void nativeOnVisibilityChanged(long var1, boolean var3);

    private native void nativeOnActivityStopped(long var1);

    private native void nativeOnActivityStarted(long var1);

    private native void nativeSetVSyncPaused(long var1, boolean var3);

    private native void nativeOnUpdateRefreshRate(long var1, float var3);

    private native void nativeDestroy(long var1);

    private native void nativeOnCursorVisibilityChanged(long var1, boolean var3);

    private native void nativeOnFallbackCursorModeToggled(long var1, boolean var3);

    private native void nativeOnSupportedRefreshRatesUpdated(long var1, float[] var3);

    public static /* synthetic */ boolean access$002(WindowAndroid windowAndroid, boolean bl) {
        windowAndroid.mIsTouchExplorationEnabled = bl;
        return bl;
    }

    public static /* synthetic */ boolean access$402(WindowAndroid windowAndroid, boolean bl) {
        windowAndroid.mPendingVSyncRequest = bl;
        return bl;
    }

    static {
        $assertionsDisabled = WindowAndroid.class.desiredAssertionStatus() ^ true;
    }

    public View getReadbackView() {
        return null;
    }

    public boolean isInsideVSync() {
        return this.mVSyncMonitor.b;
    }

    public long getVsyncPeriodInMillis() {
        return this.mVSyncMonitor.b() / 1000L;
    }

    public void setAndroidPermissionDelegate(e e2) {
        this.mPermissionDelegate = e2;
    }

    public boolean showIntent(PendingIntent pendingIntent, IntentCallback intentCallback, Integer n2) {
        return this.showCancelableIntent(pendingIntent, intentCallback, n2) >= 0;
    }

    public boolean showIntent(Intent intent, IntentCallback intentCallback, Integer n2) {
        return this.showCancelableIntent(intent, intentCallback, n2) >= 0;
    }

    public int showCancelableIntent(PendingIntent pendingIntent, IntentCallback intentCallback, Integer n2) {
        j.a(TAG, "Can't show intent as context is not an Activity: " + pendingIntent);
        return -1;
    }

    public int showCancelableIntent(Intent intent, IntentCallback intentCallback, Integer n2) {
        j.a(TAG, "Can't show intent as context is not an Activity: " + intent);
        return -1;
    }

    public int showCancelableIntent(Callback<Integer> callback, IntentCallback intentCallback, Integer n2) {
        j.a(TAG, "Can't show intent as context is not an Activity");
        return -1;
    }

    public void cancelIntent(int n2) {
        j.a(TAG, "Can't cancel intent as context is not an Activity: " + n2);
    }

    public boolean removeIntentCallback(IntentCallback intentCallback) {
        int n2 = this.mOutstandingIntents.indexOfValue((Object)intentCallback);
        if (n2 < 0) {
            return false;
        }
        WindowAndroid windowAndroid = this;
        windowAndroid.mOutstandingIntents.remove(n2);
        windowAndroid.mIntentErrors.remove(n2);
        return true;
    }

    @Override
    public final boolean hasPermission(String string2) {
        e e2 = ((WindowAndroid)e2).mPermissionDelegate;
        if (e2 != null) {
            return e2.hasPermission(string2);
        }
        return a.b.a.a.a(ContextUtils.sApplicationContext, string2, Process.myPid(), Process.myUid()) == 0;
    }

    @Override
    public final boolean canRequestPermission(String string2) {
        e e2 = ((WindowAndroid)e2).mPermissionDelegate;
        if (e2 != null) {
            return e2.canRequestPermission(string2);
        }
        e2 = new Object[]{};
        j.d(TAG, "Cannot determine the request permission state as the context is not an Activity", (Object[])e2);
        if ($assertionsDisabled) {
            return false;
        }
        throw new AssertionError((Object)"Failed to determine the request permission state using a WindowAndroid without an Activity");
    }

    @Override
    public final boolean isPermissionRevokedByPolicy(String string2) {
        e e2 = ((WindowAndroid)e2).mPermissionDelegate;
        if (e2 != null) {
            return e2.isPermissionRevokedByPolicy(string2);
        }
        e2 = new Object[]{};
        j.d(TAG, "Cannot determine the policy permission state as the context is not an Activity", (Object[])e2);
        if ($assertionsDisabled) {
            return false;
        }
        throw new AssertionError((Object)"Failed to determine the policy permission state using a WindowAndroid without an Activity");
    }

    @Override
    public final void requestPermissions(String[] stringArray, a.b.p.a.f f2) {
        Object object = object.mPermissionDelegate;
        if (object != null) {
            object.requestPermissions(stringArray, f2);
            return;
        }
        object = new Object[]{};
        j.d(TAG, "Cannot request permissions as the context is not an Activity", object);
        if ($assertionsDisabled) {
            return;
        }
        throw new AssertionError((Object)"Failed to request permissions using a WindowAndroid without an Activity");
    }

    @Override
    public boolean handlePermissionResult(int n2, String[] stringArray, int[] nArray) {
        e e2 = ((WindowAndroid)e2).mPermissionDelegate;
        if (e2 != null) {
            return e2.handlePermissionResult(n2, stringArray, nArray);
        }
        return false;
    }

    public void showError(String string2) {
        if (string2 != null) {
            f.a((Context)ContextUtils.sApplicationContext, (CharSequence)string2, (int)0).a.show();
        }
    }

    public void showError(int n2) {
        this.showError(ContextUtils.sApplicationContext.getString(n2));
    }

    public void showCallbackNonExistentError(String string2) {
        this.showError(string2);
    }

    public void sendBroadcast(Intent intent) {
        ContextUtils.sApplicationContext.sendBroadcast(intent);
    }

    public a.b.p.b.a getDisplay() {
        return this.mDisplayAndroid;
    }

    public WeakReference<Activity> getActivity() {
        return new WeakReference<Object>(null);
    }

    public Context getApplicationContext() {
        return ContextUtils.sApplicationContext;
    }

    public void saveInstanceState(Bundle bundle) {
        bundle.putSerializable(WINDOW_CALLBACK_ERRORS, this.mIntentErrors);
    }

    public void restoreInstanceState(Bundle object) {
        if (object == null) {
            return;
        }
        if ((object = object.getSerializable(WINDOW_CALLBACK_ERRORS)) instanceof HashMap) {
            this.mIntentErrors = (HashMap)object;
        }
    }

    public void onVisibilityChanged(boolean bl) {
        long l2 = this.mNativeWindowAndroid;
        if (l2 == 0L) {
            return;
        }
        this.nativeOnVisibilityChanged(l2, bl);
    }

    public void onActivityStopped() {
        long l2 = this.mNativeWindowAndroid;
        if (l2 == 0L) {
            return;
        }
        this.nativeOnActivityStopped(l2);
    }

    public void onActivityStarted() {
        long l2 = this.mNativeWindowAndroid;
        if (l2 == 0L) {
            return;
        }
        this.nativeOnActivityStarted(l2);
    }

    public void onActivityPaused() {
        Iterator<ActivityStateObserver> iterator = ((WindowAndroid)((Object)iterator)).mActivityStateObservers.iterator();
        while (iterator.hasNext()) {
            ((ActivityStateObserver)iterator.next()).onActivityPaused();
        }
    }

    public void onActivityResumed() {
        Iterator<ActivityStateObserver> iterator = ((WindowAndroid)((Object)iterator)).mActivityStateObservers.iterator();
        while (iterator.hasNext()) {
            ((ActivityStateObserver)iterator.next()).onActivityResumed();
        }
    }

    public void addActivityStateObserver(ActivityStateObserver activityStateObserver) {
        if (!$assertionsDisabled && this.mActivityStateObservers.b.contains(activityStateObserver)) {
            throw new AssertionError();
        }
        this.mActivityStateObservers.a(activityStateObserver);
    }

    public void removeActivityStateObserver(ActivityStateObserver activityStateObserver) {
        if (!$assertionsDisabled && !this.mActivityStateObservers.b.contains(activityStateObserver)) {
            throw new AssertionError();
        }
        this.mActivityStateObservers.b(activityStateObserver);
    }

    public int getActivityState() {
        return 6;
    }

    public boolean canResolveActivity(Intent intent) {
        return ContextUtils.sApplicationContext.getPackageManager().queryIntentActivities(intent, 0).size() > 0;
    }

    public void destroy() {
        TouchExplorationMonitor touchExplorationMonitor;
        long l2 = ((WindowAndroid)((Object)a2)).mNativeWindowAndroid;
        if (l2 != 0L) {
            ((WindowAndroid)((Object)a2)).nativeDestroy(l2);
        }
        if (Build.VERSION.SDK_INT >= 19 && (touchExplorationMonitor = ((WindowAndroid)((Object)a2)).mTouchExplorationMonitor) != null) {
            touchExplorationMonitor.destroy();
        }
        a a2 = ((WindowAndroid)((Object)a2)).mCursorObserver;
        b b2 = b.a;
        if (b2 != null) {
            b2.a(a2);
        }
    }

    public void setAnimationPlaceholderView(View view) {
        WindowAndroid windowAndroid = this;
        windowAndroid.mAnimationPlaceholderView = view;
        windowAndroid.mIsTouchExplorationEnabled = windowAndroid.mAccessibilityManager.isTouchExplorationEnabled();
        windowAndroid.refreshWillNotDraw();
        if (Build.VERSION.SDK_INT >= 19) {
            this.mTouchExplorationMonitor = new TouchExplorationMonitor();
        }
    }

    public m getKeyboardDelegate() {
        return this.mKeyboardVisibilityDelegate;
    }

    public void setKeyboardDelegate(m m2) {
        this.mKeyboardVisibilityDelegate = m2;
        m.a = m2;
    }

    public void addContextMenuCloseListener(OnCloseContextMenuListener onCloseContextMenuListener) {
        this.mContextMenuCloseListeners.a(onCloseContextMenuListener);
    }

    public void removeContextMenuCloseListener(OnCloseContextMenuListener onCloseContextMenuListener) {
        this.mContextMenuCloseListeners.b(onCloseContextMenuListener);
    }

    public void onContextMenuClosed() {
        Iterator<OnCloseContextMenuListener> iterator = ((WindowAndroid)((Object)iterator)).mContextMenuCloseListeners.iterator();
        while (iterator.hasNext()) {
            ((OnCloseContextMenuListener)iterator.next()).onContextMenuClosed();
        }
    }

    public void startAnimationOverContent(Animator animator) {
        if (this.mAnimationPlaceholderView == null) {
            return;
        }
        if (!animator.isStarted()) {
            if (this.mAnimationsOverContent.add(animator)) {
                animator.start();
                this.refreshWillNotDraw();
                animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animator) {
                        3 v0 = this;
                        animator.removeListener((Animator.AnimatorListener)this);
                        v0.WindowAndroid.this.mAnimationsOverContent.remove(animator);
                        v0.WindowAndroid.this.refreshWillNotDraw();
                    }
                });
                return;
            }
            throw new IllegalArgumentException("Already Added.");
        }
        throw new IllegalArgumentException("Already started.");
    }

    public WeakReference<Context> getContext() {
        return new WeakReference<Context>((Context)this.mContextRef.get());
    }

    public IBinder getWindowToken() {
        if ((this = this.getWindow()) == null) {
            return null;
        }
        if ((this = this.peekDecorView()) == null) {
            return null;
        }
        return this.getWindowToken();
    }

    public boolean haveAnimationsEnded() {
        return this.mAnimationsOverContent.isEmpty();
    }

    public void setVSyncPaused(boolean bl) {
        long l2;
        if (this.mVSyncPaused == bl) {
            return;
        }
        this.mVSyncPaused = bl;
        if (!this.mVSyncPaused && this.mPendingVSyncRequest) {
            this.requestVSyncUpdate();
        }
        if ((l2 = this.mNativeWindowAndroid) != 0L) {
            this.nativeSetVSyncPaused(l2, bl);
        }
    }

    @Override
    public void onRefreshRateChanged(float f2) {
        WindowAndroid windowAndroid = this;
        windowAndroid.mVSyncMonitor.a(f2);
        long l2 = windowAndroid.mNativeWindowAndroid;
        if (l2 != 0L) {
            this.nativeOnUpdateRefreshRate(l2, f2);
        }
    }

    @Override
    @TargetApi(value=23)
    public void onCurrentModeChanged(Display.Mode mode) {
        this.recomputeSupportedRefreshRates();
    }

    @Override
    @TargetApi(value=23)
    public void onDisplayModesChanged(List<Display.Mode> list) {
        this.recomputeSupportedRefreshRates();
    }

    public static interface IntentCallback {
        public void onIntentCompleted(WindowAndroid var1, int var2, Intent var3);
    }

    public static interface ActivityStateObserver {
        public void onActivityPaused();

        public void onActivityResumed();
    }

    public static interface OnCloseContextMenuListener {
        public void onContextMenuClosed();
    }

    @TargetApi(value=19)
    private class TouchExplorationMonitor {
        public AccessibilityManager.TouchExplorationStateChangeListener mTouchExplorationListener;

        public TouchExplorationMonitor() {
            this.mTouchExplorationListener = new AccessibilityManager.TouchExplorationStateChangeListener(){

                public void onTouchExplorationStateChanged(boolean bl) {
                    1 v0 = this;
                    WindowAndroid windowAndroid = v0.WindowAndroid.this;
                    WindowAndroid.access$002(windowAndroid, windowAndroid.mAccessibilityManager.isTouchExplorationEnabled());
                    v0.WindowAndroid.this.refreshWillNotDraw();
                }
            };
            WindowAndroid.this.mAccessibilityManager.addTouchExplorationStateChangeListener(this.mTouchExplorationListener);
        }

        public void destroy() {
            WindowAndroid.this.mAccessibilityManager.removeTouchExplorationStateChangeListener(this.mTouchExplorationListener);
        }
    }
}

