/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import a.b.a.e.b;
import a.b.a.e.k;
import a.b.a.j;
import a.b.p.n;
import a.b.p.o;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ClipData;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.vccorp.content.R;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.chromium.base.BuildInfo;
import org.chromium.base.ContentUriUtils;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.base.task.PostTask;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="ui")
public class SelectFileDialog
implements WindowAndroid.IntentCallback,
n {
    public static final String TAG = "SelectFileDialog";
    public static final String IMAGE_TYPE = "image/";
    public static final String VIDEO_TYPE = "video/";
    public static final String AUDIO_TYPE = "audio/";
    public static final String ALL_IMAGE_TYPES = "image/*";
    public static final String ALL_VIDEO_TYPES = "video/*";
    public static final String ALL_AUDIO_TYPES = "audio/*";
    public static final String ANY_TYPES = "*/*";
    public static final long DURATION_BEFORE_FILE_CLEAN_UP_IN_MILLIS;
    public static final String[] POPULAR_IMAGE_EXTENSIONS;
    public static final String[] POPULAR_VIDEO_EXTENSIONS;
    public static final int SELECT_FILE_DIALOG_SCOPE_GENERIC = 0;
    public static final int SELECT_FILE_DIALOG_SCOPE_IMAGES = 1;
    public static final int SELECT_FILE_DIALOG_SCOPE_VIDEOS = 2;
    public static final int SELECT_FILE_DIALOG_SCOPE_IMAGES_AND_VIDEOS = 3;
    public static final int SELECT_FILE_DIALOG_SCOPE_COUNT = 4;
    @SuppressLint(value={"StaticFieldLeak"})
    public static WindowAndroid sOverrideWindowAndroid;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final long mNativeSelectFileDialog;
    public List<String> mFileTypes;
    public boolean mCapture;
    public boolean mAllowMultiple;
    public Uri mCameraOutputUri;
    public WindowAndroid mWindowAndroid;
    public boolean mSupportsImageCapture;
    public boolean mSupportsVideoCapture;
    public boolean mSupportsAudioCapture;

    public SelectFileDialog(long l2) {
        this.mNativeSelectFileDialog = l2;
    }

    public static void setWindowAndroidForTests(WindowAndroid windowAndroid) {
        sOverrideWindowAndroid = windowAndroid;
    }

    @TargetApi(value=18)
    private void selectFile(String[] object, boolean bl, boolean bl2, WindowAndroid windowAndroid) {
        ArrayList arrayList;
        this.mFileTypes = new ArrayList<String>(Arrays.asList(object));
        this.mCapture = bl;
        this.mAllowMultiple = bl2;
        object = sOverrideWindowAndroid;
        if (object == null) {
            object = windowAndroid;
        }
        SelectFileDialog selectFileDialog = this;
        selectFileDialog.mWindowAndroid = object;
        selectFileDialog.mSupportsImageCapture = selectFileDialog.mWindowAndroid.canResolveActivity(new Intent("android.media.action.IMAGE_CAPTURE"));
        selectFileDialog.mSupportsVideoCapture = selectFileDialog.mWindowAndroid.canResolveActivity(new Intent("android.media.action.VIDEO_CAPTURE"));
        selectFileDialog.mSupportsAudioCapture = selectFileDialog.mWindowAndroid.canResolveActivity(new Intent("android.provider.MediaStore.RECORD_SOUND"));
        object = arrayList;
        arrayList = new ArrayList();
        String string2 = BuildInfo.isAtLeastQ() ? "android.permission.READ_MEDIA_IMAGES" : "android.permission.READ_EXTERNAL_STORAGE";
        SelectFileDialog selectFileDialog2 = this;
        selectFileDialog2.shouldUsePhotoPicker();
        bl2 = false;
        if ((selectFileDialog2.mSupportsImageCapture && this.shouldShowImageTypes() || this.mSupportsVideoCapture && this.shouldShowVideoTypes()) && !windowAndroid.hasPermission("android.permission.CAMERA")) {
            object.add("android.permission.CAMERA");
        }
        if (this.mSupportsAudioCapture && this.shouldShowAudioTypes() && !windowAndroid.hasPermission("android.permission.RECORD_AUDIO")) {
            object.add("android.permission.RECORD_AUDIO");
        }
        if (object.isEmpty()) {
            this.launchSelectFileIntent();
        } else {
            Object object2 = object;
            object = object2.toArray(new String[object2.size()]);
            windowAndroid.requestPermissions((String[])object, (arg_0, arg_1) -> this.a(bl2, (String[])object, string2, arg_0, arg_1));
        }
    }

    private void launchSelectFileIntent() {
        SelectFileDialog selectFileDialog = this;
        boolean bl = selectFileDialog.mWindowAndroid.hasPermission("android.permission.CAMERA");
        if (selectFileDialog.mSupportsImageCapture && bl) {
            new GetCameraIntentTask(false, this.mWindowAndroid, this).executeOnExecutor(b.THREAD_POOL_EXECUTOR);
        } else {
            this.launchSelectFileWithCameraIntent(null);
        }
    }

    private void launchSelectFileWithCameraIntent(Intent intent) {
        Intent intent2;
        ArrayList<Intent> arrayList;
        Intent intent3;
        SelectFileDialog selectFileDialog = this;
        RecordHistogram.recordEnumeratedHistogram("Android.SelectFileDialogScope", selectFileDialog.determineSelectFileDialogScope(), 4);
        boolean bl = selectFileDialog.mWindowAndroid.hasPermission("android.permission.CAMERA");
        Intent intent4 = null;
        if (selectFileDialog.mSupportsVideoCapture && bl) {
            Intent intent5;
            intent4 = intent5;
            intent5 = new Intent("android.media.action.VIDEO_CAPTURE");
        }
        SelectFileDialog selectFileDialog2 = this;
        bl = selectFileDialog2.mWindowAndroid.hasPermission("android.permission.RECORD_AUDIO");
        Intent intent6 = null;
        if (selectFileDialog2.mSupportsAudioCapture && bl) {
            Intent intent7;
            intent6 = intent7;
            intent7 = new Intent("android.provider.MediaStore.RECORD_SOUND");
        }
        if (this.captureImage() && intent != null ? this.mWindowAndroid.showIntent(intent, (WindowAndroid.IntentCallback)this, (Integer)R.string.low_memory_error) : (this.captureVideo() && intent4 != null ? this.mWindowAndroid.showIntent(intent4, (WindowAndroid.IntentCallback)this, (Integer)R.string.low_memory_error) : this.captureAudio() && intent6 != null && this.mWindowAndroid.showIntent(intent6, (WindowAndroid.IntentCallback)this, (Integer)R.string.low_memory_error))) {
            return;
        }
        SelectFileDialog selectFileDialog3 = this;
        Activity cfr_ignored_0 = (Activity)selectFileDialog3.mWindowAndroid.getActivity().get();
        SelectFileDialog.convertToImageMimeTypes(selectFileDialog3.mFileTypes);
        selectFileDialog3.shouldUsePhotoPicker();
        Intent intent8 = intent3;
        intent3 = new Intent("android.intent.action.GET_CONTENT");
        if (Build.VERSION.SDK_INT >= 18 && this.mAllowMultiple) {
            intent8.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        ArrayList<Intent> arrayList2 = arrayList;
        arrayList = new ArrayList<Intent>();
        if (!this.noSpecificType()) {
            if (this.shouldShowImageTypes()) {
                if (intent != null) {
                    arrayList2.add(intent);
                }
                intent8.setType(ALL_IMAGE_TYPES);
            } else if (this.shouldShowVideoTypes()) {
                if (intent4 != null) {
                    arrayList2.add(intent4);
                }
                intent8.setType(ALL_VIDEO_TYPES);
            } else if (this.shouldShowAudioTypes()) {
                if (intent6 != null) {
                    arrayList2.add(intent6);
                }
                intent8.setType(ALL_AUDIO_TYPES);
            }
            intent8.addCategory("android.intent.category.OPENABLE");
        }
        if (arrayList2.isEmpty()) {
            intent8.setType(ANY_TYPES);
            if (intent != null) {
                arrayList2.add(intent);
            }
            if (intent4 != null) {
                arrayList2.add(intent4);
            }
            if (intent6 != null) {
                arrayList2.add(intent6);
            }
        }
        intent = intent2;
        intent2 = new Intent("android.intent.action.CHOOSER");
        if (!arrayList2.isEmpty()) {
            intent.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])arrayList2.toArray(new Intent[0]));
        }
        intent.putExtra("android.intent.extra.INTENT", (Parcelable)intent8);
        if (!this.mWindowAndroid.showIntent(intent, (WindowAndroid.IntentCallback)this, (Integer)R.string.low_memory_error)) {
            SelectFileDialog selectFileDialog4 = this;
            selectFileDialog4.onFileNotSelected(selectFileDialog4.mNativeSelectFileDialog);
        }
    }

    private boolean shouldUsePhotoPicker() {
        SelectFileDialog selectFileDialog = list;
        List<String> list = SelectFileDialog.convertToImageMimeTypes(selectFileDialog.mFileTypes);
        if (!selectFileDialog.captureImage() && list != null) {
            o.a();
        }
        return false;
    }

    public static List<String> convertToImageMimeTypes(List<String> arrayList) {
        ArrayList<String> arrayList2;
        if (arrayList.size() == 0) {
            return null;
        }
        ArrayList<String> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<String>();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            String string2 = SelectFileDialog.ensureMimeType((String)iterator.next());
            if (!string2.startsWith(IMAGE_TYPE)) {
                return null;
            }
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String ensureMimeType(String string2) {
        if (string2.length() == 0) {
            return "";
        }
        String string3 = MimeTypeMap.getFileExtensionFromUrl((String)string2);
        if (string3.length() > 0) {
            string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3);
            if (string2 != null) {
                return string2;
            }
            return "application/octet-stream";
        }
        return string2;
    }

    private File getFileForImageCapture(Context context) {
        if (!$assertionsDisabled && ThreadUtils.runningOnUiThread()) {
            throw new AssertionError();
        }
        return File.createTempFile(String.valueOf(System.currentTimeMillis()), ".jpg", o.a(context));
    }

    private void onFileNotSelected() {
        SelectFileDialog selectFileDialog = this;
        selectFileDialog.onFileNotSelected(selectFileDialog.mNativeSelectFileDialog);
    }

    private boolean noSpecificType() {
        return this.mFileTypes.size() != 1 || this.mFileTypes.contains(ANY_TYPES);
    }

    private boolean shouldShowTypes(String string2, String string3) {
        if (!this.noSpecificType() && !this.mFileTypes.contains(string2)) {
            return this.countAcceptTypesFor(string3) > 0;
        }
        return true;
    }

    private boolean shouldShowImageTypes() {
        return this.shouldShowTypes(ALL_IMAGE_TYPES, IMAGE_TYPE);
    }

    private boolean shouldShowVideoTypes() {
        return this.shouldShowTypes(ALL_VIDEO_TYPES, VIDEO_TYPE);
    }

    private boolean shouldShowAudioTypes() {
        return this.shouldShowTypes(ALL_AUDIO_TYPES, AUDIO_TYPE);
    }

    private boolean acceptsSpecificType(String string2) {
        return this.mFileTypes.size() == 1 && TextUtils.equals((CharSequence)this.mFileTypes.get(0), (CharSequence)string2);
    }

    private boolean captureImage() {
        return this.mCapture && this.acceptsSpecificType(ALL_IMAGE_TYPES);
    }

    private boolean captureVideo() {
        return this.mCapture && this.acceptsSpecificType(ALL_VIDEO_TYPES);
    }

    private boolean captureAudio() {
        return this.mCapture && this.acceptsSpecificType(ALL_AUDIO_TYPES);
    }

    private int countAcceptTypesFor(String string2) {
        int n2 = 0;
        Iterator<String> iterator = this.mFileTypes.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().startsWith(string2)) continue;
            ++n2;
        }
        return n2;
    }

    public static void clearCapturedCameraFiles() {
        PostTask.postDelayedTask(k.a, () -> {
            File[] fileArray;
            block12: {
                block11: {
                    fileArray = o.a(ContextUtils.sApplicationContext);
                    if (fileArray.isDirectory()) break block11;
                    return;
                }
                fileArray = fileArray.listFiles();
                if (fileArray != null) break block12;
                return;
            }
            long l2 = System.currentTimeMillis();
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                File file = fileArray[i2];
                long l3 = l2 - file.lastModified();
                if (l3 <= DURATION_BEFORE_FILE_CLEAN_UP_IN_MILLIS) continue;
                if (file.delete()) continue;
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = stringBuilder.append("Failed to delete: ").append(file).toString();
                try {
                    j.b(TAG, string2, new Object[0]);
                }
                catch (IOException iOException) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = iOException;
                    j.d(TAG, "Failed to delete captured camera files.", objectArray2);
                    break;
                }
                continue;
            }
        }, 0L);
    }

    private boolean eligibleForPhotoPicker() {
        return SelectFileDialog.convertToImageMimeTypes(this.mFileTypes) != null;
    }

    private void onFileSelected(long l2, String string2, String string3) {
        if (this.eligibleForPhotoPicker()) {
            RecordHistogram.recordCount100Histogram("Android.SelectFileDialogImgCount", 1);
        }
        this.nativeOnFileSelected(l2, string2, string3);
    }

    private void onMultipleFilesSelected(long l2, String[] stringArray, String[] stringArray2) {
        if (this.eligibleForPhotoPicker()) {
            RecordHistogram.recordCount100Histogram("Android.SelectFileDialogImgCount", stringArray.length);
        }
        this.nativeOnMultipleFilesSelected(l2, stringArray, stringArray2);
    }

    private void onFileNotSelected(long l2) {
        if (this.eligibleForPhotoPicker()) {
            RecordHistogram.recordCount100Histogram("Android.SelectFileDialogImgCount", 0);
        }
        this.nativeOnFileNotSelected(l2);
    }

    private void recordImageCountHistogram(int n2) {
        RecordHistogram.recordCount100Histogram("Android.SelectFileDialogImgCount", n2);
    }

    public static SelectFileDialog create(long l2) {
        return new SelectFileDialog(l2);
    }

    private native void nativeOnFileSelected(long var1, String var3, String var4);

    private native void nativeOnMultipleFilesSelected(long var1, String[] var3, String[] var4);

    private native void nativeOnFileNotSelected(long var1);

    private native void nativeOnContactsSelected(long var1, String var3);

    private /* synthetic */ void a(boolean bl, String[] stringArray, String string2, String[] stringArray2, int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != -1) continue;
            if (this.mCapture) {
                SelectFileDialog selectFileDialog = this;
                selectFileDialog.onFileNotSelected(selectFileDialog.mNativeSelectFileDialog);
                return;
            }
            if (!bl || !stringArray[i2].equals(string2)) continue;
            SelectFileDialog selectFileDialog = this;
            selectFileDialog.onFileNotSelected(selectFileDialog.mNativeSelectFileDialog);
            return;
        }
        this.launchSelectFileIntent();
    }

    public static /* synthetic */ Uri access$102(SelectFileDialog selectFileDialog, Uri uri) {
        selectFileDialog.mCameraOutputUri = uri;
        return uri;
    }

    public static /* synthetic */ void access$300(SelectFileDialog selectFileDialog) {
        SelectFileDialog selectFileDialog2 = selectFileDialog;
        selectFileDialog2.onFileNotSelected(selectFileDialog2.mNativeSelectFileDialog);
    }

    static {
        $assertionsDisabled = SelectFileDialog.class.desiredAssertionStatus() ^ true;
        DURATION_BEFORE_FILE_CLEAN_UP_IN_MILLIS = TimeUnit.HOURS.toMillis(1L);
        POPULAR_IMAGE_EXTENSIONS = new String[]{".apng", ".bmp", ".gif", ".jpeg", ".jpg", ".pdf", ".png", ".tif", ".tiff", ".xcf", ".webp"};
        POPULAR_VIDEO_EXTENSIONS = new String[]{".asf", ".avhcd", ".avi", ".divx", ".flv", ".mov", ".mp4", ".mpeg", ".mpg", ".swf", ".wmv", ".webm", ".mkv"};
    }

    public void setFileTypesForTests(List<String> list) {
        this.mFileTypes = list;
    }

    public void onPhotoPickerUserAction(int n2, Uri[] uriArray) {
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                Intent intent;
                Intent intent2 = intent;
                new Intent().setType(ALL_IMAGE_TYPES);
                if (this.mAllowMultiple) {
                    intent2.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
                }
                intent2.setAction("android.intent.action.GET_CONTENT");
                this.mWindowAndroid.showCancelableIntent(intent2, (WindowAndroid.IntentCallback)this, (Integer)R.string.low_memory_error);
                break;
            }
            case 2: {
                if (!this.mWindowAndroid.hasPermission("android.permission.CAMERA")) {
                    this.mWindowAndroid.requestPermissions(new String[]{"android.permission.CAMERA"}, (stringArray, nArray) -> {
                        if (!$assertionsDisabled && nArray.length != 1) {
                            throw new AssertionError();
                        }
                        if (nArray[0] == -1) {
                            SelectFileDialog selectFileDialog = this;
                            selectFileDialog.onFileNotSelected(selectFileDialog.mNativeSelectFileDialog);
                            return;
                        }
                        new GetCameraIntentTask(true, this.mWindowAndroid, this).executeOnExecutor(b.THREAD_POOL_EXECUTOR);
                    });
                    break;
                }
                new GetCameraIntentTask(true, this.mWindowAndroid, this).executeOnExecutor(b.THREAD_POOL_EXECUTOR);
                break;
            }
            case 1: {
                GetDisplayNameTask getDisplayNameTask;
                if (uriArray.length == 0) {
                    SelectFileDialog selectFileDialog = this;
                    selectFileDialog.onFileNotSelected(selectFileDialog.mNativeSelectFileDialog);
                    return;
                }
                Context context = ContextUtils.sApplicationContext;
                boolean bl = uriArray.length > 1;
                GetDisplayNameTask getDisplayNameTask2 = getDisplayNameTask;
                getDisplayNameTask2(context, bl, uriArray);
                getDisplayNameTask2.executeOnExecutor(b.THREAD_POOL_EXECUTOR);
                break;
            }
            case 0: {
                SelectFileDialog selectFileDialog = this;
                selectFileDialog.onFileNotSelected(selectFileDialog.mNativeSelectFileDialog);
            }
        }
    }

    @Override
    @TargetApi(value=18)
    public void onIntentCompleted(WindowAndroid windowAndroid, int n2, Intent uriArray) {
        if (n2 != -1) {
            uriArray4.onFileNotSelected(uriArray4.mNativeSelectFileDialog);
            return;
        }
        if (uriArray != null && (uriArray.getData() != null || Build.VERSION.SDK_INT >= 18 && uriArray.getClipData() != null)) {
            if (Build.VERSION.SDK_INT >= 18 && uriArray.getData() == null && uriArray.getClipData() != null) {
                windowAndroid = uriArray.getClipData();
                n2 = windowAndroid.getItemCount();
                if (n2 == 0) {
                    uriArray4.onFileNotSelected(uriArray4.mNativeSelectFileDialog);
                    return;
                }
                uriArray = new Uri[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    uriArray[i2] = windowAndroid.getItemAt(i2).getUri();
                }
                (SelectFileDialog)uriArray4.new GetDisplayNameTask(ContextUtils.sApplicationContext, true, uriArray).executeOnExecutor(b.THREAD_POOL_EXECUTOR);
                return;
            }
            if ("file".equals(uriArray.getData().getScheme())) {
                uriArray4.onFileSelected(uriArray4.mNativeSelectFileDialog, uriArray.getData().getSchemeSpecificPart(), "");
                return;
            }
            if ("content".equals(uriArray.getScheme())) {
                Uri[] uriArray2 = uriArray4;
                Uri[] uriArray3 = new Uri[1];
                Uri[] uriArray4 = uriArray3;
                uriArray3[0] = uriArray.getData();
                (SelectFileDialog)uriArray2.new GetDisplayNameTask(ContextUtils.sApplicationContext, false, uriArray4).executeOnExecutor(b.THREAD_POOL_EXECUTOR);
                return;
            }
            uriArray4.onFileNotSelected(uriArray4.mNativeSelectFileDialog);
            windowAndroid.showError(R.string.opening_file_error);
            return;
        }
        String string2 = "file".equals(uriArray4.mCameraOutputUri.getScheme()) ? uriArray4.mCameraOutputUri.getPath() : uriArray4.mCameraOutputUri.toString();
        uriArray4.onFileSelected(uriArray4.mNativeSelectFileDialog, string2, uriArray4.mCameraOutputUri.getLastPathSegment());
        windowAndroid.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uriArray4.mCameraOutputUri));
    }

    public int determineSelectFileDialogScope() {
        if (this.mFileTypes.size() == 0) {
            return 0;
        }
        SelectFileDialog selectFileDialog = this;
        int n2 = selectFileDialog.countAcceptTypesFor(IMAGE_TYPE);
        int n3 = selectFileDialog.countAcceptTypesFor(VIDEO_TYPE);
        if (selectFileDialog.mFileTypes.size() > n2 + n3) {
            block0: for (String string2 : this.mFileTypes) {
                boolean bl = false;
                String[] stringArray = POPULAR_IMAGE_EXTENSIONS;
                int n4 = POPULAR_IMAGE_EXTENSIONS.length;
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (!string2.equalsIgnoreCase(stringArray[i2])) continue;
                    bl = true;
                    ++n2;
                    break;
                }
                if (bl) continue;
                String[] stringArray2 = POPULAR_VIDEO_EXTENSIONS;
                int n5 = POPULAR_VIDEO_EXTENSIONS.length;
                for (n4 = 0; n4 < n5; ++n4) {
                    if (!string2.equalsIgnoreCase(stringArray2[n4])) continue;
                    ++n3;
                    continue block0;
                }
            }
        }
        if (this.mFileTypes.size() - n2 - n3 > 0) {
            return 0;
        }
        if (n3 > 0) {
            return n2 == 0 ? 2 : 3;
        }
        return 1;
    }

    public class GetDisplayNameTask
    extends b<String[]> {
        public String[] mFilePaths;
        public final Context mContext;
        public final boolean mIsMultiple;
        public final Uri[] mUris;

        public GetDisplayNameTask(Context context, boolean bl, Uri[] uriArray) {
            this.mContext = context;
            this.mIsMultiple = bl;
            this.mUris = uriArray;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String[] doInBackground() {
            Uri[] uriArray = objectArray.mUris;
            objectArray.mFilePaths = new String[objectArray.mUris.length];
            String[] stringArray = new String[uriArray.length];
            int n2 = 0;
            try {
                while (true) {
                    if (n2 >= objectArray.mUris.length) {
                        return stringArray;
                    }
                    objectArray.mFilePaths[n2] = "file".equals(objectArray.mUris[n2].getScheme()) ? objectArray.mUris[n2].getSchemeSpecificPart() : objectArray.mUris[n2].toString();
                    stringArray[n2] = ContentUriUtils.getDisplayName(objectArray.mUris[n2], objectArray.mContext, "_display_name");
                    ++n2;
                }
            }
            catch (SecurityException securityException) {
                Object[] objectArray = new Object[]{};
                j.d(SelectFileDialog.TAG, "Unable to extract results from the content provider", objectArray);
                return null;
            }
        }

        @Override
        public void onPostExecute(String[] stringArray) {
            if (stringArray == null) {
                SelectFileDialog.access$300(SelectFileDialog.this);
                return;
            }
            if (this.mIsMultiple) {
                SelectFileDialog selectFileDialog = SelectFileDialog.this;
                selectFileDialog.onMultipleFilesSelected(selectFileDialog.mNativeSelectFileDialog, this.mFilePaths, stringArray);
            } else {
                SelectFileDialog selectFileDialog = SelectFileDialog.this;
                selectFileDialog.onFileSelected(selectFileDialog.mNativeSelectFileDialog, this.mFilePaths[0], stringArray[0]);
            }
        }
    }

    private class GetCameraIntentTask
    extends b<Uri> {
        public Boolean mDirectToCamera;
        public WindowAndroid mWindow;
        public WindowAndroid.IntentCallback mCallback;

        public GetCameraIntentTask(Boolean bl, WindowAndroid windowAndroid, WindowAndroid.IntentCallback intentCallback) {
            this.mDirectToCamera = bl;
            this.mWindow = windowAndroid;
            this.mCallback = intentCallback;
        }

        @Override
        public Uri doInBackground() {
            try {
                GetCameraIntentTask getCameraIntentTask = getCameraIntentTask2;
                GetCameraIntentTask getCameraIntentTask2 = ContextUtils.sApplicationContext;
                return ContentUriUtils.getContentUriFromFile(getCameraIntentTask.SelectFileDialog.this.getFileForImageCapture((Context)getCameraIntentTask2));
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = iOException;
                j.b(SelectFileDialog.TAG, "Cannot retrieve content uri from file", objectArray2);
                return null;
            }
        }

        @Override
        public void onPostExecute(Uri uri) {
            Intent intent;
            GetCameraIntentTask getCameraIntentTask = this;
            SelectFileDialog.access$102(getCameraIntentTask.SelectFileDialog.this, uri);
            if (getCameraIntentTask.SelectFileDialog.this.mCameraOutputUri == null) {
                if (!SelectFileDialog.this.captureImage() && !this.mDirectToCamera.booleanValue()) {
                    SelectFileDialog.this.launchSelectFileWithCameraIntent(null);
                } else {
                    SelectFileDialog.access$300(SelectFileDialog.this);
                }
                return;
            }
            Uri uri2 = uri = intent;
            uri2("android.media.action.IMAGE_CAPTURE");
            uri2.setFlags(3);
            intent.putExtra("output", (Parcelable)SelectFileDialog.this.mCameraOutputUri);
            if (Build.VERSION.SDK_INT >= 18) {
                uri.setClipData(ClipData.newUri((ContentResolver)ContextUtils.sApplicationContext.getContentResolver(), (CharSequence)"images", (Uri)SelectFileDialog.this.mCameraOutputUri));
            }
            if (this.mDirectToCamera.booleanValue()) {
                this.mWindow.showIntent((Intent)uri, this.mCallback, (Integer)R.string.low_memory_error);
            } else {
                SelectFileDialog.this.launchSelectFileWithCameraIntent((Intent)uri);
            }
        }
    }
}

